/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MapModel;
import kd.epm.eb.business.analysiscanvas.model.MapValue;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.QueryService;
import kd.epm.eb.business.analysiscanvas.query.chart.ISplitDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChartItemService
extends AbstractItemService {
    @Override
    protected void afterProcessQueryResult(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        ArrayList<QueryDto> queryList = new ArrayList<QueryDto>(16);
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            ISplitDataService dataService = ISplitDataService.getInstance(canvasBox, item);
            if (dataService != null) {
                dataService.buildSplitQueryDim((CustomItem)item, (List<QueryDto>)queryList);
            }
        });
        if (CollectionUtils.isEmpty(queryList)) {
            return;
        }
        AnalysisCanvasConstants.CalcType calcType = ModelHelper.isBaseBox(canvasBox) ? AnalysisCanvasConstants.CalcType.BASE : AnalysisCanvasConstants.CalcType.SAND;
        QueryService.getInstance().calc(canvasBox, calcType, optType, queryList, null);
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            ISplitDataService dataService = ISplitDataService.getInstance(canvasBox, item);
            if (dataService != null) {
                dataService.processQuerySplitResult((CustomItem)item, (List<QueryDto>)queryList);
            }
        });
    }

    @Override
    public void saveDataIntoBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, IFormView formView) {
    }

    @Override
    public void getDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, Map<String, String> boxData, IFormView formView) {
    }

    @Override
    public void clearItemValue(List<CustomItem> itemList) {
        itemList.forEach(item -> {
            ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
            chartModel.setSerVals(null);
            chartModel.setDrillMem(null);
            chartModel.setDimDrill(null);
            chartModel.setPathDrill(null);
            chartModel.setSpinDrill(null);
            ModelHelper.updateModel(item, chartModel);
        });
    }

    @Override
    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
        itemList.forEach(item -> {
            ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
            Long modelId = IDUtils.toLong((Object)chartModel.getModel());
            Long datasetId = IDUtils.toLong((Object)chartModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            if ("map".equals(chartModel.getType())) {
                MapModel mapModel = chartModel.getMap();
                JSONObject dimensionViews = chartModel.getDimensionViews();
                mapModel.getDims().forEach(dim -> {
                    if (dim.getS().booleanValue()) {
                        String dimNumber = dim.getDim();
                        String memNumber = dim.getMems().get(0).getNum();
                        long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                        Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                        Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                    }
                });
                String mapDim = mapModel.getMapDim();
                Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, mapDim);
                long viewId = ModelHelper.getViewId(mapDim, dimensionViews);
                List data = mapModel.getMapValues().stream().map(MapValue::getMember).filter(Objects::nonNull).collect(Collectors.toList());
                for (MemberModel memberModel : data) {
                    Member member = ModelHelper.getMember(item.getName(), modelCache, mapDim, viewId, memberModel.getNum());
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                }
            } else {
                AtomicInteger counter = new AtomicInteger(0);
                chartModel.getChartConfig().forEach(config -> {
                    Member member;
                    long viewId;
                    JSONObject dimensionViews;
                    Map<String, Long> viewMap;
                    Long actualDatasetId = StringUtils.isEmpty((CharSequence)config.getDataset()) ? datasetId : IDUtils.toLong((Object)config.getDataset());
                    List<MemberQuoteDao> viewQuoteDao = QuoteBuilder.buildView(modelId, actualDatasetId, viewMap = ModelHelper.getViewMap(dimensionViews = config.getDimensionViews()), MemberQuoteResourceEnum.AnalysisCanvas, canvasId, modelCache);
                    if (CollectionUtils.isNotEmpty(viewQuoteDao)) {
                        quotes.addAll(viewQuoteDao);
                    }
                    config.getDims().forEach(dim -> {
                        if (dim.getS().booleanValue()) {
                            String dimNumber = dim.getDim();
                            String memNumber = dim.getMems().get(0).getNum();
                            long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                            Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, actualDatasetId, dimNumber);
                            Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                            quotes.add(new MemberQuoteDao(modelId, actualDatasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                        }
                    });
                    if (StringUtils.isNotBlank((CharSequence)config.getSerDim())) {
                        String serDim = config.getSerDim();
                        List serDimRangeList = Arrays.stream(serDim.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                        if (serDimRangeList.size() == 1) {
                            Dimension serDimension = ModelHelper.getDimension(item.getName(), modelCache, actualDatasetId, serDim);
                            viewId = ModelHelper.getViewId(serDim, dimensionViews);
                            for (MemberModel memberModel : config.getSerMems()) {
                                member = ModelHelper.getMember(item.getName(), modelCache, serDim, viewId, memberModel.getNum());
                                quotes.add(new MemberQuoteDao(modelId, actualDatasetId, serDimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                            }
                        } else {
                            config.getSerRange().stream().flatMap(p -> p.getDims().stream()).forEach(range -> {
                                String dim = range.getDim();
                                Dimension serDimension = ModelHelper.getDimension(item.getName(), modelCache, actualDatasetId, dim);
                                long viewId = ModelHelper.getViewId(dim, dimensionViews);
                                for (MemberModel memberModel : range.getMems()) {
                                    Member member = ModelHelper.getMember(item.getName(), modelCache, dim, viewId, memberModel.getNum());
                                    quotes.add(new MemberQuoteDao(modelId, actualDatasetId, serDimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                                }
                            });
                        }
                    }
                    if (counter.getAndIncrement() == 0 && StringUtils.isNotBlank((CharSequence)chartModel.getHorDim())) {
                        String horDim = chartModel.getHorDim();
                        List horDimRangeList = Arrays.stream(horDim.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                        if (horDimRangeList.size() == 1) {
                            Dimension horDimension = ModelHelper.getDimension(item.getName(), modelCache, actualDatasetId, horDim);
                            viewId = ModelHelper.getViewId(horDim, dimensionViews);
                            for (MemberModel memberModel : chartModel.getHorMems()) {
                                member = ModelHelper.getMember(item.getName(), modelCache, horDim, viewId, memberModel.getNum());
                                quotes.add(new MemberQuoteDao(modelId, actualDatasetId, horDimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                            }
                        } else {
                            chartModel.getHorRange().stream().flatMap(p -> p.getDims().stream()).forEach(range -> {
                                String dim = range.getDim();
                                Dimension serDimension = ModelHelper.getDimension(item.getName(), modelCache, actualDatasetId, dim);
                                long viewId = ModelHelper.getViewId(dim, dimensionViews);
                                for (MemberModel memberModel : range.getMems()) {
                                    Member member = ModelHelper.getMember(item.getName(), modelCache, dim, viewId, memberModel.getNum());
                                    quotes.add(new MemberQuoteDao(modelId, actualDatasetId, serDimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    @Override
    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
        itemList.forEach(item -> {
            ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
            if (datasetId != IDUtils.toLong((Object)chartModel.getDataset())) {
                return;
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)chartModel.getModel()));
            chartModel.getChartConfig().forEach(config -> {
                Map<String, DimensionModel> modelDimMap = config.getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
                dimNumbers.forEach(dimNumber -> {
                    if (modelDimMap.containsKey(dimNumber)) {
                        return;
                    }
                    DimensionModel dimensionModel = new DimensionModel();
                    dimensionModel.setDim((String)dimNumber);
                    dimensionModel.setS(Boolean.TRUE);
                    MemberModel memberModel = new MemberModel();
                    Dimension dimension = modelCache.getDimension(dimNumber);
                    memberModel.setNum(dimension.getNoneNumber());
                    memberModel.setScope(RangeEnum.ONLY.getIndex());
                    dimensionModel.setMems(Collections.singletonList(memberModel));
                    config.getDims().add(dimensionModel);
                });
            });
            if (chartModel.getMap() != null) {
                MapModel mapModel = chartModel.getMap();
                Map<String, DimensionModel> modelDimMap = mapModel.getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
                dimNumbers.forEach(dimNumber -> {
                    if (modelDimMap.containsKey(dimNumber)) {
                        return;
                    }
                    DimensionModel dimensionModel = new DimensionModel();
                    dimensionModel.setDim((String)dimNumber);
                    dimensionModel.setS(Boolean.TRUE);
                    MemberModel memberModel = new MemberModel();
                    Dimension dimension = modelCache.getDimension(dimNumber);
                    memberModel.setNum(dimension.getNoneNumber());
                    memberModel.setScope(RangeEnum.ONLY.getIndex());
                    dimensionModel.setMems(Collections.singletonList(memberModel));
                    mapModel.getDims().add(dimensionModel);
                });
            }
            ModelHelper.updateModel(item, chartModel);
        });
    }

    @Override
    public void processItemVar(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers, IFormView formView) {
    }

    @Override
    public List<SaveDto> buildCoverData(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, IFormView formView) {
        return null;
    }

    @Override
    public DimInfoDto getDimInfo(AnalysisCanvasBox canvasBox, CustomItem item, List<CustomItem> filterItemList, JSONObject reqParam, IFormView formView) {
        ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
        Long modelId = IDUtils.toLong((Object)chartModel.getModel());
        Long datasetId = IDUtils.toLong((Object)chartModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        ChartConfigModel config = chartModel.getChartConfig().get(reqParam.getIntValue("configIndex"));
        if (config == null) {
            return null;
        }
        JSONObject dimensionViews = config.getDimensionViews();
        Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
        Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
        HashMap<String, String> memberInfo = new HashMap<String, String>(20);
        if (StringUtils.isNotBlank((CharSequence)chartModel.getHorDim())) {
            memberInfo.put(chartModel.getHorDim(), chartModel.getHorMems().get(0).getNum());
        }
        if (StringUtils.isNotBlank((CharSequence)config.getSerDim())) {
            memberInfo.put(config.getSerDim(), config.getSerMems().get(0).getNum());
        }
        this.setOtherDim(config.getDims(), filterDim, memberInfo);
        ModelHelper.fillMissMember(memberInfo, sortedDimList, modelCache);
        DimInfoDto dto = new DimInfoDto();
        dto.setModelId(modelId);
        dto.setDatasetId(datasetId);
        dto.setMemberInfo(memberInfo);
        dto.setViewMap(viewMap);
        return dto;
    }
}

