/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBoxData;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.IVarService;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class DupontItemService
extends AbstractItemService {
    private static final Log log = LogFactory.getLog(DupontItemService.class);

    @Override
    public void saveDataIntoBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, IFormView formView) {
        List<String> itemListId = itemList.stream().map(CustomItem::getId).collect(Collectors.toList());
        Map<String, AnalysisCanvasBoxData> boxDataMap = AnalysisCanvasBoxDataService.getInstance().querySandboxData(canvasBox.getId(), itemListId);
        ArrayList<AnalysisCanvasBoxData> saveItemDataList = new ArrayList<AnalysisCanvasBoxData>(itemList.size());
        itemList.forEach(item -> {
            AnalysisCanvasBoxData analysisCanvasBoxData = (AnalysisCanvasBoxData)boxDataMap.get(item.getId());
            if (analysisCanvasBoxData == null) {
                analysisCanvasBoxData = AnalysisCanvasBoxDataService.getInstance().buildModel(canvasBox.getCanvasId(), canvasBox.getId(), item.getId(), null);
            }
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            JSONObject jsonObject = new JSONObject();
            jsonObject.fluentPut("changeMembers", dupontModel.getChangeMembers());
            analysisCanvasBoxData.setData(jsonObject.toJSONString());
            saveItemDataList.add(analysisCanvasBoxData);
        });
        AnalysisCanvasBoxDataService.getInstance().deleteByBoxIdAndItemIds(canvasBox.getId(), itemListId, saveItemDataList);
        AnalysisCanvasBoxDataService.getInstance().save(saveItemDataList);
    }

    @Override
    public void getDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, Map<String, String> boxData, IFormView formView) {
        itemList.forEach(item -> {
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            dupontModel.setChangeMembers(null);
            JSONObject jsonObject = JSONObject.parseObject((String)((String)boxData.get(item.getId())));
            if (jsonObject != null) {
                try {
                    JSONArray jsonArray = jsonObject.getJSONArray("changeMembers");
                    if (jsonArray != null) {
                        List<Map<String, Object>> changeMembers = jsonArray.stream().map(data -> (Map)data).collect(Collectors.toList());
                        dupontModel.setChangeMembers(changeMembers);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                ModelHelper.setMemberName(IDUtils.toLong((Object)dupontModel.getModel()), dupontModel.getDupontConfig());
                ModelHelper.updateModel(item, dupontModel);
            }
        });
    }

    @Override
    public void clearItemValue(List<CustomItem> itemList) {
        itemList.forEach(item -> {
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            dupontModel.getDupontConfig().forEach(config -> config.setValue(null));
            dupontModel.setChangeMembers(null);
            ModelHelper.updateModel(item, dupontModel);
        });
    }

    @Override
    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
        itemList.forEach(item -> {
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            Long modelId = IDUtils.toLong((Object)dupontModel.getModel());
            Long datasetId = IDUtils.toLong((Object)dupontModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            dupontModel.getDupontConfig().forEach(config -> {
                JSONObject dimensionViews = config.getDimensionViews();
                Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
                List<MemberQuoteDao> viewQuoteDao = QuoteBuilder.buildView(modelId, datasetId, viewMap, MemberQuoteResourceEnum.AnalysisCanvas, canvasId, modelCache);
                if (CollectionUtils.isNotEmpty(viewQuoteDao)) {
                    quotes.addAll(viewQuoteDao);
                }
                config.getDims().forEach(dim -> {
                    if (dim.getS().booleanValue()) {
                        String dimNumber = dim.getDim();
                        String memNumber = dim.getMems().get(0).getNum();
                        long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                        Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                        Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                    }
                });
                String dimNumber = config.getDim();
                String memNumber = config.getNum();
                long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            });
        });
    }

    @Override
    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
        itemList.forEach(item -> {
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            if (datasetId != IDUtils.toLong((Object)dupontModel.getDataset())) {
                return;
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)dupontModel.getModel()));
            dupontModel.getDupontConfig().forEach(config -> {
                Map<String, DimensionModel> modelDimMap = config.getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
                dimNumbers.forEach(dimNumber -> {
                    if (modelDimMap.containsKey(dimNumber)) {
                        return;
                    }
                    DimensionModel dimensionModel = new DimensionModel();
                    dimensionModel.setDim((String)dimNumber);
                    dimensionModel.setS(Boolean.TRUE);
                    MemberModel memberModel = new MemberModel();
                    Dimension dimension = modelCache.getDimension(dimNumber);
                    memberModel.setNum(dimension.getNoneNumber());
                    memberModel.setScope(RangeEnum.ONLY.getIndex());
                    dimensionModel.setMems(Collections.singletonList(memberModel));
                    config.getDims().add(dimensionModel);
                });
            });
            ModelHelper.updateModel(item, dupontModel);
        });
    }

    @Override
    public void processItemVar(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers, IFormView formView) {
        IVarService dupontService = IVarService.getInstance("dupontnode", canvasBox, formView);
        if (dupontService == null) {
            return;
        }
        dupontService.processChangeMember(itemList, filterItemList, calcChangeMembers);
    }

    @Override
    public List<SaveDto> buildCoverData(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, IFormView formView) {
        IVarService dupontService = IVarService.getInstance("dupontnode", canvasBox, formView);
        if (dupontService == null) {
            return Collections.emptyList();
        }
        return dupontService.getCoverData(itemList, filterItemList);
    }

    @Override
    public DimInfoDto getDimInfo(AnalysisCanvasBox canvasBox, CustomItem item, List<CustomItem> filterItemList, JSONObject reqParam, IFormView formView) {
        DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
        Long modelId = IDUtils.toLong((Object)dupontModel.getModel());
        Long datasetId = IDUtils.toLong((Object)dupontModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        BizValue config = dupontModel.getDupontConfig().get(reqParam.getIntValue("configIndex"));
        if (config == null) {
            return null;
        }
        JSONObject dimensionViews = config.getDimensionViews();
        Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
        Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
        HashMap<String, String> memberInfo = new HashMap<String, String>(20);
        memberInfo.put(config.getDim(), config.getNum());
        this.setOtherDim(config.getDims(), filterDim, memberInfo);
        ModelHelper.fillMissMember(memberInfo, sortedDimList, modelCache);
        DimInfoDto dto = new DimInfoDto();
        dto.setModelId(modelId);
        dto.setDatasetId(datasetId);
        dto.setMemberInfo(memberInfo);
        dto.setViewMap(viewMap);
        return dto;
    }
}

