/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.item.ItemService;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;

public class ItemHelper {
    private final List<String> allItemTypeList = Lists.newArrayList((Object[])new String[]{"select", "chart", "bizindicator", "table", "table2", "slider", "report", "dupontnode", "predict"});
    private final List<String> calcItemTypeList = Lists.newArrayList((Object[])new String[]{"chart", "bizindicator", "table", "table2", "slider", "dupontnode", "predict"});

    public static ItemHelper getInstance() {
        return InnerClass.instance;
    }

    private ItemHelper() {
    }

    public void buildQueryDim(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> queryList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam, IFormView formView) {
        this.calcItemTypeList.forEach(itemType -> {
            ItemService itemService = ItemService.getInstance(itemType);
            List<CustomItem> typeItemList = ModelHelper.getItems(itemType, itemList);
            itemService.buildQueryDim(canvasBox, (String)itemType, typeItemList, filterItemList, queryList, optType, calcParam, formView);
        });
    }

    public void processQueryResult(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> queryList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam, IFormView formView) {
        this.calcItemTypeList.forEach(itemType -> {
            ItemService itemService = ItemService.getInstance(itemType);
            List<CustomItem> typeItemList = ModelHelper.getItems(itemType, itemList);
            itemService.processQueryResult(canvasBox, (String)itemType, typeItemList, filterItemList, queryList, optType, calcParam, formView);
        });
    }

    public void getDataFromBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, Map<String, String> boxData, IFormView formView) {
        List<CustomItem> filterItemList = ModelHelper.getItems("select", itemList);
        this.allItemTypeList.forEach(itemType -> {
            ItemService itemService = ItemService.getInstance(itemType);
            List<CustomItem> typeItemList = ModelHelper.getItems(itemType, itemList);
            itemService.getDataFromBox(typeItemList, canvasBox, filterItemList, boxData, formView);
        });
    }

    public void clearItemValue(List<CustomItem> itemList) {
        this.allItemTypeList.forEach(itemType -> {
            ItemService itemService = ItemService.getInstance(itemType);
            List<CustomItem> typeItemList = ModelHelper.getItems(itemType, itemList);
            itemService.clearItemValue(typeItemList);
        });
    }

    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
        this.allItemTypeList.forEach(itemType -> {
            ItemService itemService = ItemService.getInstance(itemType);
            List<CustomItem> typeItemList = ModelHelper.getItems(itemType, itemList);
            itemService.buildItemQuote(canvasId, typeItemList, quotes);
        });
    }

    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
        this.allItemTypeList.forEach(itemType -> {
            ItemService itemService = ItemService.getInstance(itemType);
            List<CustomItem> typeItemList = ModelHelper.getItems(itemType, itemList);
            itemService.addNoneMember(datasetId, typeItemList, dimNumbers);
        });
    }

    public void checkItem(List<CustomItem> itemList) {
        itemList.forEach(item -> {
            BaseModel baseModel = ModelHelper.getModel(item);
            if (baseModel == null) {
                return;
            }
            this.checkItemViewIdExisted(baseModel, item.getName());
        });
    }

    private void checkItemViewIdExisted(BaseModel baseModel, String itemName) {
        if (baseModel instanceof ChartModel) {
            ChartModel chartModel = (ChartModel)baseModel;
            if ("map".equals(chartModel.getType())) {
                ModelHelper.checkViewIdExisted(itemName, chartModel.getDimensionViews());
            } else {
                List<ChartConfigModel> chartConfigModel = chartModel.getChartConfig();
                chartConfigModel.forEach(chartConfig -> ModelHelper.checkViewIdExisted(itemName, chartConfig.getDimensionViews()));
            }
        } else if (baseModel instanceof BizModel) {
            BizModel bizModel = (BizModel)baseModel;
            List<BizValue> bizConfig = bizModel.getBizConfig();
            bizConfig.forEach(config -> ModelHelper.checkViewIdExisted(itemName, config.getDimensionViews()));
        } else if (baseModel instanceof DupontModel) {
            DupontModel dupontModel = (DupontModel)baseModel;
            List<BizValue> dupontConfig = dupontModel.getDupontConfig();
            dupontConfig.forEach(config -> ModelHelper.checkViewIdExisted(itemName, config.getDimensionViews()));
        } else {
            ModelHelper.checkViewIdExisted(itemName, baseModel.getDimensionViews());
        }
    }

    private static class InnerClass {
        private static final ItemHelper instance = new ItemHelper();

        private InnerClass() {
        }
    }
}

