/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.item.BizItemService;
import kd.epm.eb.business.analysiscanvas.item.ChartItemService;
import kd.epm.eb.business.analysiscanvas.item.DupontItemService;
import kd.epm.eb.business.analysiscanvas.item.PredictItemService;
import kd.epm.eb.business.analysiscanvas.item.ReportItemService;
import kd.epm.eb.business.analysiscanvas.item.SelectorItemService;
import kd.epm.eb.business.analysiscanvas.item.SliderItemService;
import kd.epm.eb.business.analysiscanvas.item.Table2ItemService;
import kd.epm.eb.business.analysiscanvas.item.TableItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;

public interface ItemService {
    public void buildQueryDim(AnalysisCanvasBox var1, String var2, List<CustomItem> var3, List<CustomItem> var4, List<QueryDto> var5, AnalysisCanvasConstants.OptType var6, JSONObject var7, IFormView var8);

    public void processQueryResult(AnalysisCanvasBox var1, String var2, List<CustomItem> var3, List<CustomItem> var4, List<QueryDto> var5, AnalysisCanvasConstants.OptType var6, JSONObject var7, IFormView var8);

    public void saveDataIntoBox(AnalysisCanvasBox var1, List<CustomItem> var2, IFormView var3);

    public void getDataFromBox(List<CustomItem> var1, AnalysisCanvasBox var2, List<CustomItem> var3, Map<String, String> var4, IFormView var5);

    public void clearItemValue(List<CustomItem> var1);

    public void buildItemQuote(long var1, List<CustomItem> var3, List<MemberQuoteDao> var4);

    public void addNoneMember(long var1, List<CustomItem> var3, Collection<String> var4);

    public void processItemVar(AnalysisCanvasBox var1, List<CustomItem> var2, List<CustomItem> var3, Map<String, ValueDto> var4, IFormView var5);

    public List<SaveDto> buildCoverData(AnalysisCanvasBox var1, List<CustomItem> var2, List<CustomItem> var3, IFormView var4);

    public DimInfoDto getDimInfo(AnalysisCanvasBox var1, CustomItem var2, List<CustomItem> var3, JSONObject var4, IFormView var5);

    public static ItemService getInstance(String type) {
        AbstractItemService itemService;
        switch (type) {
            case "chart": {
                itemService = new ChartItemService();
                break;
            }
            case "bizindicator": {
                itemService = new BizItemService();
                break;
            }
            case "table": {
                itemService = new TableItemService();
                break;
            }
            case "table2": {
                itemService = new Table2ItemService();
                break;
            }
            case "slider": {
                itemService = new SliderItemService();
                break;
            }
            case "select": {
                itemService = new SelectorItemService();
                break;
            }
            case "report": {
                itemService = new ReportItemService();
                break;
            }
            case "dupontnode": {
                itemService = new DupontItemService();
                break;
            }
            case "predict": {
                itemService = new PredictItemService();
                break;
            }
            default: {
                itemService = null;
            }
        }
        return itemService;
    }
}

