/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBoxData;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.PredictModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.IVarService;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class PredictItemService
extends AbstractItemService {
    private static final Log log = LogFactory.getLog(PredictItemService.class);

    @Override
    public void saveDataIntoBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, IFormView formView) {
        List<String> itemListId = itemList.stream().map(CustomItem::getId).collect(Collectors.toList());
        Map<String, AnalysisCanvasBoxData> boxDataMap = AnalysisCanvasBoxDataService.getInstance().querySandboxData(canvasBox.getId(), itemListId);
        ArrayList<AnalysisCanvasBoxData> saveItemDataList = new ArrayList<AnalysisCanvasBoxData>(itemList.size());
        itemList.forEach(item -> {
            JSONObject datasetInfo;
            JSONObject modelInfo;
            JSONObject jsonObject;
            PredictModel predictModel = ModelHelper.getModel(item, PredictModel.class);
            List<Map<String, Object>> currChangeMembers = predictModel.getChangeMembers();
            if (CollectionUtils.isEmpty(currChangeMembers)) {
                return;
            }
            AnalysisCanvasBoxData analysisCanvasBoxData = (AnalysisCanvasBoxData)boxDataMap.get(item.getId());
            if (analysisCanvasBoxData == null) {
                analysisCanvasBoxData = AnalysisCanvasBoxDataService.getInstance().buildModel(canvasBox.getCanvasId(), canvasBox.getId(), item.getId(), null);
                jsonObject = new JSONObject();
            } else {
                jsonObject = JSONObject.parseObject((String)analysisCanvasBoxData.getData());
            }
            Long modelId = IDUtils.toLong((Object)predictModel.getModel());
            Long datasetId = IDUtils.toLong((Object)predictModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List dimensionList = modelCache.getDimensionList(datasetId);
            JSONObject changeInfo = jsonObject.getJSONObject("changeInfo");
            if (changeInfo == null) {
                changeInfo = new JSONObject();
            }
            if ((modelInfo = changeInfo.getJSONObject(predictModel.getModel())) == null) {
                modelInfo = new JSONObject();
                changeInfo.put(predictModel.getModel(), (Object)modelInfo);
            }
            if ((datasetInfo = modelInfo.getJSONObject(predictModel.getDataset())) == null) {
                datasetInfo = new JSONObject();
                modelInfo.put(predictModel.getDataset(), (Object)datasetInfo);
            }
            JSONArray changeMembers = datasetInfo.getJSONArray("changeMembers");
            Map<Long, Map<String, Object>> totalChangeMap = this.toDimMap((List<?>)changeMembers, dimensionList);
            Map<Long, Map<String, Object>> currChangeMap = this.toDimMap(currChangeMembers, dimensionList);
            if (MapUtils.isNotEmpty(currChangeMap)) {
                totalChangeMap.putAll(currChangeMap);
            }
            datasetInfo.fluentPut("changeMembers", totalChangeMap.values());
            jsonObject.fluentPut("changeInfo", (Object)changeInfo);
            analysisCanvasBoxData.setData(jsonObject.toJSONString());
            saveItemDataList.add(analysisCanvasBoxData);
        });
        AnalysisCanvasBoxDataService.getInstance().deleteByBoxIdAndItemIds(canvasBox.getId(), itemListId, saveItemDataList);
        AnalysisCanvasBoxDataService.getInstance().save(saveItemDataList);
    }

    private Map<Long, Map<String, Object>> toDimMap(List<?> list, List<Dimension> dimensionList) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<Long, Map<String, Object>>(10);
        }
        HashMap<Long, Map<String, Object>> changeMemberMap = new HashMap<Long, Map<String, Object>>(list.size());
        list.forEach(obj -> {
            Map map = obj instanceof JSONObject ? ((JSONObject)obj).getInnerMap() : (Map)obj;
            Map<String, String> dimMap = map.entrySet().stream().filter(entry -> !"_v".equals(entry.getKey()) && !"_t".equals(entry.getKey()) && !"_vw".equals(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, v -> String.valueOf(v.getValue()), (o1, o2) -> o2));
            Long hashId = ModelHelper.genDimMemHash(dimensionList, dimMap);
            changeMemberMap.put(hashId, map);
        });
        return changeMemberMap;
    }

    @Override
    public void getDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, Map<String, String> boxData, IFormView formView) {
        JSONObject jsonObject = JSONObject.parseObject((String)boxData.get(String.valueOf(10000L)));
        if (jsonObject != null) {
            try {
                JSONObject changeInfo = jsonObject.getJSONObject("changeInfo");
                if (changeInfo != null) {
                    changeInfo.forEach((modelId, modelObj) -> {
                        JSONObject modelInfo = (JSONObject)modelObj;
                        modelInfo.forEach((datasetId, datasetObj) -> {
                            JSONObject datasetInfo = (JSONObject)datasetObj;
                            JSONArray jsonArray = datasetInfo.getJSONArray("changeMembers");
                            if (jsonArray != null) {
                                List<Map<String, Object>> changeMembers = jsonArray.stream().map(data -> (Map)data).collect(Collectors.toList());
                                PredictModel predictModel = new PredictModel();
                                predictModel.setModel((String)modelId);
                                predictModel.setDataset((String)datasetId);
                                predictModel.setChangeMembers(changeMembers);
                                CustomItem customItem = new CustomItem();
                                customItem.setId(String.valueOf(10000L));
                                customItem.setC(new JSONObject().fluentPut("predictModel", (Object)predictModel));
                                customItem.setType("predict");
                                itemList.add(customItem);
                            }
                        });
                    });
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void clearItemValue(List<CustomItem> itemList) {
    }

    @Override
    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
    }

    @Override
    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
    }

    @Override
    public void processItemVar(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers, IFormView formView) {
        IVarService varService = IVarService.getInstance("predict", canvasBox, formView);
        if (varService == null) {
            return;
        }
        varService.processChangeMember(itemList, filterItemList, calcChangeMembers);
    }

    @Override
    public List<SaveDto> buildCoverData(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, IFormView formView) {
        IVarService varService = IVarService.getInstance("predict", canvasBox, formView);
        if (varService == null) {
            return Collections.emptyList();
        }
        return varService.getCoverData(itemList, filterItemList);
    }

    @Override
    public DimInfoDto getDimInfo(AnalysisCanvasBox canvasBox, CustomItem item, List<CustomItem> filterItemList, JSONObject reqParam, IFormView formView) {
        return null;
    }
}

