/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBoxData;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.analysiscanvas.query.report.AbstractReportService;
import kd.epm.eb.business.analysiscanvas.query.report.DynamicReportService;
import kd.epm.eb.business.analysiscanvas.query.report.FixReportService;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ReportItemService
extends AbstractItemService {
    private static final Log log = LogFactory.getLog(ReportItemService.class);

    public void calc(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, AnalysisCanvasConstants.CalcType calcType, AnalysisCanvasConstants.OptType optType, JSONObject calcParam, IFormView formView) {
        itemList.forEach(item -> {
            ReportModel reportModel = ModelHelper.getModel(item, ReportModel.class);
            ITemplateModel templateModel = this.getTemplateModel(item.getId(), reportModel, formView);
            if (templateModel == null) {
                return;
            }
            try {
                AbstractReportService reportService = this.getReportService(item.getId(), canvasBox, templateModel, reportModel, formView);
                reportService.calc(canvasBox, calcType, optType, calcParam);
                ModelHelper.updateModel(item, reportModel);
            }
            catch (AnalysisCanvasException e) {
                item.setCode(1);
                item.setMsg(e.getMessage());
            }
        });
        if (ModelHelper.needSaveIntoBox(optType)) {
            this.saveDataIntoBox(canvasBox, itemList, formView);
        }
    }

    @Override
    public void saveDataIntoBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, IFormView formView) {
        List<String> itemListId = itemList.stream().map(CustomItem::getId).collect(Collectors.toList());
        Map<String, AnalysisCanvasBoxData> boxDataMap = AnalysisCanvasBoxDataService.getInstance().querySandboxData(canvasBox.getId(), itemListId);
        ArrayList<AnalysisCanvasBoxData> saveItemDataList = new ArrayList<AnalysisCanvasBoxData>(itemList.size());
        itemList.forEach(item -> {
            AnalysisCanvasBoxData analysisCanvasBoxData = (AnalysisCanvasBoxData)boxDataMap.get(item.getId());
            if (analysisCanvasBoxData == null) {
                analysisCanvasBoxData = AnalysisCanvasBoxDataService.getInstance().buildModel(canvasBox.getCanvasId(), canvasBox.getId(), item.getId(), null);
            }
            ReportModel reportModel = ModelHelper.getModel(item, ReportModel.class);
            JSONObject jsonObject = new JSONObject();
            jsonObject.fluentPut("changeMembers", reportModel.getChangeMembers());
            analysisCanvasBoxData.setData(jsonObject.toJSONString());
            saveItemDataList.add(analysisCanvasBoxData);
        });
        AnalysisCanvasBoxDataService.getInstance().deleteByBoxIdAndItemIds(canvasBox.getId(), itemListId, saveItemDataList);
        AnalysisCanvasBoxDataService.getInstance().save(saveItemDataList);
    }

    @Override
    public void getDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, Map<String, String> boxData, IFormView formView) {
        itemList.forEach(item -> {
            ReportModel reportModel = ModelHelper.getModel(item, ReportModel.class);
            reportModel.setChangeMembers(null);
            JSONObject jsonObject = JSONObject.parseObject((String)((String)boxData.get(item.getId())));
            if (jsonObject != null) {
                String pageCacheKeySuffix = "_" + item.getId();
                if (formView != null) {
                    formView.getPageCache().remove("refreshDataRows" + pageCacheKeySuffix);
                }
                try {
                    JSONArray jsonArray = jsonObject.getJSONArray("changeMembers");
                    if (jsonArray != null) {
                        List<Map<String, Object>> changeMembers = jsonArray.stream().map(data -> (Map)data).collect(Collectors.toList());
                        reportModel.setChangeMembers(changeMembers);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                ModelHelper.updateModel(item, reportModel);
            }
        });
    }

    @Override
    public void clearItemValue(List<CustomItem> itemList) {
        itemList.forEach(item -> {
            ReportModel reportModel = ModelHelper.getModel(item, ReportModel.class);
            reportModel.setCommands(null);
            reportModel.setChangeCells(null);
            reportModel.setData(null);
            reportModel.setChangeMembers(null);
            ModelHelper.updateModel(item, reportModel);
        });
    }

    @Override
    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
        itemList.forEach(item -> {
            ReportModel reportModel = ModelHelper.getModel(item, ReportModel.class);
            Long modelId = IDUtils.toLong((Object)reportModel.getModel());
            Long datasetId = IDUtils.toLong((Object)reportModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            JSONObject dimensionViews = reportModel.getDimensionViews();
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            List<MemberQuoteDao> viewQuoteDao = QuoteBuilder.buildView(modelId, datasetId, viewMap, MemberQuoteResourceEnum.AnalysisCanvas, canvasId, modelCache);
            if (CollectionUtils.isNotEmpty(viewQuoteDao)) {
                quotes.addAll(viewQuoteDao);
            }
            reportModel.getDims().forEach(dim -> {
                if (dim.getS().booleanValue()) {
                    String dimNumber = dim.getDim();
                    String memNumber = dim.getMems().get(0).getNum();
                    long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                    Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                    Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                }
            });
        });
    }

    @Override
    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
    }

    @Override
    public void processItemVar(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers, IFormView formView) {
        itemList.forEach(item -> {
            ReportModel reportModel;
            String itemId = item.getId();
            ITemplateModel templateModel = this.getTemplateModel(itemId, reportModel = ModelHelper.getModel(item, ReportModel.class), formView);
            if (templateModel == null) {
                return;
            }
            AbstractReportService reportService = this.getReportService(itemId, canvasBox, templateModel, reportModel, formView);
            reportService.processItemChangeMember(canvasBox, reportModel, templateModel, calcChangeMembers);
            reportModel.setChangeCells(null);
            ModelHelper.updateModel(item, reportModel);
        });
    }

    @Override
    public List<SaveDto> buildCoverData(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, IFormView formView) {
        ArrayList<SaveDto> saveDtoList = new ArrayList<SaveDto>(4);
        itemList.forEach(item -> {
            ReportModel reportModel;
            String itemId = item.getId();
            ITemplateModel templateModel = this.getTemplateModel(itemId, reportModel = ModelHelper.getModel(item, ReportModel.class), formView);
            if (templateModel == null) {
                return;
            }
            AbstractReportService reportService = this.getReportService(itemId, canvasBox, templateModel, reportModel, formView);
            reportService.getCoverData(reportModel, saveDtoList);
        });
        return saveDtoList;
    }

    @Override
    public DimInfoDto getDimInfo(AnalysisCanvasBox canvasBox, CustomItem item, List<CustomItem> filterItemList, JSONObject reqParam, IFormView formView) {
        ReportModel reportModel = ModelHelper.getModel(item, ReportModel.class);
        Long modelId = IDUtils.toLong((Object)reportModel.getModel());
        Long datasetId = IDUtils.toLong((Object)reportModel.getDataset());
        JSONObject dimensionViews = reportModel.getDimensionViews();
        Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
        String itemId = item.getId();
        ITemplateModel templateModel = this.getTemplateModel(itemId, reportModel, formView);
        if (templateModel == null) {
            return null;
        }
        AbstractReportService reportService = this.getReportService(itemId, canvasBox, templateModel, reportModel, formView);
        Map unitSetting = OlapQuerySync.getUnitSettings((ITemplateModel)templateModel);
        Map<String, Pair<Boolean, String>> unitSettingMap = unitSetting.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> {
            kd.epm.eb.common.ebcommon.common.Pair pair = (kd.epm.eb.common.ebcommon.common.Pair)v.getValue();
            return Pair.of((Object)pair.p1, (Object)((BigDecimal)pair.p2).toString());
        }));
        String dataUnit = StringUtils.isNotBlank((CharSequence)templateModel.getTemplateBaseInfo().getDataunit()) ? templateModel.getTemplateBaseInfo().getDataunit() : "0";
        DimInfoDto dto = new DimInfoDto();
        dto.setModelId(modelId);
        dto.setDatasetId(datasetId);
        dto.setTemplateId(IDUtils.toLong((Object)reportModel.getTempId()));
        dto.setViewMap(viewMap);
        dto.setDataUnit(dataUnit);
        dto.setUnitSetting(unitSettingMap);
        Boolean rangeFlag = reqParam.getBoolean("range");
        if (BooleanUtils.isTrue((Boolean)rangeFlag)) {
            int startRow = reqParam.getIntValue("startRow");
            int endRow = reqParam.getIntValue("endRow");
            int startCol = reqParam.getIntValue("startCol");
            int endCol = reqParam.getIntValue("endCol");
            HashSet<String> rowDimSet = new HashSet<String>(10);
            ArrayList<Map<String, String>> memberInfoList = new ArrayList<Map<String, String>>((endRow + 1 - startRow) * (endCol + 1 - startCol));
            for (int row = startRow; row <= endRow; ++row) {
                for (int col = startCol; col <= endCol; ++col) {
                    Map memberInfo;
                    Optional<String> optional;
                    Pair<Map<String, String>, Map<String, Long>> memberAndViewMap = reportService.getMemberAndViewMap(row, col);
                    if (memberAndViewMap == null || MapUtils.isEmpty((Map)((Map)memberAndViewMap.getLeft())) || (optional = (memberInfo = (Map)memberAndViewMap.getLeft()).values().stream().filter(StringUtils::isBlank).findAny()).isPresent()) continue;
                    memberInfoList.add(memberInfo);
                    Set<String> rowDim = reportService.getRowDim(row, col);
                    if (CollectionUtils.isNotEmpty(rowDim)) {
                        rowDimSet.addAll(rowDim);
                    }
                    dto.setViewMap((Map)memberAndViewMap.getRight());
                }
            }
            dto.setRowDimSet(rowDimSet);
            dto.setMemberInfoList(memberInfoList);
        } else {
            int col;
            int row = reqParam.getIntValue("row");
            Pair<Map<String, String>, Map<String, Long>> memberAndViewMap = reportService.getMemberAndViewMap(row, col = reqParam.getIntValue("col"));
            if (memberAndViewMap != null && MapUtils.isNotEmpty((Map)((Map)memberAndViewMap.getLeft()))) {
                Map memberInfo = (Map)memberAndViewMap.getLeft();
                Optional<String> optional = memberInfo.values().stream().filter(StringUtils::isBlank).findAny();
                if (!optional.isPresent()) {
                    dto.setMemberInfo(memberInfo);
                    dto.setMemberInfoList(Collections.singletonList(memberInfo));
                }
                dto.setViewMap((Map)memberAndViewMap.getRight());
            }
        }
        return dto;
    }

    private ITemplateModel getTemplateModel(String itemId, ReportModel reportModel, IFormView formView) {
        String templateData = formView.getPageCache().get("templateModelCacheKey_" + itemId);
        if (StringUtils.isEmpty((CharSequence)templateData)) {
            return null;
        }
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templateData);
        if (templateModel == null) {
            return null;
        }
        String templateBaseData = formView.getPageCache().get("templateBaseCacheKey_" + itemId);
        BgTemplate bgTemplate = (BgTemplate)JSON.parseObject((String)templateBaseData, BgTemplate.class);
        templateModel.setTemplateBaseInfo(bgTemplate);
        templateModel.setDimemsionViews(ModelHelper.getViewMap(reportModel.getDimensionViews()));
        return templateModel;
    }

    @NotNull
    private AbstractReportService getReportService(String itemId, AnalysisCanvasBox canvasBox, ITemplateModel templateModel, ReportModel reportModel, IFormView formView) {
        String templateType = String.valueOf(templateModel.getTemplateBaseInfo().getTemplatetype());
        AbstractReportService reportService = BgTemplateTypeEnum.EBFIX.getNumber().equals(templateType) ? new FixReportService(itemId, canvasBox, reportModel, templateModel, formView) : new DynamicReportService(itemId, canvasBox, reportModel, templateModel, formView);
        return reportService;
    }
}

