/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBoxData;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.SelectModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SelectorItemService
extends AbstractItemService {
    private static final String SELECT_CACHE_VALUES = "selectCacheValues";

    @Override
    public void saveDataIntoBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, IFormView formView) {
        List<String> itemListId = itemList.stream().map(CustomItem::getId).collect(Collectors.toList());
        Map<String, AnalysisCanvasBoxData> boxDataMap = AnalysisCanvasBoxDataService.getInstance().querySandboxData(canvasBox.getId(), itemListId);
        ArrayList<AnalysisCanvasBoxData> saveItemDataList = new ArrayList<AnalysisCanvasBoxData>(itemList.size());
        JSONObject values = new JSONObject(itemList.size());
        itemList.forEach(item -> {
            AnalysisCanvasBoxData analysisCanvasBoxData = (AnalysisCanvasBoxData)boxDataMap.get(item.getId());
            if (analysisCanvasBoxData == null) {
                analysisCanvasBoxData = AnalysisCanvasBoxDataService.getInstance().buildModel(canvasBox.getCanvasId(), canvasBox.getId(), item.getId(), null);
            }
            SelectModel selectModel = ModelHelper.getModel(item, SelectModel.class);
            String value = selectModel.getValue();
            analysisCanvasBoxData.setData(value);
            values.fluentPut(item.getId(), (Object)value);
            saveItemDataList.add(analysisCanvasBoxData);
        });
        AnalysisCanvasBoxDataService.getInstance().deleteByBoxIdAndItemIds(canvasBox.getId(), itemListId, saveItemDataList);
        AnalysisCanvasBoxDataService.getInstance().save(saveItemDataList);
        formView.getPageCache().put(SELECT_CACHE_VALUES, values.toJSONString());
    }

    @Override
    public void getDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, Map<String, String> boxData, IFormView formView) {
        itemList.forEach(item -> {
            SelectModel selectModel = ModelHelper.getModel(item, SelectModel.class);
            String value = (String)boxData.get(item.getId());
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                selectModel.setValue(value);
            }
            ModelHelper.updateModel(item, selectModel);
        });
        ModelHelper.buildOption(itemList, formView);
    }

    @Override
    public void clearItemValue(List<CustomItem> itemList) {
        itemList.forEach(item -> {
            SelectModel selectModel = ModelHelper.getModel(item, SelectModel.class);
            selectModel.setValue(null);
            selectModel.setMembers(null);
            selectModel.setName(null);
            selectModel.setAdd(false);
            ModelHelper.updateModel(item, selectModel);
        });
    }

    @Override
    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
        itemList.forEach(item -> {
            SelectModel selectModel = ModelHelper.getModel(item, SelectModel.class);
            Long modelId = IDUtils.toLong((Object)selectModel.getModel());
            Long datasetId = IDUtils.toLong((Object)selectModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            JSONObject dimensionViews = selectModel.getDimensionViews();
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            List<MemberQuoteDao> viewQuoteDao = QuoteBuilder.buildView(modelId, datasetId, viewMap, MemberQuoteResourceEnum.AnalysisCanvas, canvasId, modelCache);
            if (CollectionUtils.isNotEmpty(viewQuoteDao)) {
                quotes.addAll(viewQuoteDao);
            }
            String dimNumber = selectModel.getDim().getDim();
            List<MemberModel> memberModels = selectModel.getDim().getMems();
            Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
            long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
            for (MemberModel memberModel : memberModels) {
                Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memberModel.getNum());
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            }
        });
    }

    @Override
    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
    }

    @Override
    public void processItemVar(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers, IFormView formView) {
    }

    @Override
    public List<SaveDto> buildCoverData(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, IFormView formView) {
        return null;
    }

    @Override
    public DimInfoDto getDimInfo(AnalysisCanvasBox canvasBox, CustomItem item, List<CustomItem> filterItemList, JSONObject reqParam, IFormView formView) {
        return null;
    }
}

