/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBoxData;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.IVarService;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.analysiscanvas.query.table.FuncColEnum;
import kd.epm.eb.business.forecast.helper.PredictHelper;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class Table2ItemService
extends AbstractItemService {
    private static final Log log = LogFactory.getLog(Table2ItemService.class);

    @Override
    protected void afterProcessQueryResult(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            tableModel.setReqParam(null);
            ModelHelper.updateModel(item, tableModel);
        });
    }

    @Override
    public void saveDataIntoBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, IFormView formView) {
        List<String> itemListId = itemList.stream().map(CustomItem::getId).collect(Collectors.toList());
        Map<String, AnalysisCanvasBoxData> boxDataMap = AnalysisCanvasBoxDataService.getInstance().querySandboxData(canvasBox.getId(), itemListId);
        ArrayList<AnalysisCanvasBoxData> saveItemDataList = new ArrayList<AnalysisCanvasBoxData>(itemList.size());
        itemList.forEach(item -> {
            AnalysisCanvasBoxData analysisCanvasBoxData = (AnalysisCanvasBoxData)boxDataMap.get(item.getId());
            if (analysisCanvasBoxData == null) {
                analysisCanvasBoxData = AnalysisCanvasBoxDataService.getInstance().buildModel(canvasBox.getCanvasId(), canvasBox.getId(), item.getId(), null);
            }
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            JSONObject jsonObject = new JSONObject();
            jsonObject.fluentPut("changeMembers", tableModel.getChangeMembers());
            analysisCanvasBoxData.setData(jsonObject.toJSONString());
            saveItemDataList.add(analysisCanvasBoxData);
        });
        AnalysisCanvasBoxDataService.getInstance().deleteByBoxIdAndItemIds(canvasBox.getId(), itemListId, saveItemDataList);
        AnalysisCanvasBoxDataService.getInstance().save(saveItemDataList);
    }

    @Override
    public void getDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, Map<String, String> boxData, IFormView formView) {
        itemList.forEach(item -> {
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            tableModel.setChangeMembers(null);
            JSONObject jsonObject = JSONObject.parseObject((String)((String)boxData.get(item.getId())));
            if (jsonObject != null) {
                try {
                    JSONArray jsonArray = jsonObject.getJSONArray("changeMembers");
                    if (jsonArray != null) {
                        List<Map<String, Object>> changeMembers = jsonArray.stream().map(data -> (Map)data).collect(Collectors.toList());
                        tableModel.setChangeMembers(changeMembers);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                ModelHelper.updateModel(item, tableModel);
            }
        });
    }

    @Override
    public void clearItemValue(List<CustomItem> itemList) {
        itemList.forEach(item -> {
            TableModel model = ModelHelper.getModel(item, TableModel.class);
            model.setMeta(null);
            model.setData(null);
            model.setChangeMembers(null);
            model.setReqParam(null);
            model.setCommands(null);
            ModelHelper.updateModel(item, model);
        });
    }

    @Override
    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
        itemList.forEach(item -> {
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            Long modelId = IDUtils.toLong((Object)tableModel.getModel());
            Long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            JSONObject dimensionViews = tableModel.getDimensionViews();
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            List<MemberQuoteDao> viewQuoteDao = QuoteBuilder.buildView(modelId, datasetId, viewMap, MemberQuoteResourceEnum.AnalysisCanvas, canvasId, modelCache);
            if (CollectionUtils.isNotEmpty(viewQuoteDao)) {
                quotes.addAll(viewQuoteDao);
            }
            tableModel.getDims().forEach(dim -> {
                if (dim.getS().booleanValue()) {
                    String dimNumber = dim.getDim();
                    String memNumber = dim.getMems().get(0).getNum();
                    long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                    Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                    Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                }
            });
            List<List<DimensionModel>> rowDimList = tableModel.getRowDim();
            for (int i = 0; i < rowDimList.size(); ++i) {
                List<DimensionModel> dimModelList = rowDimList.get(i);
                for (DimensionModel dim2 : dimModelList) {
                    String dimNumber = dim2.getDim();
                    Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                    long viewId = ModelHelper.getViewId(dimNumber, dimensionViews, i);
                    for (MemberModel memberModel : dim2.getMems()) {
                        Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memberModel.getNum());
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                    }
                }
            }
            List<List<DimensionModel>> colDimList = tableModel.getColDim();
            for (int i = 0; i < colDimList.size(); ++i) {
                List<DimensionModel> dimModelList = colDimList.get(i);
                for (DimensionModel dim3 : dimModelList) {
                    String dimNumber = dim3.getDim();
                    Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                    long viewId = ModelHelper.getViewId(dimNumber, dimensionViews, i);
                    for (MemberModel memberModel : dim3.getMems()) {
                        Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memberModel.getNum());
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                    }
                }
            }
        });
    }

    @Override
    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
        itemList.forEach(item -> {
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            if (datasetId != IDUtils.toLong((Object)tableModel.getDataset())) {
                return;
            }
            Map<String, DimensionModel> modelDimMap = tableModel.getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)tableModel.getModel()));
            dimNumbers.forEach(dimNumber -> {
                if (modelDimMap.containsKey(dimNumber)) {
                    return;
                }
                DimensionModel dimensionModel = new DimensionModel();
                dimensionModel.setDim((String)dimNumber);
                dimensionModel.setS(Boolean.TRUE);
                MemberModel memberModel = new MemberModel();
                Dimension dimension = modelCache.getDimension(dimNumber);
                memberModel.setNum(dimension.getNoneNumber());
                memberModel.setScope(RangeEnum.ONLY.getIndex());
                dimensionModel.setMems(Collections.singletonList(memberModel));
                tableModel.getDims().add(dimensionModel);
            });
            ModelHelper.updateModel(item, tableModel);
        });
    }

    @Override
    public void processItemVar(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers, IFormView formView) {
        IVarService varService = IVarService.getInstance("table2", canvasBox, formView);
        if (varService == null) {
            return;
        }
        varService.processChangeMember(itemList, filterItemList, calcChangeMembers);
    }

    @Override
    public List<SaveDto> buildCoverData(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, IFormView formView) {
        IVarService varService = IVarService.getInstance("table2", canvasBox, formView);
        if (varService == null) {
            return Collections.emptyList();
        }
        return varService.getCoverData(itemList, filterItemList);
    }

    @Override
    public DimInfoDto getDimInfo(AnalysisCanvasBox canvasBox, CustomItem item, List<CustomItem> filterItemList, JSONObject reqParam, IFormView formView) {
        TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
        long modelId = IDUtils.toLong((Object)tableModel.getModel());
        long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        DimInfoDto dto = new DimInfoDto();
        dto.setModelId(modelId);
        dto.setDatasetId(datasetId);
        dto.setDataUnit(String.valueOf(PredictHelper.getDataUnitInt(item.getC().getString("unit"))));
        HashMap<String, Long> viewMap = new HashMap<String, Long>(16);
        String param = reqParam.getString("rowCols");
        this.parseMemInfo(param, tableModel, modelCache, sortedDimList, viewMap, dto);
        dto.setViewMap(viewMap);
        dto.setUnitSetting(new HashMap<String, Pair<Boolean, String>>());
        return dto;
    }

    private void getViewByGroup(List<List<DimensionModel>> dims, JSONObject dimensionViews, int group, Map<String, Long> viewMap) {
        if (CollectionUtils.isNotEmpty(dims)) {
            List<DimensionModel> dimModels = dims.get(0);
            for (DimensionModel dimModel : dimModels) {
                String dimNumber = dimModel.getDim();
                long viewId = ModelHelper.getViewId(dimNumber, dimensionViews, group);
                viewMap.put(dimNumber, viewId);
            }
        }
    }

    private void parseMemInfo(String param, TableModel tableModel, IModelCacheHelper modelCache, List<String> sortedDimList, Map<String, Long> viewMap, DimInfoDto dto) {
        JSONObject dimensionViews = tableModel.getDimensionViews();
        HashSet<String> groupSet = new HashSet<String>(2);
        JSONObject jsonObject = JSON.parseObject((String)param);
        Set groupKeys = jsonObject.keySet();
        for (String groupKey : groupKeys) {
            groupSet.add(groupKey);
            if (groupSet.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8de8\u533a\u57df\u9009\u62e9\uff08\u4e0d\u540c\u533a\u57df\u53ef\u80fd\u5b58\u5728\u4e0d\u540c\u89c6\u56fe\uff09\u3002", (String)"AnalysisService_28", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            String[] groupArr = groupKey.split("@");
            int rowGroup = Integer.parseInt(groupArr[0]) - 1;
            int colGroup = Integer.parseInt(groupArr[1]) - 1;
            if (viewMap.isEmpty()) {
                List<DimensionModel> tableOtherDims = tableModel.getDims();
                viewMap.putAll(ModelHelper.getViewMap(dimensionViews, tableOtherDims));
                List<List<DimensionModel>> rowDim = tableModel.getRowDim();
                List<List<DimensionModel>> colDim = tableModel.getColDim();
                this.getViewByGroup(rowDim, dimensionViews, rowGroup, viewMap);
                this.getViewByGroup(colDim, dimensionViews, colGroup, viewMap);
            }
            JSONArray rowColArr = jsonObject.getJSONArray(groupKey);
            List<Map<String, String>> memberInfoList = rowColArr.stream().map(str -> this.parseMemInfo(str.toString(), tableModel, modelCache, sortedDimList)).collect(Collectors.toList());
            dto.setMemberInfo((Map)memberInfoList.get(0));
            dto.setMemberInfoList(memberInfoList);
        }
    }

    private Map<String, String> parseMemInfo(String rowCol, TableModel tableModel, IModelCacheHelper modelCache, List<String> sortedDimList) {
        String[] rowColMemberArr = rowCol.split("#");
        List<DimensionModel> rowDimModels = tableModel.getRowDim().get(0);
        List<DimensionModel> colDimModels = tableModel.getColDim().get(0);
        List rowColDimList = rowDimModels.stream().map(DimensionModel::getDim).collect(Collectors.toList());
        rowColDimList.addAll(colDimModels.stream().map(DimensionModel::getDim).collect(Collectors.toList()));
        rowColDimList.addAll(tableModel.getDims().stream().map(DimensionModel::getDim).collect(Collectors.toList()));
        if (rowColDimList.size() > rowColMemberArr.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\u4e0e\u914d\u7f6e\u7ef4\u5ea6\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"AnalysisService_24", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        HashMap<String, String> memberInfo = new HashMap<String, String>(20);
        for (int i = 0; i < rowColDimList.size(); ++i) {
            String memNumber = rowColMemberArr[i];
            if (memNumber.contains("@")) {
                Triple<String, String, FuncColEnum> funcColInfo = FuncColEnum.splitFuncColNumber(memNumber);
                if (funcColInfo == null) continue;
                memNumber = (String)funcColInfo.getMiddle();
            }
            memberInfo.put((String)rowColDimList.get(i), memNumber);
        }
        ModelHelper.fillMissMember(memberInfo, sortedDimList, modelCache);
        return memberInfo;
    }
}

