/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TabModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TableItemService
extends AbstractItemService {
    @Override
    protected void afterProcessQueryResult(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            TabModel model = ModelHelper.getModel(item, TabModel.class);
            ModelHelper.fillTableDatas(model);
            ModelHelper.updateModel(item, model);
        });
    }

    @Override
    public void saveDataIntoBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, IFormView formView) {
    }

    @Override
    public void getDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, Map<String, String> boxData, IFormView formView) {
        itemList.forEach(item -> {
            TabModel tabModel = ModelHelper.getModel(item, TabModel.class);
            JSONArray datas = JSONObject.parseArray((String)((String)boxData.get(item.getId())));
            if (datas == null) {
                this.queryBaseValue((CustomItem)item, canvasBox, filterItemList, formView);
            } else {
                tabModel.setRawDatas(datas);
                ModelHelper.fillTableDatas(tabModel);
                ModelHelper.updateModel(item, tabModel);
            }
        });
    }

    @Override
    public void clearItemValue(List<CustomItem> itemList) {
        itemList.forEach(item -> {
            JSONObject header;
            TabModel tabModel = ModelHelper.getModel(item, TabModel.class);
            JSONArray datas = tabModel.getDatas();
            if (datas != null) {
                tabModel.setDatas(null);
            }
            if ((header = tabModel.getHeader()) != null) {
                tabModel.setHeader(null);
            }
            ModelHelper.updateModel(item, tabModel);
        });
    }

    @Override
    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
        itemList.forEach(item -> {
            TabModel tabModel = ModelHelper.getModel(item, TabModel.class);
            Long modelId = IDUtils.toLong((Object)tabModel.getModel());
            Long datasetId = IDUtils.toLong((Object)tabModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            JSONObject dimensionViews = tabModel.getDimensionViews();
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            List<MemberQuoteDao> viewQuoteDao = QuoteBuilder.buildView(modelId, datasetId, viewMap, MemberQuoteResourceEnum.AnalysisCanvas, canvasId, modelCache);
            if (CollectionUtils.isNotEmpty(viewQuoteDao)) {
                quotes.addAll(viewQuoteDao);
            }
            tabModel.getDims().forEach(dim -> {
                if (dim.getS().booleanValue()) {
                    String dimNumber = dim.getDim();
                    String memNumber = dim.getMems().get(0).getNum();
                    long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                    Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                    Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                }
            });
            tabModel.getTabs().forEach(dim -> {
                String dimNumber = dim.getDim();
                Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                for (MemberModel memberModel : dim.getMems()) {
                    Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memberModel.getNum());
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                }
            });
        });
    }

    @Override
    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
        itemList.forEach(item -> {
            TabModel tabModel = ModelHelper.getModel(item, TabModel.class);
            if (datasetId != IDUtils.toLong((Object)tabModel.getDataset())) {
                return;
            }
            Map<String, DimensionModel> modelDimMap = tabModel.getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)tabModel.getModel()));
            dimNumbers.forEach(dimNumber -> {
                if (modelDimMap.containsKey(dimNumber)) {
                    return;
                }
                DimensionModel dimensionModel = new DimensionModel();
                dimensionModel.setDim((String)dimNumber);
                dimensionModel.setS(Boolean.TRUE);
                MemberModel memberModel = new MemberModel();
                Dimension dimension = modelCache.getDimension(dimNumber);
                memberModel.setNum(dimension.getNoneNumber());
                memberModel.setScope(RangeEnum.ONLY.getIndex());
                dimensionModel.setMems(Collections.singletonList(memberModel));
                tabModel.getDims().add(dimensionModel);
            });
            ModelHelper.updateModel(item, tabModel);
        });
    }

    @Override
    public void processItemVar(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers, IFormView formView) {
    }

    @Override
    public List<SaveDto> buildCoverData(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, IFormView formView) {
        return null;
    }

    @Override
    public DimInfoDto getDimInfo(AnalysisCanvasBox canvasBox, CustomItem item, List<CustomItem> filterItemList, JSONObject reqParam, IFormView formView) {
        return null;
    }
}

