/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.model;

import java.util.List;
import kd.epm.eb.business.analysiscanvas.model.CompareData;
import kd.epm.eb.business.analysiscanvas.model.CompareHead;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public class CompareTable {
    String title;
    AnalysisCanvasUnit valueUnit = AnalysisCanvasUnit.one;
    List<CompareHead> valueHead;
    List<List<CompareData>> valueData;
    AnalysisCanvasUnit reportUnit = AnalysisCanvasUnit.one;
    List<CompareHead> reportHead;
    List<List<CompareData>> reportData;
    AnalysisCanvasUnit dataUnit = AnalysisCanvasUnit.one;
    List<CompareHead> dataHead;
    List<List<CompareData>> dataData;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<CompareHead> getValueHead() {
        return this.valueHead;
    }

    public void setValueHead(List<CompareHead> valueHead) {
        this.valueHead = valueHead;
    }

    public List<List<CompareData>> getValueData() {
        return this.valueData;
    }

    public void setValueData(List<List<CompareData>> valueData) {
        this.valueData = valueData;
    }

    public List<CompareHead> getReportHead() {
        return this.reportHead;
    }

    public void setReportHead(List<CompareHead> reportHead) {
        this.reportHead = reportHead;
    }

    public List<List<CompareData>> getReportData() {
        return this.reportData;
    }

    public void setReportData(List<List<CompareData>> reportData) {
        this.reportData = reportData;
    }

    public List<CompareHead> getDataHead() {
        return this.dataHead;
    }

    public void setDataHead(List<CompareHead> dataHead) {
        this.dataHead = dataHead;
    }

    public List<List<CompareData>> getDataData() {
        return this.dataData;
    }

    public void setDataData(List<List<CompareData>> dataData) {
        this.dataData = dataData;
    }

    public AnalysisCanvasUnit getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(AnalysisCanvasUnit valueUnit) {
        this.valueUnit = valueUnit;
    }

    public AnalysisCanvasUnit getReportUnit() {
        return this.reportUnit;
    }

    public void setReportUnit(AnalysisCanvasUnit reportUnit) {
        this.reportUnit = reportUnit;
    }

    public AnalysisCanvasUnit getDataUnit() {
        return this.dataUnit;
    }

    public void setDataUnit(AnalysisCanvasUnit dataUnit) {
        this.dataUnit = dataUnit;
    }

    public static enum AnalysisCanvasUnit {
        one(AnalysisCanvasUnit.getOne(), 1),
        thousand(AnalysisCanvasUnit.getThousand(), 1000),
        tenThousand(AnalysisCanvasUnit.getTenThousand(), 10000),
        million(AnalysisCanvasUnit.getMillion(), 1000000),
        tenMillion(AnalysisCanvasUnit.getTenMillion(), 10000000),
        hundredMillion(AnalysisCanvasUnit.getHundredMillion(), 100000000);

        private final MultiLangEnumBridge name;
        private final int value;

        private AnalysisCanvasUnit(MultiLangEnumBridge name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name.loadKDString();
        }

        public int getValue() {
            return this.value;
        }

        public static AnalysisCanvasUnit getEnumByValue(int value) {
            for (AnalysisCanvasUnit analyseType : AnalysisCanvasUnit.values()) {
                if (analyseType.getValue() != value) continue;
                return analyseType;
            }
            return one;
        }

        private static MultiLangEnumBridge getOne() {
            return new MultiLangEnumBridge("--", "AnalysisCanvasUnit_1", "epm-eb-business");
        }

        private static MultiLangEnumBridge getThousand() {
            return new MultiLangEnumBridge("\u5343", "AnalysisCanvasUnit_2", "epm-eb-business");
        }

        private static MultiLangEnumBridge getTenThousand() {
            return new MultiLangEnumBridge("\u4e07", "AnalysisCanvasUnit_3", "epm-eb-business");
        }

        private static MultiLangEnumBridge getMillion() {
            return new MultiLangEnumBridge("\u767e\u4e07", "AnalysisCanvasUnit_4", "epm-eb-business");
        }

        private static MultiLangEnumBridge getTenMillion() {
            return new MultiLangEnumBridge("\u5343\u4e07", "AnalysisCanvasUnit_5", "epm-eb-business");
        }

        private static MultiLangEnumBridge getHundredMillion() {
            return new MultiLangEnumBridge("\u4ebf", "AnalysisCanvasUnit_6", "epm-eb-business");
        }
    }
}

