/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.PredictModel;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.SelectModel;
import kd.epm.eb.business.analysiscanvas.model.SelectOption;
import kd.epm.eb.business.analysiscanvas.model.SplitConfig;
import kd.epm.eb.business.analysiscanvas.model.TabModel;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ModelHelper {
    private static final String SELECT_CACHE_VALUES = "selectCacheValues";

    public static List<CustomItem> getItems(String type, List<CustomItem> itemList) {
        return itemList.stream().filter(item -> type.equals(item.getType())).collect(Collectors.toList());
    }

    public static void resetItems(List<CustomItem> itemList) {
        if (CollectionUtils.isNotEmpty(itemList)) {
            itemList.forEach(CustomItem::reset);
        }
    }

    public static BaseModel getModel(CustomItem item) {
        String type;
        switch (type = item.getType()) {
            case "chart": {
                return ModelHelper.getModel(item, ChartModel.class);
            }
            case "bizindicator": {
                return ModelHelper.getModel(item, BizModel.class);
            }
            case "table": {
                return ModelHelper.getModel(item, TabModel.class);
            }
            case "table2": {
                return ModelHelper.getModel(item, TableModel.class);
            }
            case "select": {
                return ModelHelper.getModel(item, SelectModel.class);
            }
            case "slider": {
                return ModelHelper.getModel(item, VarModel.class);
            }
            case "report": {
                return ModelHelper.getModel(item, ReportModel.class);
            }
            case "dupontnode": {
                return ModelHelper.getModel(item, DupontModel.class);
            }
            case "predict": {
                return ModelHelper.getModel(item, PredictModel.class);
            }
        }
        return null;
    }

    public static <T extends BaseModel> T getModel(CustomItem item, Class<T> clazz) {
        String type = clazz == ChartModel.class ? "chartModel" : (clazz == BizModel.class ? "bizModel" : (clazz == TabModel.class ? "tabModel" : (clazz == TableModel.class ? "tableModel" : (clazz == SelectModel.class ? "selectModel" : (clazz == ReportModel.class ? "reportModel" : (clazz == DupontModel.class ? "dupontModel" : (clazz == PredictModel.class ? "predictModel" : "varModel")))))));
        return (T)((BaseModel)item.getC().getJSONObject(type).toJavaObject(clazz));
    }

    public static <T extends BaseModel> void updateModel(CustomItem item, T model) {
        String type = model instanceof ChartModel ? "chartModel" : (model instanceof BizModel ? "bizModel" : (model instanceof TabModel ? "tabModel" : (model instanceof TableModel ? "tableModel" : (model instanceof SelectModel ? "selectModel" : (model instanceof ReportModel ? "reportModel" : (model instanceof DupontModel ? "dupontModel" : (model instanceof PredictModel ? "predictModel" : "varModel")))))));
        item.getC().put(type, model);
    }

    public static List<SplitConfig> getSplitConfigs(CustomItem item) {
        ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
        if ("gauge".equals(chartModel.getType())) {
            JSONObject gaugeConfig = item.getC().getJSONObject("gaugeConfig");
            if (gaugeConfig == null) {
                gaugeConfig = new JSONObject();
                gaugeConfig.fluentPut("splits", (Object)new JSONArray().fluentAdd((Object)new SplitConfig()));
                item.getC().fluentPut("gaugeConfig", (Object)gaugeConfig.toJSONString());
            }
            JSONArray array = gaugeConfig.getJSONArray("splits");
            return array.toJavaList(SplitConfig.class);
        }
        JSONArray array = item.getC().getJSONArray("markLineConfig");
        return array == null ? Collections.emptyList() : array.toJavaList(SplitConfig.class);
    }

    public static void putSplitConfigs(CustomItem item, List<SplitConfig> splitConfigs) {
        ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
        if ("gauge".equals(chartModel.getType())) {
            item.getC().getJSONObject("gaugeConfig").put("splits", splitConfigs);
        } else {
            item.getC().put("markLineConfig", splitConfigs);
        }
    }

    public static boolean isBaseBox(AnalysisCanvasBox canvasBox) {
        return AnalysisCanvasConstants.BoxType.BASE.getValue().equals(canvasBox.getType());
    }

    public static boolean isCalcQuery(AnalysisCanvasConstants.CalcType calcType) {
        return AnalysisCanvasConstants.CalcType.SAND == calcType;
    }

    public static boolean needSaveIntoBox(AnalysisCanvasConstants.OptType optType) {
        return AnalysisCanvasConstants.OptType.CALC == optType || AnalysisCanvasConstants.OptType.SELECTOR_CHANGE == optType;
    }

    public static long getViewId(String dimNumber, JSONObject dimensionViews, int index) {
        if (View.NoViewDimNums.contains(dimNumber)) {
            return 0L;
        }
        long viewId = ModelHelper.getViewId(dimNumber + '_' + index, dimensionViews);
        if (viewId == 0L) {
            viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
        }
        return viewId;
    }

    public static long getViewId(String dimNumber, JSONObject dimensionViews) {
        String viewId = null;
        if (dimensionViews != null) {
            viewId = dimensionViews.getString(dimNumber);
        }
        return IDUtils.toLong(viewId);
    }

    public static Map<String, Long> getViewMap(JSONObject dimensionViews) {
        if (dimensionViews == null) {
            return Collections.emptyMap();
        }
        Set entrySet = dimensionViews.entrySet();
        HashMap<String, Long> viewMap = new HashMap<String, Long>(entrySet.size());
        entrySet.forEach(entry -> viewMap.put((String)entry.getKey(), IDUtils.toLong(entry.getValue())));
        return viewMap;
    }

    public static Map<String, Long> getViewMap(JSONObject dimensionViews, List<DimensionModel> dimModelList) {
        HashMap<String, Long> viewMap = new HashMap<String, Long>(dimModelList.size());
        if (dimensionViews == null) {
            return viewMap;
        }
        dimModelList.forEach(dimModel -> {
            String dimNumber = dimModel.getDim();
            if (dimensionViews.containsKey((Object)dimNumber)) {
                viewMap.put(dimNumber, IDUtils.toLong((Object)dimensionViews.getString(dimNumber)));
            }
        });
        return viewMap;
    }

    public static void fillTableDatas(TabModel tabModel) {
        Long modelId = IDUtils.toLong((Object)tabModel.getModel());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        JSONObject dimensionViews = tabModel.getDimensionViews();
        List<DimensionModel> tabs = tabModel.getTabs();
        JSONObject header = new JSONObject();
        tabs.forEach(dim -> {
            Dimension dimension = modelCache.getDimension(dim.getDim());
            header.put(dim.getDim(), (Object)dimension.getName());
        });
        header.put("value", (Object)ResManager.loadResFormat((String)"\u6570\u636e", (String)"AnalysisService_4", (String)"epm-eb-business", (Object[])new Object[0]));
        tabModel.setHeader(header);
        List dataList = tabModel.getRawDatas().toJavaList(List.class);
        JSONArray newDatas = new JSONArray(16);
        dataList.forEach(data -> {
            JSONObject json = new JSONObject();
            for (int i = 0; i < tabs.size(); ++i) {
                Long viewId;
                String dimNumber = ((DimensionModel)tabs.get(i)).getDim();
                Member member = modelCache.getMember(dimNumber, viewId = IDUtils.toLong((Object)dimensionViews.getString(dimNumber)), String.valueOf(data.get(i)));
                if (member == null) {
                    return;
                }
                json.put(dimNumber, (Object)member.getName());
            }
            json.put("value", data.get(tabs.size()));
            newDatas.add((Object)json);
        });
        tabModel.setDatas(newDatas);
    }

    public static void setMemberName(long modelId, List<BizValue> bizValueList) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        bizValueList.forEach(config -> {
            JSONObject dimensionViews = config.getDimensionViews() == null ? new JSONObject() : config.getDimensionViews();
            String bizDim = config.getDim();
            String memNum = config.getNum();
            Long viewId = IDUtils.toLong((Object)dimensionViews.getString(bizDim));
            Member member = modelCache.getMember(bizDim, viewId, memNum);
            if (member != null) {
                config.setName(member.getName());
            }
        });
    }

    public static Map<String, String> getFilterFromSelector(String itemId, List<CustomItem> selectItems) {
        List<SelectModel> selectModels = selectItems.stream().map(item -> ModelHelper.getModel(item, SelectModel.class)).filter(selectModel -> selectModel.getRelationId().contains(itemId)).collect(Collectors.toList());
        selectModels.forEach(selectModel -> {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectModel.getValue())) {
                throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u5668\u7ec4\u4ef6\u7684%1\u7ef4\u5ea6\u6210\u5458\u3002", (String)"AnalysisService_1", (String)"epm-eb-business", (Object[])new Object[]{selectModel.getName()}));
            }
        });
        return selectModels.stream().collect(Collectors.toMap(k -> k.getDim().getDim(), SelectModel::getValue, (v1, v2) -> v2));
    }

    public static void buildOption(List<CustomItem> selectItems, IFormView formView) {
        selectItems.forEach(item -> {
            String value;
            SelectModel selectModel = ModelHelper.getModel(item, SelectModel.class);
            String dimNumber = selectModel.getDim().getDim();
            List<MemberModel> memberModels = selectModel.getDim().getMems();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)selectModel.getModel()));
            JSONObject dimensionViews = selectModel.getDimensionViews();
            long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
            if (viewId != 0L && !ModelHelper.viewExisted(viewId)) {
                return;
            }
            Dimension dimension = modelCache.getDimension(dimNumber);
            LinkedHashSet memberNumbers = new LinkedHashSet(16);
            for (MemberModel memberModel : memberModels) {
                List members = modelCache.getMemberSort(dimNumber, Long.valueOf(viewId), memberModel.getNum(), memberModel.getScope().intValue());
                if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                memberNumbers.addAll(members.stream().map(BaseCache::getNumber).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
            List<SelectOption> selectOptions = memberNumbers.stream().map(memberNumber -> {
                SelectOption selectOption = new SelectOption();
                Member member = modelCache.getMember(dimNumber, Long.valueOf(viewId), memberNumber);
                if (member == null) {
                    return null;
                }
                selectOption.setName(member.getName());
                selectOption.setNumber((String)memberNumber);
                return selectOption;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            selectModel.setMembers(selectOptions);
            String selectCacheValues = formView.getPageCache().get(SELECT_CACHE_VALUES);
            JSONObject cacheValues = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)selectCacheValues) ? new JSONObject() : JSON.parseObject((String)selectCacheValues);
            String cacheValue = cacheValues.getString(item.getId());
            String string = value = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cacheValue) ? cacheValue : selectModel.getValue();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
                selectModel.setValue(selectOptions.get(0).getNumber());
            } else {
                selectModel.setValue(value);
            }
            selectModel.setName(dimension.getName());
            ModelHelper.updateModel(item, selectModel);
        });
    }

    public static void refreshChangeMembers(List<CustomItem> customItemList, Map<String, ValueDto> calcChangeMembers) {
        customItemList.forEach(item -> {
            List<Object> changeMembers = Collections.emptyList();
            BaseModel baseModel = ModelHelper.getModel(item);
            if (baseModel == null) {
                return;
            }
            switch (item.getType()) {
                case "slider": {
                    changeMembers = ((VarModel)baseModel).getChangeMembers();
                    break;
                }
                case "report": {
                    changeMembers = ((ReportModel)baseModel).getChangeMembers();
                    break;
                }
                case "dupontnode": {
                    changeMembers = ((DupontModel)baseModel).getChangeMembers();
                    break;
                }
                case "table2": {
                    changeMembers = ((TableModel)baseModel).getChangeMembers();
                    break;
                }
                case "predict": {
                    changeMembers = ((PredictModel)baseModel).getChangeMembers();
                }
            }
            if (CollectionUtils.isEmpty(changeMembers) || MapUtils.isEmpty((Map)calcChangeMembers)) {
                return;
            }
            Long modelId = IDUtils.toLong((Object)baseModel.getModel());
            Long datasetId = IDUtils.toLong((Object)baseModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List allDims = modelCache.getDimensionList(datasetId);
            List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            Map changeMemberMap = changeMembers.stream().collect(Collectors.toMap(m -> ModelHelper.getMemberKeyStr(ModelHelper.transToMembersKey(m, sortedDimList, modelCache).getKeys()), v -> v, (o1, o2) -> o2, LinkedHashMap::new));
            for (Map.Entry entry : calcChangeMembers.entrySet()) {
                ValueDto valueDto;
                long changeTime;
                Map changeMember = (Map)changeMemberMap.get(entry.getKey());
                if (changeMember == null || (changeTime = Long.parseLong(((Object)changeMember.getOrDefault("_t", 0L)).toString())) >= (valueDto = (ValueDto)entry.getValue()).getT()) continue;
                changeMember.put("_v", valueDto.getV());
                changeMember.put("_t", valueDto.getT());
                changeMember.put("_vw", JSONObject.toJSONString(valueDto.getVw()));
            }
            ModelHelper.updateModel(item, baseModel);
        });
    }

    public static Dimension getDimension(String itemName, IModelCacheHelper modelCache, long datasetId, String dimNumber) {
        Map dimensionMap = modelCache.getDimensionMap(Long.valueOf(datasetId));
        Dimension dimension = (Dimension)dimensionMap.get(dimNumber);
        if (dimension == null) {
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7ec4\u4ef6\uff1a%1\uff0c\u7ef4\u5ea6[%2]\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u6216\u91cd\u65b0\u914d\u7f6e\u7ec4\u4ef6\u3002", (String)"AnalysisService_9", (String)"epm-eb-business", (Object[])new Object[]{itemName, dimNumber}));
        }
        return dimension;
    }

    public static Member getMember(String itemName, IModelCacheHelper modelCache, String dimNumber, Long viewId, String memNumber) {
        Member member = modelCache.getMember(dimNumber, viewId, memNumber);
        if (member == null) {
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7ec4\u4ef6\uff1a%1\uff0c\u7ef4\u5ea6[%2]\u7684\u6210\u5458[%3]\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u7ec4\u4ef6\u3002", (String)"AnalysisService_10", (String)"epm-eb-business", (Object[])new Object[]{itemName, dimNumber, memNumber}));
        }
        return member;
    }

    public static String getMetricType(Map<String, String> memberMap, IModelCacheHelper modelCache) {
        String memNumber = memberMap.get(SysDimensionEnum.Metric.getNumber());
        if (StringUtils.isEmpty((String)memNumber)) {
            return "";
        }
        return modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, memNumber).getDatatype();
    }

    public static boolean viewExisted(Long viewId) {
        return QueryServiceHelper.exists((String)"eb_dimensionview", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)});
    }

    public static void checkViewIdExisted(String itemName, JSONObject dimensionViews) {
        if (dimensionViews == null) {
            return;
        }
        for (Map.Entry entry : dimensionViews.entrySet()) {
            Long viewIdLong = IDUtils.toLong(entry.getValue());
            if (viewIdLong == 0L || ModelHelper.viewExisted(viewIdLong)) continue;
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7ec4\u4ef6\uff1a%1\uff0c\u7ef4\u5ea6\u201c%2\u201d\u7684\u89c6\u56fe\u5df2\u4e0d\u5b58\u5728\uff0c\u89c6\u56feid\u4e3a\u201c%3\u201d\uff0c\u8bf7\u5220\u9664\u6216\u91cd\u65b0\u914d\u7f6e\u7ec4\u4ef6\u3002", (String)"AnalysisService_14", (String)"epm-eb-business", (Object[])new Object[]{itemName, entry.getKey(), viewIdLong}));
        }
    }

    public static void checkViewIdExisted(JSONObject dimensionViews) {
        if (dimensionViews == null) {
            return;
        }
        for (Map.Entry entry : dimensionViews.entrySet()) {
            Long viewIdLong = IDUtils.toLong(entry.getValue());
            if (viewIdLong == 0L || ModelHelper.viewExisted(viewIdLong)) continue;
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u7684\u89c6\u56fe\u5df2\u4e0d\u5b58\u5728\uff0c\u89c6\u56feid\u4e3a\u201c%2\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8be5\u7ef4\u5ea6\u6210\u5458\u3002", (String)"AnalysisService_20", (String)"epm-eb-business", (Object[])new Object[]{entry.getKey(), viewIdLong}));
        }
    }

    public static MembersKey transToMembersKey(Map<String, ?> cellMemberMap, List<String> sortedDimList, IModelCacheHelper modelCache) {
        Object[] keys = new String[sortedDimList.size() + 1];
        for (int i = 0; i < sortedDimList.size(); ++i) {
            String dimNumber = sortedDimList.get(i);
            Object memNumber = cellMemberMap.get(dimNumber);
            if (memNumber == null) {
                Dimension dimension = modelCache.getDimension(dimNumber);
                memNumber = dimension.getNoneNumber();
            }
            keys[i + 1] = memNumber.toString();
        }
        return new MembersKey(keys);
    }

    public static Map<String, String> transToMemberMap(Object[] membersKeys, List<String> sortedDimList) {
        if (membersKeys.length != sortedDimList.size() + 1) {
            return null;
        }
        LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>(sortedDimList.size());
        for (int i = 0; i < sortedDimList.size(); ++i) {
            String dimNumber = sortedDimList.get(i);
            memberMap.put(dimNumber, membersKeys[i + 1].toString());
        }
        return memberMap;
    }

    public static String getMemberKeyStr(Object[] keys) {
        List memList = Arrays.stream(keys).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
        return String.join((CharSequence)String.valueOf('!'), memList);
    }

    public static void fillMissMember(Map<String, String> queryCellMap, List<String> sortedDimList, IModelCacheHelper modelCache) {
        sortedDimList.forEach(dimNumber -> {
            if (!queryCellMap.containsKey(dimNumber)) {
                Dimension dimension = modelCache.getDimension(dimNumber);
                queryCellMap.put((String)dimNumber, dimension.getNoneNumber());
            }
        });
    }

    public static Long genDimMemHash(List<Dimension> dimensionList, Map<String, String> cellDimMap) {
        String cellMembers = dimensionList.stream().map(dim -> (String)cellDimMap.get(dim.getNumber())).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).collect(Collectors.joining(","));
        return Hashing.sha256().hashString((CharSequence)cellMembers, StandardCharsets.UTF_8).padToLong();
    }

    public static Long getViewHash(List<String> sortedDimList, Map<String, Long> viewMap) {
        String key = sortedDimList.stream().filter(dim -> !View.NoViewDimNums.contains(dim)).map(viewMap::get).filter(IDUtils::isNotEmptyLong).map(Object::toString).collect(Collectors.joining("!"));
        return Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).padToLong();
    }

    public static Map<String, Long> getViewMap(String viewString, List<String> sortedDimList, IModelCacheHelper modelCache, Long dataset) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)viewString)) {
            JSONObject jsonView = JSONObject.parseObject((String)viewString);
            return sortedDimList.stream().filter(e -> !View.NoViewDimNums.contains(e)).collect(Collectors.toMap(e -> e, e -> IDUtils.isNotEmptyLong((Long)jsonView.getLong(e)) != false ? jsonView.getLong(e) : modelCache.getViewByDataSetAndDimNumber(dataset, e)));
        }
        return sortedDimList.stream().filter(e -> !View.NoViewDimNums.contains(e)).collect(Collectors.toMap(e -> e, e -> modelCache.getViewByDataSetAndDimNumber(dataset, e)));
    }

    public static Map<String, Long> getViewMap(JSONObject jsonView, List<String> sortedDimList, IModelCacheHelper modelCache, Long dataset) {
        return sortedDimList.stream().filter(e -> !View.NoViewDimNums.contains(e)).collect(Collectors.toMap(e -> e, e -> IDUtils.isNotEmptyLong((Long)jsonView.getLong(e)) != false ? jsonView.getLong(e) : modelCache.getViewByDataSetAndDimNumber(dataset, e)));
    }

    public static Map<String, Long> getViewMap(Map<String, Long> viewMap, List<String> sortedDimList, IModelCacheHelper modelCache, Long dataset) {
        return viewMap.entrySet().stream().filter(e -> !View.NoViewDimNums.contains(e.getKey()) && sortedDimList.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> IDUtils.isNotEmptyLong((Long)((Long)e.getValue())) != false ? (Long)e.getValue() : modelCache.getViewByDataSetAndDimNumber(dataset, (String)e.getKey())));
    }
}

