/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DrillConfig;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.PageConfig;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.IDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.elasticsearch.OlapDataAuditService;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.adminmode.CurrentModeEnum;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.biztemplate.SaveBizTemplate;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractDataService
implements IDataService {
    protected IFormView formView;
    protected AnalysisCanvasBox canvasBox;

    public AbstractDataService() {
    }

    public AbstractDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        this.formView = formView;
        this.canvasBox = canvasBox;
    }

    protected void fillMissMember(Map<String, String> queryCellMap, List<String> sortedDimList, IModelCacheHelper modelCache) {
        ModelHelper.fillMissMember(queryCellMap, sortedDimList, modelCache);
    }

    protected Object getCellValue(IModelCacheHelper modelCache, Map<String, String> queryCellMap, List<String> sortedDimList, Map<MembersKey, BGCell> keyBGCellMap) {
        return this.getCellValue(modelCache, queryCellMap, sortedDimList, keyBGCellMap, 0.0);
    }

    protected Object getCellValue(IModelCacheHelper modelCache, Map<String, String> queryCellMap, List<String> sortedDimList, Map<MembersKey, BGCell> keyBGCellMap, Object defaultValue) {
        Object[] keys = new String[sortedDimList.size() + 1];
        for (int i = 0; i < sortedDimList.size(); ++i) {
            String dimNumber = sortedDimList.get(i);
            if (queryCellMap.containsKey(dimNumber)) {
                keys[i + 1] = queryCellMap.get(dimNumber);
                continue;
            }
            Dimension dimension = modelCache.getDimension(dimNumber);
            keys[i + 1] = dimension.getNoneNumber();
        }
        MembersKey membersKey = new MembersKey(keys);
        BGCell bgCell = keyBGCellMap.get(membersKey);
        Object value = bgCell == null ? defaultValue : bgCell.getValue();
        return value;
    }

    protected void setOtherDim(List<DimensionModel> dims, Map<String, String> filterDim, Map<String, Set<String>> queryDim) {
        dims.forEach(dimModel -> {
            String memNumber;
            String dimNumber = dimModel.getDim();
            if (dimModel.getS().booleanValue()) {
                MemberModel member = dimModel.getMems().get(0);
                memNumber = member.getNum();
            } else {
                memNumber = (String)filterDim.get(dimNumber);
            }
            Set querySet = queryDim.computeIfAbsent(dimNumber, k -> new HashSet(1));
            querySet.add(memNumber);
        });
    }

    protected void setSpinDim(List<List<DrillConfig>> spinDrill, Map<String, Set<String>> queryDim) {
        Map<String, String> spinDimMap = this.getSpinDimMap(spinDrill);
        spinDimMap.forEach((key, value) -> {
            Set querySet = queryDim.computeIfAbsent((String)key, k -> new HashSet(1));
            querySet.add(value);
        });
    }

    protected Map<String, String> getSpinDimMap(List<List<DrillConfig>> spinDrill) {
        if (CollectionUtils.isEmpty(spinDrill)) {
            return Collections.emptyMap();
        }
        return spinDrill.stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(DrillConfig::getDimNum, DrillConfig::getMemNum, (o1, o2) -> o2));
    }

    protected Map<String, String> genFixMemberMap(List<DimensionModel> dims, Map<String, String> filterDim) {
        LinkedHashMap<String, String> fixMemberMap = new LinkedHashMap<String, String>(dims.size());
        dims.forEach(dimModel -> {
            String memNumber;
            String dimNumber = dimModel.getDim();
            if (dimModel.getS().booleanValue()) {
                MemberModel member = dimModel.getMems().get(0);
                memNumber = member.getNum();
            } else {
                memNumber = (String)filterDim.get(dimNumber);
            }
            fixMemberMap.put(dimNumber, memNumber);
        });
        return fixMemberMap;
    }

    protected void checkRelQueryDim(AnalysisCanvasConstants.OptType optType, Map<String, Long> viewMap, IModelCacheHelper modelCache, long datasetId, JSONObject calcParam) {
        if (optType != AnalysisCanvasConstants.OptType.REL_QUERY || calcParam == null || calcParam.getJSONArray("drill") == null) {
            return;
        }
        List drillConfigs = JSONObject.parseArray((String)JSONObject.toJSONString((Object)calcParam.getJSONArray("drill")), DrillConfig.class);
        Map dimensionMap = modelCache.getDimensionMap(Long.valueOf(datasetId));
        for (DrillConfig drillConfig : drillConfigs) {
            String dimNumber = drillConfig.getDimNum();
            String memNumber = drillConfig.getMemNum();
            if (StringUtils.isBlank((CharSequence)dimNumber) || StringUtils.isBlank((CharSequence)memNumber)) {
                return;
            }
            Dimension dimension = (Dimension)dimensionMap.get(dimNumber);
            if (dimension == null) {
                throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u8054\u52a8\u67e5\u8be2\u7f3a\u5c11\u5173\u8054\u7ef4\u5ea6: %1\u3002", (String)"AnalysisService_7", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
            Member member = dimension.getMember(viewMap.get(dimNumber), memNumber);
            if (member == null) {
                throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u8054\u52a8\u67e5\u8be2\u7f3a\u5c11\u5173\u8054\u7ef4\u5ea6\u6210\u5458: %1[%2]\u3002", (String)"AnalysisService_8", (String)"epm-eb-business", (Object[])new Object[]{dimNumber, memNumber}));
            }
            if (!SysDimensionEnum.Account.getNumber().equals(dimNumber) || member.getDatasetId() == null || datasetId == member.getDatasetId()) continue;
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u8054\u52a8\u67e5\u8be2\u7f3a\u5c11\u5173\u8054\u7ef4\u5ea6\u6210\u5458: %1[%2]\u3002", (String)"AnalysisService_8", (String)"epm-eb-business", (Object[])new Object[]{dimNumber, memNumber}));
        }
    }

    protected List<Member> filterDrillMemberAgg(List<Member> members) {
        List<Object> filterMembers = members;
        AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(this.canvasBox.getCanvasId());
        PageConfig pageConfig = (PageConfig)JSON.parseObject((String)canvas.getPage(), PageConfig.class);
        if (pageConfig != null && "1".equals(pageConfig.getAgg())) {
            filterMembers = members.stream().filter(m -> !AggOprtEnum.SKIP.getSign().equals(m.getAggType())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(filterMembers)) {
            throw new AnalysisCanvasException(ResManager.loadKDString((String)"\u4e0b\u94bb\u540e\u805a\u5408\u7b97\u6cd5\u975e\u201c\u5ffd\u7565\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e0b\u94bb\u3002", (String)"AnalysisService_29", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return filterMembers;
    }

    protected void setRelQueryFixMember(AnalysisCanvasConstants.OptType optType, Map<String, String> fixMemberMap, JSONObject calcParam) {
        if (optType != AnalysisCanvasConstants.OptType.REL_QUERY || calcParam == null || calcParam.getJSONArray("drill") == null) {
            return;
        }
        List drillConfigs = JSONObject.parseArray((String)JSONObject.toJSONString((Object)calcParam.getJSONArray("drill")), DrillConfig.class);
        for (DrillConfig drillConfig : drillConfigs) {
            String dimNumber = drillConfig.getDimNum();
            String memNumber = drillConfig.getMemNum();
            if (StringUtils.isBlank((CharSequence)dimNumber) || StringUtils.isBlank((CharSequence)memNumber)) {
                return;
            }
            fixMemberMap.put(dimNumber, memNumber);
        }
    }

    protected void checkQueryDim(Map<String, Set<String>> queryDim, Map<String, Long> viewMap, IModelCacheHelper modelCache, long datasetId) {
        if (queryDim == null || modelCache == null) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)modelCache.getModelobj().getId(), (String)"epm_model", (String)"currentmode");
        if (dynamicObject != null && CurrentModeEnum.ADMIN.getIndex().equals(dynamicObject.getString("currentmode"))) {
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u5f53\u524d\u63a7\u4ef6\u6240\u5c5e\u4f53\u7cfb\u5904\u4e8e\u8fd0\u7ef4\u4e2d\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u6216\u4fee\u6539\u6570\u636e\u3002", (String)"AnalysisService_27", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        Map dimensionMap = modelCache.getDimensionMap(Long.valueOf(datasetId));
        try {
            queryDim.forEach((dimNumber, memSet) -> {
                if (CollectionUtils.isEmpty((Collection)memSet)) {
                    throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7ef4\u5ea6[%1]\u7f3a\u5c11\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"AnalysisService_11", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
                }
                Dimension dimension = (Dimension)dimensionMap.get(dimNumber);
                if (dimension == null) {
                    throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7ef4\u5ea6[%1]\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"AnalysisService_12", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
                }
                memSet.forEach(memNumber -> {
                    Member member = dimension.getMember((Long)viewMap.get(dimNumber), memNumber);
                    if (member == null) {
                        throw new AnalysisCanvasException(ResManager.loadResFormat((String)"[%1]\u7ef4\u5ea6\u6210\u5458[%2]\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"AnalysisService_13", (String)"epm-eb-business", (Object[])new Object[]{dimNumber, memNumber}));
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(dimNumber) && member.getDatasetId() != null && datasetId != member.getDatasetId()) {
                        throw new AnalysisCanvasException(ResManager.loadResFormat((String)"[%1]\u7ef4\u5ea6\u6210\u5458[%2]\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"AnalysisService_13", (String)"epm-eb-business", (Object[])new Object[]{dimNumber, memNumber}));
                    }
                });
            });
        }
        catch (Exception e) {
            throw new AnalysisCanvasException(e.getMessage());
        }
    }

    protected long getViewId(String dimNumber, JSONObject dimensionViews) {
        return ModelHelper.getViewId(dimNumber, dimensionViews);
    }

    protected Map<String, Long> getViewMap(JSONObject dimensionViews) {
        return ModelHelper.getViewMap(dimensionViews);
    }

    protected AnalysisCanvasDataset getAnalysisCubeId(long canvasId, long boxId, long datasetId) {
        return AnalysisCubeService.getInstance().getAnalysisDataset(canvasId, boxId, datasetId);
    }

    protected MembersKey transToMembersKey(Map<String, ?> cellMemberMap, List<String> sortedDimList, IModelCacheHelper modelCache) {
        return ModelHelper.transToMembersKey(cellMemberMap, sortedDimList, modelCache);
    }

    protected Map<String, String> transToMemberMap(Object[] membersKeys, List<String> sortedDimList) {
        return ModelHelper.transToMemberMap(membersKeys, sortedDimList);
    }

    protected String getMemberKeyStr(Object[] keys) {
        return ModelHelper.getMemberKeyStr(keys);
    }

    protected List<Map<String, Object>> mergeChangeMembers(Map<MembersKey, ValueDto> changeMap, List<String> sortedDimList, List<Map<String, Object>> changeMembers, IModelCacheHelper modelCache) {
        if (changeMembers == null) {
            changeMembers = new ArrayList<Map<String, Object>>(changeMap.size());
        }
        ArrayList newDatas = new ArrayList(changeMembers.size());
        ArrayList removeDatas = new ArrayList(changeMembers.size());
        changeMembers.forEach(map -> {
            int reduceKeySize;
            int n = reduceKeySize = map.containsKey("_t") ? 2 : 1;
            if (map.size() - reduceKeySize != sortedDimList.size()) {
                removeDatas.add(map);
                LinkedHashMap newMemberMap = new LinkedHashMap(sortedDimList.size() + 2);
                for (String dimNumber : sortedDimList) {
                    Object memNumber = map.get(dimNumber);
                    if (memNumber == null) {
                        Dimension dimension = modelCache.getDimension(dimNumber);
                        memNumber = dimension.getNoneNumber();
                    }
                    newMemberMap.put(dimNumber, memNumber);
                }
                newMemberMap.put("_v", map.get("_v"));
                newMemberMap.put("_t", map.getOrDefault("_t", 0L));
                newMemberMap.put("_vw", map.get("_vw"));
                newDatas.add(newMemberMap);
            }
        });
        if (CollectionUtils.isNotEmpty(removeDatas)) {
            changeMembers.removeAll(removeDatas);
        }
        if (CollectionUtils.isNotEmpty(newDatas)) {
            changeMembers.addAll(newDatas);
        }
        Map changeMemberMap = changeMembers.stream().collect(Collectors.toMap(m -> this.transToMembersKey((Map<String, ?>)m, sortedDimList, modelCache), v -> v, (o1, o2) -> o2, LinkedHashMap::new));
        changeMap.forEach((k, dto) -> {
            changeMemberMap.remove(k);
            Map<String, String> memberMap = this.transToMemberMap(k.getKeys(), sortedDimList);
            if (memberMap == null) {
                return;
            }
            LinkedHashMap<String, Object> newMemberMap = new LinkedHashMap<String, Object>(sortedDimList.size() + 2);
            newMemberMap.putAll(memberMap);
            newMemberMap.put("_v", dto.getV());
            newMemberMap.put("_t", dto.getT());
            newMemberMap.put("_vw", JSONObject.toJSONString(dto.getVw()));
            changeMemberMap.put(k, newMemberMap);
        });
        return new ArrayList<Map<String, Object>>(changeMemberMap.values());
    }

    protected Map<MembersKey, ValueDto> filterPermWrite(long datasetId, Map<MembersKey, ValueDto> changeMap, IModelCacheHelper modelCache, List<String> sortedDimList) {
        HashMap bgCellListMap = Maps.newHashMapWithExpectedSize((int)changeMap.size());
        changeMap.forEach((key, valueDto) -> {
            if (valueDto == null) {
                return;
            }
            Map<String, String> memberMap = this.transToMemberMap(key.getKeys(), sortedDimList);
            Map<String, Long> viewMap = valueDto.getVw();
            Long hashId = ModelHelper.getViewHash(sortedDimList, viewMap);
            Pair listMapPair = bgCellListMap.computeIfAbsent(hashId, e -> Pair.of(new ArrayList(), (Object)viewMap));
            BGCell newCell = new BGCell(memberMap);
            newCell.setValue((Object)new BigDecimal(valueDto.getV().toString()));
            ((List)listMapPair.getLeft()).add(newCell);
        });
        if (MapUtils.isEmpty((Map)bgCellListMap)) {
            return new HashMap<MembersKey, ValueDto>(16);
        }
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)changeMap.size());
        bgCellListMap.forEach((hashId, pair) -> {
            SaveRequest request = new SaveRequest(modelCache.getModelobj().getId(), Long.valueOf(datasetId), (List)pair.getLeft(), (Map)pair.getRight());
            AlgoCalcUtils.filterPermWrite((SaveRequest)request, (IModelCacheHelper)modelCache);
            if (CollectionUtils.isNotEmpty((Collection)request.getDatas())) {
                datas.addAll(request.getDatas());
            }
        });
        if (CollectionUtils.isEmpty((Collection)datas)) {
            return new HashMap<MembersKey, ValueDto>(16);
        }
        HashMap<MembersKey, ValueDto> resultMap = new HashMap<MembersKey, ValueDto>(changeMap.size());
        datas.forEach(bgCell -> {
            MembersKey key = this.transToMembersKey(bgCell.getMemberMap(), sortedDimList, modelCache);
            resultMap.put(key, (ValueDto)changeMap.get(key));
        });
        return resultMap;
    }

    protected Map<Long, Pair<List<BGCell>, Map<String, Long>>> buildChangeCell(Map<MembersKey, ValueDto> changeMap, List<String> sortedDimList) {
        HashMap bgCellListMap = Maps.newHashMapWithExpectedSize((int)changeMap.size());
        changeMap.forEach((key, valueDto) -> {
            if (valueDto == null || valueDto.getV() == null) {
                return;
            }
            Map<String, Long> viewMap = valueDto.getVw();
            Long hashId = ModelHelper.getViewHash(sortedDimList, viewMap);
            Map<String, String> memberMap = this.transToMemberMap(key.getKeys(), sortedDimList);
            BGCell newCell = new BGCell(memberMap);
            newCell.setValue((Object)new BigDecimal(valueDto.getV().toString()));
            Pair cellPair = bgCellListMap.computeIfAbsent(hashId, e -> Pair.of(new ArrayList(), (Object)viewMap));
            ((List)cellPair.getLeft()).add(newCell);
        });
        return bgCellListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToSandboxAndExecuteRuleChain(long modelId, long datasetId, AnalysisCanvasDataset canvasDataset, List<BGCell> changeCells, Map<String, Long> viewMap) {
        try {
            AnalysisContext analysisContext = new AnalysisContext(canvasDataset.getAnalysisCubeId().longValue(), this.canvasBox.getCanvasId().longValue(), this.canvasBox.getId().longValue(), canvasDataset.getSeq().intValue());
            OlapContext.setAnalysisContext((AnalysisContext)analysisContext);
            analysisContext.getAnalysisCubeMap().put(datasetId, canvasDataset.getAnalysisCubeNum());
            OlapDataAuditService.getInstance().setOperationContextDefaultFormId(OlapDataAuditEventEnum.AnalysisCanvas.getDesc());
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.AnalysisCanvas));
            OlapTraceServiceHelper.setTraceOpInfo((String)AnalysisCanvasBoxService.getInstance().loadCacheName(canvasDataset.getBoxId()));
            SaveRequest request = new SaveRequest(Long.valueOf(modelId), Long.valueOf(datasetId), changeCells, viewMap);
            SaveBizTemplate saveBizTemplate = SaveBizTemplate.newInstance();
            OlapWriteOption opt = new OlapWriteOption();
            opt.setIgnoreDataLock(true);
            saveBizTemplate.setOlapWriteOption(opt);
            List saveCells = saveBizTemplate.doService(request);
            Options options = new Options();
            options.setUseAnalysis(Boolean.valueOf(true));
            options.setAnalysisContext(analysisContext);
            RuleExecutionService.getInstance().executeRuleChain(null, datasetId, modelId, saveCells, RuleExecuteTypeEnum.ANALYSIS.getType(), options);
        }
        finally {
            OlapContext.clearAnalysisContext();
        }
    }

    protected Object[] splitChangeObj(Object obj) {
        if (obj == null) {
            return null;
        }
        Object[] datas = new Object[4];
        String[] split = obj.toString().split("@");
        if (split.length == 4) {
            System.arraycopy(split, 0, datas, 0, 4);
        } else {
            datas[0] = split[0];
            datas[1] = null;
            datas[2] = 1;
            datas[3] = 1;
        }
        return datas;
    }

    protected void buildCoverData(String modelIdStr, String datasetIdStr, List<Map<String, Object>> changeMembers, List<SaveDto> saveDtoList) {
        if (CollectionUtils.isEmpty(changeMembers)) {
            return;
        }
        Long modelId = IDUtils.toLong((Object)modelIdStr);
        Long datasetId = IDUtils.toLong((Object)datasetIdStr);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        changeMembers.forEach(changeMap -> {
            Object val = changeMap.get("_v");
            if (val == null) {
                return;
            }
            LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>(sortedDimList.size());
            changeMap.forEach((k, v) -> {
                if ("_v".equals(k) || "_t".equals(k) || "_vw".equals(k)) {
                    return;
                }
                memberMap.put((String)k, v.toString());
            });
            this.fillMissMember(memberMap, sortedDimList, modelCache);
            BGCell data = new BGCell(memberMap);
            BigDecimal newData = new BigDecimal(val.toString());
            data.setValue((Object)newData);
            Map<String, Long> viewMap = ModelHelper.getViewMap((String)changeMap.get("_vw"), (List<String>)sortedDimList, modelCache, datasetId);
            Long viewHash = ModelHelper.getViewHash(sortedDimList, viewMap);
            Optional<SaveDto> optional = saveDtoList.stream().filter(e -> modelId.equals(e.getModelId()) && datasetId.equals(e.getDatasetId()) && viewHash.equals(e.getViewId())).findFirst();
            if (optional.isPresent()) {
                optional.get().getCells().add(data);
            } else {
                SaveDto saveDto = new SaveDto(modelId, datasetId, viewHash, viewMap);
                saveDto.getCells().add(data);
                saveDtoList.add(saveDto);
            }
        });
    }
}

