/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BizDataService
extends AbstractDataService {
    public BizDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            try {
                BizModel bizModel = ModelHelper.getModel(item, BizModel.class);
                long modelId = IDUtils.toLong((Object)bizModel.getModel());
                long datasetId = IDUtils.toLong((Object)bizModel.getDataset());
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
                if (CollectionUtils.isEmpty(bizModel.getBizConfig())) {
                    throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u4e1a\u52a1\u6307\u6807\u7ec4\u4ef6\u7f3a\u5c11\u4e3b\u6307\u6807\u6210\u5458\u3002", (String)"AnalysisService_2", (String)"epm-eb-business", (Object[])new Object[0]));
                }
                bizModel.getBizConfig().forEach(config -> {
                    JSONObject dimensionViews = config.getDimensionViews();
                    Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                    this.checkRelQueryDim(optType, viewMap, modelCache, datasetId, calcParam);
                    HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
                    HashSet<String> bizMemberSet = new HashSet<String>(2);
                    if (config.getNum() != null && StringUtils.isNotBlank((CharSequence)config.getNum())) {
                        bizMemberSet.add(config.getNum());
                    }
                    queryDim.put(config.getDim(), bizMemberSet);
                    this.setOtherDim(config.getDims(), filterDim, queryDim);
                    this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
                    QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                    QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
                });
            }
            catch (AnalysisCanvasException e) {
                item.setCode(e.getCode() != null ? e.getCode() : 1);
                item.setMsg(e.getMessage());
            }
        });
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            BizModel bizModel = ModelHelper.getModel(item, BizModel.class);
            Long modelId = IDUtils.toLong((Object)bizModel.getModel());
            Long datasetId = IDUtils.toLong((Object)bizModel.getDataset());
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
            bizModel.getBizConfig().forEach(config -> {
                JSONObject dimensionViews = config.getDimensionViews();
                Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
                Map<String, String> fixMemberMap = this.genFixMemberMap(config.getDims(), filterDim);
                this.setRelQueryFixMember(optType, fixMemberMap, calcParam);
                this.processModelResult(bizModel, (BizValue)config, fixMemberMap, queryResult);
            });
            ModelHelper.updateModel(item, bizModel);
        });
    }

    private void processModelResult(BizModel bizModel, BizValue config, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult) {
        JSONObject dimensionViews = config.getDimensionViews();
        Map<String, Long> viewMap = this.getViewMap(dimensionViews);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)bizModel.getModel()));
        List allDims = modelCache.getDimensionList(IDUtils.toLong((Object)bizModel.getDataset()));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        String bizDim = config.getDim();
        this.setValue(bizDim, config, fixMemberMap, sortedDimList, queryResult, modelCache, viewMap);
    }

    private void setValue(String bizDim, BizValue bizValue, Map<String, String> fixMemberMap, List<String> sortedDimList, Map<MembersKey, BGCell> keyBGCellMap, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        if (bizValue == null) {
            return;
        }
        String memNum = bizValue.getNum();
        HashMap<String, String> queryCellMap = new HashMap<String, String>(fixMemberMap);
        if (!queryCellMap.containsKey(bizDim)) {
            queryCellMap.put(bizDim, memNum);
        }
        this.fillMissMember(queryCellMap, sortedDimList, modelCache);
        Object value = this.getCellValue(modelCache, queryCellMap, sortedDimList, keyBGCellMap);
        bizValue.setValue(value);
        String dimNumber = SysDimensionEnum.Metric.getNumber();
        String memNumber = (String)queryCellMap.get(SysDimensionEnum.Metric.getNumber());
        Long viewId = viewMap.get(dimNumber);
        Member metricMember = modelCache.getMember(dimNumber, viewId, memNumber);
        bizValue.setDt(metricMember.getDatatype());
    }
}

