/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.IVarService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.bizrule.RuleFindService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DupontDataService
extends AbstractDataService
implements IVarService {
    public DupontDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            try {
                DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
                long modelId = IDUtils.toLong((Object)dupontModel.getModel());
                long datasetId = IDUtils.toLong((Object)dupontModel.getDataset());
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
                dupontModel.getDupontConfig().forEach(config -> {
                    JSONObject dimensionViews = config.getDimensionViews();
                    Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                    this.checkRelQueryDim(optType, viewMap, modelCache, datasetId, calcParam);
                    HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
                    HashSet<String> indexMemberSet = new HashSet<String>(2);
                    if (config.getDim() != null && StringUtils.isNotBlank((CharSequence)config.getNum())) {
                        indexMemberSet.add(config.getNum());
                    }
                    queryDim.put(config.getDim(), indexMemberSet);
                    this.setOtherDim(config.getDims(), filterDim, queryDim);
                    this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
                    QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                    QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
                });
            }
            catch (AnalysisCanvasException e) {
                item.setCode(e.getCode() != null ? e.getCode() : 1);
                item.setMsg(e.getMessage());
            }
        });
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            Long modelId = IDUtils.toLong((Object)dupontModel.getModel());
            Long datasetId = IDUtils.toLong((Object)dupontModel.getDataset());
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
            dupontModel.getDupontConfig().forEach(config -> {
                JSONObject dimensionViews = config.getDimensionViews();
                Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
                Map<String, String> fixMemberMap = this.genFixMemberMap(config.getDims(), filterDim);
                this.setRelQueryFixMember(optType, fixMemberMap, calcParam);
                this.processModelResult(dupontModel, (BizValue)config, fixMemberMap, queryResult);
            });
            ModelHelper.updateModel(item, dupontModel);
        });
    }

    private void processModelResult(BaseModel baseModel, BizValue config, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult) {
        RuleDto ruleDto;
        DupontModel dupontModel = (DupontModel)baseModel;
        JSONObject dimensionViews = config.getDimensionViews();
        Map<String, Long> viewMap = this.getViewMap(dimensionViews);
        Long modelId = IDUtils.toLong((Object)dupontModel.getModel());
        Long datasetId = IDUtils.toLong((Object)dupontModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(datasetId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        String bizDim = config.getDim();
        String memNum = config.getNum();
        HashMap<String, String> queryCellMap = new HashMap<String, String>(fixMemberMap);
        queryCellMap.put(bizDim, memNum);
        this.fillMissMember(queryCellMap, sortedDimList, modelCache);
        Object value = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
        config.setValue(value);
        Member member = modelCache.getMember(bizDim, viewMap.get(bizDim), memNum);
        config.setName(member.getName());
        int cellType = 1;
        for (Map.Entry entry : queryCellMap.entrySet()) {
            String dimNumber = (String)entry.getKey();
            String memNumber = (String)entry.getValue();
            Long viewId = viewMap.get(dimNumber);
            Member member1 = modelCache.getMember(dimNumber, viewId, memNumber);
            if (member1.isLeaf()) continue;
            cellType = 0;
            break;
        }
        if ((ruleDto = RuleFindService.getInstance().findRuleByCell(modelId, datasetId, viewMap, queryCellMap)) != null) {
            cellType += 4;
        }
        config.setCt(cellType);
        String dimNumber = SysDimensionEnum.Metric.getNumber();
        String memNumber = (String)queryCellMap.get(SysDimensionEnum.Metric.getNumber());
        Long viewId = viewMap.get(dimNumber);
        Member metricMember = modelCache.getMember(dimNumber, viewId, memNumber);
        config.setDt(metricMember.getDatatype());
    }

    @Override
    public void processChangeMember(List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers) {
        itemList.forEach(item -> {
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            this.processItemChangeMember(item.getId(), dupontModel, filterItemList, calcChangeMembers);
            ModelHelper.updateModel(item, dupontModel);
        });
    }

    private void processItemChangeMember(String itemId, DupontModel dupontModel, List<CustomItem> filterItemList, Map<String, ValueDto> totalChangeMembers) {
        Long modelId = IDUtils.toLong((Object)dupontModel.getModel());
        Long datasetId = IDUtils.toLong((Object)dupontModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Map<String, String> filterDim = ModelHelper.getFilterFromSelector(itemId, filterItemList);
        HashMap queryDim = new HashMap(20);
        HashMap<MembersKey, ValueDto> currChangeMap = new HashMap<MembersKey, ValueDto>(1);
        dupontModel.getDupontConfig().forEach(config -> {
            String varDim = config.getDim();
            Map<String, DimensionModel> modelDimMap = config.getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
            if (config.getCt() == null || config.getCt() != 1 || config.getValue() == null || StringUtils.isBlank((CharSequence)config.getValue().toString()) || BooleanUtils.isNotTrue((Boolean)config.getC())) {
                return;
            }
            config.setC(Boolean.FALSE);
            LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>(allDims.size());
            for (Dimension dim : allDims) {
                String memNumber;
                String dimNumber = dim.getNumber();
                if (dimNumber.equals(varDim)) {
                    memNumber = config.getNum();
                } else {
                    DimensionModel dimModel = modelDimMap.get(dimNumber);
                    if (dimModel != null) {
                        if (dimModel.getS().booleanValue()) {
                            MemberModel member = dimModel.getMems().get(0);
                            memNumber = member.getNum();
                        } else {
                            memNumber = (String)filterDim.get(dimNumber);
                        }
                    } else {
                        Dimension dimension = modelCache.getDimension(dimNumber);
                        memNumber = dimension.getNoneNumber();
                    }
                }
                memberMap.put(dimNumber, memNumber);
            }
            memberMap.forEach((key, value) -> {
                Set queryMemSet = queryDim.computeIfAbsent(key, v -> new HashSet(8));
                queryMemSet.add(value);
            });
            MembersKey membersKey = this.transToMembersKey(memberMap, sortedDimList, modelCache);
            ValueDto valueDto = (ValueDto)totalChangeMembers.get(this.getMemberKeyStr(membersKey.getKeys()));
            if (valueDto != null && valueDto.getT() != null && config.getT() < valueDto.getT()) {
                return;
            }
            currChangeMap.put(membersKey, new ValueDto(config.getValue(), config.getT(), ModelHelper.getViewMap(config.getDimensionViews(), sortedDimList, modelCache, datasetId)));
        });
        Map<MembersKey, ValueDto> changeMap = this.filterPermWrite(datasetId, currChangeMap, modelCache, sortedDimList);
        if (MapUtils.isNotEmpty(changeMap)) {
            changeMap.forEach((key, value) -> totalChangeMembers.put(this.getMemberKeyStr(key.getKeys()), (ValueDto)value));
            List<Map<String, Object>> changeMembers = this.mergeChangeMembers(changeMap, sortedDimList, dupontModel.getChangeMembers(), modelCache);
            dupontModel.setChangeMembers(changeMembers);
        }
        if (CollectionUtils.isNotEmpty(dupontModel.getChangeMembers())) {
            dupontModel.getChangeMembers().forEach(memberMap -> {
                MembersKey membersKey = this.transToMembersKey((Map<String, ?>)memberMap, sortedDimList, modelCache);
                if (!changeMap.containsKey(membersKey)) {
                    if (totalChangeMembers.containsKey(this.getMemberKeyStr(membersKey.getKeys()))) {
                        return;
                    }
                    changeMap.put(membersKey, new ValueDto(memberMap.get("_v"), Long.parseLong(((Object)memberMap.getOrDefault("_t", 0L)).toString()), ModelHelper.getViewMap((String)memberMap.get("_vw"), sortedDimList, modelCache, datasetId)));
                    for (Dimension dim : allDims) {
                        String dimNumber = dim.getNumber();
                        Object memNumber = memberMap.get(dimNumber);
                        if (memNumber == null) {
                            Dimension dimension = modelCache.getDimension(dimNumber);
                            memNumber = dimension.getNoneNumber();
                        }
                        Set queryMemSet = queryDim.computeIfAbsent(dimNumber, s -> new HashSet(8));
                        queryMemSet.add(memNumber.toString());
                    }
                }
            });
        }
        if (MapUtils.isEmpty(changeMap)) {
            return;
        }
        Map<Long, Pair<List<BGCell>, Map<String, Long>>> changeCells = this.buildChangeCell(changeMap, sortedDimList);
        if (MapUtils.isEmpty(changeCells)) {
            return;
        }
        AnalysisCanvasDataset canvasDataset = this.getAnalysisCubeId(this.canvasBox.getCanvasId(), this.canvasBox.getId(), datasetId);
        changeCells.forEach((key, pair) -> this.saveToSandboxAndExecuteRuleChain(modelId, datasetId, canvasDataset, (List)pair.getLeft(), (Map)pair.getRight()));
    }

    @Override
    public List<SaveDto> getCoverData(List<CustomItem> itemList, List<CustomItem> filterItemList) {
        ArrayList<SaveDto> saveDtoList = new ArrayList<SaveDto>(4);
        itemList.forEach(item -> {
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            this.buildCoverData(dupontModel.getModel(), dupontModel.getDataset(), dupontModel.getChangeMembers(), saveDtoList);
        });
        return saveDtoList;
    }
}

