/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.BizDataService;
import kd.epm.eb.business.analysiscanvas.query.DupontDataService;
import kd.epm.eb.business.analysiscanvas.query.PredictDataService;
import kd.epm.eb.business.analysiscanvas.query.SliderDataService;
import kd.epm.eb.business.analysiscanvas.query.TableDataService;
import kd.epm.eb.business.analysiscanvas.query.chart.ChartDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.table.Table2DataService;

public interface IDataService {
    public void buildQueryDim(List<CustomItem> var1, List<CustomItem> var2, List<QueryDto> var3, AnalysisCanvasConstants.OptType var4, JSONObject var5);

    public void processQueryResult(List<CustomItem> var1, List<CustomItem> var2, List<QueryDto> var3, AnalysisCanvasConstants.OptType var4, JSONObject var5);

    public static IDataService getInstance(String type, AnalysisCanvasBox canvasBox, IFormView formView) {
        AbstractDataService dataService;
        switch (type) {
            case "chart": {
                dataService = new ChartDataService(canvasBox, formView);
                break;
            }
            case "bizindicator": {
                dataService = new BizDataService(canvasBox, formView);
                break;
            }
            case "table": {
                dataService = new TableDataService(canvasBox, formView);
                break;
            }
            case "table2": {
                dataService = new Table2DataService(canvasBox, formView);
                break;
            }
            case "slider": {
                dataService = new SliderDataService(canvasBox, formView);
                break;
            }
            case "dupontnode": {
                dataService = new DupontDataService(canvasBox, formView);
                break;
            }
            case "predict": {
                dataService = new PredictDataService(canvasBox, formView);
                break;
            }
            default: {
                dataService = null;
            }
        }
        return dataService;
    }
}

