/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.PredictModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.IVarService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.forecast.model.PredModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PredictDataService
extends AbstractDataService
implements IVarService {
    public PredictDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
    }

    public List<Map<String, Object>> buildChangeMember(long modelId, long datasetId, List<PredModel> predModels) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        HashMap<MembersKey, ValueDto> currChangeMap = new HashMap<MembersKey, ValueDto>(50);
        block0: for (PredModel predModel : predModels) {
            Map<String, Long> viewMap = predModel.getDimViewMap();
            List<String> predIndexNumberList = predModel.getPredIndexNumberList();
            List<Double> predDataList = predModel.getPredDataList();
            List<String> members = predModel.getMembers();
            for (int i = 0; i < predIndexNumberList.size(); ++i) {
                Double predValue = predDataList.get(i);
                if (predValue == null) continue;
                String periodNumber = predIndexNumberList.get(i);
                LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>(sortedDimList.size());
                AtomicInteger index = new AtomicInteger(0);
                sortedDimList.forEach(dim -> {
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dim)) {
                        memberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
                    } else {
                        int j = index.getAndIncrement();
                        if (j >= members.size()) {
                            Dimension dimension = modelCache.getDimension(dim);
                            memberMap.put((String)dim, dimension.getNoneNumber());
                        } else {
                            memberMap.put((String)dim, (String)members.get(j));
                        }
                    }
                });
                RuleDto ruleDto = AnalysisCanvasUtils.getCellRule(modelId, datasetId, viewMap, memberMap);
                if (ruleDto != null) continue;
                String metricType = ModelHelper.getMetricType(memberMap, modelCache);
                if (!MetricDataTypeEnum.isNumber((String)metricType)) continue block0;
                boolean notLeaf = false;
                for (Map.Entry entry : memberMap.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    String memNumber = (String)entry.getValue();
                    Long viewId = viewMap.get(dimNumber);
                    Member realMember = modelCache.getMember(dimNumber, viewId, memNumber);
                    if (realMember != null && realMember.isLeaf()) continue;
                    notLeaf = true;
                    break;
                }
                if (notLeaf) continue block0;
                BigDecimal dataUnitNum = new BigDecimal(predModel.getDataUnit());
                BigDecimal newData = BigDecimal.valueOf(predValue).multiply(dataUnitNum);
                MembersKey membersKey = this.transToMembersKey(memberMap, sortedDimList, modelCache);
                currChangeMap.put(membersKey, new ValueDto(newData.toString(), System.currentTimeMillis(), ModelHelper.getViewMap(viewMap, sortedDimList, modelCache, (Long)datasetId)));
            }
        }
        Map<MembersKey, ValueDto> changeMap = this.filterPermWrite(datasetId, currChangeMap, modelCache, sortedDimList);
        List<Map<String, Object>> changeMembers = Collections.emptyList();
        if (MapUtils.isNotEmpty(changeMap)) {
            changeMembers = this.mergeChangeMembers(changeMap, sortedDimList, null, modelCache);
        }
        return changeMembers;
    }

    @Override
    public void processChangeMember(List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers) {
        itemList.forEach(item -> {
            PredictModel predictModel = ModelHelper.getModel(item, PredictModel.class);
            this.processItemChangeMember(predictModel, calcChangeMembers);
            ModelHelper.updateModel(item, predictModel);
        });
    }

    private void processItemChangeMember(PredictModel predictModel, Map<String, ValueDto> totalChangeMembers) {
        if (CollectionUtils.isEmpty(predictModel.getChangeMembers())) {
            return;
        }
        Long modelId = IDUtils.toLong((Object)predictModel.getModel());
        Long datasetId = IDUtils.toLong((Object)predictModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        HashMap queryDim = new HashMap(20);
        HashMap<MembersKey, ValueDto> changeMap = new HashMap<MembersKey, ValueDto>(50);
        predictModel.getChangeMembers().forEach(memberMap -> {
            MembersKey membersKey = this.transToMembersKey((Map<String, ?>)memberMap, sortedDimList, modelCache);
            long changeTime = Long.parseLong(((Object)memberMap.getOrDefault("_t", 0L)).toString());
            ValueDto valueDto = (ValueDto)totalChangeMembers.get(this.getMemberKeyStr(membersKey.getKeys()));
            if (valueDto != null && valueDto.getT() != null && changeTime < valueDto.getT()) {
                return;
            }
            changeMap.put(membersKey, new ValueDto(memberMap.get("_v"), Long.parseLong(((Object)memberMap.getOrDefault("_t", 0L)).toString()), ModelHelper.getViewMap((String)memberMap.get("_vw"), sortedDimList, modelCache, datasetId)));
            for (Dimension dim : allDims) {
                String dimNumber = dim.getNumber();
                Object memNumber = memberMap.get(dimNumber);
                if (memNumber == null) {
                    Dimension dimension = modelCache.getDimension(dimNumber);
                    memNumber = dimension.getNoneNumber();
                }
                Set queryMemSet = queryDim.computeIfAbsent(dimNumber, s -> new HashSet(8));
                queryMemSet.add(memNumber.toString());
            }
        });
        if (MapUtils.isEmpty(changeMap)) {
            return;
        }
        Map<Long, Pair<List<BGCell>, Map<String, Long>>> changeCells = this.buildChangeCell(changeMap, sortedDimList);
        if (MapUtils.isEmpty(changeCells)) {
            return;
        }
        AnalysisCanvasDataset canvasDataset = this.getAnalysisCubeId(this.canvasBox.getCanvasId(), this.canvasBox.getId(), datasetId);
        changeCells.forEach((key, pair) -> this.saveToSandboxAndExecuteRuleChain(modelId, datasetId, canvasDataset, (List)pair.getLeft(), (Map)pair.getRight()));
    }

    @Override
    public List<SaveDto> getCoverData(List<CustomItem> itemList, List<CustomItem> filterItemList) {
        ArrayList<SaveDto> saveDtoList = new ArrayList<SaveDto>(4);
        itemList.forEach(item -> {
            PredictModel predictModel = ModelHelper.getModel(item, PredictModel.class);
            this.buildCoverData(predictModel.getModel(), predictModel.getDataset(), predictModel.getChangeMembers(), saveDtoList);
        });
        return saveDtoList;
    }
}

