/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.DrillConfig;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.query.AnalysisPools;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapReportService;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryService {
    private static final Log log = LogFactory.getLog(QueryService.class);

    public static QueryService getInstance() {
        return InnerClass.instance;
    }

    private QueryService() {
    }

    public void queryBaseData(List<QueryDto> queryList, JSONObject calcParam) {
        AnalysisCanvasConstants.CalcType calcType = AnalysisCanvasConstants.CalcType.BASE;
        AnalysisCanvasConstants.OptType optType = AnalysisCanvasConstants.OptType.CALC;
        this.calc(null, calcType, optType, queryList, calcParam);
    }

    public void querySandboxData(AnalysisCanvasBox canvasBox, List<QueryDto> queryList, JSONObject calcParam) {
        AnalysisCanvasConstants.CalcType calcType = AnalysisCanvasConstants.CalcType.SAND;
        AnalysisCanvasConstants.OptType optType = AnalysisCanvasConstants.OptType.CALC;
        this.calc(canvasBox, calcType, optType, queryList, calcParam);
    }

    public void calc(AnalysisCanvasBox canvasBox, AnalysisCanvasConstants.CalcType calcType, AnalysisCanvasConstants.OptType optType, List<QueryDto> queryList, JSONObject calcParam) {
        String traceId = calcParam == null ? RequestContext.get().getTraceId() : calcParam.getString("traceId");
        String logPrefix = "AnalysisCanvas calc traceId:" + traceId;
        int querySize = queryList.size();
        ArrayList<Future> futureList = new ArrayList<Future>(querySize);
        for (QueryDto queryDto : queryList) {
            Future future = AnalysisPools.QUERY_POOL.submit(() -> {
                Long modelId = queryDto.getModelId();
                Long datasetId = queryDto.getDatasetId();
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Long bizModelId = modelCache.getBusModelByDataSet(datasetId);
                Map<String, Long> viewMap = queryDto.getViewMap();
                Map<String, Set<String>> queryDim = queryDto.getQueryDim();
                this.fillQueryDim(modelCache, datasetId, queryDim);
                List<BGCell> bgCells = this.doCalc(canvasBox, calcType, optType, modelId, bizModelId, datasetId, queryDim, viewMap, calcParam, logPrefix);
                queryDto.setQueryResult(bgCells);
                return null;
            }, RequestContext.getOrCreate());
            futureList.add(future);
        }
        for (Future future : futureList) {
            try {
                future.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.error(e.getMessage(), (Throwable)e);
                if (e.getCause() instanceof RejectedExecutionException) {
                    throw new AnalysisCanvasException(e, new ErrorCode("Analysis.QueryService", ResManager.loadResFormat((String)"Olap\u67e5\u8be2\u7e41\u5fd9\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"AnalysisService_22", (String)"epm-eb-business", (Object[])new Object[0])), e.getMessage());
                }
                throw new KDBizException((Throwable)e, new ErrorCode("Analysis.QueryService", e.getMessage()), new Object[]{e.getMessage()});
            }
        }
    }

    private void fillQueryDim(IModelCacheHelper modelCache, Long datasetId, Map<String, Set<String>> queryDim) {
        List dimensionList = modelCache.getDimensionList(datasetId);
        Set<String> datasetDims = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        datasetDims.forEach(dimNumber -> {
            if (!queryDim.containsKey(dimNumber)) {
                Dimension dimension = modelCache.getDimension(dimNumber);
                queryDim.put((String)dimNumber, Sets.newHashSet((Object[])new String[]{dimension.getNoneNumber()}));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BGCell> doCalc(AnalysisCanvasBox canvasBox, AnalysisCanvasConstants.CalcType calcType, AnalysisCanvasConstants.OptType optType, long modelId, long bizModelId, long datasetId, Map<String, Set<String>> queryDim, Map<String, Long> viewMap, JSONObject calcParam, String logPrefix) {
        List analysisBgCells;
        AlgoCalcRequest request;
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        AnalysisContext analysisContext = null;
        if (ModelHelper.isCalcQuery(calcType)) {
            AnalysisCanvasDataset canvasDataset = this.getAnalysisCubeId(canvasBox.getCanvasId(), canvasBox.getId(), datasetId);
            analysisContext = new AnalysisContext(canvasDataset.getAnalysisCubeId().longValue(), canvasBox.getCanvasId().longValue(), canvasBox.getId().longValue(), canvasDataset.getSeq().intValue());
            analysisContext.getAnalysisCubeMap().put(datasetId, canvasDataset.getAnalysisCubeNum());
        }
        if ((request = this.buildAlgoCalcRequest(analysisContext, optType, modelId, bizModelId, datasetId, queryDim, viewMap, calcParam)) == null) {
            log.info("{} noPermRead query modelId:{} bizModelId:{} datasetId:{}", new Object[]{logPrefix, modelId, bizModelId, datasetId});
            return Collections.emptyList();
        }
        try {
            if (analysisContext != null) {
                OlapContext.setAnalysisContext(analysisContext);
            }
            Set ruleIds = request.getRules().stream().map(RuleDto::getId).collect(Collectors.toSet());
            QueryRequest queryRequest = this.buildQueryRequest(request);
            analysisBgCells = OlapReportService.getInstance().reportQuery(ruleIds, Collections.singletonList(queryRequest));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            analysisBgCells = AlgoCalcUtils.filterPermRead((List)analysisBgCells, (long)datasetId, (Map)request.getViewMap(), (IModelCacheHelper)modelCache);
        }
        finally {
            OlapContext.clearAnalysisContext();
        }
        log.info("{} query modelId:{} bizModelId:{} datasetId:{} cost:{}ms", new Object[]{logPrefix, modelId, bizModelId, datasetId, totalStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return analysisBgCells;
    }

    public AlgoCalcRequest buildAlgoCalcRequest(AnalysisContext analysisContext, AnalysisCanvasConstants.OptType optType, long modelId, long bizModelId, long datasetId, Map<String, Set<String>> queryDim, Map<String, Long> viewMap, JSONObject calcParam) {
        this.setRelQueryDim(optType, queryDim, calcParam);
        AlgoCalcRequest request = this.buildCalcRequest(analysisContext, modelId, datasetId, viewMap, queryDim);
        request = AlgoCalcUtils.filterPermRead((AlgoCalcRequest)request, (IModelCacheHelper)ModelCacheContext.getOrCreate((Long)modelId));
        if (request != null) {
            Set<RuleDto> requestRules = this.getRule(bizModelId, request.getMemberInfo());
            request.setRules(new ArrayList<RuleDto>(requestRules));
            if (analysisContext != null) {
                requestRules.forEach(ruleDto -> {
                    List ruleRightItemDto = ruleDto.getRuleRightItemDto();
                    if (CollectionUtils.isNotEmpty((Collection)ruleRightItemDto)) {
                        ruleRightItemDto.forEach(rightItem -> {
                            Long rDatasetId = rightItem.getDataSetId();
                            if (IDUtils.isNotEmptyLong((Long)rDatasetId).booleanValue()) {
                                AnalysisCanvasDataset canvasDataset = this.getAnalysisCubeId(analysisContext.getAnalysisCanvasId(), analysisContext.getAnalysisBoxId(), rDatasetId);
                                analysisContext.getAnalysisCubeMap().put(rDatasetId, canvasDataset.getAnalysisCubeNum());
                            }
                        });
                    }
                });
            }
        }
        return request;
    }

    public QueryRequest buildQueryRequest(AlgoCalcRequest request) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setModelId(request.getModelId());
        queryRequest.setDatasetId(request.getDatasetId());
        queryRequest.setViewMap(request.getViewMap());
        queryRequest.setMemberInfo(request.getMemberInfo());
        queryRequest.setOptions(request.getOptions());
        return queryRequest;
    }

    private void setRelQueryDim(AnalysisCanvasConstants.OptType optType, Map<String, Set<String>> queryDim, JSONObject calcParam) {
        if (optType != AnalysisCanvasConstants.OptType.REL_QUERY || calcParam == null || calcParam.getJSONArray("drill") == null) {
            return;
        }
        List drillConfigs = JSONObject.parseArray((String)JSONObject.toJSONString((Object)calcParam.getJSONArray("drill")), DrillConfig.class);
        for (DrillConfig drillConfig : drillConfigs) {
            String dimNumber = drillConfig.getDimNum();
            String memNumber = drillConfig.getMemNum();
            if (StringUtils.isBlank((CharSequence)dimNumber) || StringUtils.isBlank((CharSequence)memNumber)) {
                return;
            }
            queryDim.put(dimNumber, Sets.newHashSet((Object[])new String[]{memNumber}));
        }
    }

    private Set<RuleDto> getRule(long bizModelId, Map<String, Set<String>> queryDim) {
        List allRules = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bizModelId)).getRuleDtoList();
        if (CollectionUtils.isEmpty((Collection)allRules)) {
            return Collections.emptySet();
        }
        return new HashSet<RuleDto>(AlgoCalcUtils.filterRuleByScope(queryDim, (List)allRules, null));
    }

    private AlgoCalcRequest buildCalcRequest(AnalysisContext analysisContext, long modelId, long datasetId, Map<String, Long> viewMap, Map<String, Set<String>> queryDim) {
        AlgoCalcRequest request = new AlgoCalcRequest();
        request.setModelId(Long.valueOf(modelId));
        request.setDatasetId(Long.valueOf(datasetId));
        request.setMemberInfo(queryDim);
        request.setViewMap(viewMap);
        if (analysisContext != null) {
            Options options = new Options();
            options.setUseAnalysis(Boolean.valueOf(true));
            options.setUseAlgoAgg(Boolean.valueOf(false));
            options.setAnalysisContext(analysisContext);
            request.setOptions(options);
        }
        return request;
    }

    private AnalysisCanvasDataset getAnalysisCubeId(long canvasId, long boxId, long datasetId) {
        return AnalysisCubeService.getInstance().getAnalysisDataset(canvasId, boxId, datasetId);
    }

    private static class InnerClass {
        private static final QueryService instance = new QueryService();

        private InnerClass() {
        }
    }
}

