/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.business.analysiscanvas.model.VarRange;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.IVarService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.bizrule.RuleFindService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SliderDataService
extends AbstractDataService
implements IVarService {
    public SliderDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            try {
                VarModel varModel = ModelHelper.getModel(item, VarModel.class);
                Long modelId = IDUtils.toLong((Object)varModel.getModel());
                long datasetId = IDUtils.toLong((Object)varModel.getDataset());
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
                JSONObject dimensionViews = varModel.getDimensionViews();
                Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
                HashSet<String> varDimMemSet = new HashSet<String>(varModel.getVars().size());
                for (VarRange var : varModel.getVars()) {
                    varDimMemSet.add(var.getNum());
                }
                queryDim.put(varModel.getVarDim(), varDimMemSet);
                this.setOtherDim(varModel.getDims(), filterDim, queryDim);
                this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
            }
            catch (AnalysisCanvasException e) {
                item.setCode(e.getCode() != null ? e.getCode() : 1);
                item.setMsg(e.getMessage());
            }
        });
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            VarModel varModel = ModelHelper.getModel(item, VarModel.class);
            Long modelId = IDUtils.toLong((Object)varModel.getModel());
            Long datasetId = IDUtils.toLong((Object)varModel.getDataset());
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
            JSONObject dimensionViews = varModel.getDimensionViews();
            Map<String, Long> viewMap = this.getViewMap(dimensionViews);
            QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
            Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
            Map<String, String> fixMemberMap = this.genFixMemberMap(varModel.getDims(), filterDim);
            this.setRelQueryFixMember(optType, fixMemberMap, calcParam);
            this.processModelResult(varModel, fixMemberMap, queryResult);
            ModelHelper.updateModel(item, varModel);
        });
    }

    private void processModelResult(BaseModel baseModel, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult) {
        VarModel varModel = (VarModel)baseModel;
        JSONObject dimensionViews = varModel.getDimensionViews();
        Map<String, Long> viewMap = this.getViewMap(dimensionViews);
        long modelId = IDUtils.toLong((Object)varModel.getModel());
        long datasetId = IDUtils.toLong((Object)varModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(Long.valueOf(datasetId));
        Map baseViewMap = modelCache.getViewsByDataSetIncludeBase(Long.valueOf(datasetId));
        List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        HashMap<String, String> queryCellMap = new HashMap<String, String>(fixMemberMap);
        for (VarRange var : varModel.getVars()) {
            RuleDto ruleDto;
            queryCellMap.put(varModel.getVarDim(), var.getNum());
            this.fillMissMember(queryCellMap, sortedDimList, modelCache);
            Object value = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
            var.setV(value);
            int cellType = 1;
            for (Map.Entry entry : queryCellMap.entrySet()) {
                String dimNumber = (String)entry.getKey();
                String memNumber = (String)entry.getValue();
                Long viewId = viewMap.get(dimNumber);
                Member member = modelCache.getMember(dimNumber, viewId, memNumber);
                if (member.isLeaf()) continue;
                cellType = 0;
                break;
            }
            if ((ruleDto = RuleFindService.getInstance().findRuleByCell(modelId, datasetId, viewMap, queryCellMap)) != null) {
                cellType += 4;
            }
            var.setCt(cellType);
            String dimNumber = SysDimensionEnum.Metric.getNumber();
            String memNumber = (String)queryCellMap.get(SysDimensionEnum.Metric.getNumber());
            Long viewId = viewMap.get(dimNumber);
            Member metricMember = modelCache.getMember(dimNumber, viewId, memNumber);
            var.setDt(metricMember.getDatatype());
        }
    }

    @Override
    public void processChangeMember(List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers) {
        itemList.forEach(item -> {
            VarModel varModel = ModelHelper.getModel(item, VarModel.class);
            this.processItemChangeMember(item.getId(), varModel, filterItemList, calcChangeMembers);
            ModelHelper.updateModel(item, varModel);
        });
    }

    private void processItemChangeMember(String itemId, VarModel varModel, List<CustomItem> filterItemList, Map<String, ValueDto> totalChangeMembers) {
        Long modelId = IDUtils.toLong((Object)varModel.getModel());
        Long datasetId = IDUtils.toLong((Object)varModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Map<String, String> filterDim = ModelHelper.getFilterFromSelector(itemId, filterItemList);
        String varDim = varModel.getVarDim();
        Map<String, DimensionModel> modelDimMap = varModel.getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
        HashMap queryDim = new HashMap(20);
        HashMap<MembersKey, ValueDto> currChangeMap = new HashMap<MembersKey, ValueDto>(varModel.getVars().size());
        varModel.getVars().forEach(var -> {
            if (var.getCt() == null || var.getCt() != 1 || var.getV() == null || BooleanUtils.isNotTrue((Boolean)var.getC())) {
                return;
            }
            var.setC(Boolean.FALSE);
            LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>(allDims.size());
            for (Dimension dim : allDims) {
                String memNumber;
                String dimNumber = dim.getNumber();
                if (dimNumber.equals(varDim)) {
                    memNumber = var.getNum();
                } else {
                    DimensionModel dimModel = (DimensionModel)modelDimMap.get(dimNumber);
                    if (dimModel != null) {
                        if (dimModel.getS().booleanValue()) {
                            MemberModel member = dimModel.getMems().get(0);
                            memNumber = member.getNum();
                        } else {
                            memNumber = (String)filterDim.get(dimNumber);
                        }
                    } else {
                        Dimension dimension = modelCache.getDimension(dimNumber);
                        memNumber = dimension.getNoneNumber();
                    }
                }
                memberMap.put(dimNumber, memNumber);
            }
            memberMap.forEach((key, value) -> {
                Set queryMemSet = queryDim.computeIfAbsent(key, v -> new HashSet(8));
                queryMemSet.add(value);
            });
            MembersKey membersKey = this.transToMembersKey(memberMap, sortedDimList, modelCache);
            ValueDto valueDto = (ValueDto)totalChangeMembers.get(this.getMemberKeyStr(membersKey.getKeys()));
            if (valueDto != null && valueDto.getT() != null && var.getT() < valueDto.getT()) {
                return;
            }
            currChangeMap.put(membersKey, new ValueDto(var.getV(), var.getT(), ModelHelper.getViewMap(varModel.getDimensionViews(), sortedDimList, modelCache, datasetId)));
        });
        Map<MembersKey, ValueDto> changeMap = this.filterPermWrite(datasetId, currChangeMap, modelCache, sortedDimList);
        if (MapUtils.isNotEmpty(changeMap)) {
            changeMap.forEach((key, value) -> totalChangeMembers.put(this.getMemberKeyStr(key.getKeys()), (ValueDto)value));
            List<Map<String, Object>> changeMembers = this.mergeChangeMembers(changeMap, sortedDimList, varModel.getChangeMembers(), modelCache);
            varModel.setChangeMembers(changeMembers);
        }
        if (CollectionUtils.isNotEmpty(varModel.getChangeMembers())) {
            varModel.getChangeMembers().forEach(memberMap -> {
                MembersKey membersKey = this.transToMembersKey((Map<String, ?>)memberMap, sortedDimList, modelCache);
                if (!changeMap.containsKey(membersKey)) {
                    if (totalChangeMembers.containsKey(this.getMemberKeyStr(membersKey.getKeys()))) {
                        return;
                    }
                    changeMap.put(membersKey, new ValueDto(memberMap.get("_v"), Long.parseLong(((Object)memberMap.getOrDefault("_t", 0L)).toString()), ModelHelper.getViewMap((String)memberMap.get("_vw"), sortedDimList, modelCache, datasetId)));
                    for (Dimension dim : allDims) {
                        String dimNumber = dim.getNumber();
                        Object memNumber = memberMap.get(dimNumber);
                        if (memNumber == null) {
                            Dimension dimension = modelCache.getDimension(dimNumber);
                            memNumber = dimension.getNoneNumber();
                        }
                        Set queryMemSet = queryDim.computeIfAbsent(dimNumber, s -> new HashSet(8));
                        queryMemSet.add(memNumber.toString());
                    }
                }
            });
        }
        if (MapUtils.isEmpty(changeMap)) {
            return;
        }
        Map<Long, Pair<List<BGCell>, Map<String, Long>>> changeCells = this.buildChangeCell(changeMap, sortedDimList);
        if (MapUtils.isEmpty(changeCells)) {
            return;
        }
        AnalysisCanvasDataset canvasDataset = this.getAnalysisCubeId(this.canvasBox.getCanvasId(), this.canvasBox.getId(), datasetId);
        changeCells.forEach((key, pair) -> this.saveToSandboxAndExecuteRuleChain(modelId, datasetId, canvasDataset, (List)pair.getLeft(), (Map)pair.getRight()));
    }

    @Override
    public List<SaveDto> getCoverData(List<CustomItem> itemList, List<CustomItem> filterItemList) {
        ArrayList<SaveDto> saveDtoList = new ArrayList<SaveDto>(4);
        itemList.forEach(item -> {
            VarModel varModel = ModelHelper.getModel(item, VarModel.class);
            this.buildCoverData(varModel.getModel(), varModel.getDataset(), varModel.getChangeMembers(), saveDtoList);
        });
        return saveDtoList;
    }
}

