/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TabModel;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TableDataService
extends AbstractDataService {
    public TableDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            try {
                TabModel tabModel = ModelHelper.getModel(item, TabModel.class);
                long modelId = IDUtils.toLong((Object)tabModel.getModel());
                long datasetId = IDUtils.toLong((Object)tabModel.getDataset());
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
                JSONObject dimensionViews = tabModel.getDimensionViews();
                Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                this.checkRelQueryDim(optType, viewMap, modelCache, datasetId, calcParam);
                HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
                List<DimensionModel> tabs = tabModel.getTabs();
                tabs.forEach(dim -> {
                    long viewId = this.getViewId(dim.getDim(), dimensionViews);
                    List<MemberModel> memberModels = dim.getMems();
                    HashSet tabMemberSet = new HashSet(16);
                    for (MemberModel memberModel : memberModels) {
                        List members = modelCache.getMember(dim.getDim(), Long.valueOf(viewId), memberModel.getNum(), memberModel.getScope().intValue());
                        members.forEach(member -> tabMemberSet.add(member.getNumber()));
                    }
                    queryDim.put(dim.getDim(), tabMemberSet);
                });
                this.setOtherDim(tabModel.getDims(), filterDim, queryDim);
                this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
            }
            catch (AnalysisCanvasException e) {
                item.setCode(e.getCode() != null ? e.getCode() : 1);
                item.setMsg(e.getMessage());
            }
        });
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            TabModel tabModel = ModelHelper.getModel(item, TabModel.class);
            Long modelId = IDUtils.toLong((Object)tabModel.getModel());
            Long datasetId = IDUtils.toLong((Object)tabModel.getDataset());
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
            JSONObject dimensionViews = tabModel.getDimensionViews();
            Map<String, Long> viewMap = this.getViewMap(dimensionViews);
            QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
            Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
            Map<String, String> fixMemberMap = this.genFixMemberMap(tabModel.getDims(), filterDim);
            this.setRelQueryFixMember(optType, fixMemberMap, calcParam);
            this.processModelResult(tabModel, fixMemberMap, queryResult);
            ModelHelper.updateModel(item, tabModel);
        });
    }

    private void processModelResult(BaseModel baseModel, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult) {
        TabModel tabModel = (TabModel)baseModel;
        JSONObject dimensionViews = tabModel.getDimensionViews();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)tabModel.getModel()));
        List allDims = modelCache.getDimensionList(IDUtils.toLong((Object)tabModel.getDataset()));
        HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
        List<DimensionModel> tabs = tabModel.getTabs();
        tabs.forEach(dim -> {
            long viewId = this.getViewId(dim.getDim(), dimensionViews);
            List<MemberModel> memberModels = dim.getMems();
            HashSet tabMemberSet = new HashSet(16);
            for (MemberModel memberModel : memberModels) {
                List members = modelCache.getMember(dim.getDim(), Long.valueOf(viewId), memberModel.getNum(), memberModel.getScope().intValue());
                members.forEach(member -> tabMemberSet.add(member.getNumber()));
            }
            queryDim.put(dim.getDim(), tabMemberSet);
        });
        fixMemberMap.forEach((dim, mem) -> {
            Set cfr_ignored_0 = queryDim.put((String)dim, Sets.newHashSet((Object[])new String[]{mem}));
        });
        List<List<String>> numberList = this.getNumberList(queryDim, allDims);
        List<BGCell> bgCellList = this.filterBGcell(numberList, queryResult);
        JSONArray jsonArray = new JSONArray(bgCellList.size());
        bgCellList.forEach(bgCell -> {
            Map bgCellMap = bgCell.getMemberMap();
            ArrayList<String> memberList = new ArrayList<String>(tabs.size() + 1);
            tabs.forEach(dim -> {
                String memberNumber = (String)bgCellMap.get(dim.getDim());
                memberList.add(memberNumber);
            });
            memberList.add(String.valueOf(bgCell.getValue()));
            jsonArray.add(memberList);
        });
        tabModel.setRawDatas(jsonArray);
        String dimNumber = SysDimensionEnum.Metric.getNumber();
        String memNumber = fixMemberMap.get(SysDimensionEnum.Metric.getNumber());
        long metricViewId = this.getViewId(dimNumber, dimensionViews);
        Member metricMember = modelCache.getMember(dimNumber, Long.valueOf(metricViewId), memNumber);
        tabModel.setDt(metricMember.getDatatype());
    }

    private List<List<String>> getNumberList(Map<String, Set<String>> queryDim, List<Dimension> allDims) {
        ArrayList numberList = new ArrayList(allDims.size());
        allDims.forEach(dimension -> {
            Set memSet = (Set)queryDim.get(dimension.getNumber());
            if (CollectionUtils.isEmpty((Collection)memSet)) {
                memSet = Sets.newHashSet((Object[])new String[]{dimension.getNoneNumber()});
            }
            numberList.add(new ArrayList(memSet));
        });
        return Lists.cartesianProduct(numberList);
    }

    private List<BGCell> filterBGcell(List<List<String>> numberList, Map<MembersKey, BGCell> keyBGCellMap) {
        ArrayList<BGCell> bgCellList = new ArrayList<BGCell>(numberList.size());
        numberList.forEach(numbers -> {
            Object[] keys = new String[numbers.size() + 1];
            for (int i = 0; i < numbers.size(); ++i) {
                keys[i + 1] = (String)numbers.get(i);
            }
            MembersKey membersKey = new MembersKey(keys);
            BGCell bgCell = (BGCell)keyBGCellMap.get(membersKey);
            if (bgCell != null) {
                bgCellList.add(bgCell);
            }
        });
        return bgCellList;
    }
}

