/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.chart;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DrillConfig;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.SplitConfig;
import kd.epm.eb.business.analysiscanvas.model.SplitModel;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractChartDataService
extends AbstractDataService {
    public AbstractChartDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
            try {
                this.buildChartQueryDim(chartModel, filterDim, dtoList, optType, calcParam);
            }
            catch (AnalysisCanvasException e) {
                item.setCode(e.getCode() != null ? e.getCode() : 1);
                item.setMsg(e.getMessage());
            }
        });
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
            Long modelId = IDUtils.toLong((Object)chartModel.getModel());
            Long datasetId = IDUtils.toLong((Object)chartModel.getDataset());
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
            if (CollectionUtils.isEmpty(chartModel.getChartConfig())) {
                return;
            }
            chartModel.setSerVals(null);
            chartModel.getChartConfig().forEach(chartConfig -> {
                JSONObject dimensionViews = this.getDimensionView(chartModel, (ChartConfigModel)chartConfig);
                Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, StringUtils.isEmpty((String)chartConfig.getDataset()) ? datasetId : IDUtils.toLong((Object)chartConfig.getDataset()), viewMap, dtoList);
                Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
                Map<String, String> fixMemberMap = this.genFixMemberMap(chartConfig.getDims(), filterDim);
                this.setRelQueryFixMember(optType, fixMemberMap, calcParam);
                this.processChartQueryResult(chartModel, (ChartConfigModel)chartConfig, fixMemberMap, queryResult);
            });
            ModelHelper.updateModel(item, chartModel);
        });
    }

    protected void processSplitConfig(CustomItem item, List<SplitConfig> splitConfigs, List<QueryDto> dtoList) {
        try {
            splitConfigs.forEach(config -> {
                SplitModel splitModel = config.getSplitModel();
                if (splitModel == null || splitModel.getModel() == null) {
                    return;
                }
                Long modelId = IDUtils.toLong((Object)splitModel.getModel());
                Long datasetId = IDUtils.toLong((Object)splitModel.getDataset());
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)modelId));
                JSONObject dimensionViews = splitModel.getDimensionViews();
                Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
                String serialDim = splitModel.getDim();
                long serialViewId = this.getViewId(serialDim, dimensionViews);
                List member = modelCache.getMember(serialDim, Long.valueOf(serialViewId), splitModel.getMember().getNum(), splitModel.getMember().getScope().intValue());
                Set memberSet = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                Set querySet = queryDim.computeIfAbsent(serialDim, k -> new HashSet(memberSet.size()));
                querySet.addAll(memberSet);
                this.setOtherDim(splitModel.getDims(), new HashMap<String, String>(), queryDim);
                this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
            });
        }
        catch (AnalysisCanvasException e) {
            item.setCode(e.getCode() != null ? e.getCode() : 1);
            item.setMsg(e.getMessage());
        }
    }

    protected void processSplitConfigResult(List<SplitConfig> splitConfigs, List<QueryDto> dtoList) {
        splitConfigs.forEach(config -> {
            SplitModel splitModel = config.getSplitModel();
            if (splitModel == null || splitModel.getModel() == null) {
                return;
            }
            Long modelId = IDUtils.toLong((Object)splitModel.getModel());
            Long datasetId = IDUtils.toLong((Object)splitModel.getDataset());
            HashMap<String, String> filterDim = new HashMap<String, String>();
            JSONObject dimensionViews = splitModel.getDimensionViews();
            Map<String, Long> viewMap = this.getViewMap(dimensionViews);
            QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
            Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
            Map<String, String> fixMemberMap = this.genFixMemberMap(splitModel.getDims(), filterDim);
            Object value = this.getSplitQueryResult(splitModel, fixMemberMap, queryResult, viewMap);
            config.setNum(value);
        });
    }

    private Object getSplitQueryResult(SplitModel splitModel, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult, Map<String, Long> viewMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)splitModel.getModel()));
        List allDims = modelCache.getDimensionList(IDUtils.toLong((Object)splitModel.getDataset()));
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        String dim = splitModel.getDim();
        long viewId = viewMap.get(dim);
        MemberModel member = splitModel.getMember();
        List members = modelCache.getMember(dim, Long.valueOf(viewId), member.getNum(), member.getScope().intValue());
        String serialNumber = member.getNum();
        HashMap<String, String> queryCellMap = new HashMap<String, String>(fixMemberMap);
        queryCellMap.put(dim, serialNumber);
        this.fillMissMember(queryCellMap, sortedDimList, modelCache);
        splitModel.setMemName(((Member)members.get(0)).getName());
        return this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
    }

    protected JSONObject getDimensionView(ChartModel chartModel, ChartConfigModel chartConfig) {
        JSONObject dimensionViews = chartConfig.getDimensionViews();
        if (dimensionViews == null) {
            dimensionViews = chartModel.getDimensionViews();
        }
        return dimensionViews;
    }

    protected List<String> getDimensionRange(String dimNumbers) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dimNumbers) ? Collections.emptyList() : Arrays.stream(dimNumbers.split(",")).filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList());
    }

    protected List<DrillConfig> buildDimDrill(IModelCacheHelper modelCache, List<Dimension> dimensionList, String chartFilterDim, String needAddDimDrill, ChartConfigModel chartConfigModel) {
        List<String> serDimRange = this.getDimensionRange(chartFilterDim);
        List<String> needDimDrillList = this.getDimensionRange(needAddDimDrill);
        ArrayList<String> filterDim = new ArrayList<String>(serDimRange);
        List<String> filterDims = Arrays.asList(SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.Currency.getNumber());
        filterDim.addAll(filterDims);
        JSONObject dimensionViews = chartConfigModel.getDimensionViews();
        return dimensionList.stream().filter(e -> !filterDim.contains(e.getNumber())).map(e -> {
            String dimNumber = e.getNumber();
            Optional<DimensionModel> optional = chartConfigModel.getDims().stream().filter(p -> p.getDim().equals(dimNumber) && p.getS() != false).findFirst();
            if (optional.isPresent()) {
                DimensionModel dimensionModel = optional.get();
                List<MemberModel> members = dimensionModel.getMems();
                if (CollectionUtils.isNotEmpty(members)) {
                    Member member = modelCache.getMember(dimNumber, dimensionViews.getLong(dimNumber), members.get(0).getNum());
                    if (member == null) {
                        return null;
                    }
                    DrillConfig drill = new DrillConfig();
                    drill.setDimNum(dimNumber);
                    drill.setDimName(e.getName());
                    drill.setMemNum(member.getNumber());
                    drill.setMemName(member.getName());
                    drill.setLeaf(member.isLeaf());
                    drill.setAgg(AggOprtEnum.ADD.getSign().equals(member.getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(member.getAggType()));
                    return drill;
                }
                return null;
            }
            if (CollectionUtils.isNotEmpty((Collection)needDimDrillList) && needDimDrillList.contains(dimNumber)) {
                DrillConfig drill = new DrillConfig();
                drill.setDimNum(dimNumber);
                drill.setDimName(e.getName());
                return drill;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    abstract void buildChartQueryDim(ChartModel var1, Map<String, String> var2, List<QueryDto> var3, AnalysisCanvasConstants.OptType var4, JSONObject var5);

    abstract void processChartQueryResult(ChartModel var1, ChartConfigModel var2, Map<String, String> var3, Map<MembersKey, BGCell> var4);
}

