/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.chart;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.ChartAxisModel;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.ChartSerialModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DrillConfig;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.SplitConfig;
import kd.epm.eb.business.analysiscanvas.query.chart.AbstractChartDataService;
import kd.epm.eb.business.analysiscanvas.query.chart.ISplitDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BarLineChartDataService
extends AbstractChartDataService
implements ISplitDataService {
    public BarLineChartDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void processChartQueryResult(ChartModel chartModel, ChartConfigModel chartConfig, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult) {
        Long actualDatasetId = StringUtils.isEmpty((CharSequence)chartConfig.getDataset()) ? IDUtils.toLong((Object)chartModel.getDataset()) : IDUtils.toLong((Object)chartConfig.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)chartModel.getModel()));
        List allDims = modelCache.getDimensionList(actualDatasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(chartModel.getDimDrill()) && CollectionUtils.isNotEmpty(chartModel.getChartConfig())) {
            ArrayList filterDimList = new ArrayList(16);
            if ("barLine".equals(chartModel.getType()) && chartModel.getChartConfig().size() == 2) {
                sortedDimList.forEach(dim -> {
                    ChartConfigModel leftConfig = chartModel.getChartConfig().get(0);
                    ChartConfigModel rightConfig = chartModel.getChartConfig().get(1);
                    Optional<DimensionModel> leftMember = leftConfig.getDims().stream().filter(e -> dim.equals(e.getDim()) && e.getS() != false).findFirst();
                    Optional<DimensionModel> rightMember = rightConfig.getDims().stream().filter(e -> dim.equals(e.getDim()) && e.getS() != false).findFirst();
                    if (leftMember.isPresent() && rightMember.isPresent()) {
                        boolean sameMember;
                        boolean bl = sameMember = CollectionUtils.isNotEmpty(leftMember.get().getMems()) && CollectionUtils.isNotEmpty(rightMember.get().getMems()) && leftMember.get().getMems().get(0).getNum().equals(rightMember.get().getMems().get(0).getNum());
                        if (!sameMember) {
                            filterDimList.add(dim);
                        }
                    } else if (chartModel.getChartConfig().stream().flatMap(e -> this.getDimensionRange(e.getSerDim()).stream()).noneMatch(dim::equals) && !this.getDimensionRange(chartModel.getHorDim()).contains(dim)) {
                        filterDimList.add(dim);
                    }
                });
            }
            filterDimList.addAll(chartModel.getChartConfig().stream().flatMap(e -> this.getDimensionRange(e.getSerDim()).stream()).collect(Collectors.toList()));
            String chartFilterDim = filterDimList.stream().distinct().collect(Collectors.joining(","));
            chartModel.setDimDrill(this.buildDimDrill(modelCache, allDims, chartFilterDim, chartModel.getHorDim(), chartModel.getChartConfig().get(0)));
        }
        int horSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P007);
        int serSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P008);
        List<ChartSerialModel> serValList = chartModel.getSerVals();
        if (serValList == null) {
            serValList = new ArrayList<ChartSerialModel>(16);
            chartModel.setSerVals(serValList);
        }
        ArrayList horMemberPair = new ArrayList();
        List<Object> serMemberPair = new ArrayList();
        ArrayList serialModels = new ArrayList();
        JSONObject dimensionViews = this.getDimensionView(chartModel, chartConfig);
        String dimNumber = SysDimensionEnum.Metric.getNumber();
        String memNumber = fixMemberMap.get(SysDimensionEnum.Metric.getNumber());
        long metricViewId = this.getViewId(dimNumber, dimensionViews);
        Member metricMember = modelCache.getMember(dimNumber, Long.valueOf(metricViewId), memNumber);
        String horDim = chartModel.getHorDim();
        List horDimRangeList = Arrays.stream(horDim.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(chartModel.getPathDrill()) && CollectionUtils.isNotEmpty(chartModel.getSpinDrill())) {
            long drillViewId;
            int spinSize = chartModel.getSpinDrill().size();
            List<DrillConfig> spinDrillConfigs = chartModel.getSpinDrill().get(spinSize - 1);
            int pathSize = chartModel.getPathDrill().size();
            DrillConfig pathDrillConfig = chartModel.getPathDrill().get(pathSize - 1);
            if (spinDrillConfigs.size() == 1 || spinDrillConfigs.stream().noneMatch(e -> e.getDimNum().equals(pathDrillConfig.getDimNum()))) {
                String drillDim = pathDrillConfig.getDimNum();
                drillViewId = this.getViewId(drillDim, dimensionViews);
                List<Member> drillMembers = modelCache.getMember(drillDim, Long.valueOf(drillViewId), pathDrillConfig.getMemNum(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                List<Member> drillMemberRange = (drillMembers = this.filterDrillMemberAgg(drillMembers)).size() > horSize ? drillMembers.subList(0, horSize) : drillMembers;
                List collect = drillMemberRange.stream().map(e -> {
                    Dimension dimension = modelCache.getDimension(drillDim);
                    DrillConfig config = new DrillConfig();
                    config.setDimName(dimension.getName());
                    config.setDimNum(drillDim);
                    config.setLeaf(e.isLeaf());
                    config.setMemNum(e.getNumber());
                    config.setMemName(e.getName());
                    config.setAgg(AggOprtEnum.ADD.getSign().equals(e.getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(e.getAggType()));
                    return Pair.of((Object)e.getName(), Collections.singletonList(config));
                }).collect(Collectors.toList());
                horMemberPair.addAll(collect);
            } else {
                String dimNum = pathDrillConfig.getDimNum();
                drillViewId = this.getViewId(dimNum, dimensionViews);
                List<Member> drillMembers = modelCache.getMember(dimNum, Long.valueOf(drillViewId), pathDrillConfig.getMemNum(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                List<Member> drillMemberRange = (drillMembers = this.filterDrillMemberAgg(drillMembers)).size() > horSize ? drillMembers.subList(0, horSize) : drillMembers;
                List collect = drillMemberRange.stream().map(p -> {
                    ArrayList drillConfigs = new ArrayList();
                    spinDrillConfigs.forEach(drill -> {
                        Member member;
                        String dim1 = drill.getDimNum();
                        Dimension dimension = modelCache.getDimension(dim1);
                        if (dimNum.equals(dim1)) {
                            member = p;
                        } else {
                            long horViewId = this.getViewId(dim1, dimensionViews);
                            member = modelCache.getMember(dim1, Long.valueOf(horViewId), drill.getMemNum());
                        }
                        if (member == null) {
                            return;
                        }
                        DrillConfig config = new DrillConfig();
                        config.setDimName(dimension.getName());
                        config.setDimNum(dim1);
                        config.setLeaf(member.isLeaf());
                        config.setMemNum(member.getNumber());
                        config.setMemName(member.getName());
                        config.setAgg(AggOprtEnum.ADD.getSign().equals(member.getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(member.getAggType()));
                        drillConfigs.add(config);
                    });
                    return Pair.of((Object)p.getName(), drillConfigs);
                }).collect(Collectors.toList());
                horMemberPair.addAll(collect);
            }
        } else if (horDimRangeList.size() == 1) {
            long horViewId = this.getViewId(horDim, dimensionViews);
            List<MemberModel> horMems = chartModel.getHorMems();
            ArrayList horMemberList = new ArrayList(16);
            if (StringUtils.isNotBlank((CharSequence)chartModel.getDrillMem())) {
                List members = modelCache.getMember(horDim, Long.valueOf(horViewId), chartModel.getDrillMem(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                horMemberList.addAll(members);
            } else {
                for (MemberModel horMem : horMems) {
                    horMemberList.addAll(modelCache.getMember(horDim, Long.valueOf(horViewId), horMem.getNum(), horMem.getScope().intValue()));
                }
            }
            ArrayList horMemberRange = horMemberList.size() > horSize ? horMemberList.subList(0, horSize) : horMemberList;
            List collect = horMemberRange.stream().map(e -> {
                Dimension dimension = modelCache.getDimension(horDim);
                DrillConfig config = new DrillConfig();
                config.setDimName(dimension.getName());
                config.setDimNum(horDim);
                config.setLeaf(e.isLeaf());
                config.setMemNum(e.getNumber());
                config.setMemName(e.getName());
                config.setAgg(AggOprtEnum.ADD.getSign().equals(e.getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(e.getAggType()));
                return Pair.of((Object)e.getName(), Collections.singletonList(config));
            }).collect(Collectors.toList());
            horMemberPair.addAll(collect);
        } else {
            List collect = chartModel.getHorRange().stream().map(p -> {
                ArrayList drillConfigs = new ArrayList();
                p.getDims().forEach(dim -> {
                    String dim1 = dim.getDim();
                    Dimension dimension = modelCache.getDimension(dim1);
                    long horViewId = this.getViewId(dim1, dimensionViews);
                    List horMembers = dim.getMems().stream().flatMap(e -> modelCache.getMember(dim1, Long.valueOf(horViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(horMembers)) {
                        return;
                    }
                    DrillConfig config = new DrillConfig();
                    config.setDimName(dimension.getName());
                    config.setDimNum(dim1);
                    config.setLeaf(((Member)horMembers.get(0)).isLeaf());
                    config.setMemNum(((Member)horMembers.get(0)).getNumber());
                    config.setMemName(((Member)horMembers.get(0)).getName());
                    config.setAgg(AggOprtEnum.ADD.getSign().equals(((Member)horMembers.get(0)).getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(((Member)horMembers.get(0)).getAggType()));
                    drillConfigs.add(config);
                });
                return Pair.of((Object)p.getName(), drillConfigs);
            }).collect(Collectors.toList());
            horMemberPair.addAll(collect);
        }
        String serialDim = chartConfig.getSerDim();
        List serDimRangeList = Arrays.stream(serialDim.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (serDimRangeList.size() == 1) {
            long serialViewId = this.getViewId(serialDim, dimensionViews);
            List serMembers = chartConfig.getSerMems().stream().flatMap(e -> modelCache.getMember(serialDim, Long.valueOf(serialViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
            List serMemberRange = serMembers.size() > serSize ? serMembers.subList(0, serSize) : serMembers;
            serMemberPair = serMemberRange.stream().map(e -> {
                HashMap<String, String> range = new HashMap<String, String>();
                range.put(serialDim, e.getNumber());
                return Pair.of((Object)e.getName(), range);
            }).collect(Collectors.toList());
        } else {
            serMemberPair = chartConfig.getSerRange().stream().map(p -> {
                HashMap range = new HashMap();
                p.getDims().forEach(dim -> {
                    String dim1 = dim.getDim();
                    long horViewId = this.getViewId(dim1, dimensionViews);
                    List horMembers = dim.getMems().stream().flatMap(e -> modelCache.getMember(dim1, Long.valueOf(horViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(horMembers)) {
                        return;
                    }
                    range.put(dim1, ((Member)horMembers.get(0)).getNumber());
                });
                return Pair.of((Object)p.getName(), range);
            }).collect(Collectors.toList());
        }
        serMemberPair.forEach(ser -> {
            HashMap queryCellMap = new HashMap(fixMemberMap);
            queryCellMap.putAll((Map)ser.getRight());
            LinkedHashMap axisMap = new LinkedHashMap();
            horMemberPair.forEach(hor -> {
                Map<String, String> dimMaps = ((List)hor.getRight()).stream().collect(Collectors.toMap(DrillConfig::getDimNum, DrillConfig::getMemNum));
                queryCellMap.putAll(this.getSpinDimMap(chartModel.getSpinDrill()));
                queryCellMap.putAll(dimMaps);
                this.fillMissMember(queryCellMap, sortedDimList, modelCache);
                Object value = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
                String horMemNumber = ((List)hor.getRight()).stream().map(DrillConfig::getMemNum).collect(Collectors.joining(","));
                ChartAxisModel model = new ChartAxisModel();
                model.setName((String)hor.getKey());
                model.setNum(horMemNumber);
                model.setLeaf(((List)hor.getRight()).size() > 1 || ((DrillConfig)((List)hor.getRight()).get(0)).getLeaf() != false);
                model.setValue(value);
                model.setDt(metricMember.getDatatype());
                model.setDrill((List)hor.getRight());
                model.setMer(metricMember.hasAgg());
                axisMap.put(horMemNumber, model);
            });
            ChartSerialModel serialModel = new ChartSerialModel();
            serialModel.setSerial((String)ser.getKey());
            serialModel.setType(chartConfig.getType());
            serialModel.setAxisList(Lists.newArrayList(axisMap.values()));
            serialModels.add(serialModel);
        });
        serValList.addAll(serialModels);
    }

    @Override
    void buildChartQueryDim(ChartModel chartModel, Map<String, String> filterDim, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        if (CollectionUtils.isEmpty(chartModel.getChartConfig())) {
            return;
        }
        int horSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P007);
        int serSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P008);
        long modelId = IDUtils.toLong((Object)chartModel.getModel());
        long datasetId = IDUtils.toLong((Object)chartModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, Set> horQueryDim = new HashMap<String, Set>(20);
        if (CollectionUtils.isNotEmpty(chartModel.getPathDrill()) && CollectionUtils.isNotEmpty(chartModel.getSpinDrill())) {
            JSONObject dimensionViews = this.getDimensionView(chartModel, chartModel.getChartConfig().get(0));
            int spinSize = chartModel.getSpinDrill().size();
            List<DrillConfig> spinDrillConfigs = chartModel.getSpinDrill().get(spinSize - 1);
            int pathSize = chartModel.getPathDrill().size();
            DrillConfig pathDrillConfig = chartModel.getPathDrill().get(pathSize - 1);
            if (spinDrillConfigs.size() == 1 || spinDrillConfigs.stream().noneMatch(e -> e.getDimNum().equals(pathDrillConfig.getDimNum()))) {
                String drillDim = pathDrillConfig.getDimNum();
                long drillViewId = this.getViewId(drillDim, dimensionViews);
                List<Member> drillMembers = modelCache.getMember(drillDim, Long.valueOf(drillViewId), pathDrillConfig.getMemNum(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                List<Member> drillMemberRange = (drillMembers = this.filterDrillMemberAgg(drillMembers)).size() > horSize ? drillMembers.subList(0, horSize) : drillMembers;
                Set memberSet = drillMemberRange.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                Set querySet = horQueryDim.computeIfAbsent(drillDim, k -> new HashSet(memberSet.size()));
                querySet.addAll(memberSet);
            } else {
                spinDrillConfigs.forEach(p -> {
                    String drillDim = p.getDimNum();
                    if (drillDim.equals(pathDrillConfig.getDimNum())) {
                        long drillViewId = this.getViewId(drillDim, dimensionViews);
                        List<Member> drillMembers = modelCache.getMember(drillDim, Long.valueOf(drillViewId), pathDrillConfig.getMemNum(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                        List<Member> drillMemberRange = (drillMembers = this.filterDrillMemberAgg(drillMembers)).size() > horSize ? drillMembers.subList(0, horSize) : drillMembers;
                        Set memberSet = drillMemberRange.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                        Set querySet = horQueryDim.computeIfAbsent(drillDim, k -> new HashSet(memberSet.size()));
                        querySet.addAll(memberSet);
                    } else {
                        Set querySet = horQueryDim.computeIfAbsent(drillDim, k -> new HashSet(16));
                        querySet.add(p.getMemNum());
                    }
                });
            }
        } else {
            JSONObject dimensionViews = this.getDimensionView(chartModel, chartModel.getChartConfig().get(0));
            String horDim = chartModel.getHorDim();
            List horDimRangeList = Arrays.stream(horDim.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (horDimRangeList.size() == 1) {
                long horViewId = this.getViewId(horDim, dimensionViews);
                List horMembers = chartModel.getHorMems().stream().flatMap(e -> modelCache.getMember(horDim, Long.valueOf(horViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                List horMemberRange = horMembers.size() > horSize ? horMembers.subList(0, horSize) : horMembers;
                Set memberSet = horMemberRange.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                Set querySet = horQueryDim.computeIfAbsent(horDim, k -> new HashSet(memberSet.size()));
                querySet.addAll(memberSet);
            } else {
                chartModel.getHorRange().forEach(p -> p.getDims().forEach(dim -> {
                    String dim1 = dim.getDim();
                    long horViewId = this.getViewId(dim1, dimensionViews);
                    List horMembers = dim.getMems().stream().flatMap(e -> modelCache.getMember(dim1, Long.valueOf(horViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                    Set memberSet = horMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    Set querySet = horQueryDim.computeIfAbsent(dim1, k -> new HashSet(memberSet.size()));
                    querySet.addAll(memberSet);
                }));
            }
        }
        chartModel.getChartConfig().forEach(chartConfig -> {
            long actualDatasetId = StringUtils.isEmpty((CharSequence)chartConfig.getDataset()) ? datasetId : IDUtils.toLong((Object)chartConfig.getDataset());
            JSONObject dimensionViews = this.getDimensionView(chartModel, (ChartConfigModel)chartConfig);
            Map<String, Long> viewMap = this.getViewMap(dimensionViews);
            this.checkRelQueryDim(optType, viewMap, modelCache, actualDatasetId, calcParam);
            HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
            queryDim.putAll(horQueryDim);
            String serialDim = chartConfig.getSerDim();
            List serDimRangeList = Arrays.stream(serialDim.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (serDimRangeList.size() == 1) {
                long serialViewId = this.getViewId(serialDim, dimensionViews);
                List serMembers = chartConfig.getSerMems().stream().flatMap(e -> modelCache.getMember(serialDim, Long.valueOf(serialViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                List serMemberRange = serMembers.size() > serSize ? serMembers.subList(0, serSize) : serMembers;
                Set memberSet = serMemberRange.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                Set querySet = queryDim.computeIfAbsent(serialDim, k -> new HashSet(memberSet.size()));
                querySet.addAll(memberSet);
            } else {
                chartConfig.getSerRange().forEach(p -> p.getDims().forEach(dim -> {
                    String dim1 = dim.getDim();
                    long serialViewId = this.getViewId(dim1, dimensionViews);
                    List horMembers = dim.getMems().stream().flatMap(e -> modelCache.getMember(dim1, Long.valueOf(serialViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                    Set memberSet = horMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    Set querySet = queryDim.computeIfAbsent(dim1, k -> new HashSet(memberSet.size()));
                    querySet.addAll(memberSet);
                }));
            }
            this.setOtherDim(chartConfig.getDims(), filterDim, queryDim);
            if (CollectionUtils.isNotEmpty(chartModel.getPathDrill()) && CollectionUtils.isNotEmpty(chartModel.getSpinDrill())) {
                this.setSpinDim(chartModel.getSpinDrill(), queryDim);
            }
            this.checkQueryDim(queryDim, viewMap, modelCache, actualDatasetId);
            QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, actualDatasetId, viewMap, dtoList);
            QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
        });
    }

    @Override
    public void buildSplitQueryDim(CustomItem item, List<QueryDto> dtoList) {
        List<SplitConfig> splitConfigs = ModelHelper.getSplitConfigs(item);
        this.processSplitConfig(item, splitConfigs, dtoList);
    }

    @Override
    public void processQuerySplitResult(CustomItem item, List<QueryDto> dtoList) {
        List<SplitConfig> splitConfigs = ModelHelper.getSplitConfigs(item);
        this.processSplitConfigResult(splitConfigs, dtoList);
        ModelHelper.putSplitConfigs(item, splitConfigs);
    }
}

