/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.chart;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.IDataService;
import kd.epm.eb.business.analysiscanvas.query.chart.AbstractChartDataService;
import kd.epm.eb.business.analysiscanvas.query.chart.BarLineChartDataService;
import kd.epm.eb.business.analysiscanvas.query.chart.GaugeChartDataService;
import kd.epm.eb.business.analysiscanvas.query.chart.MapChartDataService;
import kd.epm.eb.business.analysiscanvas.query.chart.PieChartDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import org.jetbrains.annotations.Nullable;

public class ChartDataService
extends AbstractDataService {
    public ChartDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            IDataService dataService = this.getChartDataService((CustomItem)item);
            if (dataService == null) {
                return;
            }
            dataService.buildQueryDim(Collections.singletonList(item), filterItemList, dtoList, optType, calcParam);
        });
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            IDataService dataService = this.getChartDataService((CustomItem)item);
            if (dataService == null) {
                return;
            }
            dataService.processQueryResult(Collections.singletonList(item), filterItemList, dtoList, optType, calcParam);
        });
    }

    @Nullable
    private IDataService getChartDataService(CustomItem item) {
        ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
        AbstractChartDataService dataService = null;
        String type = chartModel.getType();
        if ("bar".equals(type) || "line".equals(type) || "sortbar".equals(type) || "barLine".equals(type)) {
            dataService = new BarLineChartDataService(this.canvasBox, this.formView);
        } else if ("pie".equals(type) || "annular".equals(type) || "progress".equals(type)) {
            dataService = new PieChartDataService(this.canvasBox, this.formView);
        } else if ("map".equals(type)) {
            dataService = new MapChartDataService(this.canvasBox, this.formView);
        } else if ("gauge".equals(type)) {
            dataService = new GaugeChartDataService(this.canvasBox, this.formView);
        }
        return dataService;
    }
}

