/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.chart;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.ChartAxisModel;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.ChartSerialModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.SplitConfig;
import kd.epm.eb.business.analysiscanvas.query.chart.AbstractChartDataService;
import kd.epm.eb.business.analysiscanvas.query.chart.ISplitDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GaugeChartDataService
extends AbstractChartDataService
implements ISplitDataService {
    public GaugeChartDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    void processChartQueryResult(ChartModel chartModel, ChartConfigModel chartConfig, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)chartModel.getModel()));
        List allDims = modelCache.getDimensionList(IDUtils.toLong((Object)chartModel.getDataset()));
        List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        List<ChartSerialModel> serValList = chartModel.getSerVals();
        if (serValList == null) {
            serValList = new ArrayList<ChartSerialModel>(16);
            chartModel.setSerVals(serValList);
        }
        JSONObject dimensionViews = this.getDimensionView(chartModel, chartConfig);
        String dimNumber = SysDimensionEnum.Metric.getNumber();
        String memNumber = fixMemberMap.get(SysDimensionEnum.Metric.getNumber());
        long metricViewId = this.getViewId(dimNumber, dimensionViews);
        Member metricMember = modelCache.getMember(dimNumber, Long.valueOf(metricViewId), memNumber);
        String serialDim = chartConfig.getSerDim();
        long viewId = this.getViewId(serialDim, dimensionViews);
        ArrayList memberList = new ArrayList(16);
        if (StringUtils.isNotBlank((CharSequence)chartModel.getDrillMem())) {
            List members = modelCache.getMember(serialDim, Long.valueOf(viewId), chartModel.getDrillMem(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
            memberList.addAll(members);
        } else {
            List<MemberModel> serialMems = chartConfig.getSerMems();
            for (MemberModel mem : serialMems) {
                memberList.addAll(modelCache.getMember(serialDim, Long.valueOf(viewId), mem.getNum(), mem.getScope().intValue()));
            }
        }
        LinkedHashMap serialModelMap = new LinkedHashMap(memberList.size());
        memberList.forEach(serialMem -> {
            String serialNumber = serialMem.getNumber();
            if (!serialModelMap.containsKey(serialNumber)) {
                HashMap<String, String> queryCellMap = new HashMap<String, String>(fixMemberMap);
                queryCellMap.put(serialDim, serialNumber);
                this.fillMissMember(queryCellMap, sortedDimList, modelCache);
                Object value = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
                ChartAxisModel model = new ChartAxisModel();
                model.setName(serialMem.getName());
                model.setNum(serialNumber);
                model.setLeaf(serialMem.isLeaf());
                model.setValue(value);
                model.setDt(metricMember.getDatatype());
                ChartSerialModel serialModel = new ChartSerialModel();
                serialModel.setSerial(serialMem.getName());
                serialModel.setType(chartModel.getType());
                serialModel.setAxisList(Collections.singletonList(model));
                serialModelMap.put(serialNumber, serialModel);
            }
        });
        serValList.addAll(serialModelMap.values());
    }

    @Override
    void buildChartQueryDim(ChartModel chartModel, Map<String, String> filterDim, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        if (CollectionUtils.isEmpty(chartModel.getChartConfig())) {
            return;
        }
        long modelId = IDUtils.toLong((Object)chartModel.getModel());
        long datasetId = IDUtils.toLong((Object)chartModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        chartModel.getChartConfig().forEach(chartConfig -> {
            JSONObject dimensionViews = this.getDimensionView(chartModel, (ChartConfigModel)chartConfig);
            Map<String, Long> viewMap = this.getViewMap(dimensionViews);
            this.checkRelQueryDim(optType, viewMap, modelCache, datasetId, calcParam);
            HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
            String serialDim = chartConfig.getSerDim();
            long serialViewId = this.getViewId(serialDim, dimensionViews);
            chartConfig.getSerMems().forEach(memberModel -> {
                List member = modelCache.getMember(serialDim, Long.valueOf(serialViewId), memberModel.getNum(), memberModel.getScope().intValue());
                Set memberSet = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                if (queryDim.containsKey(serialDim)) {
                    memberSet.addAll((Collection)queryDim.get(serialDim));
                }
                Set querySet = queryDim.computeIfAbsent(serialDim, k -> new HashSet(memberSet.size()));
                querySet.addAll(memberSet);
            });
            this.setOtherDim(chartConfig.getDims(), filterDim, queryDim);
            this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
            QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
            QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
        });
    }

    @Override
    public void buildSplitQueryDim(CustomItem item, List<QueryDto> dtoList) {
        List<SplitConfig> splitConfigs = ModelHelper.getSplitConfigs(item);
        this.processSplitConfig(item, splitConfigs, dtoList);
    }

    @Override
    public void processQuerySplitResult(CustomItem item, List<QueryDto> dtoList) {
        List<SplitConfig> splitConfigs = ModelHelper.getSplitConfigs(item);
        this.processSplitConfigResult(splitConfigs, dtoList);
        ModelHelper.putSplitConfigs(item, splitConfigs);
    }
}

