/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.chart;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.MapValue;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.query.chart.AbstractChartDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class MapChartDataService
extends AbstractChartDataService {
    public MapChartDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            ChartModel chartModel = ModelHelper.getModel(item, ChartModel.class);
            Long modelId = IDUtils.toLong((Object)chartModel.getModel());
            Long datasetId = IDUtils.toLong((Object)chartModel.getDataset());
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
            JSONObject dimensionViews = chartModel.getDimensionViews();
            Map<String, Long> viewMap = this.getViewMap(dimensionViews);
            QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
            Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
            Map<String, String> fixMemberMap = this.genFixMemberMap(chartModel.getMap().getDims(), filterDim);
            this.setRelQueryFixMember(optType, fixMemberMap, calcParam);
            this.processChartQueryResult(chartModel, null, fixMemberMap, queryResult);
            ModelHelper.updateModel(item, chartModel);
        });
    }

    @Override
    void processChartQueryResult(ChartModel chartModel, ChartConfigModel chartConfig, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult) {
        JSONObject dimensionViews = chartModel.getDimensionViews();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)chartModel.getModel()));
        List allDims = modelCache.getDimensionList(IDUtils.toLong((Object)chartModel.getDataset()));
        List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        String dimNumber = SysDimensionEnum.Metric.getNumber();
        String memNumber = fixMemberMap.get(SysDimensionEnum.Metric.getNumber());
        long metricViewId = this.getViewId(dimNumber, dimensionViews);
        Member metricMember = modelCache.getMember(dimNumber, Long.valueOf(metricViewId), memNumber);
        chartModel.getMap().setDt(metricMember.getDatatype());
        String mapDimNumber = chartModel.getMap().getMapDim();
        List<MapValue> mapValues = chartModel.getMap().getMapValues();
        long mapViewId = this.getViewId(mapDimNumber, dimensionViews);
        mapValues.forEach(map -> {
            HashMap<String, String> queryCellMap = new HashMap<String, String>(fixMemberMap);
            if (map.getMember() == null) {
                map.setValue(0);
            } else {
                queryCellMap.put(mapDimNumber, map.getMember().getNum());
                this.fillMissMember(queryCellMap, sortedDimList, modelCache);
                Object value = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
                map.setValue(value);
                List members = modelCache.getMember(mapDimNumber, Long.valueOf(mapViewId), map.getMember().getNum(), map.getMember().getScope().intValue());
                if (CollectionUtils.isNotEmpty((Collection)members)) {
                    Member member = (Member)members.get(0);
                    map.setMemberName(member.getName());
                }
            }
        });
    }

    @Override
    void buildChartQueryDim(ChartModel chartModel, Map<String, String> filterDim, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        long modelId = IDUtils.toLong((Object)chartModel.getModel());
        long datasetId = IDUtils.toLong((Object)chartModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        JSONObject dimensionViews = chartModel.getDimensionViews();
        Map<String, Long> viewMap = this.getViewMap(dimensionViews);
        this.checkRelQueryDim(optType, viewMap, modelCache, datasetId, calcParam);
        HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
        String mapDimNumber = chartModel.getMap().getMapDim();
        long viewId = this.getViewId(mapDimNumber, dimensionViews);
        List memberModels = chartModel.getMap().getMapValues().stream().map(MapValue::getMember).filter(Objects::nonNull).collect(Collectors.toList());
        HashSet mapMemberSet = new HashSet(16);
        for (MemberModel memberModel : memberModels) {
            List members = modelCache.getMember(mapDimNumber, Long.valueOf(viewId), memberModel.getNum(), memberModel.getScope().intValue());
            members.forEach(member -> mapMemberSet.add(member.getNumber()));
        }
        queryDim.put(mapDimNumber, mapMemberSet);
        this.setOtherDim(chartModel.getMap().getDims(), filterDim, queryDim);
        this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
        QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
        QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
    }
}

