/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.chart;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.ChartAxisModel;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.ChartSerialModel;
import kd.epm.eb.business.analysiscanvas.model.DrillConfig;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.query.chart.AbstractChartDataService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PieChartDataService
extends AbstractChartDataService {
    public PieChartDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    void processChartQueryResult(ChartModel chartModel, ChartConfigModel chartConfig, Map<String, String> fixMemberMap, Map<MembersKey, BGCell> queryResult) {
        List<Pair> serMemberPair;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)chartModel.getModel()));
        List allDims = modelCache.getDimensionList(IDUtils.toLong((Object)chartModel.getDataset()));
        List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(chartModel.getDimDrill()) && CollectionUtils.isNotEmpty(chartModel.getChartConfig())) {
            chartModel.setDimDrill(this.buildDimDrill(modelCache, allDims, null, chartModel.getChartConfig().get(0).getSerDim(), chartModel.getChartConfig().get(0)));
        }
        ArrayList serialModels = new ArrayList();
        List<ChartSerialModel> serValList = chartModel.getSerVals();
        if (serValList == null) {
            serValList = new ArrayList<ChartSerialModel>(16);
            chartModel.setSerVals(serValList);
        }
        int serSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P008);
        JSONObject dimensionViews = this.getDimensionView(chartModel, chartConfig);
        String dimNumber = SysDimensionEnum.Metric.getNumber();
        String memNumber = fixMemberMap.get(SysDimensionEnum.Metric.getNumber());
        long metricViewId = this.getViewId(dimNumber, dimensionViews);
        Member metricMember = modelCache.getMember(dimNumber, Long.valueOf(metricViewId), memNumber);
        if (CollectionUtils.isNotEmpty(chartModel.getPathDrill()) && CollectionUtils.isNotEmpty(chartModel.getSpinDrill())) {
            int spinSize = chartModel.getSpinDrill().size();
            List<DrillConfig> spinDrillConfigs = chartModel.getSpinDrill().get(spinSize - 1);
            int pathSize = chartModel.getPathDrill().size();
            DrillConfig pathDrillConfig = chartModel.getPathDrill().get(pathSize - 1);
            if (spinDrillConfigs.size() == 1 || spinDrillConfigs.stream().noneMatch(e -> e.getDimNum().equals(pathDrillConfig.getDimNum()))) {
                String drillDim = pathDrillConfig.getDimNum();
                long drillViewId = this.getViewId(drillDim, dimensionViews);
                List<Member> drillMembers = modelCache.getMember(drillDim, Long.valueOf(drillViewId), pathDrillConfig.getMemNum(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                List<Member> drillMemberRange = (drillMembers = this.filterDrillMemberAgg(drillMembers)).size() > serSize ? drillMembers.subList(0, serSize) : drillMembers;
                serMemberPair = drillMemberRange.stream().map(e -> {
                    Dimension dimension = modelCache.getDimension(drillDim);
                    DrillConfig config = new DrillConfig();
                    config.setDimName(dimension.getName());
                    config.setDimNum(drillDim);
                    config.setLeaf(e.isLeaf());
                    config.setMemNum(e.getNumber());
                    config.setMemName(e.getName());
                    config.setAgg(AggOprtEnum.ADD.getSign().equals(e.getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(e.getAggType()));
                    return Pair.of((Object)e.getName(), Collections.singletonList(config));
                }).collect(Collectors.toList());
            } else {
                String dimNum = pathDrillConfig.getDimNum();
                long drillViewId = this.getViewId(dimNum, dimensionViews);
                List<Member> drillMembers = modelCache.getMember(dimNum, Long.valueOf(drillViewId), pathDrillConfig.getMemNum(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                List<Member> drillMemberRange = (drillMembers = this.filterDrillMemberAgg(drillMembers)).size() > serSize ? drillMembers.subList(0, serSize) : drillMembers;
                serMemberPair = drillMemberRange.stream().map(p -> {
                    ArrayList drillConfigs = new ArrayList();
                    spinDrillConfigs.forEach(drill -> {
                        Member member;
                        String dim1 = drill.getDimNum();
                        Dimension dimension = modelCache.getDimension(dim1);
                        if (dimNum.equals(dim1)) {
                            member = p;
                        } else {
                            long horViewId = this.getViewId(dim1, dimensionViews);
                            member = modelCache.getMember(dim1, Long.valueOf(horViewId), drill.getMemNum());
                        }
                        if (member == null) {
                            return;
                        }
                        DrillConfig config = new DrillConfig();
                        config.setDimName(dimension.getName());
                        config.setDimNum(dim1);
                        config.setLeaf(member.isLeaf());
                        config.setMemNum(member.getNumber());
                        config.setMemName(member.getName());
                        config.setAgg(AggOprtEnum.ADD.getSign().equals(member.getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(member.getAggType()));
                        drillConfigs.add(config);
                    });
                    return Pair.of((Object)p.getName(), drillConfigs);
                }).collect(Collectors.toList());
            }
        } else {
            String serialDim = chartConfig.getSerDim();
            List serDimRangeList = Arrays.stream(serialDim.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (serDimRangeList.size() == 1) {
                long serViewId = this.getViewId(serialDim, dimensionViews);
                List<MemberModel> serMems = chartConfig.getSerMems();
                ArrayList serMemberList = new ArrayList(16);
                if (StringUtils.isNotBlank((CharSequence)chartModel.getDrillMem())) {
                    List members = modelCache.getMember(serialDim, Long.valueOf(serViewId), chartModel.getDrillMem(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                    serMemberList.addAll(members);
                } else {
                    for (MemberModel serMem : serMems) {
                        serMemberList.addAll(modelCache.getMember(serialDim, Long.valueOf(serViewId), serMem.getNum(), serMem.getScope().intValue()));
                    }
                }
                ArrayList serMemberRange = serMemberList.size() > serSize ? serMemberList.subList(0, serSize) : serMemberList;
                serMemberPair = serMemberRange.stream().map(e -> {
                    Dimension dimension = modelCache.getDimension(serialDim);
                    DrillConfig config = new DrillConfig();
                    config.setDimName(dimension.getName());
                    config.setDimNum(serialDim);
                    config.setLeaf(e.isLeaf());
                    config.setMemNum(e.getNumber());
                    config.setMemName(e.getName());
                    config.setAgg(AggOprtEnum.ADD.getSign().equals(e.getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(e.getAggType()));
                    return Pair.of((Object)e.getName(), Collections.singletonList(config));
                }).collect(Collectors.toList());
            } else {
                serMemberPair = chartConfig.getSerRange().stream().map(p -> {
                    ArrayList drillConfigs = new ArrayList();
                    p.getDims().forEach(dim -> {
                        String dim1 = dim.getDim();
                        Dimension dimension = modelCache.getDimension(dim1);
                        long horViewId = this.getViewId(dim1, dimensionViews);
                        List horMembers = dim.getMems().stream().flatMap(e -> modelCache.getMember(dim1, Long.valueOf(horViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(horMembers)) {
                            return;
                        }
                        DrillConfig config = new DrillConfig();
                        config.setDimName(dimension.getName());
                        config.setDimNum(dim1);
                        config.setLeaf(((Member)horMembers.get(0)).isLeaf());
                        config.setMemNum(((Member)horMembers.get(0)).getNumber());
                        config.setMemName(((Member)horMembers.get(0)).getName());
                        config.setAgg(AggOprtEnum.ADD.getSign().equals(((Member)horMembers.get(0)).getAggType()) || AggOprtEnum.SUBSTRACT.getSign().equals(((Member)horMembers.get(0)).getAggType()));
                        drillConfigs.add(config);
                    });
                    return Pair.of((Object)p.getName(), drillConfigs);
                }).collect(Collectors.toList());
            }
        }
        serMemberPair.forEach(ser -> {
            String serialNumber = ((List)ser.getRight()).stream().map(DrillConfig::getMemNum).collect(Collectors.joining(","));
            Map<String, String> dimMaps = ((List)ser.getRight()).stream().collect(Collectors.toMap(DrillConfig::getDimNum, DrillConfig::getMemNum));
            HashMap<String, String> queryCellMap = new HashMap<String, String>(fixMemberMap);
            queryCellMap.putAll(this.getSpinDimMap(chartModel.getSpinDrill()));
            queryCellMap.putAll(dimMaps);
            this.fillMissMember(queryCellMap, sortedDimList, modelCache);
            Object value = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
            ChartAxisModel model = new ChartAxisModel();
            model.setName((String)ser.getLeft());
            model.setNum(serialNumber);
            model.setLeaf(((List)ser.getRight()).size() > 1 || ((DrillConfig)((List)ser.getRight()).get(0)).getLeaf() != false);
            model.setValue(value);
            model.setDt(metricMember.getDatatype());
            model.setDrill((List)ser.getRight());
            model.setMer(metricMember.hasAgg());
            ChartSerialModel serialModel = new ChartSerialModel();
            serialModel.setSerial((String)ser.getLeft());
            serialModel.setType(chartModel.getType());
            serialModel.setAxisList(Collections.singletonList(model));
            serialModels.add(serialModel);
        });
        serValList.addAll(serialModels);
    }

    @Override
    void buildChartQueryDim(ChartModel chartModel, Map<String, String> filterDim, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        if (CollectionUtils.isEmpty(chartModel.getChartConfig())) {
            return;
        }
        int serSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P008);
        long modelId = IDUtils.toLong((Object)chartModel.getModel());
        long datasetId = IDUtils.toLong((Object)chartModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        if (CollectionUtils.isNotEmpty(chartModel.getPathDrill()) && CollectionUtils.isNotEmpty(chartModel.getSpinDrill())) {
            chartModel.getChartConfig().forEach(chartConfig -> {
                JSONObject dimensionViews = this.getDimensionView(chartModel, (ChartConfigModel)chartConfig);
                Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                this.checkRelQueryDim(optType, viewMap, modelCache, datasetId, calcParam);
                HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
                int spinSize = chartModel.getSpinDrill().size();
                List<DrillConfig> spinDrillConfigs = chartModel.getSpinDrill().get(spinSize - 1);
                int pathSize = chartModel.getPathDrill().size();
                DrillConfig pathDrillConfig = chartModel.getPathDrill().get(pathSize - 1);
                if (spinDrillConfigs.size() == 1 || spinDrillConfigs.stream().noneMatch(e -> e.getDimNum().equals(pathDrillConfig.getDimNum()))) {
                    String drillDim = pathDrillConfig.getDimNum();
                    long drillViewId = this.getViewId(drillDim, dimensionViews);
                    List<Member> drillMembers = modelCache.getMember(drillDim, Long.valueOf(drillViewId), pathDrillConfig.getMemNum(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                    List<Member> drillMemberRange = (drillMembers = this.filterDrillMemberAgg(drillMembers)).size() > serSize ? drillMembers.subList(0, serSize) : drillMembers;
                    Set memberSet = drillMemberRange.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    Set querySet = queryDim.computeIfAbsent(drillDim, k -> new HashSet(memberSet.size()));
                    querySet.addAll(memberSet);
                } else {
                    spinDrillConfigs.forEach(p -> {
                        String drillDim = p.getDimNum();
                        if (drillDim.equals(pathDrillConfig.getDimNum())) {
                            long drillViewId = this.getViewId(drillDim, dimensionViews);
                            List<Member> drillMembers = modelCache.getMember(drillDim, Long.valueOf(drillViewId), pathDrillConfig.getMemNum(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                            List<Member> drillMemberRange = (drillMembers = this.filterDrillMemberAgg(drillMembers)).size() > serSize ? drillMembers.subList(0, serSize) : drillMembers;
                            Set memberSet = drillMemberRange.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                            Set querySet = queryDim.computeIfAbsent(drillDim, k -> new HashSet(memberSet.size()));
                            querySet.addAll(memberSet);
                        } else {
                            Set querySet = queryDim.computeIfAbsent(drillDim, k -> new HashSet(16));
                            querySet.add(p.getMemNum());
                        }
                    });
                }
                this.setOtherDim(chartConfig.getDims(), filterDim, queryDim);
                this.setSpinDim(chartModel.getSpinDrill(), queryDim);
                this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
            });
        } else {
            chartModel.getChartConfig().forEach(chartConfig -> {
                JSONObject dimensionViews = this.getDimensionView(chartModel, (ChartConfigModel)chartConfig);
                Map<String, Long> viewMap = this.getViewMap(dimensionViews);
                this.checkRelQueryDim(optType, viewMap, modelCache, datasetId, calcParam);
                HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
                String serialDim = chartConfig.getSerDim();
                List serDimRangeList = Arrays.stream(serialDim.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                if (serDimRangeList.size() == 1) {
                    long serialViewId = this.getViewId(serialDim, dimensionViews);
                    List serMembers = chartConfig.getSerMems().stream().flatMap(e -> modelCache.getMember(serialDim, Long.valueOf(serialViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                    List serMemberRange = serMembers.size() > serSize ? serMembers.subList(0, serSize) : serMembers;
                    Set memberSet = serMemberRange.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    Set querySet = queryDim.computeIfAbsent(serialDim, k -> new HashSet(memberSet.size()));
                    querySet.addAll(memberSet);
                } else {
                    chartConfig.getSerRange().forEach(p -> p.getDims().forEach(dim -> {
                        String dim1 = dim.getDim();
                        long serialViewId = this.getViewId(dim1, dimensionViews);
                        List horMembers = dim.getMems().stream().flatMap(e -> modelCache.getMember(dim1, Long.valueOf(serialViewId), e.getNum(), e.getScope().intValue()).stream()).collect(Collectors.toList());
                        Set memberSet = horMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                        Set querySet = queryDim.computeIfAbsent(dim1, k -> new HashSet(memberSet.size()));
                        querySet.addAll(memberSet);
                    }));
                }
                this.setOtherDim(chartConfig.getDims(), filterDim, queryDim);
                this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
            });
        }
    }
}

