/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.dto;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.CellConvertUtils;
import org.apache.commons.collections4.CollectionUtils;

public class QueryDto
implements Cloneable {
    private Long modelId;
    private Long datasetId;
    private Map<String, Set<String>> queryDim;
    private Map<String, Long> viewMap;
    private Map<MembersKey, BGCell> queryResult;

    public QueryDto(Long modelId, Long datasetId, Map<String, Long> viewMap) {
        this.modelId = modelId;
        this.datasetId = datasetId;
        this.viewMap = viewMap;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Map<String, Set<String>> getQueryDim() {
        return this.queryDim;
    }

    public void setQueryDim(Map<String, Set<String>> queryDim) {
        this.queryDim = queryDim;
    }

    public Map<String, Long> getViewMap() {
        return this.viewMap;
    }

    public void setViewMap(Map<String, Long> viewMap) {
        this.viewMap = viewMap;
    }

    public Map<MembersKey, BGCell> getQueryResult() {
        return this.queryResult;
    }

    public void setQueryResult(List<BGCell> bgCellList) {
        if (CollectionUtils.isEmpty(bgCellList)) {
            this.queryResult = Collections.emptyMap();
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        List allDims = modelCache.getDimensionList(this.datasetId);
        List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        this.queryResult = CellConvertUtils.convertToMap(bgCellList, sortedDimList);
    }

    public QueryDto clone() {
        try {
            QueryDto clone = (QueryDto)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

