/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.dto;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class QueryDtoHelper {
    public static QueryDto getQueryDto(long modelId, long datasetId, Map<String, Long> itemViewMap, List<QueryDto> dtoList) {
        HashMap<String, Long> viewMap = new HashMap<String, Long>(16);
        for (Map.Entry<String, Long> entry : itemViewMap.entrySet()) {
            String key = entry.getKey();
            if (key.contains("_")) continue;
            viewMap.put(key, entry.getValue());
        }
        if (CollectionUtils.isEmpty(dtoList)) {
            return QueryDtoHelper.createNewDto(modelId, datasetId, viewMap, dtoList);
        }
        List dtoListForModel = dtoList.stream().filter(dto -> dto.getModelId() == modelId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dtoListForModel)) {
            return QueryDtoHelper.createNewDto(modelId, datasetId, viewMap, dtoList);
        }
        List dtoListForDataset = dtoListForModel.stream().filter(dto -> dto.getDatasetId() == datasetId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dtoListForDataset)) {
            return QueryDtoHelper.createNewDto(modelId, datasetId, viewMap, dtoList);
        }
        for (QueryDto dto2 : dtoListForDataset) {
            Map<String, Long> dtoViewMap = dto2.getViewMap();
            if (dtoViewMap.size() != viewMap.size()) continue;
            boolean match = true;
            for (Map.Entry entry : viewMap.entrySet()) {
                String key = (String)entry.getKey();
                Long dtoVal = dtoViewMap.get(key);
                if (dtoVal != null && dtoVal.longValue() == ((Long)entry.getValue()).longValue()) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return dto2;
        }
        return QueryDtoHelper.createNewDto(modelId, datasetId, viewMap, dtoList);
    }

    public static void mergeQueryDim(QueryDto dto, Map<String, Set<String>> queryDim) {
        if (MapUtils.isEmpty(dto.getQueryDim())) {
            dto.setQueryDim(queryDim);
        } else {
            Map<String, Set<String>> dtoQueryDim = dto.getQueryDim();
            queryDim.forEach((dim, mems) -> {
                Set memSet = dtoQueryDim.computeIfAbsent((String)dim, k -> new HashSet(16));
                memSet.addAll(mems);
            });
        }
    }

    private static QueryDto createNewDto(long modelId, long datasetId, Map<String, Long> viewMap, List<QueryDto> dtoList) {
        QueryDto queryDto = new QueryDto(modelId, datasetId, viewMap);
        dtoList.add(queryDto);
        return queryDto;
    }
}

