/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.QueryService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.service.OlapReportService;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.domain.view.js.SpreadProperties;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractReportService
extends AbstractDataService {
    protected final IModelCacheHelper modelCache;
    protected final Long modelId;
    protected final Long bizModelId;
    protected final Long datasetId;
    protected final ReportModel reportModel;
    protected final ITemplateModel templateModel;
    protected final String pageCacheKeySuffix;
    protected OlapQuerySync.ViewArea viewArea = null;
    protected IEbSpreadManager spreadManager = null;

    public AbstractReportService(String itemId, AnalysisCanvasBox canvasBox, ReportModel reportModel, ITemplateModel templateModel, IFormView formView) {
        this.formView = formView;
        this.canvasBox = canvasBox;
        this.reportModel = reportModel;
        this.templateModel = templateModel;
        this.modelId = IDUtils.toLong((Object)reportModel.getModel());
        this.datasetId = IDUtils.toLong((Object)reportModel.getDataset());
        this.modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        this.bizModelId = this.modelCache.getBusModelByDataSet(this.datasetId);
        this.pageCacheKeySuffix = "_" + itemId;
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
    }

    abstract void initSpreadManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calc(AnalysisCanvasBox canvasBox, AnalysisCanvasConstants.CalcType calcType, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        List<AlgoCalcRequest> algoCalcRequests;
        if (optType != AnalysisCanvasConstants.OptType.VIRTUAL) {
            this.removeRefreshRows(this.pageCacheKeySuffix);
        }
        this.viewArea = this.initViewArea();
        String spreadData = "";
        AnalysisContext analysisContext = null;
        if (ModelHelper.isCalcQuery(calcType)) {
            AnalysisCanvasDataset canvasDataset = this.getAnalysisCubeId(canvasBox.getCanvasId(), canvasBox.getId(), this.datasetId);
            analysisContext = new AnalysisContext(canvasDataset.getAnalysisCubeId().longValue(), canvasBox.getCanvasId().longValue(), canvasBox.getId().longValue(), canvasDataset.getSeq().intValue());
        }
        if (CollectionUtils.isNotEmpty(algoCalcRequests = this.buildQueryRequest(analysisContext, optType, calcParam))) {
            ArrayList<BGCell> analysisBgCells = new ArrayList<BGCell>(256);
            try {
                if (analysisContext != null) {
                    OlapContext.setAnalysisContext(analysisContext);
                }
                algoCalcRequests.forEach(request -> {
                    if (request == null) {
                        return;
                    }
                    Set ruleIds = request.getRules().stream().map(RuleDto::getId).collect(Collectors.toSet());
                    QueryRequest queryRequest = QueryService.getInstance().buildQueryRequest((AlgoCalcRequest)request);
                    analysisBgCells.addAll(OlapReportService.getInstance().reportQuery(ruleIds, Collections.singletonList(queryRequest)));
                });
                List<Map<String, Object>> dataPackage = this.processResult(analysisBgCells, optType, calcParam);
                spreadData = AbstractReportService.compressData(dataPackage);
            }
            finally {
                OlapContext.clearAnalysisContext();
            }
        }
        this.cacheRefreshRows(this.pageCacheKeySuffix, this.viewArea);
        this.clearViewArea();
        this.reportModel.setData(spreadData);
    }

    protected AlgoCalcRequest buildCalcRequest(AnalysisContext analysisContext, AnalysisCanvasConstants.OptType optType, Map<String, Set<String>> memberInfo, Map<String, Long> viewMap, JSONObject calcParam) {
        this.checkRelQueryDim(optType, viewMap, this.modelCache, this.datasetId, calcParam);
        this.checkQueryDim(memberInfo, viewMap, this.modelCache, this.datasetId);
        return QueryService.getInstance().buildAlgoCalcRequest(analysisContext, optType, this.modelId, this.bizModelId, this.datasetId, memberInfo, viewMap, calcParam);
    }

    abstract List<AlgoCalcRequest> buildQueryRequest(AnalysisContext var1, AnalysisCanvasConstants.OptType var2, JSONObject var3);

    abstract List<Map<String, Object>> processResult(List<BGCell> var1, AnalysisCanvasConstants.OptType var2, JSONObject var3);

    public void processItemChangeMember(AnalysisCanvasBox canvasBox, ReportModel reportModel, ITemplateModel templateModel, Map<String, ValueDto> totalChangeMembers) {
        Map<MembersKey, ValueDto> changeMap;
        Long modelId = IDUtils.toLong((Object)reportModel.getModel());
        Long datasetId = IDUtils.toLong((Object)reportModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        BigDecimal dataUnit = this.getDataUnit(templateModel);
        HashMap queryDim = new HashMap(20);
        HashMap<MembersKey, ValueDto> currChangeMap = new HashMap<MembersKey, ValueDto>(16);
        if (CollectionUtils.isNotEmpty(reportModel.getChangeCells())) {
            reportModel.getChangeCells().forEach(map -> {
                Object val = this.getChangeCellVal((Map<String, Object>)map);
                if (val == null) {
                    return;
                }
                int row = Integer.parseInt(map.get("r").toString());
                int col = Integer.parseInt(map.get("c").toString());
                long changeTime = Long.parseLong(map.get("t").toString());
                Pair<Map<String, String>, Map<String, Long>> memberMapByCell = this.getMemberAndViewMap(row, col);
                if (memberMapByCell == null || MapUtils.isEmpty((Map)((Map)memberMapByCell.getLeft()))) {
                    return;
                }
                Map memberMap = (Map)memberMapByCell.getLeft();
                Map viewMap = (Map)memberMapByCell.getRight();
                MembersKey membersKey = this.transToMembersKey(memberMap, sortedDimList, modelCache);
                ValueDto valueDto = (ValueDto)totalChangeMembers.get(this.getMemberKeyStr(membersKey.getKeys()));
                if (valueDto != null && valueDto.getT() != null && changeTime < valueDto.getT()) {
                    return;
                }
                RuleDto ruleDto = AnalysisCanvasUtils.getCellRule(modelId, datasetId, viewMap, memberMap);
                if (ruleDto != null) {
                    return;
                }
                String metricType = ModelHelper.getMetricType(memberMap, modelCache);
                if (!MetricDataTypeEnum.isNumber((String)metricType)) {
                    return;
                }
                for (Map.Entry entry : memberMap.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    String memNumber = (String)entry.getValue();
                    Long viewId = (Long)viewMap.get(dimNumber);
                    Member realMember = modelCache.getMember(dimNumber, viewId, memNumber);
                    if (realMember != null && realMember.isLeaf()) continue;
                    return;
                }
                val = this.getRealValueWithDataUnit(dataUnit, metricType, val);
                memberMap.forEach((key, value) -> {
                    Set queryMemSet = queryDim.computeIfAbsent(key, v -> new HashSet(8));
                    queryMemSet.add(value);
                });
                currChangeMap.put(membersKey, new ValueDto(val, changeTime, ModelHelper.getViewMap(viewMap, sortedDimList, modelCache, datasetId)));
            });
        }
        if (MapUtils.isNotEmpty(changeMap = this.filterPermWrite(datasetId, currChangeMap, modelCache, sortedDimList))) {
            changeMap.forEach((key, value) -> totalChangeMembers.put(this.getMemberKeyStr(key.getKeys()), (ValueDto)value));
            List<Map<String, Object>> changeMembers = this.mergeChangeMembers(changeMap, sortedDimList, reportModel.getChangeMembers(), modelCache);
            reportModel.setChangeMembers(changeMembers);
        }
        if (CollectionUtils.isNotEmpty(reportModel.getChangeMembers())) {
            reportModel.getChangeMembers().forEach(memberMap -> {
                MembersKey membersKey = this.transToMembersKey((Map<String, ?>)memberMap, sortedDimList, modelCache);
                if (!changeMap.containsKey(membersKey)) {
                    if (totalChangeMembers.containsKey(this.getMemberKeyStr(membersKey.getKeys()))) {
                        return;
                    }
                    changeMap.put(membersKey, new ValueDto(memberMap.get("_v"), Long.parseLong(((Object)memberMap.getOrDefault("_t", 0L)).toString()), ModelHelper.getViewMap((String)memberMap.get("_vw"), sortedDimList, modelCache, datasetId)));
                    for (Dimension dim : allDims) {
                        String dimNumber = dim.getNumber();
                        Object memNumber = memberMap.get(dimNumber);
                        if (memNumber == null) {
                            Dimension dimension = modelCache.getDimension(dimNumber);
                            memNumber = dimension.getNoneNumber();
                        }
                        Set queryMemSet = queryDim.computeIfAbsent(dimNumber, s -> new HashSet(8));
                        queryMemSet.add(memNumber.toString());
                    }
                }
            });
        }
        if (MapUtils.isEmpty(changeMap)) {
            return;
        }
        Map<Long, Pair<List<BGCell>, Map<String, Long>>> changeCells = this.buildChangeCell(changeMap, sortedDimList);
        if (MapUtils.isEmpty(changeCells)) {
            return;
        }
        AnalysisCanvasDataset canvasDataset = this.getAnalysisCubeId(canvasBox.getCanvasId(), canvasBox.getId(), datasetId);
        changeCells.forEach((key, pair) -> this.saveToSandboxAndExecuteRuleChain(modelId, datasetId, canvasDataset, (List)pair.getLeft(), (Map)pair.getRight()));
    }

    public abstract Pair<Map<String, String>, Map<String, Long>> getMemberAndViewMap(int var1, int var2);

    public abstract Set<String> getRowDim(int var1, int var2);

    public void getCoverData(ReportModel reportModel, List<SaveDto> saveDtoList) {
        if (CollectionUtils.isEmpty(reportModel.getChangeMembers())) {
            return;
        }
        Long modelId = IDUtils.toLong((Object)reportModel.getModel());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(this.datasetId);
        List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        reportModel.getChangeMembers().forEach(changeMap -> {
            Object val = changeMap.get("_v");
            if (val == null) {
                return;
            }
            LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>(sortedDimList.size());
            changeMap.forEach((k, v) -> {
                if ("_v".equals(k) || "_t".equals(k) || "_vw".equals(k)) {
                    return;
                }
                memberMap.put((String)k, v.toString());
            });
            this.fillMissMember(memberMap, sortedDimList, modelCache);
            BGCell data = new BGCell(memberMap);
            BigDecimal newData = new BigDecimal(val.toString());
            data.setValue((Object)newData);
            Map<String, Long> viewMap = ModelHelper.getViewMap((String)changeMap.get("_vw"), (List<String>)sortedDimList, modelCache, this.datasetId);
            Long viewHash = ModelHelper.getViewHash(sortedDimList, viewMap);
            Optional<SaveDto> optional = saveDtoList.stream().filter(e -> modelId.equals(e.getModelId()) && this.datasetId.equals(e.getDatasetId()) && viewHash.equals(e.getViewId())).findFirst();
            if (optional.isPresent()) {
                optional.get().getCells().add(data);
            } else {
                SaveDto saveDto = new SaveDto(modelId, this.datasetId, viewHash, viewMap);
                saveDto.getCells().add(data);
                saveDtoList.add(saveDto);
            }
        });
    }

    protected OlapQuerySync.ViewArea initViewArea() {
        String vmData;
        OlapQuerySync.ViewArea viewArea = null;
        if (this.formView != null && StringUtils.isNotEmpty((String)(vmData = this.formView.getPageCache().get("viewArea")))) {
            JSONObject data = JSON.parseObject((String)vmData);
            viewArea = new OlapQuerySync.ViewArea(data.getIntValue("topRow"), data.getIntValue("bottomRow"), data.getIntValue("leftCol"), data.getIntValue("rightCol"));
        }
        if (viewArea == null) {
            viewArea = new OlapQuerySync.ViewArea(0, 65, 0, 50);
        }
        return viewArea;
    }

    protected void clearViewArea() {
        this.formView.getPageCache().remove("viewArea");
    }

    protected Set<CellDimMember> toSetCellDimMember(Set<String> origin) {
        if (origin != null) {
            HashSet<CellDimMember> target = new HashSet<CellDimMember>(origin.size());
            origin.forEach(e -> target.add(new CellDimMember(e)));
            return target;
        }
        return null;
    }

    protected void fillMissDimensionInCellDimMember(Map<String, Set<CellDimMember>> allDimMembers) {
        List dimensionList = this.modelCache.getDimensionList(this.templateModel.getTemplateBaseInfo().getDatasetID());
        Set<String> datasetDims = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        datasetDims.forEach(dimNumber -> {
            if (!allDimMembers.containsKey(dimNumber)) {
                Dimension dimension = this.modelCache.getDimension(dimNumber);
                allDimMembers.put((String)dimNumber, this.toSetCellDimMember(Sets.newHashSet((Object[])new String[]{dimension.getNoneNumber()})));
            }
        });
    }

    protected void fillMissDimensionInMap(Map<String, String> allDimMap) {
        List dimensionList = this.modelCache.getDimensionList(this.templateModel.getTemplateBaseInfo().getDatasetID());
        Set<String> datasetDims = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        datasetDims.forEach(dimNumber -> {
            if (!allDimMap.containsKey(dimNumber)) {
                Dimension dimension = this.modelCache.getDimension(dimNumber);
                allDimMap.put((String)dimNumber, dimension.getNoneNumber());
            }
        });
    }

    protected Set<Integer> getRefreshedRows(String pageCacheKeySuffix) {
        String serial = "";
        if (this.getFormView() != null) {
            serial = this.getFormView().getPageCache().get("refreshDataRows" + pageCacheKeySuffix);
        }
        Set refreshRows = StringUtils.isNotEmpty((String)serial) ? (Set)SerializationUtils.fromJsonString((String)serial, Set.class) : new HashSet();
        return refreshRows;
    }

    protected void cacheRefreshRows(String pageCacheKeySuffix, OlapQuerySync.ViewArea viewArea) {
        if (this.getFormView() == null) {
            return;
        }
        Set<Integer> refreshRows = this.getRefreshedRows(pageCacheKeySuffix);
        for (int i = viewArea.getStartrow(); i <= viewArea.getEndrow(); ++i) {
            refreshRows.add(i);
        }
        this.getFormView().getPageCache().put("refreshDataRows" + pageCacheKeySuffix, SerializationUtils.toJsonString(refreshRows));
    }

    protected void removeRefreshRows(String pageCacheKeySuffix) {
        if (this.getFormView() != null) {
            this.getFormView().getPageCache().remove("refreshDataRows" + pageCacheKeySuffix);
        }
    }

    protected Map<String, Long> extractDimensionViewsByPartition(Map<String, Long> dimensionViews, String rowPartition, String colPartition) {
        if (dimensionViews != null) {
            HashMap<String, Long> dimViewsByPart = new HashMap<String, Long>(16);
            dimensionViews.forEach((k, v) -> {
                if (k.endsWith("_" + rowPartition) || k.endsWith("_" + colPartition)) {
                    dimViewsByPart.put(k.substring(0, k.indexOf("_")), (Long)v);
                } else if (!k.contains("_") && !dimViewsByPart.containsKey(k)) {
                    dimViewsByPart.put((String)k, (Long)v);
                }
            });
            return dimViewsByPart;
        }
        return new HashMap<String, Long>(16);
    }

    protected BigDecimal getDataUnit(ITemplateModel templateModel) {
        String dataUnit = templateModel.getTemplateBaseInfo().getDataunit();
        BigDecimal unit = null;
        if (StringUtils.isNotEmpty((String)dataUnit) && !"0".equals(dataUnit)) {
            unit = BigDecimal.TEN.pow(Integer.parseInt(dataUnit));
        }
        return unit;
    }

    protected Object getValueWithDataUnit(BigDecimal unit, String metricDataType, Object value) {
        if (value != null && unit != null && MetricDataTypeEnum.CURRENCY.getIndex().equals(metricDataType)) {
            value = value instanceof Long ? BigDecimal.valueOf((Long)value).divide(unit, 2, RoundingMode.HALF_UP) : ((BigDecimal)value).divide(unit, 2, RoundingMode.HALF_UP);
        }
        return value;
    }

    protected Object getRealValueWithDataUnit(BigDecimal unit, String metricDataType, Object value) {
        if (value != null && unit != null && MetricDataTypeEnum.CURRENCY.getIndex().equals(metricDataType)) {
            value = value instanceof BigDecimal ? ((BigDecimal)value).multiply(unit) : new BigDecimal(value.toString()).multiply(unit);
        }
        return value;
    }

    protected Pair<MembersKey, String> getCellMemberKeyAndMetric(List<String> sortedDimList, List<String> rowDimList, List<String> colDimList, List<CellDimMember> rowDimMemberList, List<CellDimMember> colDimMemberList, MultiAreaManager multiAreaManager, IEbSpreadManager spreadManager, IModelCacheHelper modelCache, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        String memNumber;
        String dimNumber;
        HashMap<String, String> cellMemberMap = new HashMap<String, String>(20);
        String metricDataType = null;
        for (Map.Entry entry : spreadManager.getPageViewDims().entrySet()) {
            dimNumber = (String)entry.getKey();
            memNumber = ((PageViewDimMember)entry.getValue()).getNumber();
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                metricDataType = modelCache.getMember(dimNumber, null, memNumber).getDatatype();
            }
            cellMemberMap.put(dimNumber, memNumber);
        }
        if (multiAreaManager != null && multiAreaManager.getAreaPageViewDims() != null) {
            for (Map.Entry entry : multiAreaManager.getAreaPageViewDims().entrySet()) {
                dimNumber = (String)entry.getKey();
                memNumber = ((PageViewDimMember)entry.getValue()).getNumber();
                if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                    metricDataType = modelCache.getMember(dimNumber, null, memNumber).getDatatype();
                }
                cellMemberMap.put(dimNumber, memNumber);
            }
        }
        this.setRelQueryFixMember(optType, cellMemberMap, calcParam);
        Map rowDimPosMap = multiAreaManager == null ? null : DimPropertyHelper.getDimPosMap((List)multiAreaManager.getRowHeaders());
        for (int i = 0; i < rowDimList.size(); ++i) {
            dimNumber = rowDimList.get(i);
            int realPos = rowDimPosMap == null ? i : (Integer)rowDimPosMap.get(dimNumber);
            CellDimMember cellDimMember = rowDimMemberList.get(realPos);
            if (cellDimMember == null) {
                return null;
            }
            if (cellDimMember instanceof MetricCellDimMember) {
                metricDataType = String.valueOf(((MetricCellDimMember)cellDimMember).getDatatype());
            }
            cellMemberMap.put(dimNumber, cellDimMember.getDimMemberNumber());
        }
        Map colDimPosMap = multiAreaManager == null ? null : DimPropertyHelper.getDimPosMap((List)multiAreaManager.getColHeaders());
        for (int i = 0; i < colDimList.size(); ++i) {
            String dimNumber2 = colDimList.get(i);
            int realPos = colDimPosMap == null ? i : (Integer)colDimPosMap.get(dimNumber2);
            CellDimMember cellDimMember = colDimMemberList.get(realPos);
            if (cellDimMember == null) {
                return null;
            }
            if (cellDimMember instanceof MetricCellDimMember) {
                metricDataType = String.valueOf(((MetricCellDimMember)cellDimMember).getDatatype());
            }
            cellMemberMap.put(dimNumber2, cellDimMember.getDimMemberNumber());
        }
        MembersKey membersKey = this.transToMembersKey(cellMemberMap, sortedDimList, modelCache);
        return Pair.of((Object)membersKey, (Object)metricDataType);
    }

    protected void packageCells(List<Map<String, Object>> parameters, ECell cell) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(3);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), cell.getRow());
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), cell.getCol());
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), cell.getValue());
        parameters.add(valMap);
    }

    protected static String compressData(List<Map<String, Object>> parameters) {
        byte[] bb;
        try {
            String spreadData = JSON.toJSONString(parameters);
            System.out.println(" ---- spreadData: " + spreadData);
            bb = Base64.getEncoder().encode(GZIPUtils.compress((String)spreadData));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return "base64" + new String(bb);
    }

    protected Object getChangeCellVal(Map<String, Object> map) {
        Object val = map.get("v");
        if (!(val instanceof Number) && !(val instanceof String)) {
            return null;
        }
        if (val instanceof String) {
            if (StringUtils.isEmpty((String)((String)val))) {
                val = null;
            } else if (this.isNotSupportExcelFormat((String)val)) {
                String vdata = this.removeAmountSign((String)val);
                boolean isNegative = vdata.startsWith("(");
                String validateData = vdata.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(",", "");
                if (isNegative) {
                    validateData = "-" + validateData;
                }
                try {
                    val = new BigDecimal(validateData);
                }
                catch (Throwable ex) {
                    val = null;
                }
            }
        }
        return val;
    }

    private boolean isNotSupportExcelFormat(String data) {
        data = this.removeAmountSign(data);
        String AMOUNT_PATTERN = "^\\(?((-?([0-9]+|[0-9]{1,3}(,[0-9]{3})*))(.[0-9]{1,})?)\\)?$";
        return StringUtils.isNotEmpty((String)data) && Pattern.matches(AMOUNT_PATTERN, data.trim());
    }

    private String removeAmountSign(String data) {
        return data.replaceAll("[\\\\$,US\u00a3\u00a5]", "");
    }

    public IFormView getFormView() {
        return this.formView;
    }
}

