/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.query.report.AbstractReportService;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.CellConvertUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.serializer.EbSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DynamicReportService
extends AbstractReportService {
    public DynamicReportService(String itemId, AnalysisCanvasBox canvasBox, ReportModel reportModel, ITemplateModel templateModel, IFormView formView) {
        super(itemId, canvasBox, reportModel, templateModel, formView);
        this.initSpreadManager();
    }

    @Override
    protected final void initSpreadManager() {
        String serial = this.getFormView().getPageCache().get("spreadManagerCacheKey" + this.pageCacheKeySuffix);
        this.spreadManager = EbSpreadManagerSerializerUtil.read((String)serial);
    }

    @Override
    protected List<AlgoCalcRequest> buildQueryRequest(AnalysisContext analysisContext, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        boolean isNeedPartition;
        if (this.templateModel == null) {
            return null;
        }
        LinkedList<AlgoCalcRequest> calcRequestList = new LinkedList<AlgoCalcRequest>();
        HashMap<String, Long> viewMap = new HashMap<String, Long>(16);
        Map templateViewMap = this.spreadManager.getDimemsionViews();
        Map<String, Set<CellDimMember>> allDimensionMembers = this.getAllDimMember(this.viewArea);
        if (MapUtils.isEmpty(allDimensionMembers)) {
            return null;
        }
        boolean bl = isNeedPartition = templateViewMap != null && templateViewMap.keySet().stream().anyMatch(k -> k.contains("_"));
        if (isNeedPartition) {
            Map allDimMemInPartition;
            String partNumber;
            String dimNumber;
            List rowDimNums = this.templateModel.getAreaRangeEntry().getRowdimensions().stream().map(IBaseEntry::getNumber).collect(Collectors.toList());
            List colDimNums = this.templateModel.getAreaRangeEntry().getColdimensions().stream().map(IBaseEntry::getNumber).collect(Collectors.toList());
            boolean isMetricInRow = Boolean.TRUE.equals(this.templateModel.getAreaRangeEntry().isMetricInRow());
            HashMap<String, Map<String, List<CellDimMember>>> rowPartitionByDimNumMap = new HashMap<String, Map<String, List<CellDimMember>>>(16);
            HashMap<String, Map> rowPartitionByPartNumMap = new HashMap<String, Map>(16);
            HashMap<String, Map<String, List<CellDimMember>>> colPartitionByDimNumMap = new HashMap<String, Map<String, List<CellDimMember>>>(16);
            HashMap<String, Map> colPartitionByPartNumMap = new HashMap<String, Map>(16);
            HashMap<String, String> pageViewDimMemMap = new HashMap<String, String>(16);
            for (Map.Entry<String, Set<CellDimMember>> entry : allDimensionMembers.entrySet()) {
                if (rowDimNums.contains(entry.getKey()) || SysDimensionEnum.Metric.getNumber().equals(entry.getKey()) && isMetricInRow) {
                    rowPartitionByDimNumMap.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(e -> e.getPartition() == null ? "" : e.getPartition())));
                    continue;
                }
                if (colDimNums.contains(entry.getKey()) || SysDimensionEnum.Metric.getNumber().equals(entry.getKey()) && !isMetricInRow) {
                    colPartitionByDimNumMap.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(e -> e.getPartition() == null ? "" : e.getPartition())));
                    continue;
                }
                if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                    pageViewDimMemMap.put(entry.getKey(), entry.getValue().iterator().next().getDimMemberNumber());
                    viewMap.put(entry.getKey(), DimensionViewServiceHelper.getViewId((Map)templateViewMap, (String)entry.getKey(), null));
                    continue;
                }
                throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u65e0\u6709\u6548\u6210\u5458\uff0c\u62a5\u8868\u4e3a\u7a7a\u3002", (String)"DynamicReportService_1", (String)"epm-eb-business", (Object[])new Object[]{entry.getKey()}));
            }
            for (Map.Entry<String, Set<Object>> entry : rowPartitionByDimNumMap.entrySet()) {
                dimNumber = entry.getKey();
                for (Map.Entry partEntry : ((Map)((Object)entry.getValue())).entrySet()) {
                    partNumber = (String)partEntry.getKey();
                    rowPartitionByPartNumMap.get(partNumber);
                    allDimMemInPartition = rowPartitionByPartNumMap.computeIfAbsent(partNumber, k -> new HashMap(16));
                    allDimMemInPartition.put(dimNumber, partEntry.getValue());
                }
            }
            for (Map.Entry<String, Set<Object>> entry : colPartitionByDimNumMap.entrySet()) {
                dimNumber = entry.getKey();
                for (Map.Entry partEntry : ((Map)((Object)entry.getValue())).entrySet()) {
                    partNumber = (String)partEntry.getKey();
                    colPartitionByPartNumMap.get(partNumber);
                    allDimMemInPartition = colPartitionByPartNumMap.computeIfAbsent(partNumber, k -> new HashMap(16));
                    allDimMemInPartition.put(dimNumber, partEntry.getValue());
                }
            }
            for (Map.Entry<String, Set<Object>> entry : rowPartitionByPartNumMap.entrySet()) {
                String rowPartition = entry.getKey();
                Map rowDimMemMap = (Map)((Object)entry.getValue());
                rowDimMemMap.keySet().forEach(dimNum -> viewMap.put((String)dimNum, DimensionViewServiceHelper.getViewId((Map)templateViewMap, (String)dimNum, (String)rowPartition)));
                for (Map.Entry colEntry : colPartitionByPartNumMap.entrySet()) {
                    String colPartition = (String)colEntry.getKey();
                    Map colDimMemMap = (Map)colEntry.getValue();
                    HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
                    rowDimMemMap.forEach((k, v) -> memberInfo.put((String)k, v.stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet())));
                    colDimMemMap.forEach((k, v) -> memberInfo.put((String)k, v.stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet())));
                    pageViewDimMemMap.forEach((k, v) -> {
                        Set cfr_ignored_0 = memberInfo.put((String)k, Sets.newHashSet((Object[])new String[]{v}));
                    });
                    colDimMemMap.keySet().forEach(dimNum -> viewMap.put((String)dimNum, DimensionViewServiceHelper.getViewId((Map)templateViewMap, (String)dimNum, (String)colPartition)));
                    calcRequestList.add(this.buildCalcRequest(analysisContext, optType, memberInfo, viewMap, calcParam));
                }
            }
        } else {
            HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
            for (Map.Entry<String, Set<CellDimMember>> entry : allDimensionMembers.entrySet()) {
                if (entry.getValue() != null && entry.getValue().size() > 0) {
                    memberInfo.put(entry.getKey(), entry.getValue().stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet()));
                    continue;
                }
                throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u65e0\u6709\u6548\u6210\u5458\uff0c\u62a5\u8868\u4e3a\u7a7a\u3002", (String)"DynamicReportService_1", (String)"epm-eb-business", (Object[])new Object[]{entry.getKey()}));
            }
            calcRequestList.add(this.buildCalcRequest(analysisContext, optType, memberInfo, templateViewMap, calcParam));
        }
        return calcRequestList;
    }

    private Map<String, Set<CellDimMember>> getAllDimMember(OlapQuerySync.ViewArea viewArea) {
        int i;
        Set<Integer> refreshedRows = this.getRefreshedRows(this.pageCacheKeySuffix);
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        List rowDimNumList = this.spreadManager.getRowpartitionDims();
        List colDimNumList = this.spreadManager.getColpartitionDims();
        ArrayList rowDimMemList = new ArrayList(16);
        ArrayList colDimMemList = new ArrayList(16);
        rowDimNumList.forEach(e -> rowDimMemList.add(new HashSet(16)));
        colDimNumList.forEach(e -> colDimMemList.add(new HashSet(16)));
        boolean needQuery = false;
        for (int row = viewArea.getStartrow(); row <= viewArea.getEndrow(); ++row) {
            if (refreshedRows.contains(row)) continue;
            needQuery = true;
            List rowDimMemberList = (List)this.spreadManager.getRowpartitionDimMems().get(row);
            if (rowDimMemberList == null || rowDimMemberList.size() == 0) continue;
            for (i = 0; i < rowDimMemberList.size(); ++i) {
                ((Set)rowDimMemList.get(i)).add(rowDimMemberList.get(i));
            }
            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                List colDimMemberList = (List)this.spreadManager.getColpartitionDimMems().get(col);
                if (colDimMemberList == null || colDimMemberList.size() == 0) continue;
                for (int i2 = 0; i2 < colDimMemberList.size(); ++i2) {
                    ((Set)colDimMemList.get(i2)).add(colDimMemberList.get(i2));
                }
            }
        }
        if (!needQuery) {
            return null;
        }
        HashMap<String, Set<CellDimMember>> allDimMembers = new HashMap<String, Set<CellDimMember>>(16);
        for (i = 0; i < rowDimNumList.size(); ++i) {
            allDimMembers.put((String)rowDimNumList.get(i), (Set<CellDimMember>)rowDimMemList.get(i));
        }
        for (i = 0; i < colDimNumList.size(); ++i) {
            allDimMembers.put((String)colDimNumList.get(i), (Set<CellDimMember>)colDimMemList.get(i));
        }
        Map allDimensionWithMemberStr = (Map)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized((Object)this.spreadManager.getAlldimensionWithMembers()));
        for (Map.Entry entry : allDimensionWithMemberStr.entrySet()) {
            allDimMembers.computeIfAbsent((String)entry.getKey(), (Function<String, Set<CellDimMember>>)((Function<String, Set>)f -> this.toSetCellDimMember((Set)entry.getValue())));
        }
        this.fillMissDimensionInCellDimMember(allDimMembers);
        return allDimMembers;
    }

    @Override
    protected List<Map<String, Object>> processResult(List<BGCell> bgCellList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        if (CollectionUtils.isEmpty(bgCellList)) {
            return null;
        }
        List allDims = this.modelCache.getDimensionList(this.datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Map keyBGCellMap = CellConvertUtils.convertToMap(bgCellList, sortedDimList);
        Set<Integer> refreshedRows = this.getRefreshedRows(this.pageCacheKeySuffix);
        BigDecimal unit = this.getDataUnit(this.templateModel);
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>(keyBGCellMap.size());
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        List rowDimList = this.spreadManager.getRowpartitionDims();
        List colDimList = this.spreadManager.getColpartitionDims();
        for (int row = this.viewArea.getStartrow(); row <= this.viewArea.getEndrow(); ++row) {
            List rowDimMemberList;
            if (refreshedRows.contains(row) || (rowDimMemberList = (List)this.spreadManager.getRowpartitionDimMems().get(row)) == null || rowDimMemberList.size() == 0) continue;
            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                Pair<MembersKey, String> pair;
                List colDimMemberList = (List)this.spreadManager.getColpartitionDimMems().get(col);
                if (colDimMemberList == null || colDimMemberList.size() == 0 || (pair = this.getCellMemberKeyAndMetric(sortedDimList, rowDimList, colDimList, rowDimMemberList, colDimMemberList, null, this.spreadManager, this.modelCache, optType, calcParam)) == null) continue;
                MembersKey membersKey = (MembersKey)pair.getLeft();
                String metricType = (String)pair.getRight();
                ECell cell = sheet.getECellNotAdd(row, col);
                if (cell == null) {
                    cell = sheet.getECell(row, col);
                }
                BGCell bgCell = (BGCell)keyBGCellMap.get(membersKey);
                Object newValue = null;
                if (bgCell != null) {
                    newValue = bgCell.getValue();
                }
                newValue = this.getValueWithDataUnit(unit, metricType, newValue);
                cell.setValue(newValue);
                this.packageCells(parameters, cell);
            }
        }
        return parameters;
    }

    @Override
    public Pair<Map<String, String>, Map<String, Long>> getMemberAndViewMap(int row, int col) {
        Map rowDimMem;
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        if (col < sheet.getValueAreaColStart() || row < sheet.getValueAreaRowStart()) {
            return null;
        }
        String rowPartition = "";
        String colPartition = "";
        LinkedHashMap dimMemberMap = new LinkedHashMap(16);
        Map colDimMem = this.spreadManager.getColpartitionDimMemsByCol(Integer.valueOf(col));
        if (colDimMem != null) {
            dimMemberMap.putAll(colDimMem);
            for (Map.Entry entry : colDimMem.entrySet()) {
                CellDimMember cellDimMember = (CellDimMember)entry.getValue();
                colPartition = cellDimMember.getPartition();
            }
        }
        if ((rowDimMem = this.spreadManager.getRowpartitionDimMemsByRow(Integer.valueOf(row))) != null) {
            dimMemberMap.putAll(rowDimMem);
            for (Map.Entry entry : rowDimMem.entrySet()) {
                CellDimMember cellDimMember = (CellDimMember)entry.getValue();
                rowPartition = cellDimMember.getPartition();
            }
        }
        Map<String, String> map = dimMemberMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> ((CellDimMember)value.getValue()).getDimMemberNumber(), (o1, o2) -> o2));
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        Map allDimMembers = this.spreadManager.getAlldimensionWithMembers();
        for (Map.Entry entry : allDimMembers.entrySet()) {
            String dimNumber = (String)entry.getKey();
            if (map.containsKey(dimNumber)) continue;
            String memNumber = "";
            if (entry.getValue() != null && ((Set)entry.getValue()).size() > 0) {
                memNumber = (String)((Set)entry.getValue()).iterator().next();
            }
            hashMap.put(dimNumber, memNumber);
        }
        this.fillMissDimensionInMap(hashMap);
        HashMap viewMap = new HashMap(20);
        viewMap.putAll(DimensionViewServiceHelper.getViewIds((Map)this.spreadManager.getDimemsionViews(), (String)rowPartition));
        viewMap.putAll(DimensionViewServiceHelper.getViewIds((Map)this.spreadManager.getDimemsionViews(), (String)colPartition));
        return Pair.of(hashMap, viewMap);
    }

    @Override
    public Set<String> getRowDim(int row, int col) {
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        if (col < sheet.getValueAreaColStart() || row < sheet.getValueAreaRowStart()) {
            return null;
        }
        Map rowDimMem = this.spreadManager.getRowpartitionDimMemsByRow(Integer.valueOf(row));
        if (rowDimMem != null) {
            return rowDimMem.keySet();
        }
        return null;
    }
}

