/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.query.report.AbstractReportService;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.CellConvertUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.AreaInfo;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FixReportService
extends AbstractReportService {
    public FixReportService(String itemId, AnalysisCanvasBox canvasBox, ReportModel reportModel, ITemplateModel templateModel, IFormView formView) {
        super(itemId, canvasBox, reportModel, templateModel, formView);
        this.initSpreadManager();
    }

    @Override
    protected final void initSpreadManager() {
        String serial = this.getFormView().getPageCache().get("spreadManagerCacheKey" + this.pageCacheKeySuffix);
        this.spreadManager = FixSpreadManagerSerializerUtil.read((String)serial);
    }

    @Override
    protected List<AlgoCalcRequest> buildQueryRequest(AnalysisContext analysisContext, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        if (this.templateModel == null || this.templateModel.getAreaRanges().isEmpty()) {
            return null;
        }
        LinkedList<AlgoCalcRequest> calcRequestList = new LinkedList<AlgoCalcRequest>();
        Map<String, Long> reportModelViewMap = this.getViewMap(this.reportModel.getDimensionViews());
        Map templateViewMap = this.spreadManager.getDimemsionViews();
        Map<String, Set<CellDimMember>> allDimensionMembers = this.getAllDimMember(this.viewArea);
        if (MapUtils.isEmpty(allDimensionMembers)) {
            return null;
        }
        if (this.templateModel.getAreaRanges().size() > 1) {
            String dimNumber;
            List rowColDims = this.templateModel.getRowcolDims();
            HashMap<String, Map<String, List<CellDimMember>>> partitionMapByDimNum = new HashMap<String, Map<String, List<CellDimMember>>>(16);
            HashMap<String, Map> partitionMapByPartNum = new HashMap<String, Map>(16);
            HashMap<String, String> pageHideDimMemMap = new HashMap<String, String>(16);
            for (Map.Entry<String, Set<CellDimMember>> entry : allDimensionMembers.entrySet()) {
                dimNumber = entry.getKey();
                if (rowColDims.contains(dimNumber)) {
                    partitionMapByDimNum.put(dimNumber, entry.getValue().stream().collect(Collectors.groupingBy(CellDimMember::getPartition)));
                    continue;
                }
                pageHideDimMemMap.put(dimNumber, entry.getValue().iterator().next().getDimMemberNumber());
            }
            for (Map.Entry<String, Set<Object>> entry : partitionMapByDimNum.entrySet()) {
                dimNumber = entry.getKey();
                for (Map.Entry partEntry : ((Map)((Object)entry.getValue())).entrySet()) {
                    String partNumber = (String)partEntry.getKey();
                    Map allDimMemsInPartition = partitionMapByPartNum.computeIfAbsent(partNumber, k -> new HashMap(16));
                    allDimMemsInPartition.put(dimNumber, partEntry.getValue());
                }
            }
            for (Map.Entry<String, Set<Object>> entry : partitionMapByPartNum.entrySet()) {
                String partitionKey = entry.getKey();
                Map colDimMems = (Map)((Object)entry.getValue());
                HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
                colDimMems.forEach((k, v) -> memberInfo.put((String)k, v.stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet())));
                pageHideDimMemMap.forEach((k, v) -> {
                    Set cfr_ignored_0 = memberInfo.put((String)k, Sets.newHashSet((Object[])new String[]{v}));
                });
                Map<String, Long> viewMap = this.extractDimensionViewsByPartition(templateViewMap, partitionKey, null);
                viewMap.putAll(reportModelViewMap);
                calcRequestList.add(this.buildCalcRequest(analysisContext, optType, memberInfo, viewMap, calcParam));
            }
        } else {
            HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
            for (Map.Entry<String, Set<CellDimMember>> entry : allDimensionMembers.entrySet()) {
                if (entry.getValue() != null && entry.getValue().size() > 0) {
                    memberInfo.put(entry.getKey(), entry.getValue().stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet()));
                    continue;
                }
                throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u65e0\u6709\u6548\u6210\u5458\uff0c\u62a5\u8868\u4e3a\u7a7a\u3002", (String)"DynamicReportService_1", (String)"epm-eb-business", (Object[])new Object[]{entry.getKey()}));
            }
            HashMap<String, Long> viewMap = new HashMap<String, Long>(templateViewMap);
            viewMap.putAll(reportModelViewMap);
            calcRequestList.add(this.buildCalcRequest(analysisContext, optType, memberInfo, viewMap, calcParam));
        }
        return calcRequestList;
    }

    private Map<String, Set<CellDimMember>> getAllDimMember(OlapQuerySync.ViewArea viewArea) {
        List multiAreaManagers = this.spreadManager.getMultiAreaManager();
        HashMap<String, Set> membersWithinView = new HashMap<String, Set>(16);
        Set<Integer> refreshedRows = this.getRefreshedRows(this.pageCacheKeySuffix);
        for (MultiAreaManager multiAreaManager : multiAreaManagers) {
            String areaIndex = multiAreaManager.getAreaIndex();
            List rowDimNumList = multiAreaManager.getRowpartitionDims();
            List colDimNumList = multiAreaManager.getColpartitionDims();
            Map rowDimPosMap = DimPropertyHelper.getDimPosMap((List)multiAreaManager.getRowHeaders());
            Map colDimPosMap = DimPropertyHelper.getDimPosMap((List)multiAreaManager.getColHeaders());
            ArrayList rowDimMemList = new ArrayList(16);
            rowDimNumList.forEach(e -> rowDimMemList.add(new HashSet(16)));
            boolean hasRowMembers = false;
            MultiAreaManager.ValueArea valueAreaStart = multiAreaManager.getValueAreaStart();
            int rowStart = valueAreaStart.getRow_start();
            for (int row = viewArea.getStartrow(); row <= viewArea.getEndrow(); ++row) {
                Boolean isFullDim;
                List rowDimMemberList;
                int relatedRow;
                if (refreshedRows.contains(row) || (relatedRow = row - rowStart) < 0 || (rowDimMemberList = (List)multiAreaManager.getRowpartitionDimMems().get(relatedRow)) == null || rowDimMemberList.size() == 0 || !(isFullDim = DimPropertyHelper.isFullDimCells((Map)rowDimPosMap, (List)rowDimMemberList)).booleanValue()) continue;
                int rowDimPos = 0;
                for (CellDimMember cellDimMember : rowDimMemberList) {
                    if (cellDimMember == null || cellDimMember.isProperty()) continue;
                    ((Set)rowDimMemList.get(rowDimPos)).add(cellDimMember);
                    ++rowDimPos;
                }
                hasRowMembers = true;
            }
            if (hasRowMembers) {
                Object s22;
                Set members;
                for (int i = 0; i < rowDimNumList.size(); ++i) {
                    members = membersWithinView.computeIfAbsent((String)rowDimNumList.get(i), k -> new HashSet(16));
                    members.addAll((Collection)rowDimMemList.get(i));
                }
                for (Object s22 : colDimNumList) {
                    members = membersWithinView.computeIfAbsent((String)s22, k -> new HashSet(16));
                    int colDimPos = (Integer)colDimPosMap.get(s22);
                    for (List m : multiAreaManager.getColpartitionDimMems()) {
                        if (m.get(colDimPos) == null || ((CellDimMember)m.get(colDimPos)).isProperty()) continue;
                        members.add(m.get(colDimPos));
                    }
                }
                Map areaPageViewDims = multiAreaManager.getAreaPageViewDims();
                s22 = areaPageViewDims.entrySet().iterator();
                while (s22.hasNext()) {
                    Map.Entry entry = (Map.Entry)s22.next();
                    members = membersWithinView.computeIfAbsent((String)entry.getKey(), k -> new HashSet(16));
                    members.add(new CellDimMember(((PageViewDimMember)entry.getValue()).isIsleaf(), ((PageViewDimMember)entry.getValue()).getNumber(), multiAreaManager.getAreaIndex()));
                }
            }
            for (Set cellDimMembers : membersWithinView.values()) {
                cellDimMembers.forEach(e -> {
                    if (e.getPartition() == null) {
                        e.setPartition(areaIndex);
                    }
                });
            }
        }
        if (membersWithinView.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : membersWithinView.entrySet()) {
            if (entry.getValue() != null && !((Set)entry.getValue()).isEmpty()) continue;
            return null;
        }
        HashMap<String, Set<CellDimMember>> allDimMembers = new HashMap<String, Set<CellDimMember>>(membersWithinView);
        Map map = (Map)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized((Object)this.spreadManager.getAlldimensionWithMembers()));
        for (Map.Entry entry : map.entrySet()) {
            allDimMembers.computeIfAbsent((String)entry.getKey(), (Function<String, Set<CellDimMember>>)((Function<String, Set>)f -> this.toSetCellDimMember((Set)entry.getValue())));
        }
        this.fillMissDimensionInCellDimMember(allDimMembers);
        return allDimMembers;
    }

    @Override
    protected List<Map<String, Object>> processResult(List<BGCell> bgCellList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        if (CollectionUtils.isEmpty(bgCellList)) {
            return null;
        }
        List allDims = this.modelCache.getDimensionList(this.datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Map keyBGCellMap = CellConvertUtils.convertToMap(bgCellList, sortedDimList);
        Set<Integer> refreshedRows = this.getRefreshedRows(this.pageCacheKeySuffix);
        BigDecimal unit = this.getDataUnit(this.templateModel);
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>(keyBGCellMap.size());
        for (MultiAreaManager multiAreaManager : this.spreadManager.getMultiAreaManager()) {
            MultiAreaManager.ValueArea valueRowColStart = multiAreaManager.getValueAreaStart();
            int rowStart = valueRowColStart.getRow_start();
            int colStart = valueRowColStart.getCol_start();
            List rowDimList = multiAreaManager.getRowpartitionDims();
            List colDimList = multiAreaManager.getColpartitionDims();
            int rowHeadDimsCount = rowDimList.size();
            int colHeadDimsCount = colDimList.size();
            if (multiAreaManager.getDimPropertys() != null) {
                rowHeadDimsCount += DimPropertyHelper.getPropertyCount((Map)multiAreaManager.getDimPropertys(), (List)rowDimList);
                colHeadDimsCount += DimPropertyHelper.getPropertyCount((Map)multiAreaManager.getDimPropertys(), (List)colDimList);
            }
            ISheet sheet = multiAreaManager.getData().getDataSheet();
            int rowSize = multiAreaManager.getRowpartitionDimMems().size();
            for (int viewRow = this.viewArea.getStartrow(); viewRow <= this.viewArea.getEndrow(); ++viewRow) {
                List rowDimMemberList;
                int row;
                if (refreshedRows != null && refreshedRows.contains(viewRow)) continue;
                int n = row = multiAreaManager.getFloatonWhere() == 1 ? viewRow - rowStart - colHeadDimsCount : viewRow - rowStart;
                if (row < 0 || row > rowSize - 1 || (rowDimMemberList = (List)multiAreaManager.getRowpartitionDimMems().get(row)) == null || rowDimMemberList.size() == 0) continue;
                long rowDimCount = rowDimMemberList.stream().filter(mem -> mem != null && !mem.isProperty()).count();
                if ((long)rowDimList.size() != rowDimCount) continue;
                int relativeRow = multiAreaManager.getFloatonWhere() == 1 ? row + colHeadDimsCount : row;
                for (int col = 0; col < multiAreaManager.getColpartitionDimMems().size(); ++col) {
                    Pair<MembersKey, String> pair;
                    List colDimMemberList = (List)multiAreaManager.getColpartitionDimMems().get(col);
                    if (colDimMemberList == null || colDimMemberList.size() == 0) continue;
                    long colDimCount = colDimMemberList.stream().filter(mem -> mem != null && !mem.isProperty()).count();
                    if ((long)colDimList.size() != colDimCount || (pair = this.getCellMemberKeyAndMetric(sortedDimList, rowDimList, colDimList, rowDimMemberList, colDimMemberList, multiAreaManager, this.spreadManager, this.modelCache, optType, calcParam)) == null) continue;
                    MembersKey membersKey = (MembersKey)pair.getLeft();
                    String metricType = (String)pair.getRight();
                    int relativeCol = multiAreaManager.getFloatonWhere() == 0 ? col + rowHeadDimsCount : col;
                    ECell cell = sheet.getECellNotAdd(relativeRow, relativeCol);
                    if (cell == null) {
                        cell = sheet.getECell(relativeRow, relativeCol);
                    }
                    BGCell bgCell = (BGCell)keyBGCellMap.get(membersKey);
                    Object newValue = null;
                    if (bgCell != null) {
                        newValue = bgCell.getValue();
                    }
                    newValue = this.getValueWithDataUnit(unit, metricType, newValue);
                    cell.setValue(newValue);
                    cell.setRow(cell.getRow() + rowStart);
                    cell.setCol(cell.getCol() + colStart);
                    this.packageCells(parameters, cell);
                }
            }
        }
        return parameters;
    }

    @Override
    public Pair<Map<String, String>, Map<String, Long>> getMemberAndViewMap(int row, int col) {
        Map pageViewDimMemberMap;
        Map colDimMem;
        AreaInfo areaInfo = this.spreadManager.getAreaInfoByRowCol(row, col);
        if (areaInfo == null || areaInfo.getRelativerow() < 0 || areaInfo.getRelativecol() < 0) {
            return null;
        }
        LinkedHashMap dimMemberMap = new LinkedHashMap();
        Map rowDimMem = areaInfo.getMultiAreaManager().getRowpartitionDimMemsByRow(areaInfo.getRelativerow());
        if (rowDimMem != null) {
            dimMemberMap.putAll(rowDimMem);
        }
        if ((colDimMem = areaInfo.getMultiAreaManager().getColpartitionDimMemsByCol(areaInfo.getRelativecol())) != null) {
            dimMemberMap.putAll(colDimMem);
        }
        if (MapUtils.isNotEmpty((Map)(pageViewDimMemberMap = areaInfo.getMultiAreaManager().getAreaPageViewDims()))) {
            for (Map.Entry entry : pageViewDimMemberMap.entrySet()) {
                dimMemberMap.put(entry.getKey(), new CellDimMember(((PageViewDimMember)entry.getValue()).isIsleaf(), ((PageViewDimMember)entry.getValue()).getNumber()));
            }
        }
        if (dimMemberMap.size() != this.templateModel.getRowcolDims().size()) {
            return null;
        }
        Map<String, String> rowColDimMap = dimMemberMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> {
            CellDimMember value1 = (CellDimMember)value.getValue();
            if (value1 == null) {
                return "";
            }
            return value1.getDimMemberNumber();
        }, (o1, o2) -> o2));
        HashMap<String, String> allDimMap = new HashMap<String, String>(rowColDimMap);
        Map allDimMembers = areaInfo.getMultiAreaManager().getEbSpreadManager().getAlldimensionWithMembers();
        for (Map.Entry entry : allDimMembers.entrySet()) {
            String dimNumber = (String)entry.getKey();
            if (rowColDimMap.containsKey(dimNumber)) continue;
            String memNumber = "";
            if (entry.getValue() != null && ((Set)entry.getValue()).size() > 0) {
                memNumber = (String)((Set)entry.getValue()).iterator().next();
            }
            allDimMap.put(dimNumber, memNumber);
        }
        this.fillMissDimensionInMap(allDimMap);
        String partition = areaInfo.getMultiAreaManager().getAreaIndex();
        Map viewMap = DimensionViewServiceHelper.getViewIds((Map)this.spreadManager.getDimemsionViews(), (String)partition);
        return Pair.of(allDimMap, (Object)viewMap);
    }

    @Override
    public Set<String> getRowDim(int row, int col) {
        AreaInfo areaInfo = this.spreadManager.getAreaInfoByRowCol(row, col);
        if (areaInfo == null || areaInfo.getRelativerow() < 0 || areaInfo.getRelativecol() < 0) {
            return null;
        }
        Map rowDimMem = areaInfo.getMultiAreaManager().getRowpartitionDimMemsByRow(areaInfo.getRelativerow());
        if (rowDimMem != null) {
            return rowDimMem.keySet();
        }
        return null;
    }
}

