/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.table;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TableMetaDim;
import kd.epm.eb.business.analysiscanvas.model.TableMetaMem;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.IVarService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.analysiscanvas.query.table.FuncColEnum;
import kd.epm.eb.business.analysiscanvas.query.table.TableCommandEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

class BaseDataService
extends AbstractDataService
implements IVarService {
    protected static final String TYPE_HIDE = "hide";
    protected static final String TYPE_ROW = "row";
    protected static final String TYPE_COL = "col";

    public BaseDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            try {
                TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
                long modelId = IDUtils.toLong((Object)tableModel.getModel());
                long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
                List<DimensionModel> tableOtherDims = tableModel.getDims();
                List<List<DimensionModel>> rowDimList = tableModel.getRowDim();
                List<List<DimensionModel>> colDimList = tableModel.getColDim();
                ArrayList<List<DimensionModel>> hideDimList = new ArrayList<List<DimensionModel>>(1);
                hideDimList.add(tableModel.getDims());
                JSONArray metaRowArr = new JSONArray();
                JSONArray metaColArr = new JSONArray();
                JSONArray metaHideArr = new JSONArray();
                ArrayList<Map<String, Long>> rowViewList = new ArrayList<Map<String, Long>>(rowDimList.size());
                ArrayList<Map<String, Long>> colViewList = new ArrayList<Map<String, Long>>(colDimList.size());
                ArrayList<Map<String, Set<String>>> rowQueryDimList = new ArrayList<Map<String, Set<String>>>(rowDimList.size());
                ArrayList<Map<String, Set<String>>> colQueryDimList = new ArrayList<Map<String, Set<String>>>(colDimList.size());
                this.buildRowMetaAndQuery((CustomItem)item, tableModel, rowDimList, (List<Map<String, Long>>)rowViewList, (List<Map<String, Set<String>>>)rowQueryDimList, metaRowArr, calcParam, filterDim);
                this.buildColMetaAndQuery((CustomItem)item, tableModel, colDimList, (List<Map<String, Long>>)colViewList, (List<Map<String, Set<String>>>)colQueryDimList, metaColArr, calcParam, filterDim);
                this.buildHideMetaAndQuery((CustomItem)item, tableModel, (List<List<DimensionModel>>)hideDimList, (List<Map<String, Long>>)new ArrayList<Map<String, Long>>(1), (List<Map<String, Set<String>>>)new ArrayList<Map<String, Set<String>>>(1), metaHideArr, calcParam, filterDim);
                for (int rowIndex = 0; rowIndex < rowQueryDimList.size(); ++rowIndex) {
                    Map rowViewMap = (Map)rowViewList.get(rowIndex);
                    Map rowQueryDim = (Map)rowQueryDimList.get(rowIndex);
                    this.setOtherDim(tableOtherDims, filterDim, rowQueryDim);
                    for (int colIndex = 0; colIndex < colQueryDimList.size(); ++colIndex) {
                        HashMap<String, Long> viewMap = new HashMap<String, Long>((Map)colViewList.get(colIndex));
                        HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>((Map)colQueryDimList.get(colIndex));
                        viewMap.putAll(rowViewMap);
                        queryDim.putAll(rowQueryDim);
                        this.checkRelQueryDim(optType, viewMap, modelCache, datasetId, calcParam);
                        this.fillActualMem(queryDim);
                        this.checkQueryDim(queryDim, viewMap, modelCache, datasetId);
                        QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                        QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
                    }
                }
                JSONObject meta = new JSONObject();
                meta.fluentPut("rows", (Object)metaRowArr).fluentPut("cols", (Object)metaColArr).fluentPut("hides", (Object)metaHideArr);
                tableModel.setMeta(meta);
                this.setCommand(tableModel, calcParam);
                ModelHelper.updateModel(item, tableModel);
            }
            catch (AnalysisCanvasException e) {
                item.setCode(e.getCode() != null ? e.getCode() : 1);
                item.setMsg(e.getMessage());
            }
        });
    }

    private void fillActualMem(Map<String, Set<String>> queryDim) {
        Set<String> bpMemSet = queryDim.get(SysDimensionEnum.BudgetPeriod.getNumber());
        HashSet<Object> realMemSet = new HashSet<Object>(bpMemSet.size());
        HashSet<String> removeMemSet = new HashSet<String>(bpMemSet.size());
        boolean needActual = false;
        for (String mem : bpMemSet) {
            Triple<String, String, FuncColEnum> funcColInfo;
            if (!mem.contains("@") || (funcColInfo = FuncColEnum.splitFuncColNumber(mem)) == null) continue;
            if (((FuncColEnum)((Object)funcColInfo.getRight())).isActual()) {
                needActual = true;
            }
            realMemSet.add(funcColInfo.getLeft());
            realMemSet.add(funcColInfo.getMiddle());
            removeMemSet.add(mem);
        }
        if (CollectionUtils.isNotEmpty(realMemSet)) {
            bpMemSet.removeAll(removeMemSet);
            bpMemSet.addAll(realMemSet);
        }
        if (needActual) {
            queryDim.get(SysDimensionEnum.DataType.getNumber()).add("Actual");
            queryDim.get(SysDimensionEnum.ChangeType.getNumber()).add("EBChanges");
            queryDim.get(SysDimensionEnum.Version.getNumber()).add("ACTUAL");
        }
    }

    protected void setCommand(TableModel tableModel, JSONObject calcParam) {
        tableModel.addCommand(TableCommandEnum.REBUILD, "");
    }

    protected void buildRowMetaAndQuery(CustomItem item, TableModel tableModel, List<List<DimensionModel>> rowDimList, List<Map<String, Long>> rowViewList, List<Map<String, Set<String>>> rowQueryDimList, JSONArray metaRowArr, JSONObject calcParam, Map<String, String> filterDim) {
        this.buildMetaAndQuery(item, tableModel, rowDimList, rowViewList, rowQueryDimList, metaRowArr, calcParam, filterDim, TYPE_ROW);
    }

    protected void buildColMetaAndQuery(CustomItem item, TableModel tableModel, List<List<DimensionModel>> colDimList, List<Map<String, Long>> colViewList, List<Map<String, Set<String>>> colQueryDimList, JSONArray metaColArr, JSONObject calcParam, Map<String, String> filterDim) {
        this.buildMetaAndQuery(item, tableModel, colDimList, colViewList, colQueryDimList, metaColArr, calcParam, filterDim, TYPE_COL);
    }

    protected void buildHideMetaAndQuery(CustomItem item, TableModel tableModel, List<List<DimensionModel>> hideDimList, List<Map<String, Long>> hideViewList, List<Map<String, Set<String>>> hideQueryDimList, JSONArray metaHideArr, JSONObject calcParam, Map<String, String> filterDim) {
        this.buildMetaAndQuery(item, tableModel, hideDimList, hideViewList, hideQueryDimList, metaHideArr, calcParam, filterDim, TYPE_HIDE);
    }

    protected void buildMetaAndQuery(CustomItem item, TableModel tableModel, List<List<DimensionModel>> dimList, List<Map<String, Long>> viewList, List<Map<String, Set<String>>> queryDimList, JSONArray metaArr, JSONObject calcParam, Map<String, String> filterDim, String type) {
        long modelId = IDUtils.toLong((Object)tableModel.getModel());
        long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        JSONObject dimensionViews = tableModel.getDimensionViews();
        List<DimensionModel> tableOtherDims = tableModel.getDims();
        for (int index = 0; index < dimList.size(); ++index) {
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews, tableOtherDims);
            viewList.add(viewMap);
            HashMap queryDim = new HashMap(20);
            queryDimList.add(queryDim);
            JSONArray metaDimArr = new JSONArray();
            for (DimensionModel dimModel : dimList.get(index)) {
                String dimNumber = dimModel.getDim();
                Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                long viewId = type.equals(TYPE_HIDE) ? ModelHelper.getViewId(dimNumber, dimensionViews) : ModelHelper.getViewId(dimNumber, dimensionViews, index);
                viewMap.put(dimNumber, viewId);
                HashSet<String> memberSet = new HashSet<String>(16);
                TableMetaDim tableMetaDim = new TableMetaDim().number(dimNumber).name(dimension.getName());
                if (dimModel.getS().booleanValue()) {
                    for (MemberModel memberModel : dimModel.getMems()) {
                        int queryScope = type.equals(TYPE_ROW) ? this.getMemberQueryScope(memberModel.getScope()) : memberModel.getScope().intValue();
                        List memberList = modelCache.getMemberSort(dimNumber, Long.valueOf(viewId), memberModel.getNum(), queryScope);
                        memberSet.addAll(memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                        memberList.forEach(member -> {
                            boolean hasNext = this.memberHasNext((Member)member, memberModel.getScope());
                            JSONObject metaMem = new TableMetaMem().number(member.getNumber()).name(member.getName()).isLeaf(member.isLeaf()).hasNext(hasNext).rootScope(memberModel.getScope()).dataType(this.getDataType(dimNumber, member.getNumber(), modelCache)).getJsonObj();
                            tableMetaDim.addMem(metaMem);
                        });
                    }
                } else {
                    String memNumber = filterDim.get(dimNumber);
                    memberSet.add(memNumber);
                    int scope = RangeEnum.ONLY.getIndex();
                    Member member2 = modelCache.getMember(dimNumber, Long.valueOf(viewId), memNumber);
                    boolean hasNext = this.memberHasNext(member2, scope);
                    JSONObject metaMem = new TableMetaMem().number(member2.getNumber()).name(member2.getName()).isLeaf(member2.isLeaf()).hasNext(hasNext).rootScope(scope).dataType(this.getDataType(dimNumber, member2.getNumber(), modelCache)).getJsonObj();
                    tableMetaDim.addMem(metaMem);
                }
                metaDimArr.add((Object)tableMetaDim.getJsonObj());
                queryDim.put(dimNumber, memberSet);
            }
            metaArr.add((Object)metaDimArr);
        }
    }

    protected String getDataType(String dimNumber, String memNumber, IModelCacheHelper modelCache) {
        String dataType = null;
        if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            Member metricMember = modelCache.getMember(dimNumber, null, memNumber);
            dataType = metricMember.getDatatype();
        }
        return dataType;
    }

    private int getMemberQueryScope(int scope) {
        int queryScope = RangeEnum.ONLY.getIndex() == scope || RangeEnum.DIRECTSUB_EXCLUDE.getIndex() == scope || RangeEnum.PEERS_EXCLUDE.getIndex() == scope || RangeEnum.PEERS.getIndex() == scope || RangeEnum.ALL_DETAIL.getIndex() == scope || RangeEnum.ALL_NOTDETAIL.getIndex() == scope ? scope : (RangeEnum.ALL_EXCLUDE.getIndex() == scope ? RangeEnum.DIRECTSUB_EXCLUDE.getIndex() : RangeEnum.ONLY.getIndex());
        return queryScope;
    }

    private boolean memberHasNext(Member member, int scope) {
        if (member.isLeaf()) {
            return false;
        }
        return RangeEnum.ONLY.getIndex() != scope && RangeEnum.DIRECTSUB_EXCLUDE.getIndex() != scope && RangeEnum.PEERS_EXCLUDE.getIndex() != scope && RangeEnum.PEERS.getIndex() != scope && RangeEnum.ALL_DETAIL.getIndex() != scope && RangeEnum.ALL_NOTDETAIL.getIndex() != scope;
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        itemList.forEach(item -> {
            if (!item.isSuccess()) {
                return;
            }
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            long modelId = IDUtils.toLong((Object)tableModel.getModel());
            long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
            JSONObject dimensionViews = tableModel.getDimensionViews();
            List<DimensionModel> tableOtherDims = tableModel.getDims();
            List<List<DimensionModel>> rowDimList = tableModel.getRowDim();
            List<List<DimensionModel>> colDimList = tableModel.getColDim();
            HashMap<MembersKey, BGCell> queryResult = new HashMap<MembersKey, BGCell>(256);
            for (int rowIndex = 0; rowIndex < rowDimList.size(); ++rowIndex) {
                Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews, tableOtherDims);
                for (DimensionModel dimensionModel : rowDimList.get(rowIndex)) {
                    String dimNumber = dimensionModel.getDim();
                    long viewId = ModelHelper.getViewId(dimNumber, dimensionViews, rowIndex);
                    viewMap.put(dimNumber, viewId);
                }
                for (int colIndex = 0; colIndex < colDimList.size(); ++colIndex) {
                    for (DimensionModel dimModel2 : colDimList.get(colIndex)) {
                        String dimNumber = dimModel2.getDim();
                        long viewId = ModelHelper.getViewId(dimNumber, dimensionViews, colIndex);
                        viewMap.put(dimNumber, viewId);
                    }
                    QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, dtoList);
                    if (!MapUtils.isNotEmpty(queryDto.getQueryResult())) continue;
                    queryResult.putAll(queryDto.getQueryResult());
                }
            }
            Map<String, String> fixMemberMap = this.genFixMemberMap(tableModel.getDims(), filterDim);
            this.buildRespData(tableModel, queryResult, fixMemberMap, optType, calcParam);
            ModelHelper.updateModel(item, tableModel);
        });
    }

    private void buildRespData(TableModel tableModel, Map<MembersKey, BGCell> queryResult, Map<String, String> fixMemberMap, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        long modelId = IDUtils.toLong((Object)tableModel.getModel());
        long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(Long.valueOf(datasetId));
        List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        JSONObject originMetaObj = tableModel.getMeta();
        JSONObject metaObj = JSON.parseObject((String)originMetaObj.toJSONString());
        JSONArray rowArr = metaObj.getJSONArray("rows");
        JSONArray colArr = metaObj.getJSONArray("cols");
        if (AnalysisCanvasConstants.OptType.EXPAND == optType && TYPE_ROW.equals(calcParam.getString("type"))) {
            JSONObject cell = calcParam.getJSONObject("cell");
            String expandDim = cell.getString("colKey");
            String expandMem = cell.getString("num");
            JSONArray metaArr = rowArr.getJSONArray(0);
            for (int i = 0; i < metaArr.size(); ++i) {
                JSONObject obj = metaArr.getJSONObject(i);
                TableMetaDim tableMetaDim = (TableMetaDim)obj.toJavaObject(TableMetaDim.class);
                if (!tableMetaDim.getDim().equals(expandDim)) continue;
                JSONObject metaMem = new TableMetaMem().number(expandMem).getJsonObj();
                tableMetaDim.addMem(metaMem);
                break;
            }
        }
        List<List<String>> rowMemNumList = this.buildMetaMemberNumList(rowArr);
        List<List<String>> colMemNumList = this.buildMetaMemberNumList(colArr);
        List rowDimList = tableModel.getRowDim().get(0).stream().map(DimensionModel::getDim).collect(Collectors.toList());
        List colDimList = tableModel.getColDim().get(0).stream().map(DimensionModel::getDim).collect(Collectors.toList());
        Object[] hideNumKeys = fixMemberMap.values().toArray(new Object[0]);
        this.setRelQueryFixMember(optType, fixMemberMap, calcParam);
        JSONObject respDataMap = new JSONObject();
        rowMemNumList.forEach(rowMemList -> {
            HashMap<String, String> queryCellMap = new HashMap<String, String>(fixMemberMap);
            for (int i = 0; i < rowDimList.size(); ++i) {
                String rowDim = (String)rowDimList.get(i);
                String rowMem = (String)rowMemList.get(i);
                queryCellMap.put(rowDim, rowMem);
            }
            Object[] rowNumKeys = rowMemList.toArray(new Object[0]);
            colMemNumList.forEach(colMemList -> {
                Triple<String, String, FuncColEnum> funcColInfo = null;
                for (int i = 0; i < colDimList.size(); ++i) {
                    String colDim = (String)colDimList.get(i);
                    String colMem = (String)colMemList.get(i);
                    if (colMem.contains("@")) {
                        funcColInfo = FuncColEnum.splitFuncColNumber(colMem);
                    }
                    queryCellMap.put(colDim, colMem);
                }
                Object cellValue = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult, null, funcColInfo);
                if (cellValue != null) {
                    Object[] colNumKeys = colMemList.toArray(new Object[0]);
                    Object[] memNumKeys = new Object[rowNumKeys.length + colNumKeys.length + hideNumKeys.length];
                    System.arraycopy(rowNumKeys, 0, memNumKeys, 0, rowNumKeys.length);
                    System.arraycopy(colNumKeys, 0, memNumKeys, rowNumKeys.length, colNumKeys.length);
                    System.arraycopy(hideNumKeys, 0, memNumKeys, rowNumKeys.length + colNumKeys.length, hideNumKeys.length);
                    respDataMap.put(Arrays.stream(memNumKeys).map(Object::toString).collect(Collectors.joining("#")), (Object)cellValue.toString());
                }
            });
        });
        tableModel.setData(respDataMap);
    }

    protected Object getCellValue(IModelCacheHelper modelCache, Map<String, String> queryCellMap, List<String> sortedDimList, Map<MembersKey, BGCell> queryResult, Object defaultValue, Triple<String, String, FuncColEnum> funcColInfo) {
        if (funcColInfo == null) {
            return super.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult, defaultValue);
        }
        HashMap<String, String> funcQueryCellMap = new HashMap<String, String>(queryCellMap);
        funcQueryCellMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), (String)funcColInfo.getLeft());
        Object cellValue = super.getCellValue(modelCache, funcQueryCellMap, sortedDimList, queryResult, defaultValue);
        FuncColEnum funcColEnum = (FuncColEnum)((Object)funcColInfo.getRight());
        if (FuncColEnum.Y2Y_ACTUAL == funcColEnum || FuncColEnum.M2M_ACTUAL == funcColEnum || FuncColEnum.Y2Y_ACTUAL_RATE == funcColEnum || FuncColEnum.M2M_ACTUAL_RATE == funcColEnum) {
            funcQueryCellMap.put(SysDimensionEnum.DataType.getNumber(), "Actual");
            funcQueryCellMap.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
            String ctMemNum = (String)funcQueryCellMap.get(SysDimensionEnum.ChangeType.getNumber());
            List ctMemList = modelCache.getMember(SysDimensionEnum.ChangeType.getNumber(), null, "EBChanges", RangeEnum.ALL.getIndex());
            Set ctMemNumSet = ctMemList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            if (!ctMemNumSet.contains(ctMemNum)) {
                funcQueryCellMap.put(SysDimensionEnum.ChangeType.getNumber(), "EBChanges");
            }
        }
        funcQueryCellMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), (String)funcColInfo.getMiddle());
        Object lastCellValue = super.getCellValue(modelCache, funcQueryCellMap, sortedDimList, queryResult, defaultValue);
        BigDecimal cellVal = null;
        BigDecimal lastCellVal = null;
        if (cellValue != null) {
            cellVal = new BigDecimal(cellValue.toString());
        }
        if (lastCellValue != null) {
            lastCellVal = new BigDecimal(lastCellValue.toString());
        }
        BigDecimal funcColVal = null;
        switch ((FuncColEnum)((Object)funcColInfo.getRight())) {
            case Y2Y: 
            case M2M: 
            case Y2Y_ACTUAL: 
            case M2M_ACTUAL: {
                if (cellVal == null) break;
                if (lastCellVal == null) {
                    lastCellVal = new BigDecimal(0);
                }
                funcColVal = cellVal.subtract(lastCellVal);
                break;
            }
            case Y2Y_RATE: 
            case M2M_RATE: 
            case Y2Y_ACTUAL_RATE: 
            case M2M_ACTUAL_RATE: {
                BigDecimal zero;
                if (cellVal == null || lastCellVal == null || lastCellVal.compareTo(zero = new BigDecimal(0)) == 0) break;
                funcColVal = cellVal.subtract(lastCellVal).divide(lastCellVal, 4, RoundingMode.HALF_UP);
            }
        }
        return funcColVal;
    }

    private List<List<String>> buildMetaMemberNumList(JSONArray rowArr) {
        ArrayList<List<String>> rowDimMemNumList = new ArrayList<List<String>>(256);
        rowArr.forEach(metaDimArrObj -> {
            JSONArray metaDimArr = (JSONArray)metaDimArrObj;
            ArrayList dimMemNumList = new ArrayList(metaDimArr.size());
            metaDimArr.forEach(metaDimObj -> {
                JSONObject metaDim = (JSONObject)metaDimObj;
                JSONArray memArr = metaDim.getJSONArray("mems");
                List memNumList = memArr.stream().map(memObj -> {
                    JSONObject memInfo = (JSONObject)memObj;
                    return memInfo.getString("k");
                }).collect(Collectors.toList());
                dimMemNumList.add(memNumList);
            });
            rowDimMemNumList.addAll(Lists.cartesianProduct(dimMemNumList));
        });
        return rowDimMemNumList;
    }

    @Override
    public void processChangeMember(List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers) {
        itemList.forEach(item -> {
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            this.processItemChangeMember(item.getId(), tableModel, filterItemList, calcChangeMembers);
            ModelHelper.updateModel(item, tableModel);
        });
    }

    private void processItemChangeMember(String itemId, TableModel tableModel, List<CustomItem> filterItemList, Map<String, ValueDto> totalChangeMembers) {
        if (MapUtils.isEmpty(tableModel.getChangeCells())) {
            return;
        }
        Long modelId = IDUtils.toLong((Object)tableModel.getModel());
        Long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        List rowColDimList = tableModel.getRowDim().get(0).stream().map(DimensionModel::getDim).collect(Collectors.toList());
        rowColDimList.addAll(tableModel.getColDim().get(0).stream().map(DimensionModel::getDim).collect(Collectors.toList()));
        rowColDimList.addAll(tableModel.getDims().stream().map(DimensionModel::getDim).collect(Collectors.toList()));
        HashMap queryDim = new HashMap(20);
        HashMap<MembersKey, ValueDto> currChangeMap = new HashMap<MembersKey, ValueDto>(16);
        tableModel.getChangeCells().forEach((key, changeValStr) -> {
            if (changeValStr == null) {
                return;
            }
            Object[] pair = this.splitChangeObj(changeValStr);
            Object changeValue = pair[0];
            long changeTime = pair[1] == null ? 0L : Long.parseLong(pair[1].toString());
            int rowGroup = Integer.parseInt(pair[2].toString()) - 1;
            int colGroup = Integer.parseInt(pair[3].toString()) - 1;
            Map<String, Long> viewMap = this.getViewMap(tableModel, rowGroup, colGroup);
            LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>(allDims.size());
            String[] memNumArr = key.split("#");
            if (memNumArr.length != rowColDimList.size()) {
                return;
            }
            for (int i = 0; i < rowColDimList.size(); ++i) {
                memberMap.put((String)rowColDimList.get(i), memNumArr[i]);
            }
            for (Dimension dim : allDims) {
                String dimNumber2 = dim.getNumber();
                if (memberMap.containsKey(dimNumber2)) continue;
                Dimension dimension = modelCache.getDimension(dimNumber2);
                memberMap.put(dimNumber2, dimension.getNoneNumber());
            }
            RuleDto ruleDto = AnalysisCanvasUtils.getCellRule(modelId, datasetId, viewMap, memberMap);
            if (ruleDto != null) {
                return;
            }
            String metricType = ModelHelper.getMetricType(memberMap, modelCache);
            if (!MetricDataTypeEnum.isNumber((String)metricType)) {
                return;
            }
            for (Map.Entry entry : memberMap.entrySet()) {
                String dimNumber3 = (String)entry.getKey();
                String memNumber2 = (String)entry.getValue();
                Long viewId = viewMap.get(dimNumber3);
                Member realMember = modelCache.getMember(dimNumber3, viewId, memNumber2);
                if (realMember != null && realMember.isLeaf()) continue;
                return;
            }
            memberMap.forEach((dimNumber, memNumber) -> {
                Set queryMemSet = queryDim.computeIfAbsent(dimNumber, v -> new HashSet(8));
                queryMemSet.add(memNumber);
            });
            MembersKey membersKey = this.transToMembersKey(memberMap, sortedDimList, modelCache);
            ValueDto valueDto = (ValueDto)totalChangeMembers.get(this.getMemberKeyStr(membersKey.getKeys()));
            if (valueDto != null && valueDto.getT() != null && changeTime < valueDto.getT()) {
                return;
            }
            currChangeMap.put(membersKey, new ValueDto(changeValue, changeTime, ModelHelper.getViewMap(viewMap, sortedDimList, modelCache, datasetId)));
        });
        Map<MembersKey, ValueDto> changeMap = this.filterPermWrite(datasetId, currChangeMap, modelCache, sortedDimList);
        if (MapUtils.isNotEmpty(changeMap)) {
            changeMap.forEach((key, value) -> totalChangeMembers.put(this.getMemberKeyStr(key.getKeys()), (ValueDto)value));
            List<Map<String, Object>> changeMembers = this.mergeChangeMembers(changeMap, sortedDimList, tableModel.getChangeMembers(), modelCache);
            tableModel.setChangeMembers(changeMembers);
        }
        if (CollectionUtils.isNotEmpty(tableModel.getChangeMembers())) {
            tableModel.getChangeMembers().forEach(memberMap -> {
                MembersKey membersKey = this.transToMembersKey((Map<String, ?>)memberMap, sortedDimList, modelCache);
                if (!changeMap.containsKey(membersKey)) {
                    if (totalChangeMembers.containsKey(this.getMemberKeyStr(membersKey.getKeys()))) {
                        return;
                    }
                    changeMap.put(membersKey, new ValueDto(memberMap.get("_v"), Long.parseLong(((Object)memberMap.getOrDefault("_t", 0L)).toString()), ModelHelper.getViewMap((String)memberMap.get("_vw"), sortedDimList, modelCache, datasetId)));
                    for (Dimension dim : allDims) {
                        String dimNumber = dim.getNumber();
                        Object memNumber = memberMap.get(dimNumber);
                        if (memNumber == null) {
                            Dimension dimension = modelCache.getDimension(dimNumber);
                            memNumber = dimension.getNoneNumber();
                        }
                        Set queryMemSet = queryDim.computeIfAbsent(dimNumber, s -> new HashSet(8));
                        queryMemSet.add(memNumber.toString());
                    }
                }
            });
        }
        if (MapUtils.isEmpty(changeMap)) {
            return;
        }
        Map<Long, Pair<List<BGCell>, Map<String, Long>>> changeCells = this.buildChangeCell(changeMap, sortedDimList);
        if (MapUtils.isEmpty(changeCells)) {
            return;
        }
        AnalysisCanvasDataset canvasDataset = this.getAnalysisCubeId(this.canvasBox.getCanvasId(), this.canvasBox.getId(), datasetId);
        changeCells.forEach((key, pair) -> this.saveToSandboxAndExecuteRuleChain(modelId, datasetId, canvasDataset, (List)pair.getLeft(), (Map)pair.getRight()));
    }

    private Map<String, Long> getViewMap(TableModel tableModel, int rowGroup, int colGroup) {
        HashMap<String, Long> viewMap = new HashMap<String, Long>(16);
        JSONObject dimensionViews = tableModel.getDimensionViews();
        List<DimensionModel> tableOtherDims = tableModel.getDims();
        viewMap.putAll(ModelHelper.getViewMap(dimensionViews, tableOtherDims));
        List<List<DimensionModel>> rowDim = tableModel.getRowDim();
        List<List<DimensionModel>> colDim = tableModel.getColDim();
        this.getViewByGroup(rowDim, dimensionViews, rowGroup, viewMap);
        this.getViewByGroup(colDim, dimensionViews, colGroup, viewMap);
        return viewMap;
    }

    private void getViewByGroup(List<List<DimensionModel>> dims, JSONObject dimensionViews, int group, Map<String, Long> viewMap) {
        if (CollectionUtils.isNotEmpty(dims)) {
            List<DimensionModel> dimModels = dims.get(0);
            for (DimensionModel dimModel : dimModels) {
                String dimNumber = dimModel.getDim();
                long viewId = ModelHelper.getViewId(dimNumber, dimensionViews, group);
                viewMap.put(dimNumber, viewId);
            }
        }
    }

    @Override
    public List<SaveDto> getCoverData(List<CustomItem> itemList, List<CustomItem> filterItemList) {
        ArrayList<SaveDto> saveDtoList = new ArrayList<SaveDto>(4);
        itemList.forEach(item -> {
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            this.buildCoverData(tableModel.getModel(), tableModel.getDataset(), tableModel.getChangeMembers(), saveDtoList);
        });
        return saveDtoList;
    }
}

