/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TableMetaDim;
import kd.epm.eb.business.analysiscanvas.model.TableMetaMem;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.query.table.BaseDataService;
import kd.epm.eb.business.analysiscanvas.query.table.FuncColEnum;
import kd.epm.eb.business.analysiscanvas.query.table.TableCommandEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.DataTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

class CalcTableDataService
extends BaseDataService {
    public CalcTableDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    protected void setCommand(TableModel tableModel, JSONObject calcParam) {
        tableModel.addCommand(TableCommandEnum.UPDATE_CELL_VAL, "");
    }

    @Override
    protected void buildRowMetaAndQuery(CustomItem item, TableModel tableModel, List<List<DimensionModel>> rowDimList, List<Map<String, Long>> rowViewList, List<Map<String, Set<String>>> rowQueryDimList, JSONArray metaRowArr, JSONObject calcParam, Map<String, String> filterDim) {
        this.buildQueryByPage(item, tableModel, rowViewList, rowQueryDimList, metaRowArr, "row");
    }

    @Override
    protected void buildColMetaAndQuery(CustomItem item, TableModel tableModel, List<List<DimensionModel>> colDimList, List<Map<String, Long>> colViewList, List<Map<String, Set<String>>> colQueryDimList, JSONArray metaColArr, JSONObject calcParam, Map<String, String> filterDim) {
        this.buildQueryByPage(item, tableModel, colViewList, colQueryDimList, metaColArr, "col");
    }

    private void buildQueryByPage(CustomItem item, TableModel tableModel, List<Map<String, Long>> viewList, List<Map<String, Set<String>>> queryDimList, JSONArray metaArr, String type) {
        JSONArray pageKeyList;
        List dimList;
        if (tableModel.getReqParam() == null) {
            return;
        }
        long modelId = IDUtils.toLong((Object)tableModel.getModel());
        long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        JSONObject dimensionViews = tableModel.getDimensionViews();
        List<DimensionModel> tableOtherDims = tableModel.getDims();
        if ("row".equals(type)) {
            dimList = tableModel.getRowDim().get(0).stream().map(DimensionModel::getDim).collect(Collectors.toList());
            pageKeyList = tableModel.getReqParam().getJSONObject("rowColKey").getJSONArray("row");
        } else {
            dimList = tableModel.getColDim().get(0).stream().map(DimensionModel::getDim).collect(Collectors.toList());
            pageKeyList = tableModel.getReqParam().getJSONObject("rowColKey").getJSONArray("col");
        }
        pageKeyList.forEach(key -> {
            if (!key.toString().contains("#")) {
                return;
            }
            String[] keyArr = key.toString().split("#");
            if (!this.checkKeyArrLength(keyArr, dimList, type)) {
                return;
            }
            int groupIndex = "row".equals(type) ? Integer.parseInt(keyArr[0].split("_")[0]) : Integer.parseInt(keyArr[0]);
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews, tableOtherDims);
            viewList.add(viewMap);
            HashMap<String, HashSet> queryDim = new HashMap<String, HashSet>(20);
            queryDimList.add(queryDim);
            JSONArray metaDimArr = new JSONArray();
            for (int i = 0; i < dimList.size(); ++i) {
                String dimNumber = (String)dimList.get(i);
                Pair<String, String> pair = this.getMemNumber(dimNumber, keyArr, i, type, dimList.size());
                if (pair == null) continue;
                String memNumber = (String)pair.getLeft();
                String metaMemNumber = (String)pair.getRight();
                queryDim.put(dimNumber, Sets.newHashSet((Object[])new String[]{metaMemNumber}));
                long viewId = ModelHelper.getViewId(dimNumber, dimensionViews, groupIndex - 1);
                viewMap.put(dimNumber, viewId);
                Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                TableMetaDim tableMetaDim = new TableMetaDim().number(dimNumber).name(dimension.getName());
                Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                TableMetaMem tableMetaMem = new TableMetaMem().number(metaMemNumber).name(member.getName()).dataType(this.getDataType(dimNumber, memNumber, modelCache));
                this.setFuncColDataType(metaMemNumber, tableMetaMem);
                tableMetaDim.addMem(tableMetaMem.getJsonObj());
                metaDimArr.add((Object)tableMetaDim.getJsonObj());
            }
            metaArr.add((Object)metaDimArr);
        });
    }

    private void setFuncColDataType(String metaMemNumber, TableMetaMem tableMetaMem) {
        if (metaMemNumber.contains("@")) {
            Triple<String, String, FuncColEnum> funcColInfo = FuncColEnum.splitFuncColNumber(metaMemNumber);
            if (funcColInfo == null) {
                return;
            }
            FuncColEnum funcColEnum = (FuncColEnum)((Object)funcColInfo.getRight());
            if (FuncColEnum.Y2Y_RATE == funcColEnum || FuncColEnum.M2M_RATE == funcColEnum || FuncColEnum.Y2Y_ACTUAL_RATE == funcColEnum || FuncColEnum.M2M_ACTUAL_RATE == funcColEnum) {
                tableMetaMem.dataType(DataTypeEnum.PROPORTION.getOIndex());
            }
        }
    }

    private boolean checkKeyArrLength(String[] keyArr, List<String> dimList, String type) {
        if ("row".equals(type)) {
            return keyArr.length == dimList.size() + 1;
        }
        return keyArr.length >= dimList.size() * 2;
    }

    private Pair<String, String> getMemNumber(String dimNumber, String[] keyArr, int index, String type, int dimSize) {
        if ("row".equals(type)) {
            return Pair.of((Object)keyArr[index + 1], (Object)keyArr[index + 1]);
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && keyArr.length > dimSize * 2) {
            String funcColNumber = keyArr[keyArr.length - 1];
            Triple<String, String, FuncColEnum> triple = FuncColEnum.splitFuncColNumber(funcColNumber);
            if (triple != null) {
                return Pair.of((Object)triple.getMiddle(), (Object)funcColNumber);
            }
            return null;
        }
        return Pair.of((Object)keyArr[2 * index + 1], (Object)keyArr[2 * index + 1]);
    }
}

