/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TableMetaDim;
import kd.epm.eb.business.analysiscanvas.model.TableMetaMem;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.query.table.CalcTableDataService;
import kd.epm.eb.business.analysiscanvas.query.table.FuncColEnum;
import kd.epm.eb.business.analysiscanvas.query.table.TableCommandEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.DataTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang3.tuple.Pair;

class ColAppendDataService
extends CalcTableDataService {
    public ColAppendDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    protected void setCommand(TableModel tableModel, JSONObject calcParam) {
        tableModel.addCommand(TableCommandEnum.COL_APPEND, calcParam);
    }

    @Override
    protected void buildColMetaAndQuery(CustomItem item, TableModel tableModel, List<List<DimensionModel>> colDimList, List<Map<String, Long>> colViewList, List<Map<String, Set<String>>> colQueryDimList, JSONArray metaColArr, JSONObject calcParam, Map<String, String> filterDim) {
        super.buildColMetaAndQuery(item, tableModel, colDimList, colViewList, colQueryDimList, metaColArr, calcParam, filterDim);
        this.buildQueryByPageCol(item, tableModel, colViewList, colQueryDimList, metaColArr, calcParam);
    }

    private void buildQueryByPageCol(CustomItem item, TableModel tableModel, List<Map<String, Long>> viewList, List<Map<String, Set<String>>> queryDimList, JSONArray metaArr, JSONObject calcParam) {
        int dataIndex;
        long modelId = IDUtils.toLong((Object)tableModel.getModel());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        JSONObject cell = calcParam.getJSONObject("cell");
        String colKey = cell.getString("colKey");
        String[] colKeyArr = colKey.split("#");
        int groupIndex = Integer.parseInt(colKeyArr[0]) - 1;
        ArrayList<String> memKeyList = new ArrayList<String>(colKeyArr.length);
        for (int i = 1; i < colKeyArr.length; i += 2) {
            memKeyList.add(colKeyArr[i]);
        }
        String memKey = String.join((CharSequence)"#", memKeyList);
        List<List<DimensionModel>> colDimList = tableModel.getColDim();
        List<DimensionModel> dimModelList = colDimList.get(groupIndex);
        List<String> dimNumberList = dimModelList.stream().map(DimensionModel::getDim).collect(Collectors.toList());
        for (dataIndex = 0; dataIndex < queryDimList.size(); ++dataIndex) {
            Map<String, Set<String>> dimMemMap = queryDimList.get(dataIndex);
            ArrayList<String> queryMemKeyList = new ArrayList<String>(colKeyArr.length);
            for (DimensionModel dimModel : dimModelList) {
                Set<String> memSet = dimMemMap.get(dimModel.getDim());
                queryMemKeyList.add(memSet.iterator().next());
            }
            if (memKey.equals(String.join((CharSequence)"#", queryMemKeyList))) break;
        }
        Map<String, Long> viewMap = viewList.get(dataIndex);
        Map<String, Set<String>> queryDim = queryDimList.get(dataIndex);
        JSONArray metaDimArr = metaArr.getJSONArray(dataIndex);
        String expandType = calcParam.getString("type");
        FuncColEnum funcColEnum = FuncColEnum.find(expandType);
        Pair<Integer, TableMetaMem> pair = this.getFunctionMetaMem(item, cell, dimNumberList, modelCache, viewMap, funcColEnum);
        int bpIndex = (Integer)pair.getLeft();
        TableMetaMem tableMetaMem = (TableMetaMem)pair.getRight();
        String funcColNumber = tableMetaMem.getNumber();
        Set<String> bpMemNumberSet = queryDim.get(SysDimensionEnum.BudgetPeriod.getNumber());
        bpMemNumberSet.add(funcColNumber);
        TableMetaDim tableMetaDim = (TableMetaDim)metaDimArr.getObject(bpIndex, TableMetaDim.class);
        tableMetaDim.getMems().add(0, (Object)tableMetaMem.getJsonObj());
        metaDimArr.remove(bpIndex);
        metaDimArr.add(bpIndex, (Object)tableMetaDim.getJsonObj());
        viewList.clear();
        queryDimList.clear();
        metaArr.clear();
        viewList.add(viewMap);
        queryDimList.add(queryDim);
        metaArr.add((Object)metaDimArr);
    }

    private Pair<Integer, TableMetaMem> getFunctionMetaMem(CustomItem item, JSONObject cell, List<String> dimNumberList, IModelCacheHelper modelCache, Map<String, Long> viewMap, FuncColEnum funcColEnum) {
        Member funcMember;
        int bpIndex;
        for (bpIndex = 0; bpIndex < dimNumberList.size(); ++bpIndex) {
            String dimNumber = dimNumberList.get(bpIndex);
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) break;
        }
        String[] colKeyArr = cell.getString("colKey").split("#");
        if (bpIndex >= dimNumberList.size() || colKeyArr.length != dimNumberList.size() * 2) {
            throw new AnalysisCanvasException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u671f\u95f4\u5217\u6216\u671f\u95f4\u5217\u4f4d\u7f6e\u5df2\u6539\u53d8\uff0c\u8bf7\u5173\u95ed\u91cd\u65b0\u6253\u5f00\u753b\u5e03\u3002", (String)"AnalysisService_25", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        String memNumber = colKeyArr[2 * bpIndex + 1];
        int offset = funcColEnum.getOffset();
        if (FuncColEnum.Y2Y_RATE == funcColEnum || FuncColEnum.Y2Y == funcColEnum || FuncColEnum.Y2Y_ACTUAL_RATE == funcColEnum || FuncColEnum.Y2Y_ACTUAL == funcColEnum) {
            if (memNumber.contains("HF")) {
                offset = 2;
            } else if (memNumber.contains("Q")) {
                offset = 4;
            }
        }
        if ((funcMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), memNumber, -offset)) == null) {
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u7cfb\u7edf\u4e2d\u65e0 %1 \u4e0a\u5e74\u540c\u671f/\u4e0a\u671f\u6210\u5458\uff0c\u8bf7\u589e\u52a0\u540e\u518d\u914d\u7f6e\u51fd\u6570\u5217\u3002", (String)"AnalysisService_26", (String)"epm-eb-business", (Object[])new Object[]{memNumber}), 2);
        }
        String lastMemNumber = colKeyArr[colKeyArr.length - 1];
        String lastDimNumber = dimNumberList.get(dimNumberList.size() - 1);
        Long lastDimViewId = viewMap.get(lastDimNumber);
        Member lastMember = ModelHelper.getMember(item.getName(), modelCache, lastDimNumber, lastDimViewId, lastMemNumber);
        String funcColNumber = funcColEnum.getFuncColNumber(memNumber, funcMember.getNumber());
        TableMetaMem metaMem = new TableMetaMem().number(funcColNumber).name(lastMember.getName() + "(" + funcColEnum.getLabel() + ")").isLeaf(cell.getBoolean("leaf")).hasNext(cell.getBoolean("next")).rootScope(cell.getInteger("rs"));
        if (FuncColEnum.Y2Y_RATE == funcColEnum || FuncColEnum.M2M_RATE == funcColEnum || FuncColEnum.Y2Y_ACTUAL_RATE == funcColEnum || FuncColEnum.M2M_ACTUAL_RATE == funcColEnum) {
            metaMem.dataType(DataTypeEnum.PROPORTION.getOIndex());
        }
        return Pair.of((Object)bpIndex, (Object)metaMem);
    }
}

