/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.table;

import java.util.Arrays;
import java.util.Optional;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import org.apache.commons.lang3.tuple.Triple;

public enum FuncColEnum {
    Y2Y(12, FuncColEnum.getLabelY2Y()),
    M2M(1, FuncColEnum.getLabelM2M()),
    Y2Y_RATE(12, FuncColEnum.getLabelY2Y_RATE()),
    M2M_RATE(1, FuncColEnum.getLabelM2M_RATE()),
    Y2Y_ACTUAL(12, FuncColEnum.getLabelY2Y_ACTUAL()),
    M2M_ACTUAL(1, FuncColEnum.getLabelM2M_ACTUAL()),
    Y2Y_ACTUAL_RATE(12, FuncColEnum.getLabelY2Y_ACTUAL_RATE()),
    M2M_ACTUAL_RATE(1, FuncColEnum.getLabelM2M_ACTUAL_RATE());

    int offset;
    MultiLangEnumBridge label;

    private FuncColEnum(int offset, MultiLangEnumBridge label) {
        this.offset = offset;
        this.label = label;
    }

    private static MultiLangEnumBridge getLabelY2Y() {
        return new MultiLangEnumBridge("\u540c\u6bd4\u589e\u957f", "AnalysisCanvasFuncCol_1", "epm-eb-business");
    }

    private static MultiLangEnumBridge getLabelM2M() {
        return new MultiLangEnumBridge("\u73af\u6bd4\u589e\u957f", "AnalysisCanvasFuncCol_2", "epm-eb-business");
    }

    private static MultiLangEnumBridge getLabelY2Y_RATE() {
        return new MultiLangEnumBridge("\u540c\u6bd4\u589e\u957f\u7387", "AnalysisCanvasFuncCol_3", "epm-eb-business");
    }

    private static MultiLangEnumBridge getLabelM2M_RATE() {
        return new MultiLangEnumBridge("\u73af\u6bd4\u589e\u957f\u7387", "AnalysisCanvasFuncCol_4", "epm-eb-business");
    }

    private static MultiLangEnumBridge getLabelY2Y_ACTUAL() {
        return new MultiLangEnumBridge("\u540c\u6bd4\u5b9e\u9645\u589e\u957f", "AnalysisCanvasFuncCol_5", "epm-eb-business");
    }

    private static MultiLangEnumBridge getLabelM2M_ACTUAL() {
        return new MultiLangEnumBridge("\u73af\u6bd4\u5b9e\u9645\u589e\u957f", "AnalysisCanvasFuncCol_6", "epm-eb-business");
    }

    private static MultiLangEnumBridge getLabelY2Y_ACTUAL_RATE() {
        return new MultiLangEnumBridge("\u540c\u6bd4\u5b9e\u9645\u589e\u957f\u7387", "AnalysisCanvasFuncCol_7", "epm-eb-business");
    }

    private static MultiLangEnumBridge getLabelM2M_ACTUAL_RATE() {
        return new MultiLangEnumBridge("\u73af\u6bd4\u5b9e\u9645\u589e\u957f\u7387", "AnalysisCanvasFuncCol_8", "epm-eb-business");
    }

    public int getOffset() {
        return this.offset;
    }

    public String getLabel() {
        return this.label.loadKDString();
    }

    public String getFuncColNumber(String memNumber1, String memNumber2) {
        return memNumber1 + "@" + memNumber2 + "@" + this.name();
    }

    public static Triple<String, String, FuncColEnum> splitFuncColNumber(String number) {
        String[] arr = number.split("@");
        if (arr.length != 3) {
            return null;
        }
        return Triple.of((Object)arr[0], (Object)arr[1], (Object)((Object)FuncColEnum.find(arr[2])));
    }

    public static FuncColEnum find(String type) {
        Optional<FuncColEnum> optional = Arrays.stream(FuncColEnum.values()).filter(k -> k.name().equals(type)).findFirst();
        return optional.orElse(null);
    }

    public boolean isActual() {
        return this == Y2Y_ACTUAL || this == M2M_ACTUAL || this == Y2Y_ACTUAL_RATE || this == M2M_ACTUAL_RATE;
    }
}

