/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TableMetaDim;
import kd.epm.eb.business.analysiscanvas.model.TableMetaMem;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.query.table.CalcTableDataService;
import kd.epm.eb.business.analysiscanvas.query.table.TableCommandEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.IDUtils;

class RowExpandDataService
extends CalcTableDataService {
    public RowExpandDataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    protected void setCommand(TableModel tableModel, JSONObject calcParam) {
        tableModel.addCommand(TableCommandEnum.ROW_EXPAND, calcParam);
        tableModel.addCommand(TableCommandEnum.UPDATE_PART_CELL_VAL, calcParam);
    }

    @Override
    protected void buildRowMetaAndQuery(CustomItem item, TableModel tableModel, List<List<DimensionModel>> dimList, List<Map<String, Long>> viewList, List<Map<String, Set<String>>> queryDimList, JSONArray metaArr, JSONObject calcParam, Map<String, String> filterDim) {
        long modelId = IDUtils.toLong((Object)tableModel.getModel());
        long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        JSONObject dimensionViews = tableModel.getDimensionViews();
        List<DimensionModel> tableOtherDims = tableModel.getDims();
        Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews, tableOtherDims);
        viewList.add(viewMap);
        HashMap queryDim = new HashMap(20);
        queryDimList.add(queryDim);
        JSONObject cell = calcParam.getJSONObject("cell");
        JSONObject dimInfo = calcParam.getJSONObject("dimInfo");
        String cellKey = cell.getString("cellKey");
        String expandDim = cell.getString("colKey");
        String expandMem = cell.getString("num");
        int rootScope = cell.getInteger("rs");
        int groupIndex = Integer.parseInt(cellKey.split("#")[0].split("_")[0]) - 1;
        List<DimensionModel> dimModelList = dimList.get(groupIndex);
        JSONArray metaDimArr = new JSONArray();
        for (DimensionModel dimModel : dimModelList) {
            String dimNumber = dimModel.getDim();
            Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
            long viewId = ModelHelper.getViewId(dimNumber, dimensionViews, groupIndex);
            viewMap.put(dimNumber, viewId);
            HashSet<String> memberSet = new HashSet<String>(16);
            TableMetaDim tableMetaDim = new TableMetaDim().number(dimNumber).name(dimension.getName());
            if (dimNumber.equals(expandDim)) {
                int queryScope = this.getMemberQueryScope(rootScope);
                List memberList = modelCache.getMemberSort(dimNumber, Long.valueOf(viewId), expandMem, queryScope);
                memberSet.addAll(memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                memberSet.add(expandMem);
                memberList.forEach(member -> {
                    boolean hasNext = this.memberHasNext((Member)member, rootScope);
                    JSONObject metaMem = new TableMetaMem().number(member.getNumber()).name(member.getName()).isLeaf(member.isLeaf()).hasNext(hasNext).rootScope(rootScope).getJsonObj();
                    tableMetaDim.addMem(metaMem);
                });
            } else {
                dimInfo.getJSONArray(dimNumber).forEach(obj -> {
                    JSONObject cellObj = (JSONObject)obj;
                    String memNumber = cellObj.getString("num");
                    if (memberSet.contains(memNumber)) {
                        return;
                    }
                    memberSet.add(memNumber);
                    JSONObject metaMem = new TableMetaMem().number(memNumber).name(cellObj.getString("val")).isLeaf(cellObj.getBoolean("leaf")).hasNext(cellObj.getBoolean("next")).rootScope(cellObj.getInteger("rs")).getJsonObj();
                    tableMetaDim.addMem(metaMem);
                });
            }
            metaDimArr.add((Object)tableMetaDim.getJsonObj());
            queryDim.put(dimNumber, memberSet);
        }
        metaArr.add((Object)metaDimArr);
    }

    private int getMemberQueryScope(int rootScope) {
        int queryScope = RangeEnum.ALL_DETAIL_INCLUDE.getIndex() == rootScope ? RangeEnum.ALL_DETAIL.getIndex() : RangeEnum.DIRECTSUB_EXCLUDE.getIndex();
        return queryScope;
    }

    private boolean memberHasNext(Member member, int rootScope) {
        if (member.isLeaf()) {
            return false;
        }
        return RangeEnum.ALL_EXCLUDE.getIndex() == rootScope || RangeEnum.ALL.getIndex() == rootScope;
    }
}

