/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.query.table;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.AbstractDataService;
import kd.epm.eb.business.analysiscanvas.query.IDataService;
import kd.epm.eb.business.analysiscanvas.query.IVarService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.analysiscanvas.query.table.BaseDataService;
import kd.epm.eb.business.analysiscanvas.query.table.CalcTableDataService;
import kd.epm.eb.business.analysiscanvas.query.table.ColAppendDataService;
import kd.epm.eb.business.analysiscanvas.query.table.FuncColEnum;
import kd.epm.eb.business.analysiscanvas.query.table.RowExpandDataService;

public class Table2DataService
extends AbstractDataService
implements IVarService {
    public Table2DataService(AnalysisCanvasBox canvasBox, IFormView formView) {
        super(canvasBox, formView);
    }

    @Override
    public void buildQueryDim(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        IDataService dataService = this.getDataService(optType, calcParam);
        if (dataService == null) {
            return;
        }
        dataService.buildQueryDim(itemList, filterItemList, dtoList, optType, calcParam);
    }

    @Override
    public void processQueryResult(List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        IDataService dataService = this.getDataService(optType, calcParam);
        if (dataService == null) {
            return;
        }
        dataService.processQueryResult(itemList, filterItemList, dtoList, optType, calcParam);
    }

    @Override
    public void processChangeMember(List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers) {
        BaseDataService varService = new BaseDataService(this.canvasBox, this.formView);
        varService.processChangeMember(itemList, filterItemList, calcChangeMembers);
    }

    @Override
    public List<SaveDto> getCoverData(List<CustomItem> itemList, List<CustomItem> filterItemList) {
        BaseDataService varService = new BaseDataService(this.canvasBox, this.formView);
        return varService.getCoverData(itemList, filterItemList);
    }

    private IDataService getDataService(AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
        BaseDataService dataService;
        switch (optType) {
            case INIT: {
                dataService = new BaseDataService(this.canvasBox, this.formView);
                break;
            }
            case EXPAND: {
                String expandType = calcParam.getString("type");
                FuncColEnum funcColEnum = FuncColEnum.find(expandType);
                if (funcColEnum != null) {
                    dataService = new ColAppendDataService(this.canvasBox, this.formView);
                    break;
                }
                dataService = new RowExpandDataService(this.canvasBox, this.formView);
                break;
            }
            default: {
                dataService = new CalcTableDataService(this.canvasBox, this.formView);
            }
        }
        return dataService;
    }
}

