/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.execute;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.business.analyzeReport.context.ConditionContext;
import kd.epm.eb.business.analyzeReport.context.DatasetSelContext;
import kd.epm.eb.business.analyzeReport.context.DimGroupExecContext;
import kd.epm.eb.business.analyzeReport.execute.ConditionExecutor;
import kd.epm.eb.business.analyzeReport.execute.IDimGroupExecutor;
import kd.epm.eb.common.analysereport.constants.ConditionCompareType;
import kd.epm.eb.common.analysereport.pojo.condition.Condition;
import kd.epm.eb.common.analysereport.pojo.condition.ConditionResult;

public class ConditionRowExecutor
extends ConditionExecutor {
    private static final NumberFormat decimalFormat = DecimalFormat.getInstance();
    private Condition conditionRow;

    @Override
    public void select(DatasetSelContext selContext) {
        this.select(this.conditionRow, selContext);
    }

    private boolean compareDimGroupData(ConditionContext context) {
        BigDecimal leftOlapVal = this.getDimGroupVal(true, context);
        BigDecimal rightOlapVal = this.getDimGroupVal(false, context);
        return this.compareVal(this.conditionRow.getCompareSign(), leftOlapVal, rightOlapVal);
    }

    private boolean compareFixData(ConditionContext context) {
        BigDecimal leftOlapVal = this.getDimGroupVal(true, context);
        BigDecimal fixData = this.conditionRow.getRightNumVal();
        return this.compareVal(this.conditionRow.getCompareSign(), leftOlapVal, fixData);
    }

    private ConditionResult compareSubData(ConditionContext context) {
        BigDecimal leftOlapVal = this.getDimGroupVal(true, context);
        BigDecimal rightOlapVal = this.getDimGroupVal(false, context);
        BigDecimal compareVal = this.conditionRow.getRightNumVal();
        BigDecimal subData = leftOlapVal.subtract(rightOlapVal);
        ConditionResult result = new ConditionResult();
        String resultStr = decimalFormat.format(subData);
        result.setResult(resultStr);
        result.setSucceed(this.compareVal(this.conditionRow.getCompareSign(), subData, compareVal));
        return result;
    }

    private ConditionResult compareUpdateRate(ConditionContext context) {
        BigDecimal leftOlapVal = this.getDimGroupVal(true, context);
        BigDecimal rightOlapVal = this.getDimGroupVal(false, context);
        BigDecimal subData = leftOlapVal.subtract(rightOlapVal);
        BigDecimal compareVal = this.conditionRow.getRightNumVal();
        BigDecimal rate = rightOlapVal.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.0000") : subData.divide(rightOlapVal, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
        ConditionResult result = new ConditionResult();
        String resultStr = rate.toString();
        resultStr = resultStr.substring(0, resultStr.length() - 2) + "%";
        result.setResult(resultStr);
        result.setSucceed(this.compareVal(this.conditionRow.getCompareSign(), rate, compareVal));
        return result;
    }

    private IDimGroupExecutor getDimGroupExecutor(Long groupId, ConditionContext context) {
        IDimGroupExecutor executor = null;
        if (groupId != null && !groupId.equals(0L)) {
            executor = context.getMemberGroupMap().get(groupId);
        }
        return executor;
    }

    private BigDecimal getDimGroupVal(boolean isLeft, ConditionContext context) {
        IDimGroupExecutor dimGroupExecutor = isLeft ? this.getDimGroupExecutor(this.conditionRow.getLeftVal(), context) : this.getDimGroupExecutor(this.conditionRow.getRightVal(), context);
        BigDecimal olapVal = null;
        if (dimGroupExecutor != null) {
            DimGroupExecContext dimGroupExecContext = new DimGroupExecContext();
            dimGroupExecContext.setOlapData(context.getOlapData());
            dimGroupExecContext.setPageDimMembers(context.getPageDimMembers());
            dimGroupExecContext.setFunctionDimMembs(context.getFunctionDimMembers());
            dimGroupExecContext.setModelId(context.getModelCacheHelper().getModelobj().getId());
            dimGroupExecContext.setMemberGroupMap(context.getMemberGroupMap());
            olapVal = dimGroupExecutor.execute(dimGroupExecContext).getToCalculateResult();
        }
        if (olapVal == null) {
            olapVal = BigDecimal.ZERO;
        }
        return olapVal;
    }

    private boolean compareVal(String compareSign, BigDecimal sourceData, BigDecimal targetData) {
        boolean result = false;
        int compareResult = sourceData.compareTo(targetData);
        switch (compareSign) {
            case "1": {
                result = compareResult > 0;
                break;
            }
            case "2": {
                result = compareResult < 0;
                break;
            }
            case "3": {
                result = compareResult == 0;
                break;
            }
            case "4": {
                result = compareResult >= 0;
                break;
            }
            case "6": {
                result = compareResult <= 0;
                break;
            }
            case "7": {
                result = compareResult != 0;
            }
        }
        return result;
    }

    @Override
    public ConditionResult getResult(ConditionContext context) {
        ConditionResult result;
        String compareValType = this.conditionRow.getRightValueType();
        ConditionCompareType compareType = ConditionCompareType.getTypeByVal((String)compareValType);
        switch (compareType) {
            case UPRATE: {
                result = this.compareUpdateRate(context);
                break;
            }
            case FIXDATA: {
                result = this.getFalseResult();
                result.setSucceed(this.compareFixData(context));
                break;
            }
            case SUBDATA: {
                result = this.compareSubData(context);
                break;
            }
            case DIMGROUP: {
                result = this.getFalseResult();
                result.setSucceed(this.compareDimGroupData(context));
                break;
            }
            default: {
                result = this.getFalseResult();
            }
        }
        return result;
    }

    public Condition getConditionRow() {
        return this.conditionRow;
    }

    public void setConditionRow(Condition conditionRow) {
        this.conditionRow = conditionRow;
    }

    @Override
    public String toString() {
        return this.getSign() + "-" + (this.conditionRow == null ? "" : SerializationUtils.toJsonString((Object)this.conditionRow));
    }
}

