/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.execute;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analyzeReport.context.DatasetSelContext;
import kd.epm.eb.business.analyzeReport.context.DimGroupExecContext;
import kd.epm.eb.business.analyzeReport.execute.IDimGroupExecutor;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupDataFormat;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupResult;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;

public class DimGroupExecutor
implements IDimGroupExecutor {
    private static final Log log = LogFactory.getLog(DimGroupExecutor.class);
    private MembersKey membersKey;
    private Long datasetId;
    private String suitObject;
    private Map<String, Integer> functionDimIndex;
    private Map<String, Integer> paramDimIndex;
    private MetricDataTypeEnum metricDataType;
    private DimGroupDataFormat dimGroupDataFormat;

    @Override
    public void select(DatasetSelContext selContext) {
        if (this.functionDimIndex != null && !this.functionDimIndex.isEmpty()) {
            selContext.getRefFunctionDimOnDataset().computeIfAbsent(this.datasetId, key -> new HashSet(16)).addAll(this.functionDimIndex.keySet());
        }
        if (this.paramDimIndex != null && !this.paramDimIndex.isEmpty()) {
            selContext.getRefParamDimOnDataset().computeIfAbsent(this.datasetId, key -> new HashSet(16)).addAll(this.paramDimIndex.keySet());
        }
    }

    protected Object getData(DimGroupExecContext context) {
        Object result = null;
        Map<MembersKey, Object> olapData = context.getOlapData().get(this.datasetId);
        if (olapData != null && this.membersKey != null) {
            if (this.updateMemberKey(context)) {
                this.membersKey.initHashCode();
            }
            result = olapData.get(this.membersKey);
        }
        return result;
    }

    @Override
    public DimGroupResult execute(DimGroupExecContext context) {
        Object data = this.getData(context);
        DimGroupResult dimGroupResult = data == null ? this.getDefaultData() : (data instanceof BigDecimal ? new DimGroupResult((BigDecimal)data, this.isHasUnit(), DimGroupTypeEnum.NUMBER, this.getDimGroupDataFormat()) : new DimGroupResult(data));
        CommonServiceHelper.handleLogBySign((Log)log, (String)"groupResult_MemberKey", () -> ((MembersKey)this.membersKey).toString(), (String)"DimGroupExecutor", (String)"executeGroupResult");
        CommonServiceHelper.handleLogBySign((Log)log, (String)"groupResult", () -> ((DimGroupResult)dimGroupResult).toString(), (String)"DimGroupExecutor", (String)"executeGroupResult");
        return dimGroupResult;
    }

    private DimGroupResult getDefaultData() {
        MetricDataTypeEnum metricDataType = this.getMetricDataType();
        if (metricDataType == null || AnalyseReportUtil.dataTypes.contains(metricDataType.getIndex())) {
            return new DimGroupResult(BigDecimal.ZERO, this.isHasUnit(), DimGroupTypeEnum.NUMBER, this.getDimGroupDataFormat());
        }
        return new DimGroupResult((Object)"");
    }

    private Boolean isHasUnit() {
        return MetricDataTypeEnum.CURRENCY == this.getMetricDataType();
    }

    protected boolean updateMemberKey(DimGroupExecContext context) {
        boolean updated = false;
        if (this.paramDimIndex != null && !this.paramDimIndex.isEmpty()) {
            Map<String, MemberView> pageDimMembers = context.getPageDimMembers();
            for (Map.Entry<String, Integer> entry : this.paramDimIndex.entrySet()) {
                MemberView memberView;
                String value = null;
                if (pageDimMembers != null && (memberView = pageDimMembers.get(entry.getKey())) != null) {
                    value = memberView.getMemberNumber();
                }
                this.membersKey.getKeys()[entry.getValue().intValue()] = value;
            }
            updated = true;
        }
        if (this.functionDimIndex != null && !this.functionDimIndex.isEmpty()) {
            Map<String, MemberView> functionDimMembs = context.getFunctionDimMembs();
            for (Map.Entry<String, Integer> entry : this.functionDimIndex.entrySet()) {
                this.membersKey.getKeys()[entry.getValue().intValue()] = functionDimMembs == null ? null : functionDimMembs.get(entry.getKey()).getMemberNumber();
            }
            updated = true;
        }
        return updated;
    }

    public Map<String, Integer> getFunctionDimIndex() {
        return this.functionDimIndex;
    }

    public void setFunctionDimIndex(Map<String, Integer> functionDimIndex) {
        this.functionDimIndex = functionDimIndex;
    }

    public Map<String, Integer> getParamDimIndex() {
        return this.paramDimIndex;
    }

    public void setParamDimIndex(Map<String, Integer> paramDimIndex) {
        this.paramDimIndex = paramDimIndex;
    }

    public MembersKey getMembersKey() {
        return this.membersKey;
    }

    public void setMembersKey(MembersKey membersKey) {
        this.membersKey = membersKey;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public String getSuitObject() {
        return this.suitObject;
    }

    public void setSuitObject(String suitObject) {
        this.suitObject = suitObject;
    }

    public MetricDataTypeEnum getMetricDataType() {
        return this.metricDataType;
    }

    public void setMetricDataType(MetricDataTypeEnum metricDataType) {
        this.metricDataType = metricDataType;
    }

    public DimGroupDataFormat getDimGroupDataFormat() {
        return this.dimGroupDataFormat;
    }

    public void setDimGroupDataFormat(DimGroupDataFormat dimGroupDataFormat) {
        this.dimGroupDataFormat = dimGroupDataFormat;
    }
}

