/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.execute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analyzeReport.context.DatasetSelContext;
import kd.epm.eb.business.analyzeReport.context.DimGroupExecContext;
import kd.epm.eb.business.analyzeReport.execute.IDimGroupExecutor;
import kd.epm.eb.common.analysereport.constants.DataFormatTypeEnum;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.constants.LogicOperationEnum;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupDataFormat;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupResult;
import kd.epm.eb.common.analysereport.pojo.formula.FormulaNode;
import kd.epm.eb.common.utils.CommonServiceHelper;

public class DimGroupFormulaExecutor
implements IDimGroupExecutor {
    private static final Log log = LogFactory.getLog(DimGroupFormulaExecutor.class);
    private String formulaName;
    private List<Long> refDimGroupIds = new ArrayList<Long>(16);
    private FormulaNode formulaNode;
    private DimGroupDataFormat dimGroupDataFormat;

    @Override
    public DimGroupResult execute(DimGroupExecContext context) {
        HashMap<Long, DimGroupResult> dimGroupValues = new HashMap<Long, DimGroupResult>(16);
        Map<Long, IDimGroupExecutor> memberGroupMap = context.getMemberGroupMap();
        for (Long refDimGroupId : this.refDimGroupIds) {
            dimGroupValues.put(refDimGroupId, memberGroupMap.get(refDimGroupId).execute(context));
        }
        DimGroupDataFormat dimGroupDataFormat = this.getDimGroupDataFormat();
        if (dimGroupDataFormat == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u8282\u70b9%1\u7684\u6570\u636e\u683c\u5f0f\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimGroupFormulaExecutor_0", (String)"epm-eb-business", (Object[])new Object[]{this.getFormulaName()}));
        }
        int calDigit = dimGroupDataFormat.getDigit();
        if (DataFormatTypeEnum.RATE == dimGroupDataFormat.getDataFormat()) {
            calDigit += 2;
        }
        DimGroupResult result = new DimGroupResult();
        FormulaNode formulaNode = this.getFormulaNode();
        formulaNode.calculate(dimGroupValues, result, LogicOperationEnum.PLUS, calDigit);
        DimGroupResult dimGroupResult = new DimGroupResult(result.getResult(), Boolean.valueOf(true), DimGroupTypeEnum.FORMULA, dimGroupDataFormat);
        dimGroupResult.setNeedChangeRateDigit(true);
        CommonServiceHelper.handleLogBySign((Log)log, (String)"formulaNode", () -> ((FormulaNode)formulaNode).toString(), (String)"DimGroupExecutor", (String)"formulaNode");
        CommonServiceHelper.handleLogBySign((Log)log, (String)"formulaResult", () -> ((DimGroupResult)dimGroupResult).toString(), (String)"DimGroupExecutor", (String)"executeFormulaResult");
        return dimGroupResult;
    }

    @Override
    public void select(DatasetSelContext selContext) {
        for (Long dimGroupId : this.getRefDimGroupIds()) {
            this.select(dimGroupId, selContext);
        }
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public List<Long> getRefDimGroupIds() {
        return this.refDimGroupIds;
    }

    public void setRefDimGroupIds(List<Long> refDimGroupIds) {
        this.refDimGroupIds = refDimGroupIds;
    }

    public FormulaNode getFormulaNode() {
        return this.formulaNode;
    }

    public void setFormulaNode(FormulaNode formulaNode) {
        this.formulaNode = formulaNode;
    }

    public DimGroupDataFormat getDimGroupDataFormat() {
        return this.dimGroupDataFormat;
    }

    public void setDimGroupDataFormat(DimGroupDataFormat dimGroupDataFormat) {
        this.dimGroupDataFormat = dimGroupDataFormat;
    }
}

