/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.execute;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.epm.eb.business.analyzeReport.context.DimGroupExecContext;
import kd.epm.eb.business.analyzeReport.execute.DimGroupPeriodExecutor;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.cache.impl.MembersKey;

public class DimGroupPeriodDivExecutor
extends DimGroupPeriodExecutor {
    private Map<String, String> secondPeriodCache = new HashMap<String, String>(16);
    private boolean isRate;
    private boolean isRing;

    public boolean isRate() {
        return this.isRate;
    }

    public boolean isRing() {
        return this.isRing;
    }

    public DimGroupPeriodDivExecutor(int periodIndex, boolean isRate, boolean isRing, int periodOffset) {
        super(periodIndex, periodOffset);
        this.isRate = isRate;
        this.isRing = isRing;
    }

    @Override
    public Object getData(DimGroupExecContext context) {
        BigDecimal result = null;
        if (this.isRate) {
            BigDecimal secondVal;
            BigDecimal firstVal = (BigDecimal)super.getData(context);
            if (firstVal != null && (secondVal = this.getSecondVal(context)) != null) {
                result = secondVal.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.0000") : firstVal.subtract(secondVal).divide(secondVal, 11, RoundingMode.HALF_UP);
            }
        } else {
            this.updateMemberKey(context);
            result = this.getSecondVal(context);
        }
        return result;
    }

    private BigDecimal getSecondVal(DimGroupExecContext context) {
        String currentPeriod = this.getCurrentPeriod();
        String refPeriod = this.secondPeriodCache.computeIfAbsent(currentPeriod, key -> AnalyseReportUtil.getInstance().calcPeriod((String)key, this.isRing));
        BigDecimal secondVal = null;
        if (refPeriod != null) {
            this.updatePeriod(refPeriod, true);
            Map<MembersKey, Object> olapData = context.getOlapData().get(this.getDatasetId());
            secondVal = olapData == null ? null : (BigDecimal)olapData.get(this.getMembersKey());
            this.updatePeriod(currentPeriod, true);
        }
        return secondVal;
    }
}

