/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.execute;

import java.util.HashMap;
import java.util.Map;
import kd.epm.eb.business.analyzeReport.context.DimGroupExecContext;
import kd.epm.eb.business.analyzeReport.execute.DimGroupExecutor;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class DimGroupPeriodExecutor
extends DimGroupExecutor {
    private final int periodIndex;
    private final int offsetVal;
    private final Map<String, String> offsetPeriodCache = new HashMap<String, String>(16);

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public DimGroupPeriodExecutor(int periodIndex, int offsetVal) {
        this.periodIndex = periodIndex;
        this.offsetVal = offsetVal;
    }

    @Override
    protected boolean updateMemberKey(DimGroupExecContext context) {
        boolean updated = super.updateMemberKey(context);
        if (this.offsetVal != 0) {
            String currentPeriod = this.getCurrentPeriod();
            currentPeriod = this.offsetPeriodCache.computeIfAbsent(currentPeriod, key -> TemplateVarCommonUtil.getPeriodOffset((String)key, (int)this.offsetVal, (Long)context.getModelId()));
            this.updatePeriod(currentPeriod, false);
            updated = true;
        }
        return updated;
    }

    protected void updatePeriod(String periodNum, boolean updateHash) {
        this.getMembersKey().getKeys()[this.periodIndex] = periodNum;
        if (updateHash) {
            this.getMembersKey().initHashCode();
        }
    }

    protected String getCurrentPeriod() {
        return (String)this.getMembersKey().getKeys()[this.periodIndex];
    }
}

