/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.execute;

import java.util.List;
import kd.epm.eb.business.analyzeReport.context.ConditionContext;
import kd.epm.eb.business.analyzeReport.context.DatasetSelContext;
import kd.epm.eb.business.analyzeReport.execute.IConditionExecutor;
import kd.epm.eb.common.analysereport.pojo.condition.ConditionResult;
import kd.epm.eb.common.analysereport.pojo.condition.MultiResultCondition;
import kd.epm.eb.common.analysereport.pojo.condition.ResultJdCondition;
import kd.epm.eb.common.utils.StringUtils;

public class MultiResConditionExecutor
implements IConditionExecutor {
    private List<IConditionExecutor> executorList;
    private MultiResultCondition condition;

    @Override
    public void select(DatasetSelContext selContext) {
        this.executorList.forEach(iConditionExecutor -> iConditionExecutor.select(selContext));
    }

    public List<IConditionExecutor> getExecutorList() {
        return this.executorList;
    }

    public void setExecutorList(List<IConditionExecutor> executorList) {
        this.executorList = executorList;
    }

    public MultiResultCondition getCondition() {
        return this.condition;
    }

    public void setCondition(MultiResultCondition condition) {
        this.condition = condition;
    }

    @Override
    public ConditionResult getResult(ConditionContext context) {
        for (int index = 0; index < this.executorList.size(); ++index) {
            String graph;
            IConditionExecutor executor = this.executorList.get(index);
            ConditionResult result = executor.getResult(context);
            if (!result.isSucceed()) continue;
            ResultJdCondition rowCondition = (ResultJdCondition)this.condition.getConditions().get(index);
            StringBuilder sb = new StringBuilder();
            String word = rowCondition.getWord();
            if (StringUtils.isNotEmpty((String)word)) {
                sb.append(word);
            }
            if (rowCondition.getNumberDisplay()) {
                sb.append(result.getResult());
            }
            if (StringUtils.isNotEmpty((String)(graph = rowCondition.getGraph()))) {
                sb.append(this.getGraph(graph));
            }
            result.setResult(sb.toString());
            return result;
        }
        return this.getFalseResult();
    }

    private String getGraph(String graph) {
        switch (graph) {
            case "1": {
                return "\u2191";
            }
            case "2": {
                return "\u2193";
            }
            case "3": {
                return "\u25a1";
            }
            case "4": {
                return "\u25cb";
            }
            case "5": {
                return "\u25b3";
            }
        }
        return graph;
    }
}

