/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.execute;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.epm.eb.business.analyzeReport.context.ConditionContext;
import kd.epm.eb.business.analyzeReport.context.DatasetSelContext;
import kd.epm.eb.business.analyzeReport.context.DimGroupExecContext;
import kd.epm.eb.business.analyzeReport.context.FunctionExecContext;
import kd.epm.eb.business.analyzeReport.context.VarParseContext;
import kd.epm.eb.business.analyzeReport.execute.IConditionExecutor;
import kd.epm.eb.business.analyzeReport.execute.IDimGroupExecutor;
import kd.epm.eb.business.analyzeReport.execute.IFunctionExecutor;
import kd.epm.eb.business.analyzeReport.factory.ConditionExecutorFactory;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptFuncUtil;
import kd.epm.eb.common.analysereport.constants.ConstantKeys;
import kd.epm.eb.common.analysereport.constants.FieldTypeEnum;
import kd.epm.eb.common.analysereport.constants.FunctionShowType;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.constants.SortWayEnum;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.condition.Condition;
import kd.epm.eb.common.analysereport.pojo.condition.ConditionResult;
import kd.epm.eb.common.analysereport.pojo.condition.IConditionData;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionStrResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionTableResult;
import kd.epm.eb.common.analysereport.pojo.functions.OrderFunction;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FieldLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberFilter;
import kd.epm.eb.common.analysereport.pojo.functions.steps.ShowLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.SortWay;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class OrderFunctionExecutor
implements IFunctionExecutor {
    private OrderFunction functionData;

    public OrderFunctionExecutor(OrderFunction functionData) {
        this.functionData = functionData;
    }

    public OrderFunction getFunctionData() {
        return this.functionData;
    }

    @Override
    public void selectParam(VarParseContext parseContext, DatasetSelContext selContext) {
        this.select(selContext);
        IModelCacheHelper modelCacheHelper = parseContext.getModelCacheHelper();
        Map<Long, Map<String, Set<String>>> allDimMemberNums = parseContext.getDimMemberNums();
        Map<Long, Set<String>> refFunctionDimOnDataset = selContext.getRefFunctionDimOnDataset();
        MemberFilter filter = (MemberFilter)this.functionData.getStepData(FunctionStepEnum.MEMBERFILTER);
        Map<String, Set<String>> membNumsOnFilter = AnalyseRptFuncUtil.parseMembRange2Set(filter, modelCacheHelper);
        refFunctionDimOnDataset.forEach((datasetId, dimNums) -> {
            Map dimMembNums = allDimMemberNums.computeIfAbsent((Long)datasetId, key -> new HashMap(16));
            dimNums.forEach(dimNum -> {
                Set membNums = (Set)membNumsOnFilter.get(dimNum);
                if (membNums != null) {
                    dimMembNums.computeIfAbsent(dimNum, key -> new HashSet(16)).addAll(membNums);
                }
            });
        });
        refFunctionDimOnDataset.clear();
    }

    @Override
    public void select(DatasetSelContext selContext) {
        MemberFilter memberFilter = this.functionData.getMemberFilter();
        JudgeCondition filterCondition = memberFilter.getFilterCondition();
        if (filterCondition != null) {
            filterCondition.getConditionList().forEach(condition -> this.select((Condition)condition, selContext));
        }
        SortWay sortWay = this.functionData.getSortWay();
        this.select(sortWay.getSortAccord(), selContext);
        JudgeCondition sortCondition = sortWay.getSortCondition();
        if (sortCondition != null) {
            sortCondition.getConditionList().forEach(condition -> this.select((Condition)condition, selContext));
        }
        ShowLayout showLayout = this.functionData.getShowLayout();
        showLayout.getFieldLayoutList().forEach(fieldLayout -> {
            String fieldType = fieldLayout.getFieldType();
            String showField = fieldLayout.getShowField();
            if (FieldTypeEnum.DIMGROUP.getValue().equals(fieldType)) {
                Long membGroupId = IDUtils.toLong((Object)showField);
                this.select(membGroupId, selContext);
            } else if (FieldTypeEnum.CONDITION.getValue().equals(fieldType)) {
                Long conditionId = IDUtils.toLong((Object)showField);
                IConditionExecutor executor = selContext.getConditionExecutorMap().get(conditionId);
                if (executor != null) {
                    executor.select(selContext);
                }
            }
        });
    }

    @Override
    public FunctionResult executeNoData(FunctionExecContext execContext) {
        ShowLayout showLayout = this.functionData.getShowLayout();
        String[] tableHead = this.getTableHead(showLayout.getFieldLayoutList());
        ArrayList<String[]> dataList = new ArrayList<String[]>(16);
        dataList.add(tableHead);
        return this.dealShow(showLayout, dataList);
    }

    @Override
    public FunctionResult execute(FunctionExecContext execContext) {
        IModelCacheHelper modelCacheHelper = execContext.getVarParseContext().getModelCacheHelper();
        MemberFilter memberFilter = this.functionData.getMemberFilter();
        MemberFilterResult filterResult = this.dealMemberFilter(modelCacheHelper, memberFilter, execContext);
        SortWay sortWay = this.functionData.getSortWay();
        List<MemberGroupData> sortedMemberGroups = this.dealSortWay(filterResult.getDimNums(), filterResult.getDimMembNumGroups(), filterResult.getDimViewMap(), sortWay, execContext);
        ShowLayout showLayout = this.functionData.getShowLayout();
        return this.dealShow(sortedMemberGroups, filterResult.getDimNums(), filterResult.getDimViewMap(), showLayout, execContext);
    }

    private FunctionResult dealShow(List<MemberGroupData> sortedMemberGroups, List<String> dimNums, Map<String, Long> dimViewMap, ShowLayout showLayout, FunctionExecContext execContext) {
        int showAmount = showLayout.getShowAmount();
        this.cutShowDataList(showAmount, sortedMemberGroups);
        ArrayList<String[]> dataList = new ArrayList<String[]>(16);
        List fieldLayoutList = showLayout.getFieldLayoutList();
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>(dimNums.size());
        int index = 0;
        for (String dimNum : dimNums) {
            dimIndexMap.put(dimNum, index);
            ++index;
        }
        Map<Long, Map<MembersKey, Object>> olapData = execContext.getOlapData();
        Map<Long, IDimGroupExecutor> dimMemberGroup = execContext.getVarParseContext().getDimMemberGroup();
        Map<Long, IConditionExecutor> conditionMap = execContext.getVarParseContext().getConditionMap();
        IModelCacheHelper modelCacheHelper = execContext.getVarParseContext().getModelCacheHelper();
        ConditionContext conditionContext = new ConditionContext();
        conditionContext.setMemberGroupMap(dimMemberGroup);
        conditionContext.setOlapData(olapData);
        conditionContext.setPageDimMembers(execContext.getPageDimNums());
        conditionContext.setModelCacheHelper(modelCacheHelper);
        String[] tableHead = this.getTableHead(fieldLayoutList);
        dataList.add(tableHead);
        DimGroupExecContext dimGroupExecContext = new DimGroupExecContext();
        dimGroupExecContext.setOlapData(olapData);
        dimGroupExecContext.setPageDimMembers(execContext.getPageDimNums());
        dimGroupExecContext.setModelId(modelCacheHelper.getModelobj().getId());
        dimGroupExecContext.setMemberGroupMap(dimMemberGroup);
        HashSet<Integer> notExsitIndex = new HashSet<Integer>(16);
        for (int i = 0; i < tableHead.length; ++i) {
            notExsitIndex.add(i);
        }
        fieldLayoutList.forEach(field -> notExsitIndex.remove(field.getLocation()));
        for (MemberGroupData dimMembGroup : sortedMemberGroups) {
            String[] rowValues = new String[tableHead.length];
            List<String> dimMemberNums = dimMembGroup.getDimMembNumGroup();
            for (FieldLayout fieldLayout : fieldLayoutList) {
                String toShowVal = null;
                String fieldType = fieldLayout.getFieldType();
                String showField = fieldLayout.getShowField();
                if (FieldTypeEnum.DIMMENSION.getValue().equals(fieldType)) {
                    toShowVal = this.selDimFieldVal(showField, dimIndexMap, dimMemberNums, dimViewMap, modelCacheHelper);
                } else if (FieldTypeEnum.DIMGROUP.getValue().equals(fieldType)) {
                    toShowVal = this.selDimGroupFieldVal(showField, dimMemberGroup, dimIndexMap, dimMemberNums, dimViewMap, dimGroupExecContext);
                } else if (FieldTypeEnum.CONDITION.getValue().equals(fieldType)) {
                    toShowVal = this.selConditionFieldVal(showField, conditionMap, dimIndexMap, dimMemberNums, dimViewMap, conditionContext);
                }
                if (toShowVal == null) {
                    toShowVal = "";
                }
                toShowVal = fieldLayout.getPreText() + toShowVal + fieldLayout.getBackText();
                int location = fieldLayout.getLocation();
                String showStr = rowValues[location];
                showStr = showStr == null ? toShowVal : showStr + toShowVal;
                rowValues[location] = showStr;
            }
            notExsitIndex.forEach(colIndex -> {
                rowValues[colIndex.intValue()] = "";
            });
            dataList.add(rowValues);
        }
        return this.dealShow(showLayout, dataList);
    }

    private String selConditionFieldVal(String showField, Map<Long, IConditionExecutor> conditionMap, Map<String, Integer> dimIndexMap, List<String> dimMemberNums, Map<String, Long> dimViewMap, ConditionContext conditionContext) {
        Long conditionId = IDUtils.toLong((Object)showField);
        IConditionExecutor conditionExecutor = conditionMap.get(conditionId);
        if (conditionExecutor != null) {
            HashMap<String, MemberView> functionDimMembNums = new HashMap<String, MemberView>(dimIndexMap.size());
            dimIndexMap.forEach((dimNum, membIndex) -> functionDimMembNums.put((String)dimNum, new MemberView((String)dimMemberNums.get((int)membIndex), (Long)dimViewMap.get(dimNum))));
            conditionContext.setFunctionDimMembers(functionDimMembNums);
            ConditionResult conditionResult = conditionExecutor.getResult(conditionContext);
            if (conditionResult.isSucceed()) {
                return conditionResult.getResult();
            }
        }
        return null;
    }

    private String selDimGroupFieldVal(String showField, Map<Long, IDimGroupExecutor> dimMemberGroup, Map<String, Integer> dimIndexMap, List<String> dimMemberNums, Map<String, Long> dimViewMap, DimGroupExecContext dimGroupExecContext) {
        Long membGroupId = IDUtils.toLong((Object)showField);
        IDimGroupExecutor executor = dimMemberGroup.get(membGroupId);
        if (executor != null) {
            HashMap<String, MemberView> functionDimMembNums = new HashMap<String, MemberView>(dimIndexMap.size());
            dimIndexMap.forEach((dimNum, membIndex) -> functionDimMembNums.put((String)dimNum, new MemberView((String)dimMemberNums.get((int)membIndex), (Long)dimViewMap.get(dimNum))));
            dimGroupExecContext.setFunctionDimMembs(functionDimMembNums);
            DimGroupResult groupVal = executor.execute(dimGroupExecContext);
            if (groupVal != null) {
                return groupVal.getShowResult();
            }
        }
        return null;
    }

    private String selDimFieldVal(String showField, Map<String, Integer> dimIndexMap, List<String> dimMemberNums, Map<String, Long> dimViewMap, IModelCacheHelper modelCacheHelper) {
        Integer dimIndex = dimIndexMap.get(showField);
        if (dimIndex != null) {
            String membNumber = dimMemberNums.get(dimIndex);
            Member member = modelCacheHelper.getMember(showField, dimViewMap.get(showField), membNumber);
            if (member != null) {
                return member.getName();
            }
        }
        return null;
    }

    private void cutShowDataList(int showAmount, List<MemberGroupData> sortedMemberGroups) {
        int count = 1;
        Iterator<MemberGroupData> iterator = sortedMemberGroups.iterator();
        MemberGroupData current = null;
        while (iterator.hasNext()) {
            MemberGroupData next = iterator.next();
            if (next == null || next.isNull()) {
                iterator.remove();
                continue;
            }
            if (current == null) {
                current = next;
                continue;
            }
            if (current.compareTo(next) == 0) continue;
            if (count >= showAmount) {
                iterator.remove();
                continue;
            }
            current = next;
            ++count;
        }
    }

    private FunctionResult dealShow(ShowLayout showLayout, List<String[]> dataList) {
        if (FunctionShowType.TABLE.getVal().equals(showLayout.getShowWay())) {
            FunctionTableResult result = new FunctionTableResult();
            result.setTableRows(dataList);
            return result;
        }
        String fillWayText = showLayout.getFillWayText();
        StringBuilder sb = new StringBuilder();
        for (int seq = 1; seq < dataList.size(); ++seq) {
            String[] rowVal;
            for (String val : rowVal = dataList.get(seq)) {
                sb.append(val);
            }
            sb.append(fillWayText);
        }
        if (sb.length() > 0 && StringUtils.isNotEmpty((String)fillWayText)) {
            sb.setLength(sb.length() - fillWayText.length());
        }
        FunctionStrResult result = new FunctionStrResult();
        result.setShowStr(sb.toString());
        return result;
    }

    private String[] getTableHead(List<FieldLayout> fieldLayoutList) {
        HashMap<Integer, String> tableHead = new HashMap<Integer, String>(fieldLayoutList.size());
        int maxIndex = 0;
        for (FieldLayout fieldLayout : fieldLayoutList) {
            String title;
            int location = fieldLayout.getLocation();
            if (maxIndex < location) {
                maxIndex = location;
            }
            title = (title = (String)tableHead.get(location)) == null ? fieldLayout.getTitle() : title + "," + fieldLayout.getTitle();
            tableHead.put(location, title);
        }
        String[] head = new String[maxIndex + 1];
        for (int index = 0; index < head.length; ++index) {
            String title;
            head[index] = title = tableHead.getOrDefault(index, "");
        }
        return head;
    }

    private List<MemberGroupData> dealSortWay(List<String> dimNums, List<List<String>> dimMembNumsGroup, Map<String, Long> dimViewMap, SortWay sortWay, FunctionExecContext execContext) {
        Function<List, MemberGroupData> sortFunction;
        SortWayEnum sortWayEnum = SortWayEnum.getSortWayByVal((String)sortWay.getSortWay());
        if (sortWayEnum == SortWayEnum.NULL) {
            sortFunction = memberNumsGroup -> new MemberGroupStrData();
        } else {
            boolean conditionResult = false;
            if (sortWay.getSortCondition() != null) {
                IConditionExecutor conditionExecutor = ConditionExecutorFactory.getExecutor((IConditionData)sortWay.getSortCondition());
                ConditionContext context = new ConditionContext();
                context.setMemberGroupMap(execContext.getVarParseContext().getDimMemberGroup());
                context.setOlapData(execContext.getOlapData());
                context.setPageDimMembers(execContext.getPageDimNums());
                context.setModelCacheHelper(execContext.getVarParseContext().getModelCacheHelper());
                conditionResult = conditionExecutor.getBoolean(context);
            }
            boolean bigValUp = true;
            if (sortWayEnum == SortWayEnum.GROUPDOWN) {
                bigValUp = false;
            } else if (sortWayEnum == SortWayEnum.CONDITIONDOWN && conditionResult) {
                bigValUp = false;
            } else if (sortWayEnum == SortWayEnum.CONDITIONUP && !conditionResult) {
                bigValUp = false;
            }
            Long sortAccord = sortWay.getSortAccord();
            boolean valUp = bigValUp;
            Map<Long, IDimGroupExecutor> dimMemberGroup = execContext.getVarParseContext().getDimMemberGroup();
            IDimGroupExecutor dimGroupExecutor = dimMemberGroup.get(sortAccord);
            DimGroupExecContext dimGroupExecContext = new DimGroupExecContext();
            dimGroupExecContext.setPageDimMembers(execContext.getPageDimNums());
            dimGroupExecContext.setOlapData(execContext.getOlapData());
            dimGroupExecContext.setModelId(execContext.getVarParseContext().getModelCacheHelper().getModelobj().getId());
            dimGroupExecContext.setMemberGroupMap(dimMemberGroup);
            sortFunction = memberNumsGroup -> {
                HashMap<String, MemberView> functionDimMembNums = new HashMap<String, MemberView>();
                for (int i = 0; i < dimNums.size() && i < memberNumsGroup.size(); ++i) {
                    String dimNum = (String)dimNums.get(i);
                    functionDimMembNums.put((String)dimNums.get(i), new MemberView((String)memberNumsGroup.get(i), (Long)dimViewMap.get(dimNum)));
                }
                dimGroupExecContext.setFunctionDimMembs(functionDimMembNums);
                MemberGroupOLapData comparator = new MemberGroupOLapData();
                comparator.setBigValUp(valUp);
                DimGroupResult dimMemberGroupVal = dimGroupExecutor.execute(dimGroupExecContext);
                comparator.setOlapVal(dimMemberGroupVal.getToCalculateResult());
                return comparator;
            };
        }
        ArrayList<MemberGroupData> sortList = new ArrayList<MemberGroupData>(dimMembNumsGroup.size());
        Iterator<List<String>> iterator = dimMembNumsGroup.iterator();
        while (iterator.hasNext()) {
            List<String> memberNumsGroup2 = iterator.next();
            MemberGroupData memberGroupData = sortFunction.apply(memberNumsGroup2);
            memberGroupData.setDimMembNumGroup(memberNumsGroup2);
            sortList.add(memberGroupData);
            iterator.remove();
        }
        ConstantKeys.commonLog.info(String.format("%s-MemberRangeSize[Sorted:%s]", this.functionData.getNumber(), sortList.size()));
        Collections.sort(sortList);
        if (execContext.getLogSigns().contains("sortedDimMembs")) {
            CommonServiceHelper.handleLog((Log)ConstantKeys.commonLog, (String)String.format("%s:%s-%s", "AnalyseExec", "sortedDimMembs", this.functionData.getNumber()), (String)SerializationUtils.toJsonString(sortList));
        }
        return sortList;
    }

    private MemberFilterResult dealMemberFilter(IModelCacheHelper modelCacheHelper, MemberFilter memberFilter, FunctionExecContext execContext) {
        List memberGroups;
        Map<String, List<String>> dimMembNums = AnalyseRptFuncUtil.parseMembRange2List(memberFilter, modelCacheHelper);
        ArrayList<String> dimNums = new ArrayList<String>(dimMembNums.size());
        ArrayList allMembNums = new ArrayList(dimMembNums.size());
        HashMap dimViewMap = new HashMap(16);
        memberFilter.getMemberRanges().forEach(memberRange -> dimViewMap.put(memberRange.getDimNum(), memberRange.getViewId()));
        dimMembNums.forEach((dimNum, members) -> {
            dimNums.add((String)dimNum);
            allMembNums.add(members);
        });
        IConditionExecutor conditionExecutor = ConditionExecutorFactory.getExecutor((IConditionData)memberFilter.getFilterCondition());
        ConditionContext context = new ConditionContext();
        context.setMemberGroupMap(execContext.getVarParseContext().getDimMemberGroup());
        context.setOlapData(execContext.getOlapData());
        context.setPageDimMembers(execContext.getPageDimNums());
        context.setFunctionDimMembers(new HashMap<String, MemberView>(dimNums.size()));
        context.setModelCacheHelper(execContext.getVarParseContext().getModelCacheHelper());
        ArrayList<List<String>> dimMembNumGroups = new ArrayList<List<String>>(16);
        int count = 1;
        while ((memberGroups = CommonServiceHelper.getDescartes((int)count, allMembNums)) != null) {
            for (int i = 0; i < dimNums.size(); ++i) {
                String dimNum2 = (String)dimNums.get(i);
                context.getFunctionDimMembers().put((String)dimNums.get(i), new MemberView((String)memberGroups.get(i), (Long)dimViewMap.get(dimNum2)));
            }
            if (conditionExecutor.getBoolean(context)) {
                dimMembNumGroups.add(memberGroups);
            }
            ++count;
        }
        MemberFilterResult result = new MemberFilterResult();
        result.setDimNums(dimNums);
        result.setDimMembNumGroups(dimMembNumGroups);
        result.getDimViewMap().putAll(dimViewMap);
        ConstantKeys.commonLog.info(String.format("%s-MemberRangeSize[Descartes:%s,Filtered:%s]", this.functionData.getNumber(), count - 1, dimMembNumGroups.size()));
        if (execContext.getLogSigns().contains("dimMembNums")) {
            CommonServiceHelper.handleLog((Log)ConstantKeys.commonLog, (String)String.format("%s:%s-%s", "AnalyseExec", "dimMembNums", this.functionData.getNumber()), (String)SerializationUtils.toJsonString(dimMembNums));
        }
        if (execContext.getLogSigns().contains("dimMembGroups")) {
            CommonServiceHelper.handleLog((Log)ConstantKeys.commonLog, (String)String.format("%s:%s-%s", "AnalyseExec", "dimMembGroups", this.functionData.getNumber()), (String)SerializationUtils.toJsonString(dimMembNumGroups));
        }
        return result;
    }

    private static class MemberFilterResult {
        private List<List<String>> dimMembNumGroups;
        private List<String> dimNums;
        private Map<String, Long> dimViewMap = new HashMap<String, Long>(16);

        private MemberFilterResult() {
        }

        public List<List<String>> getDimMembNumGroups() {
            return this.dimMembNumGroups;
        }

        public void setDimMembNumGroups(List<List<String>> dimMembNumGroups) {
            this.dimMembNumGroups = dimMembNumGroups;
        }

        public List<String> getDimNums() {
            return this.dimNums;
        }

        public void setDimNums(List<String> dimNums) {
            this.dimNums = dimNums;
        }

        public Map<String, Long> getDimViewMap() {
            return this.dimViewMap;
        }
    }

    private static class MemberGroupOLapData
    extends MemberGroupData {
        private BigDecimal olapVal;
        private boolean bigValUp = true;

        private MemberGroupOLapData() {
        }

        public void setOlapVal(BigDecimal olapVal) {
            this.olapVal = olapVal;
        }

        public BigDecimal getOlapVal() {
            if (this.olapVal == null) {
                this.olapVal = BigDecimal.ZERO;
            }
            return this.olapVal;
        }

        @Override
        public boolean isNull() {
            return this.olapVal == null || this.olapVal.compareTo(BigDecimal.ZERO) == 0;
        }

        @Override
        public int compareTo(@NotNull MemberGroupData o) {
            MemberGroupOLapData target = (MemberGroupOLapData)o;
            int result = this.getOlapVal().compareTo(target.getOlapVal());
            if (!this.bigValUp) {
                result *= -1;
            }
            return result;
        }

        public boolean isBigValUp() {
            return this.bigValUp;
        }

        public void setBigValUp(boolean bigValUp) {
            this.bigValUp = bigValUp;
        }
    }

    private static class MemberGroupStrData
    extends MemberGroupData {
        private String memberStr;

        private MemberGroupStrData() {
        }

        @Override
        public void setDimMembNumGroup(List<String> dimMembNumGroup) {
            super.setDimMembNumGroup(dimMembNumGroup);
            this.memberStr = String.join((CharSequence)",", dimMembNumGroup);
        }

        @Override
        public int compareTo(@NotNull MemberGroupData o) {
            MemberGroupStrData target = (MemberGroupStrData)o;
            String memberStr1 = target.getMemberStr();
            if (this.memberStr == null && memberStr1 != null) {
                return -1;
            }
            if (this.memberStr == null) {
                return 0;
            }
            if (memberStr1 == null) {
                return 1;
            }
            return this.memberStr.compareTo(memberStr1);
        }

        @Override
        public boolean isNull() {
            return StringUtils.isEmpty((String)this.memberStr);
        }

        public String getMemberStr() {
            return this.memberStr;
        }
    }

    private static class MemberGroupData
    implements Comparable<MemberGroupData> {
        private List<String> dimMembNumGroup;

        private MemberGroupData() {
        }

        @Override
        public int compareTo(@NotNull MemberGroupData o) {
            return 0;
        }

        public boolean isNull() {
            return false;
        }

        public List<String> getDimMembNumGroup() {
            return this.dimMembNumGroup;
        }

        public void setDimMembNumGroup(List<String> dimMembNumGroup) {
            this.dimMembNumGroup = dimMembNumGroup;
        }
    }
}

