/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.execute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analyzeReport.context.RptSectionExecContext;
import kd.epm.eb.business.analyzeReport.execute.IRptSectionExecutor;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.section.MultiTypeMember;
import kd.epm.eb.common.analysereport.pojo.section.RptSection;
import kd.epm.eb.common.analysereport.pojo.section.RptSectionExecResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.dto.ReportProcessQuote;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessQuoteService;
import kd.epm.eb.common.reportprocess.utils.ReportProcessUtil;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RptSectionExecutor
implements IRptSectionExecutor {
    private static final Log log = LogFactory.getLog(RptSectionExecutor.class);
    private Map<Long, String> allErrorInfo = new HashMap<Long, String>(16);

    @Override
    public RptSectionExecResult execute(RptSectionExecContext context) {
        long time1 = System.currentTimeMillis();
        IModelCacheHelper modelCacheHelper = context.getModelCacheHelper();
        Map<Long, RptSection> rptSectionMap = AnalyseReportUtil.getInstance().queryRptSection(context.getRptSectionIds());
        RptSectionExecResult result = new RptSectionExecResult();
        if (rptSectionMap.size() > 0) {
            Map dimViewMap = modelCacheHelper.getViewsByBusModelIncludeBase(context.getBizModelId());
            this.parseRptSection(rptSectionMap, modelCacheHelper, dimViewMap, context);
            Map<Long, ReportExportDataRequest> refRptProcess = this.buildExportRequest(rptSectionMap, dimViewMap, modelCacheHelper);
            this.handleLog(rptSectionMap, refRptProcess);
            this.readRptWord(refRptProcess, rptSectionMap, context, result);
        }
        if (CollectionUtils.isNotEmpty(this.allErrorInfo)) {
            result.getErrorSectionInfo().putAll(this.allErrorInfo);
        }
        long time2 = System.currentTimeMillis();
        log.info("RptSectionExec:" + (time2 - time1));
        return result;
    }

    private void handleLog(Map<Long, RptSection> rptSectionMap, Map<Long, ReportExportDataRequest> refRptProcess) {
        Set signByGroupNum = LogSignHelper.getLogSignByGropNum((String)"RptSectionExecutor");
        if (signByGroupNum.contains("rptSectionMap")) {
            CommonServiceHelper.handleLog((Log)log, (String)"rptSectionMap", (String)SerializationUtils.toJsonString(rptSectionMap));
        }
        if (signByGroupNum.contains("refRptProcess")) {
            CommonServiceHelper.handleLog((Log)log, (String)"refRptProcess", (String)SerializationUtils.toJsonString(refRptProcess));
        }
    }

    private void readRptWord(Map<Long, ReportExportDataRequest> refRptProcess, Map<Long, RptSection> rptSectionMap, RptSectionExecContext context, RptSectionExecResult result) {
        Map<Long, String> errorSectionInfo = this.getAllErrorInfo();
        ArrayList<ReportExportDataRequest> request = new ArrayList<ReportExportDataRequest>(refRptProcess.values());
        for (RptSection rptSection : rptSectionMap.values()) {
            if (refRptProcess.containsKey(rptSection.getId()) || errorSectionInfo.containsKey(rptSection.getId())) continue;
            errorSectionInfo.put(rptSection.getId(), ResManager.loadResFormat((String)"%1\u5207\u7247\u672a\u80fd\u5339\u914d\u4e0a\u62a5\u8868\u5b9e\u4f8b", (String)"RptSectionExecutor_1", (String)"epm-eb-business", (Object[])new Object[]{rptSection.getName()}));
        }
        List workbooks = (List)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"RptExportMService", (String)"exportRpt", (Object[])new Object[]{request, false});
        if (workbooks == null || workbooks.isEmpty()) {
            return;
        }
        SXSSFWorkbook sourceBook = (SXSSFWorkbook)workbooks.get(0);
        XSSFWorkbook workbook = sourceBook.getXSSFWorkbook();
        for (RptSection rptSection : rptSectionMap.values()) {
            Sheet sheet = workbook.getSheet(rptSection.getNumber());
            if (sheet == null && !errorSectionInfo.containsKey(rptSection.getId())) {
                errorSectionInfo.put(rptSection.getId(), ResManager.loadResFormat((String)"%1\u5207\u7247\u5173\u8054\u7684\u62a5\u8868\u4e0d\u5b58\u5728", (String)"RptSectionExecutor_2", (String)"epm-eb-business", (Object[])new Object[]{rptSection.getName()}));
                continue;
            }
            if (sheet == null || context.isNeedWorkbook()) continue;
            if (sheet.getLastRowNum() < 0) {
                sheet = sourceBook.getSheet(rptSection.getNumber());
            }
            result.getTables().put(rptSection.getId(), sheet);
        }
        if (context.isNeedWorkbook()) {
            result.setWorkbook((Workbook)sourceBook);
        }
    }

    private Map<Long, ReportExportDataRequest> buildExportRequest(Map<Long, RptSection> rptSectionMap, Map<String, Long> viewsByBusModel, IModelCacheHelper modelCacheHelper) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        HashMap<Long, ReportExportDataRequest> result = new HashMap<Long, ReportExportDataRequest>(16);
        HashMap dimStrSecIdMap = new HashMap(16);
        Map<Long, String> errorSectionInfo = this.getAllErrorInfo();
        StringBuilder sb = new StringBuilder(16);
        HashSet tempIds = new HashSet(16);
        HashSet entityIds = new HashSet(16);
        HashSet versionIds = new HashSet(16);
        HashSet dataTypeIds = new HashSet(16);
        HashSet periodIds = new HashSet(16);
        rptSectionMap.values().forEach(rptSection -> {
            if (!errorSectionInfo.containsKey(rptSection.getId())) {
                Map orderDimInfo = rptSection.getOrderDimInfo();
                Long entityId = this.getMemberId(orderDimInfo, SysDimensionEnum.Entity.getNumber());
                Long versionId = this.getMemberId(orderDimInfo, SysDimensionEnum.Version.getNumber());
                Long dataTypeId = this.getMemberId(orderDimInfo, SysDimensionEnum.DataType.getNumber());
                Long periodId = this.getMemberId(orderDimInfo, SysDimensionEnum.BudgetPeriod.getNumber());
                Long tempId = rptSection.getTemplateId();
                tempIds.add(tempId);
                versionIds.add(versionId);
                entityIds.add(entityId);
                dataTypeIds.add(dataTypeId);
                periodIds.add(periodId);
                sb.append(entityId).append(',').append(versionId).append(',').append(dataTypeId).append(',').append(periodId).append(',').append(tempId);
                dimStrSecIdMap.computeIfAbsent(sb.toString(), key -> new HashSet(16)).add(rptSection.getId());
                sb.setLength(0);
            }
        });
        HashSet<Long> existTempIds = new HashSet<Long>(16);
        HashSet processIds = new HashSet(16);
        ReportProcessUtil.queryProcess((Long)modelId, entityIds, periodIds, dataTypeIds, versionIds, tempIds, (tId, eId, dId, pId, vId, id) -> {
            sb.append(eId).append(',').append(vId).append(',').append(dId).append(',').append(pId).append(',').append(tId);
            Set refSectionIds = (Set)dimStrSecIdMap.get(sb.toString());
            if (refSectionIds != null) {
                for (Long sectionId : refSectionIds) {
                    ReportExportDataRequest exportDataRequest = new ReportExportDataRequest();
                    RptSection rptSection = (RptSection)rptSectionMap.get(sectionId);
                    exportDataRequest.setUserId(UserUtils.getUserId());
                    exportDataRequest.setTemplateId(tId);
                    exportDataRequest.setEntityId(eId);
                    exportDataRequest.setProcessId(id);
                    existTempIds.add(tId);
                    processIds.add(id);
                    MultiTypeMember orgMember = (MultiTypeMember)rptSection.getOrderDimInfo().get(SysDimensionEnum.Entity.getNumber());
                    if (orgMember != null) {
                        exportDataRequest.setEntityViewId(orgMember.getViewId());
                    }
                    exportDataRequest.setModelId(modelId);
                    exportDataRequest.setProcessType(ProcessTypeEnum.REPORT);
                    exportDataRequest.setIncludePageDim(Boolean.valueOf(false));
                    exportDataRequest.setSheetName(rptSection.getNumber());
                    exportDataRequest.setExportData(true);
                    exportDataRequest.setDivideCell(Boolean.valueOf(true));
                    exportDataRequest.setRemoveRange(false);
                    exportDataRequest.setExportTypeEnum(ReportExportTypeEnum.EXPORT_DATA);
                    exportDataRequest.setShowDimName(true);
                    HashMap pageViewDimMembers = new HashMap(16);
                    rptSection.getPageViewDimInfo().forEach((dimNumber, member) -> pageViewDimMembers.put(dimNumber, member.getMemberNumber()));
                    exportDataRequest.setDefaultDimMemberMap(pageViewDimMembers);
                    result.put(rptSection.getId(), exportDataRequest);
                }
            }
            sb.setLength(0);
        });
        if (processIds.size() > 0) {
            Map reportProcessQuote = ReportProcessQuoteService.getInstance().getReportProcessQuote(processIds, modelId);
            CommonServiceHelper.handleLogBySign((Log)log, (String)"reportProcessQuote", () -> SerializationUtils.toJsonString((Object)reportProcessQuote), (String)"RptSectionExecutor", (String)"reportProcessQuote");
            HashMap rptProcessIdMap = new HashMap(16);
            reportProcessQuote.forEach((typeEnum, value) -> value.forEach(quote -> rptProcessIdMap.put(quote.getReportProcessId(), new Pair(quote, typeEnum))));
            HashMap<Long, Map<String, Set<String>>> tempPageViewMembers = new HashMap<Long, Map<String, Set<String>>>(16);
            Map<Long, ITemplateModel> templateModelMap = this.loadTemplateModel(existTempIds);
            Iterator iterator = result.entrySet().iterator();
            HashMap<Long, Map> allVarVal = new HashMap<Long, Map>(16);
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Long rptSectionId = (Long)entry.getKey();
                RptSection rptSection2 = rptSectionMap.get(rptSectionId);
                ReportExportDataRequest request = (ReportExportDataRequest)entry.getValue();
                Long tempId = request.getTemplateId();
                Pair typeEnumPair = (Pair)rptProcessIdMap.get(request.getProcessId());
                ITemplateModel templateModel = templateModelMap.get(tempId);
                String errorStr = null;
                Long sourceId = null;
                Long orgViewId = null;
                if (templateModel == null) {
                    errorStr = ResManager.loadKDString((String)"\u5207\u7247\u5173\u8054\u7684\u6a21\u677f\u4e0d\u5b58\u5728", (String)"RptSectionExecutor_3", (String)"epm-eb-business", (Object[])new Object[0]);
                } else {
                    if (typeEnumPair == null) {
                        sourceId = 0L;
                    } else {
                        sourceId = ((ReportProcessQuote)typeEnumPair.p1).getSourceId2();
                        orgViewId = ((ReportProcessQuote)typeEnumPair.p1).getSourceId3();
                        request.setProcessType(((ReportProcessQuote)typeEnumPair.p1).getProcessTypeEnum());
                    }
                    MultiTypeMember orgMember = (MultiTypeMember)rptSection2.getOrderDimInfo().get(SysDimensionEnum.Entity.getNumber());
                    if (orgMember != null && !IDUtils.equals((Object)orgMember.getViewId(), (Object)orgViewId)) {
                        errorStr = ResManager.loadResFormat((String)"\u5207\u7247\u5173\u8054\u7684\u62a5\u8868\u9875\u9762\u7ef4\u6210\u5458\u4e0e\u5207\u7247\u7ef4\u5ea6\u53d6\u503c\u914d\u7f6e[%1:%2]\u65e0\u4ea4\u96c6\u3002", (String)"RptSectionExecutor_4", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.Entity.getNumber(), orgMember.getMemberNumber()});
                    } else {
                        Long _sourceId = sourceId;
                        Map varValues = allVarVal.computeIfAbsent(_sourceId, key -> key.equals(0L) ? new HashMap(16) : ReportVarUtil.getVarValues((Integer)((ProcessTypeEnum)typeEnumPair.p2).getIndex(), (Long)modelId, (Long)_sourceId));
                        Map pageViewDimInfo = rptSection2.getPageViewDimInfo();
                        for (Map.Entry memberEntry : pageViewDimInfo.entrySet()) {
                            String dimNum = (String)memberEntry.getKey();
                            MultiTypeMember member = (MultiTypeMember)memberEntry.getValue();
                            Set<String> memberNums = this.getOrLoadTempPageRangeMember(tempPageViewMembers, tempId, templateModel, dimNum, modelCacheHelper, viewsByBusModel, varValues);
                            if ((memberNums == null || memberNums.contains(member.getMemberNumber())) && (memberNums != null || !SysDimensionEnum.Entity.getNumber().equals(dimNum) || modelCacheHelper.getMember(dimNum, orgViewId, member.getMemberNumber()) != null)) continue;
                            errorStr = ResManager.loadResFormat((String)"\u5207\u7247\u5173\u8054\u7684\u62a5\u8868\u9875\u9762\u7ef4\u6210\u5458\u4e0e\u5207\u7247\u7ef4\u5ea6\u53d6\u503c\u914d\u7f6e[%1:%2]\u65e0\u4ea4\u96c6\u3002", (String)"RptSectionExecutor_4", (String)"epm-eb-business", (Object[])new Object[]{dimNum, member.getMemberNumber()});
                            break;
                        }
                    }
                }
                if (errorStr != null) {
                    this.getAllErrorInfo().put(rptSectionId, rptSection2.getName() + errorStr);
                    iterator.remove();
                    continue;
                }
                request.setReportProcessId(sourceId);
            }
        }
        return result;
    }

    private Set<String> getOrLoadTempPageRangeMember(Map<Long, Map<String, Set<String>>> tempPageViewMembers, Long tempId, ITemplateModel templateModel, String dimNumber, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap, Map<String, Map<String, String>> varValues) {
        Map dimMemberMap = tempPageViewMembers.computeIfAbsent(tempId, key -> new HashMap(16));
        HashSet<String> memberNums = (HashSet<String>)dimMemberMap.get(dimNumber);
        if (memberNums == null && !SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            memberNums = new HashSet<String>(16);
            List pageMemberEntry = templateModel.getPagemembentry();
            Long modelId = modelCacheHelper.getModelobj().getId();
            for (IPageDimensionEntry entry : pageMemberEntry) {
                if (!dimNumber.equals(entry.getDimension().getNumber())) continue;
                Map views = templateModel.getDimemsionViews();
                Long viewId = (Long)views.get(dimNumber);
                if (viewId == null) {
                    viewId = dimViewMap.get(dimNumber);
                }
                for (IDimensionMember member : entry.getMembers()) {
                    if (TemplateVarCommonUtil.checkIsVar((String)member.getNumber(), (String)dimNumber).booleanValue()) {
                        String memberNum;
                        Map<String, String> varValMap = varValues.get(dimNumber);
                        if (varValMap == null || (memberNum = kd.epm.eb.common.var.ReportVarUtil.getVarValueNoError((Long)modelId, (String)member.getNumber(), varValMap, (String)dimNumber)) == null) continue;
                        memberNums.add(memberNum);
                        continue;
                    }
                    List members = modelCacheHelper.getMember(dimNumber, viewId, member.getNumber(), member.getScope());
                    if (members == null) continue;
                    for (Member m : members) {
                        memberNums.add(m.getNumber());
                    }
                }
            }
            dimMemberMap.put(dimNumber, memberNums);
        }
        return memberNums;
    }

    private Map<Long, ITemplateModel> loadTemplateModel(Set<Long> templateIds) {
        DynamicObjectCollection tempObjs = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,data,templatetype", (QFilter[])new QFilter("id", "in", templateIds).toArray());
        HashMap<Long, ITemplateModel> tempModelMap = new HashMap<Long, ITemplateModel>(tempObjs.size());
        for (DynamicObject obj : tempObjs) {
            Long tempId = obj.getLong("id");
            String dataStr = obj.getString("data");
            String type = obj.getString("templatetype");
            ITemplateModel templateModel = BgTemplateTypeEnum.EBFIX.getNumber().equals(type) ? FixtemplateSerializerUtil.read((String)dataStr) : TemplateModelJSONUtil.parseITemplateModel((String)dataStr);
            tempModelMap.put(tempId, templateModel);
        }
        return tempModelMap;
    }

    private Long getMemberId(Map<String, MultiTypeMember> dimInfo, String dimNumber) {
        MultiTypeMember multiTypeMember = dimInfo.get(dimNumber);
        if (multiTypeMember == null) {
            return 0L;
        }
        return multiTypeMember.getMemberId();
    }

    public void parseRptSection(Map<Long, RptSection> rptSectionMap, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap, RptSectionExecContext context) {
        Map<String, MemberView> dimVarValues = context.getDimVarValues();
        Map<String, MemberView> paramDimValues = context.getParamDimValues();
        Map<String, Integer> allParamOffset = AnalyseReportUtil.getInstance().getAllParamOffset(context.getModelId(), context.getBizModelId());
        for (RptSection section : rptSectionMap.values()) {
            if (this.parseMemberEntry(section, section.getPageViewDimInfo(), modelCacheHelper, dimVarValues, paramDimValues, dimViewMap, allParamOffset)) continue;
            this.parseMemberEntry(section, section.getOrderDimInfo(), modelCacheHelper, dimVarValues, paramDimValues, dimViewMap, allParamOffset);
        }
    }

    private boolean parseMemberEntry(RptSection section, Map<String, MultiTypeMember> entryDimInfo, IModelCacheHelper modelCacheHelper, Map<String, MemberView> dimVarValues, Map<String, MemberView> paramDimValues, Map<String, Long> dimViewMap, Map<String, Integer> allParamOffset) {
        for (Map.Entry<String, MultiTypeMember> entry : entryDimInfo.entrySet()) {
            String errorInfo = null;
            String dimNumber = entry.getKey();
            MultiTypeMember member = entry.getValue();
            if (member.getType() == DimMemberTypeEnum.MEMBER && TemplateVarCommonUtil.checkIsVar((String)member.getMemberNumber(), (String)dimNumber).booleanValue()) {
                MemberView varVal = dimVarValues.get(member.getMemberNumber());
                errorInfo = varVal == null ? ResManager.loadResFormat((String)"%1\u53d8\u91cf%2\u672a\u8d4b\u503c", (String)"RptSectionExecutor_5", (String)"epm-eb-business", (Object[])new Object[]{dimNumber, member.getMemberNumber()}) : this.checkMember(modelCacheHelper, member, dimNumber, varVal.getMemberNumber(), varVal.getViewId());
            } else if (member.getType() == DimMemberTypeEnum.PARAM) {
                MemberView paramVal = paramDimValues.get(dimNumber);
                if (paramVal == null) {
                    errorInfo = ResManager.loadResFormat((String)"%1\u53c2\u6570\u672a\u8d4b\u503c", (String)"RptSectionExecutor_6", (String)"epm-eb-business", (Object[])new Object[]{dimNumber});
                } else {
                    String paramNum;
                    String paramValNumber = paramVal.getMemberNumber().split("!")[0];
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && StringUtils.isNotEmpty((String)(paramNum = member.getMemberNumber()))) {
                        Integer offsetVal = allParamOffset.get(paramNum);
                        if (offsetVal == null) {
                            errorInfo = ResManager.loadResFormat((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u671f\u95f4\u53c2\u6570[%1]\u7684\u504f\u79fb\u91cf", (String)"RptSectionExecutor_7", (String)"epm-eb-business", (Object[])new Object[]{paramNum});
                        } else {
                            try {
                                paramValNumber = TemplateVarCommonUtil.getPeriodOffset((String)paramValNumber, (int)offsetVal, (Long)modelCacheHelper.getModelobj().getId());
                            }
                            catch (Exception e) {
                                errorInfo = e.getMessage();
                            }
                        }
                    }
                    if (errorInfo == null) {
                        errorInfo = this.checkMember(modelCacheHelper, member, dimNumber, paramValNumber, paramVal.getViewId());
                    }
                }
            }
            if (errorInfo == null) continue;
            this.getAllErrorInfo().put(section.getId(), ResManager.loadResFormat((String)"%1\u89e3\u6790\u5931\u8d25\uff1a%2", (String)"RptSectionExecutor_8", (String)"epm-eb-business", (Object[])new Object[]{section.getName(), errorInfo}));
            return true;
        }
        return false;
    }

    private String checkMember(IModelCacheHelper modelCacheHelper, MultiTypeMember member, String dimNumber, String memberValNum, Long refViewId) {
        String errorInfo = null;
        Member memb = modelCacheHelper.getMember(dimNumber, refViewId, memberValNum);
        if (memb == null) {
            errorInfo = ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458%2\u4e0d\u5b58\u5728", (String)"RptSectionExecutor_9", (String)"epm-eb-business", (Object[])new Object[]{dimNumber, memberValNum});
        } else {
            member.setMemberId(memb.getId());
            member.setMemberNumber(memb.getNumber());
            member.setType(DimMemberTypeEnum.MEMBER);
            member.setViewId(refViewId);
        }
        return errorInfo;
    }

    public Map<Long, String> getAllErrorInfo() {
        return this.allErrorInfo;
    }
}

