/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.factory;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.eb.business.analyzeReport.execute.ConditionAndExecutor;
import kd.epm.eb.business.analyzeReport.execute.ConditionExecutor;
import kd.epm.eb.business.analyzeReport.execute.ConditionOrExecutor;
import kd.epm.eb.business.analyzeReport.execute.ConditionRowExecutor;
import kd.epm.eb.business.analyzeReport.execute.IConditionExecutor;
import kd.epm.eb.business.analyzeReport.execute.MultiResConditionExecutor;
import kd.epm.eb.common.analysereport.pojo.VarParams;
import kd.epm.eb.common.analysereport.pojo.condition.AbstractCondition;
import kd.epm.eb.common.analysereport.pojo.condition.Condition;
import kd.epm.eb.common.analysereport.pojo.condition.IConditionData;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.analysereport.pojo.condition.MultiResultCondition;
import kd.epm.eb.common.analysereport.pojo.condition.ResultJdCondition;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ConditionExecutorFactory {
    public static IConditionExecutor parserAndSelParam(DynamicObject obj, VarParams varParams) {
        DynamicObjectCollection conditionRows = obj.getDynamicObjectCollection("entryentity");
        if (conditionRows != null && !conditionRows.isEmpty()) {
            MultiResultCondition multiResultCondition = new MultiResultCondition();
            multiResultCondition.setNumber(obj.getString("number"));
            ResultJdCondition condition = new ResultJdCondition();
            Condition preCondition = null;
            for (DynamicObject row : conditionRows) {
                Condition conditionRow = new Condition();
                conditionRow.setCompareSign(row.getString("comparesymbol"));
                if (preCondition != null) {
                    String connect = row.getString("connector");
                    if (StringUtils.isEmpty((String)connect)) {
                        connect = "or";
                    }
                    preCondition.setConnectSign(connect);
                }
                conditionRow.setRightValueType(row.getString("offsettype"));
                conditionRow.setRightNumVal(row.getBigDecimal("compareresult"));
                conditionRow.setLeftVal(Long.valueOf(row.getLong("source.id")));
                conditionRow.setRightVal(Long.valueOf(row.getLong("compare.id")));
                varParams.getDimMemberGroupIds().add(conditionRow.getLeftVal());
                varParams.getDimMemberGroupIds().add(conditionRow.getRightVal());
                condition.addCondition(conditionRow);
                if (row.getBoolean("isend")) {
                    condition.setGraph(row.getString("warngraph"));
                    condition.setWord(row.getString("worddisplay"));
                    condition.setNumberDisplay("1".equals(row.getString("numberdisplay")));
                    multiResultCondition.getConditions().add(condition);
                    condition = new ResultJdCondition();
                    preCondition = null;
                    continue;
                }
                preCondition = conditionRow;
            }
            return ConditionExecutorFactory.getExecutor((IConditionData)multiResultCondition);
        }
        return null;
    }

    public static IConditionExecutor getExecutor(@NotNull IConditionData conditionData) {
        if (conditionData instanceof MultiResultCondition) {
            return ConditionExecutorFactory.getMultiResultExecutor((MultiResultCondition)conditionData);
        }
        return ConditionExecutorFactory.getJudgeExecutor((JudgeCondition)conditionData);
    }

    private static IConditionExecutor getMultiResultExecutor(@NotNull MultiResultCondition conditionData) {
        MultiResConditionExecutor executor = new MultiResConditionExecutor();
        List conditions = conditionData.getConditions();
        ArrayList<IConditionExecutor> executorList = new ArrayList<IConditionExecutor>(conditions.size());
        for (ResultJdCondition condition : conditions) {
            IConditionExecutor conditionExecutor = ConditionExecutorFactory.getJudgeExecutor((JudgeCondition)condition);
            executorList.add(conditionExecutor);
        }
        executor.setExecutorList(executorList);
        executor.setCondition(conditionData);
        return executor;
    }

    private static IConditionExecutor getJudgeExecutor(@NotNull JudgeCondition judgeCondition) {
        List conditionList = judgeCondition.getConditionList();
        return ConditionExecutorFactory.getExecutor(conditionList, condition -> {
            ConditionRowExecutor conditionRow = new ConditionRowExecutor();
            conditionRow.setConditionRow((Condition)condition);
            return conditionRow;
        });
    }

    public static ConditionExecutor getExecutor(List<? extends AbstractCondition> allCondition, Function<AbstractCondition, ConditionExecutor> rowExecutorBuilder) {
        LinkedList conditionList = new LinkedList();
        int count = 1;
        int size = allCondition.size();
        for (AbstractCondition abstractCondition : allCondition) {
            int bracketCount;
            ConditionExecutor conditionRow = rowExecutorBuilder.apply(abstractCondition);
            ConditionExecutor executor = "or".equals(abstractCondition.getConnectSign()) || "|".equals(abstractCondition.getConnectSign()) || count == size ? new ConditionOrExecutor() : ("and".equals(abstractCondition.getConnectSign()) || "&".equals(abstractCondition.getConnectSign()) ? new ConditionAndExecutor() : new ConditionOrExecutor());
            if (bracketCount >= 0) {
                Object preObj;
                do {
                    if ((preObj = conditionList.poll()) instanceof String) {
                        if (bracketCount == 0) {
                            conditionList.addFirst(preObj);
                        }
                        --bracketCount;
                        continue;
                    }
                    if (!(preObj instanceof ConditionExecutor)) continue;
                    ConditionExecutor preObjCondition = (ConditionExecutor)preObj;
                    preObjCondition.setRight(conditionRow);
                    conditionRow = preObjCondition;
                } while (bracketCount >= 0 && preObj != null);
            } else {
                for (bracketCount = abstractCondition.getRightB() - abstractCondition.getLeftB(); bracketCount < 0; ++bracketCount) {
                    conditionList.addFirst("(");
                }
            }
            executor.setLeft(conditionRow);
            conditionList.addFirst(executor);
            ++count;
        }
        Object result = conditionList.poll();
        if (result instanceof ConditionExecutor) {
            return (ConditionExecutor)result;
        }
        return new ConditionExecutor();
    }
}

