/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.factory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.analyzeReport.execute.DimGroupBgRateExecutor;
import kd.epm.eb.business.analyzeReport.execute.DimGroupExecutor;
import kd.epm.eb.business.analyzeReport.execute.DimGroupFormulaExecutor;
import kd.epm.eb.business.analyzeReport.execute.DimGroupPeriodDivExecutor;
import kd.epm.eb.business.analyzeReport.execute.DimGroupPeriodExecutor;
import kd.epm.eb.business.analyzeReport.execute.IDimGroupExecutor;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.analysereport.constants.ApplicableObjectEnum;
import kd.epm.eb.common.analysereport.constants.DataFormatTypeEnum;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.VarParams;
import kd.epm.eb.common.analysereport.pojo.formula.DimGroupDataFormat;
import kd.epm.eb.common.analysereport.pojo.formula.FormulaCheckResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class DimGroupExecutorFactory {
    public static IDimGroupExecutor parserAndSelParam(DynamicObject obj, IModelCacheHelper modelCacheHelper, Map<Long, Map<String, Set<String>>> dimMemberNums, VarParams varParams, Set<Long> formulaDimGroups) {
        String groupType = obj.getString("dimgrouptype");
        DimGroupTypeEnum dimGroupType = DimGroupTypeEnum.getDimGroupEnumByIndex((String)groupType);
        if (DimGroupTypeEnum.NUMBER == dimGroupType) {
            String suitType = obj.getString("suitobject");
            String dataFormat = obj.getString("dataformat");
            Long datasetId = obj.getLong("dataset.id");
            int digit = obj.getInt("digit");
            String unit = obj.getString("unit");
            String dataType = obj.getString("metricdatatype");
            if (StringUtils.isEmpty((String)dataType)) {
                dataType = obj.getString("metric.datatype");
            }
            List dimensionList = modelCacheHelper.getDimensionList(datasetId);
            HashMap<String, Integer> dimIndex = new HashMap<String, Integer>(dimensionList.size());
            for (int index = 0; index < dimensionList.size(); ++index) {
                dimIndex.put(((Dimension)dimensionList.get(index)).getNumber(), index + 1);
            }
            Object[] memberNums = new String[dimIndex.size() + 1];
            HashMap<String, Integer> functionDimIndex = new HashMap<String, Integer>(16);
            HashMap<String, Integer> paramDimIndex = new HashMap<String, Integer>(16);
            Map dimMembers = dimMemberNums.computeIfAbsent(datasetId, key -> new HashMap(16));
            DimGroupExecutorFactory.selectDimGroupParam((String[])memberNums, dimIndex, obj, functionDimIndex, paramDimIndex, dimMembers, varParams.getMemberVarInfoMap());
            PeriodInfo periodInfo = DimGroupExecutorFactory.parserPeriod(varParams.getPageDimMembers(), (String[])memberNums, dimIndex, paramDimIndex, varParams.getModelId());
            DimGroupExecutor executor = DimGroupExecutorFactory.parserDimGroup(periodInfo, suitType, modelCacheHelper, dimMembers, dimIndex);
            executor.setFunctionDimIndex(functionDimIndex);
            executor.setParamDimIndex(paramDimIndex);
            executor.setMembersKey(new MembersKey(memberNums));
            executor.setDatasetId(datasetId);
            executor.setSuitObject(suitType);
            DimGroupDataFormat dimGroupDataFormat = new DimGroupDataFormat(DataFormatTypeEnum.getDataFormatTypeEnumByIndex((String)dataFormat), digit);
            if (MetricDataTypeEnum.CURRENCY.getIndex().equals(dataType)) {
                dimGroupDataFormat.setUnit(Convert.toInt((Object)unit, (Integer)0).intValue());
            }
            executor.setMetricDataType(MetricDataTypeEnum.getByIndex((String)dataType));
            executor.setDimGroupDataFormat(dimGroupDataFormat);
            return executor;
        }
        String formulaString = obj.getString("formula");
        long modelId = obj.getLong("model.id");
        long bizModelId = obj.getLong("bizmodel.id");
        String dataFormat = obj.getString("dataformat");
        int digit = obj.getInt("digit");
        String unit = obj.getString("unit_formula");
        String name = obj.getString("name");
        DimGroupFormulaExecutor executor = new DimGroupFormulaExecutor();
        DimGroupDataFormat dimGroupDataFormat = new DimGroupDataFormat(Convert.toInt((Object)unit, (Integer)0).intValue(), DataFormatTypeEnum.getDataFormatTypeEnumByIndex((String)dataFormat), digit);
        executor.setDimGroupDataFormat(dimGroupDataFormat);
        executor.setFormulaName(name);
        FormulaCheckResult formulaCheckResult = AnalyseReportUtil.getInstance().parseToFormulaNode(formulaString, modelId, bizModelId, false);
        executor.setFormulaNode(formulaCheckResult.getFormulaNode());
        List relateDimGroups = formulaCheckResult.getRelateDimGroups();
        executor.setRefDimGroupIds(relateDimGroups);
        formulaDimGroups.addAll(relateDimGroups);
        return executor;
    }

    private static void selectDimGroupParam(String[] memberNums, Map<String, Integer> dimIndex, DynamicObject obj, Map<String, Integer> functionDimIndex, Map<String, Integer> paramDimIndex, Map<String, Set<String>> dimMembers, Map<String, MemberView> varInfoMap) {
        String accountNum = obj.getString("account.number");
        String metricNum = obj.getString("metric.number");
        memberNums[dimIndex.get((Object)SysDimensionEnum.Account.getNumber()).intValue()] = accountNum;
        memberNums[dimIndex.get((Object)SysDimensionEnum.Metric.getNumber()).intValue()] = metricNum;
        dimMembers.computeIfAbsent(SysDimensionEnum.Account.getNumber(), key -> new HashSet(16)).add(accountNum);
        dimMembers.computeIfAbsent(SysDimensionEnum.Metric.getNumber(), key -> new HashSet(16)).add(metricNum);
        obj.getDynamicObjectCollection("memberentry").forEach(row -> {
            String dimNum = row.getString("dimension.number");
            String membType = row.getString("dimmembertype");
            DimMemberTypeEnum dimMemberType = DimMemberTypeEnum.getDimMemberTypeEnumByIndex((String)membType);
            Integer index = (Integer)dimIndex.get(dimNum);
            if (index != null) {
                if (DimMemberTypeEnum.MEMBER == dimMemberType) {
                    String membNum = row.getString("member.number");
                    String memberClassType = row.getString("memberclasstype");
                    if ("eb_periodvariable".equals(memberClassType)) {
                        MemberView memberView = (MemberView)varInfoMap.get(membNum);
                        membNum = memberView == null ? null : memberView.getMemberNumber();
                    }
                    memberNums[index.intValue()] = membNum;
                    if (StringUtils.isNotEmpty((String)membNum)) {
                        dimMembers.computeIfAbsent(dimNum, key -> new HashSet(16)).add(membNum);
                    }
                } else if (DimMemberTypeEnum.PARAM == dimMemberType) {
                    String idStr = row.getString("member.id");
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNum)) {
                        memberNums[index.intValue()] = idStr;
                    }
                    paramDimIndex.put(dimNum, index);
                } else if (DimMemberTypeEnum.FUNCTION == dimMemberType) {
                    functionDimIndex.put(dimNum, index);
                }
            }
        });
    }

    private static PeriodInfo parserPeriod(Map<String, MemberView> pageMemberNums, String[] memberNums, Map<String, Integer> dimIndex, Map<String, Integer> paramDimIndex, Long modelId) {
        String srcPeriod;
        Integer periodIndex = paramDimIndex.get(SysDimensionEnum.BudgetPeriod.getNumber());
        int periodOffset = 0;
        if (periodIndex == null) {
            periodIndex = dimIndex.get(SysDimensionEnum.BudgetPeriod.getNumber());
            srcPeriod = memberNums[periodIndex];
        } else {
            MemberView memberView = pageMemberNums.get(SysDimensionEnum.BudgetPeriod.getNumber());
            srcPeriod = memberView == null ? null : memberView.getMemberNumber();
            String paramIdStr = memberNums[periodIndex];
            if (StringUtils.isNotEmpty((String)paramIdStr)) {
                DynamicObject paramObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(paramIdStr), (String)VariableTypeEnum.Parameter.getMetadata(), (String)"offset,name");
                if (paramObj == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u671f\u95f4\u504f\u79fb\u91cf\u5931\u8d25\uff1a%1\u3002", (String)"DimGroupExecutorFactory_1", (String)"epm-eb-business", (Object[])new Object[]{paramIdStr}));
                }
                periodOffset = paramObj.getInt("offset");
                String offsetPeriod = TemplateVarCommonUtil.getOff((String)srcPeriod, (int)periodOffset, (Long)modelId);
                if (offsetPeriod == null || offsetPeriod.equalsIgnoreCase("error")) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u671f\u95f4\u53d8\u91cf\u201c%1\u201d\u9009\u62e9\u7684\u671f\u95f4\u503c\u201c%2\u201d\u504f\u79fb\u201c%3\u201d\u540e\u7684\u671f\u95f4\u503c\u4e0d\u5728\u5f53\u524d\u4f53\u7cfb\u7684\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DimGroupExecutorFactory_2", (String)"epm-eb-business", (Object[])new Object[]{paramObj.getString("name"), srcPeriod, periodOffset}));
                }
                srcPeriod = offsetPeriod;
            }
        }
        return new PeriodInfo(srcPeriod, periodOffset);
    }

    private static DimGroupExecutor parserDimGroup(PeriodInfo periodInfo, String suitType, IModelCacheHelper modelCacheHelper, Map<String, Set<String>> dimMemberNums, Map<String, Integer> dimIndex) {
        Integer periodIndex = dimIndex.get(SysDimensionEnum.BudgetPeriod.getNumber());
        String srcPeriod = periodInfo.sourcePeriod;
        int periodOffset = periodInfo.offset;
        DimGroupExecutor executor = null;
        String refPeriod = null;
        ApplicableObjectEnum applyEnum = ApplicableObjectEnum.getEnumByIndex((String)suitType);
        if (ApplicableObjectEnum.YoyGrowth == applyEnum || ApplicableObjectEnum.YearOnYear == applyEnum) {
            refPeriod = AnalyseReportUtil.getInstance().calcPeriod(srcPeriod, modelCacheHelper, false);
            executor = new DimGroupPeriodDivExecutor(periodIndex, ApplicableObjectEnum.YoyGrowth == applyEnum, false, periodOffset);
        } else if (ApplicableObjectEnum.RingGrowth == applyEnum || ApplicableObjectEnum.Ring == applyEnum) {
            refPeriod = AnalyseReportUtil.getInstance().calcPeriod(srcPeriod, modelCacheHelper, true);
            executor = new DimGroupPeriodDivExecutor(periodIndex, ApplicableObjectEnum.RingGrowth == applyEnum, true, periodOffset);
        } else if (ApplicableObjectEnum.BudgetExeGrowth == applyEnum) {
            Set dataSetNums = dimMemberNums.computeIfAbsent(SysDimensionEnum.DataType.getNumber(), key -> new HashSet(16));
            dataSetNums.add("Actual");
            dataSetNums.add("Budget");
            executor = new DimGroupBgRateExecutor(dimIndex.get(SysDimensionEnum.DataType.getNumber()));
        }
        if (refPeriod != null) {
            dimMemberNums.computeIfAbsent(SysDimensionEnum.BudgetPeriod.getNumber(), key -> new HashSet(16)).add(refPeriod);
        }
        dimMemberNums.computeIfAbsent(SysDimensionEnum.BudgetPeriod.getNumber(), key -> new HashSet(16)).add(srcPeriod);
        if (executor == null) {
            executor = periodOffset != 0 ? new DimGroupPeriodExecutor(periodIndex, periodOffset) : new DimGroupExecutor();
        }
        return executor;
    }

    private static class PeriodInfo {
        private String sourcePeriod;
        private int offset;

        public PeriodInfo(String sourcePeriod, int offset) {
            this.sourcePeriod = sourcePeriod;
            this.offset = offset;
        }
    }
}

