/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.factory;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.business.analyzeReport.execute.DefaultFunctionExecutor;
import kd.epm.eb.business.analyzeReport.execute.IFunctionExecutor;
import kd.epm.eb.business.analyzeReport.execute.OrderFunctionExecutor;
import kd.epm.eb.common.analysereport.constants.FieldTypeEnum;
import kd.epm.eb.common.analysereport.constants.FunctionEnum;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.pojo.VarParams;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.analysereport.pojo.functions.Function;
import kd.epm.eb.common.analysereport.pojo.functions.OrderFunction;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberFilter;
import kd.epm.eb.common.analysereport.pojo.functions.steps.ShowLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.SortWay;
import kd.epm.eb.common.utils.IDUtils;

public class FunctionExecutorFactory {
    public static IFunctionExecutor parserAndSelParam(DynamicObject obj, VarParams varParams) {
        String functionType = obj.getString("type");
        FunctionEnum functionEnum = FunctionEnum.getFunctionEnumByFullName((String)functionType);
        Function function = Function.getInstance((FunctionEnum)functionEnum);
        function.setNumber(obj.getString("number"));
        String stepDatas = obj.getString("allstepdata_tag");
        function.setStepData(stepDatas);
        function.setModelId(Long.valueOf(obj.getLong("model.id")));
        if (functionEnum == FunctionEnum.ORDER && varParams != null) {
            FunctionExecutorFactory.selectParams(varParams, function);
        }
        return FunctionExecutorFactory.getExecutor(function);
    }

    public static void selectParams(VarParams varParams, Function functionData) {
        ShowLayout showLayout;
        SortWay sortWay;
        MemberFilter filter = (MemberFilter)functionData.getStepData(FunctionStepEnum.MEMBERFILTER);
        if (filter != null) {
            FunctionExecutorFactory.selectParamsOnCondition(filter.getFilterCondition(), varParams);
        }
        if ((sortWay = (SortWay)functionData.getStepData(FunctionStepEnum.SORTWAY)) != null) {
            FunctionExecutorFactory.selectParamsOnCondition(sortWay.getSortCondition(), varParams);
            if (IDUtils.isNotEmptyLong((Long)sortWay.getSortAccord()).booleanValue()) {
                varParams.getDimMemberGroupIds().add(sortWay.getSortAccord());
            }
        }
        if ((showLayout = (ShowLayout)functionData.getStepData(FunctionStepEnum.SHOWSETTING)) != null) {
            List fieldLayoutList = showLayout.getFieldLayoutList();
            fieldLayoutList.forEach(fieldLayout -> {
                String fieldType = fieldLayout.getFieldType();
                if (FieldTypeEnum.CONDITION.getValue().equals(fieldType)) {
                    varParams.getConditionIds().add(IDUtils.toLong((Object)fieldLayout.getShowField()));
                } else if (FieldTypeEnum.DIMGROUP.getValue().equals(fieldType)) {
                    varParams.getDimMemberGroupIds().add(IDUtils.toLong((Object)fieldLayout.getShowField()));
                }
            });
        }
    }

    private static void selectParamsOnCondition(JudgeCondition filterCondition, VarParams varParams) {
        Set dimMemberGroupIds = varParams.getDimMemberGroupIds();
        if (filterCondition != null) {
            filterCondition.getConditionList().forEach(condition -> {
                dimMemberGroupIds.add(condition.getLeftVal());
                if (IDUtils.isNotEmptyLong((Long)condition.getRightVal()).booleanValue()) {
                    dimMemberGroupIds.add(condition.getRightVal());
                }
            });
        }
    }

    public static IFunctionExecutor getExecutor(Function functionData) {
        FunctionEnum functionType = functionData.getFunctionType();
        if (functionType == FunctionEnum.ORDER) {
            return new OrderFunctionExecutor((OrderFunction)functionData);
        }
        return new DefaultFunctionExecutor();
    }
}

