/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptExportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptVarExportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.CombinationExportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.ConditionExportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.FunctionExportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.TempExportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.TempVarRefExportHandler;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.VarExportContext;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.impexp.ZipFileData;
import kd.epm.eb.common.impexp.ZipFileType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;

public class ARptExportService {
    private static final ARptExportService instance = new ARptExportService();

    public static ARptExportService getInstance() {
        return instance;
    }

    private ARptExportService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportVar(IFormView formView, Long modelId, Long bizModelId) {
        VarExportContext varExportContext = new VarExportContext();
        varExportContext.setBizModelId(bizModelId);
        varExportContext.setModelId(modelId);
        CommonUtils.putVarExportContext((VarExportContext)varExportContext);
        HashMap<String, Object> allData = new HashMap<String, Object>(16);
        try {
            this.readVarData(allData, VariableTypeEnum.Parameter, modelId, bizModelId);
            this.readVarData(allData, VariableTypeEnum.Combination, modelId, bizModelId);
            this.readVarData(allData, VariableTypeEnum.Condition, modelId, bizModelId);
            this.readVarData(allData, VariableTypeEnum.Function, modelId, bizModelId);
            allData.put("model", CommonServiceHelper.getValueFromDB((String)"epm_model", (String)"shownumber", (String)"id", (Object[])new Object[]{modelId}));
            allData.put("bizModel", CommonServiceHelper.getValueFromDB((String)"eb_businessmodel", (String)"number", (String)"id", (Object[])new Object[]{bizModelId}));
        }
        finally {
            CommonUtils.removeVarExportContext();
        }
        String bizModelName = (String)CommonServiceHelper.getValueFromDB((String)"eb_businessmodel", (String)"name", (String)"id", (Object[])new Object[]{bizModelId});
        String url = ImportAndExportUtil.downloadJsonFile(SerializationUtils.toJsonString(allData), ResManager.loadResFormat((String)"%1\u4e1a\u52a1\u6a21\u578b\u5206\u6790\u62a5\u544a\u53d8\u91cf", (String)"ARptExportService_1", (String)"epm-eb-business", (Object[])new Object[]{bizModelName}));
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    public void exportTemp(IFormView formView, Long modelId, List<Long> selTempIds) {
        TempExportHandler tempExportHandler = new TempExportHandler(modelId);
        QFilter qFilter = new QFilter("id", "in", selTempIds);
        List<Map<String, Object>> allRowData = this.readData("eb_analysereporttemplate", qFilter, (ARptExportHandler)tempExportHandler);
        qFilter = new QFilter("rpttemp", "in", selTempIds);
        qFilter.and("vartype", "!=", (Object)VariableTypeEnum.RptSection.getNumber());
        TempVarRefExportHandler refExportHandler = new TempVarRefExportHandler(allRowData);
        this.readData("eb_analysevarsel", qFilter, (ARptExportHandler)refExportHandler);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, Object> allData = new HashMap<String, Object>(16);
        allData.put("model", modelCacheHelper.getModelobj().getNumber());
        allData.put("tempData", allRowData);
        LinkedList<ZipFileData> dataList = new LinkedList<ZipFileData>();
        dataList.add(new ZipFileData("allTempRefData", ZipFileType.JSON, (Object)SerializationUtils.toJsonString(allData)));
        dataList.addAll(tempExportHandler.getAllTempFileUrlInfo());
        ImportAndExportUtil.zipDownloadFields(formView, dataList, ResManager.loadResFormat((String)"%1\u4f53\u7cfb\u5206\u6790\u62a5\u544a\u6a21\u677f", (String)"ARptExportService_2", (String)"epm-eb-business", (Object[])new Object[]{modelCacheHelper.getModelobj().getName()}));
    }

    private void readVarData(Map<String, Object> allData, VariableTypeEnum variableType, Long modelId, Long bizModelId) {
        String formKey = variableType.getMetadata();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("bizmodel", "=", (Object)bizModelId);
        ARptExportHandler exportHandler = this.getExportHandler(variableType);
        List<Map<String, Object>> allRowData = this.readData(formKey, qFilter, exportHandler);
        allData.put(variableType.getNumber(), allRowData);
    }

    private List<Map<String, Object>> readData(String formKey, QFilter qFilter, ARptExportHandler exportHandler) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)formKey);
        BillColGroup colConfig = BillImpExpUtils.getColConfig(formKey, (IDataEntityType)entityType, true, null, false, false, exportHandler.getIgnoreFields());
        return this.readData(colConfig, qFilter, exportHandler);
    }

    private ARptExportHandler getExportHandler(VariableTypeEnum variableType) {
        ARptVarExportHandler handler;
        VarExportContext varExportContext = CommonUtils.getVarExportContext();
        switch (variableType) {
            case Function: {
                handler = new FunctionExportHandler(varExportContext);
                break;
            }
            case Combination: {
                handler = new CombinationExportHandler(varExportContext);
                break;
            }
            case Condition: {
                handler = new ConditionExportHandler(varExportContext);
                break;
            }
            default: {
                handler = new ARptVarExportHandler(varExportContext);
            }
        }
        return handler;
    }

    private List<Map<String, Object>> readData(BillColGroup colGroup, QFilter filter, ARptExportHandler exportHandler) {
        DynamicObject[] objects = ImportAndExportUtil.loadObjs(colGroup, filter);
        LinkedList<Map<String, Object>> rowsData = new LinkedList<Map<String, Object>>();
        for (DynamicObject obj : objects) {
            Map<String, Object> rowData = this.selObjData(colGroup, obj);
            exportHandler.selOtherInfo(obj, rowData);
            rowsData.add(rowData);
        }
        exportHandler.handleData(rowsData);
        return rowsData;
    }

    private Map<String, Object> selObjData(BillColGroup colGroup, DynamicObject obj) {
        HashMap<String, Object> row = new HashMap<String, Object>(16);
        colGroup.getBaseCols().values().forEach(col -> {
            Object val = col.getVal(obj);
            if (val != null) {
                if (val instanceof Pair) {
                    val = ((Pair)val).p1;
                }
                row.put(col.getRealKey(), val);
            }
        });
        colGroup.getChildEntrys().values().forEach(group -> {
            DynamicObjectCollection objectCollection = obj.getDynamicObjectCollection(group.getGroupKey());
            if (CollectionUtils.isNotEmpty((Collection)objectCollection)) {
                LinkedList<Map<String, Object>> entryRowsData = new LinkedList<Map<String, Object>>();
                for (DynamicObject object : objectCollection) {
                    entryRowsData.add(this.selObjData((BillColGroup)group, object));
                }
                row.put(group.getGroupKey(), entryRowsData);
            }
        });
        return row;
    }

    private void replaceRefData(List<Map<String, Object>> rowsData) {
    }

    private Map<Long, String> readIdNumberMap(String entryFormKey, Set<Long> ids) {
        return null;
    }

    private void addLog() {
    }
}

