/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.analyzeReport.impexp.handler.ARptVarImportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.CombinationImportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.ConditionImportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.FunctionImportHandler;
import kd.epm.eb.business.analyzeReport.impexp.handler.ParamImportHandler;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.VarDataCount;
import kd.epm.eb.common.analysereport.pojo.VarImportContext;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.io.IOUtils;

public class ARptImportService {
    private static final Log log = LogFactory.getLog(ARptImportService.class);
    private static final ARptImportService instance = new ARptImportService();

    public static ARptImportService getInstance() {
        return instance;
    }

    private ARptImportService() {
    }

    public VarDataCount importVar(Long modelId, Long bizModelId, boolean isReplace, InputStream inputStream) {
        Map<String, Object> jsonData = this.readJsonData(inputStream);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        VarImportContext importContext = new VarImportContext();
        importContext.setBizModelId(bizModelId);
        importContext.setModelCacheHelper(modelCacheHelper);
        importContext.setReplace(isReplace);
        importContext.setCurrentTime(TimeServiceHelper.now());
        importContext.setCurrentUser(UserUtils.getUserId());
        try (TXHandle txHandle = TX.required();){
            try {
                this.getVarImportHandler(VariableTypeEnum.Parameter).doImport((List)jsonData.get(VariableTypeEnum.Parameter.getNumber()), importContext);
                this.getVarImportHandler(VariableTypeEnum.Combination).doImport((List)jsonData.get(VariableTypeEnum.Combination.getNumber()), importContext);
                this.getVarImportHandler(VariableTypeEnum.Condition).doImport((List)jsonData.get(VariableTypeEnum.Condition.getNumber()), importContext);
                this.getVarImportHandler(VariableTypeEnum.Function).doImport((List)jsonData.get(VariableTypeEnum.Function.getNumber()), importContext);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
        return importContext.getVarDataCount();
    }

    private ARptVarImportHandler getVarImportHandler(VariableTypeEnum variableTypeEnum) {
        ARptVarImportHandler handler;
        switch (variableTypeEnum) {
            case Function: {
                handler = new FunctionImportHandler();
                break;
            }
            case Condition: {
                handler = new ConditionImportHandler();
                break;
            }
            case Combination: {
                handler = new CombinationImportHandler();
                break;
            }
            default: {
                handler = new ParamImportHandler();
            }
        }
        handler.setVariableTypeEnum(variableTypeEnum);
        return handler;
    }

    private Map<String, Object> readJsonData(InputStream inputStream) {
        Map data;
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String sourceJson = new String(bytes);
            data = (Map)SerializationUtils.fromJsonString((String)sourceJson, HashMap.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef", (String)"ARptImportService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return data;
    }

    public boolean importTemplate(Long modelId, InputStream inputStream) {
        return true;
    }
}

