/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analyzeReport.impexp.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.business.quote.QuoteSave;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.VarImportContext;
import kd.epm.eb.common.analysereport.pojo.fileimport.RptVarImportLog;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimStrInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;

public abstract class ARptVarImportHandler {
    private VariableTypeEnum variableTypeEnum;
    private BillColGroup colConfig;
    private List<DynamicObject> updateObjs = new LinkedList<DynamicObject>();
    private List<DynamicObject> newObjs = new LinkedList<DynamicObject>();
    private List<MemberQuoteDao> memberQuoteList = new LinkedList<MemberQuoteDao>();
    private List<DynamicObject> logObjs = new LinkedList<DynamicObject>();
    private VarImportContext importContext;
    private Set<String> newNumbers = new HashSet<String>(16);

    public Long getCurrentUser() {
        return this.getImportContext().getCurrentUser();
    }

    public Date getCurrentTime() {
        return this.getImportContext().getCurrentTime();
    }

    protected void addSussLog(DynamicObject obj) {
        String name = obj.getString("name");
        String number = obj.getString("number");
        String varType = this.getVariableTypeEnum().getNumber();
        DynamicObject object = RptVarImportLog.toDynamicObject((Long)this.getModelId(), (Long)this.getBizModelId(), (String)number, (String)name, (String)varType, (boolean)this.isReplace(), (boolean)true, null);
        object.set("modifydate", (Object)this.getCurrentTime());
        this.logObjs.add(object);
    }

    protected void addRowErrorLog(String number, String name, String errorInfo) {
        String varType = this.getVariableTypeEnum().getNumber();
        DynamicObject object = RptVarImportLog.toDynamicObject((Long)this.getModelId(), (Long)this.getBizModelId(), (String)number, (String)name, (String)varType, (boolean)this.isReplace(), (boolean)false, (String)errorInfo);
        object.set("modifydate", (Object)this.getCurrentTime());
        this.logObjs.add(object);
    }

    public void doImport(List<Map<String, Object>> allRowData, VarImportContext importContext) {
        if (allRowData == null) {
            return;
        }
        this.initParam(allRowData, importContext);
        this.selectData(allRowData);
        this.saveData();
        this.afterSaveData();
    }

    protected boolean checkNumberAndName(String name, String number) {
        String numberError = NumberCheckUtils.checkNumberRule((String)number);
        String nameError = StringUtils.isEmpty((String)name) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"ARptVarImportHandler_1", (String)"epm-eb-business", (Object[])new Object[0]) : null;
        String errorStr = "";
        if (StringUtils.isNotEmpty((String)numberError)) {
            errorStr = errorStr + numberError;
        }
        if (StringUtils.isNotEmpty((String)nameError)) {
            errorStr = StringUtils.isEmpty((String)errorStr) ? nameError : errorStr + ";" + nameError;
        }
        if (StringUtils.isEmpty((String)errorStr)) {
            return false;
        }
        this.addRowErrorLog(number, name, errorStr);
        return true;
    }

    protected void initParam(List<Map<String, Object>> allRowData, VarImportContext importContext) {
        this.importContext = importContext;
        importContext.getVarDataCount().setTotalCount(this.getVariableTypeEnum(), allRowData.size());
    }

    protected abstract void selectData(List<Map<String, Object>> var1);

    private void saveData() {
        if (this.updateObjs.size() > 0) {
            this.updateObjs.forEach(this::addSussLog);
            SaveServiceHelper.save((DynamicObject[])this.updateObjs.toArray(new DynamicObject[1]));
        }
        if (this.newObjs.size() > 0) {
            this.newObjs.forEach(this::addSussLog);
            SaveServiceHelper.save((DynamicObject[])this.newObjs.toArray(new DynamicObject[1]));
        }
        if (this.memberQuoteList.size() > 0) {
            QuoteSave.get().save(this.memberQuoteList);
        }
        if (this.logObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])this.logObjs.toArray(new DynamicObject[1]));
        }
    }

    protected void afterSaveData() {
        int sussCount = this.getNewObjs().size() + this.getUpdateObjs().size();
        this.getImportContext().getVarDataCount().setSussCount(this.getVariableTypeEnum(), sussCount);
    }

    protected DynamicObject selObj2Save(BillColGroup colConfig, Map<String, Object> rowData, DynamicObject obj, RefDimStrInfo refDimColInfo) {
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)colConfig.getGroupKey());
            obj.set("creater", (Object)this.getCurrentUser());
            obj.set("createdate", (Object)this.getCurrentTime());
            Long id = GlobalIdUtil.genGlobalLongId();
            obj.set("id", (Object)id);
            this.newObjs.add(obj);
        } else {
            this.updateObjs.add(obj);
        }
        obj.set("modifier", (Object)this.getCurrentUser());
        obj.set("modifydate", (Object)this.getCurrentTime());
        obj.set("model", (Object)this.getModelId());
        obj.set("bizmodel", (Object)this.getBizModelId());
        this.fillObjData(colConfig, rowData, obj);
        if (refDimColInfo != null) {
            obj.set("reffunctiondimnums", (Object)refDimColInfo.getRefFunctionDims());
            obj.set("refparamdimnums", (Object)refDimColInfo.getRefParamDims());
        }
        return obj;
    }

    protected void fillObjData(BillColGroup colConfig, Map<String, Object> rowData, DynamicObject obj) {
        for (Map.Entry<String, ExcelCol> colEntry : colConfig.getBaseCols().entrySet()) {
            ExcelCol col = colEntry.getValue();
            String colKey = col.getRealKey();
            col.setVal(rowData.get(colKey), obj);
        }
        for (BillColGroup childGroup : colConfig.getChildEntrys().values()) {
            List allEntryRowData = (List)rowData.get(childGroup.getGroupKey());
            if (allEntryRowData == null || allEntryRowData.size() <= 0) continue;
            DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection(childGroup.getGroupKey());
            dynamicObjectCollection.clear();
            for (Map entryRowData : allEntryRowData) {
                DynamicObject rowObj = (DynamicObject)dynamicObjectCollection.getDynamicObjectType().createInstance();
                this.fillObjData(childGroup, entryRowData, rowObj);
                dynamicObjectCollection.add((Object)rowObj);
            }
        }
    }

    protected Map<String, Map<String, DynamicObject>> getAllRefObject(Map<String, Set<String>> allRefData) {
        HashMap<String, Map<String, Set<String>>> allRefDatas = new HashMap<String, Map<String, Set<String>>>(16);
        allRefData.forEach((formKey, numbers) -> allRefDatas.computeIfAbsent((String)formKey, key -> new HashMap(16)).put("", numbers));
        Map<String, Map<String, Map<String, DynamicObject>>> allRefObject = this.getAllRefObj(allRefDatas);
        HashMap<String, Map<String, DynamicObject>> result = new HashMap<String, Map<String, DynamicObject>>(allRefObject.size());
        allRefData.keySet().forEach(formKey -> result.put((String)formKey, ((Map)allRefObject.getOrDefault(formKey, new HashMap(16))).getOrDefault("", new HashMap(16))));
        return result;
    }

    protected Map<String, DynamicObject> getRefValObjs(VariableTypeEnum variableTypeEnum, Set<String> allRefData) {
        HashMap<String, Map<String, Set<String>>> allRefDatas = new HashMap<String, Map<String, Set<String>>>(16);
        allRefDatas.computeIfAbsent(variableTypeEnum.getMetadata(), key -> new HashMap(16)).put("", allRefData);
        Map<String, Map<String, Map<String, DynamicObject>>> allRefObject = this.getAllRefObj(allRefDatas);
        return ((Map)allRefObject.getOrDefault(variableTypeEnum.getMetadata(), new HashMap(16))).getOrDefault("", new HashMap(16));
    }

    protected Map<String, Map<String, Map<String, DynamicObject>>> getAllRefObj(Map<String, Map<String, Set<String>>> allRefData) {
        HashMap<String, Map<String, Map<String, DynamicObject>>> result = new HashMap<String, Map<String, Map<String, DynamicObject>>>(16);
        for (Map.Entry<String, Map<String, Set<String>>> entry : allRefData.entrySet()) {
            String formKey = entry.getKey();
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)formKey);
            BillColGroup colConfig = BillImpExpUtils.getColConfig(formKey, (IDataEntityType)entityType, true, null, false, false, null);
            for (Map.Entry<String, Set<String>> childEntry : entry.getValue().entrySet()) {
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                if (childEntry.getValue() != null) {
                    filter.and("number", "in", childEntry.getValue());
                }
                if (colConfig.getBaseCols().containsKey("bizmodel.number")) {
                    filter.and("bizmodel", "=", (Object)this.getBizModelId());
                } else if (colConfig.getBaseCols().containsKey("dimension.number")) {
                    filter.and("dimension.number", "=", (Object)childEntry.getKey());
                }
                DynamicObject[] objects = ImportAndExportUtil.loadObjs(colConfig, filter);
                HashMap<String, DynamicObject> objMap = new HashMap<String, DynamicObject>(objects.length);
                for (DynamicObject obj : objects) {
                    objMap.put(obj.getString("number"), obj);
                }
                result.computeIfAbsent(formKey, key -> new HashMap(16)).put(childEntry.getKey(), objMap);
            }
        }
        return result;
    }

    public VariableTypeEnum getVariableTypeEnum() {
        return this.variableTypeEnum;
    }

    public void setVariableTypeEnum(VariableTypeEnum variableTypeEnum) {
        this.variableTypeEnum = variableTypeEnum;
    }

    public BillColGroup getColConfig() {
        if (this.colConfig == null) {
            String formKey = this.getVariableTypeEnum().getMetadata();
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)formKey);
            this.colConfig = BillImpExpUtils.getColConfig(formKey, (IDataEntityType)entityType, true, null, false, false, null);
        }
        return this.colConfig;
    }

    protected List<DynamicObject> getUpdateObjs() {
        return this.updateObjs;
    }

    public List<DynamicObject> getNewObjs() {
        return this.newObjs;
    }

    protected String getNumber(Map<String, Object> rowData) {
        return this.getStr(rowData, "number");
    }

    protected String getName(Map<String, Object> rowData) {
        return this.getStr(rowData, "name");
    }

    protected String getStr(Map<String, Object> rowData, String fieldKey) {
        Object val;
        String result = null;
        if (rowData != null && (val = rowData.get(fieldKey)) instanceof String) {
            result = (String)val;
        }
        return result;
    }

    protected void addQuote(MemberQuoteDao quoteDao) {
        this.getMemberQuoteList().add(quoteDao);
    }

    public List<MemberQuoteDao> getMemberQuoteList() {
        return this.memberQuoteList;
    }

    public Long getModelId() {
        return this.getImportContext().getModelId();
    }

    public Long getBizModelId() {
        return this.getImportContext().getBizModelId();
    }

    public boolean isReplace() {
        return this.getImportContext().isReplace();
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.getImportContext().getModelCacheHelper();
    }

    public VarImportContext getImportContext() {
        return this.importContext;
    }

    public void setImportContext(VarImportContext importContext) {
        this.importContext = importContext;
    }

    protected boolean checkRepObj(DynamicObject cObj, String number, String name) {
        if (cObj != null && !this.isReplace() || cObj == null && !this.newNumbers.add(number)) {
            this.addRowErrorLog(number, name, ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5b58\u5728\u76f8\u540c\u7f16\u7801%s", (String)"ARptVarImportHandler_2", (String)"epm-eb-business", (Object[])new Object[]{this.getVariableTypeEnum().getName()}));
            return true;
        }
        return false;
    }
}

